/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_AllocationLine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MAllocationLine
extends X_C_AllocationLine {
    private static CLogger s_log = CLogger.getCLogger(MAllocationLine.class);
    private MInvoice m_invoice = null;
    private MAllocationHdr m_parent = null;

    public MAllocationLine(Properties ctx, int C_AllocationLine_ID, String trxName) {
        super(ctx, C_AllocationLine_ID, trxName);
        if (C_AllocationLine_ID == 0) {
            this.setAmount(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setWriteOffAmt(Env.ZERO);
            this.setOverUnderAmt(Env.ZERO);
        }
    }

    public MAllocationLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAllocationLine(MAllocationHdr parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setC_AllocationHdr_ID(parent.getC_AllocationHdr_ID());
        this.m_parent = parent;
        this.set_TrxName(parent.get_TrxName());
    }

    public MAllocationLine(MAllocationHdr parent, BigDecimal Amount, BigDecimal DiscountAmt, BigDecimal WriteOffAmt, BigDecimal OverUnderAmt) {
        this(parent);
        this.setAmount(Amount);
        this.setDiscountAmt(DiscountAmt == null ? Env.ZERO : DiscountAmt);
        this.setWriteOffAmt(WriteOffAmt == null ? Env.ZERO : WriteOffAmt);
        this.setOverUnderAmt(OverUnderAmt == null ? Env.ZERO : OverUnderAmt);
    }

    public MAllocationHdr getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MAllocationHdr(this.getCtx(), this.getC_AllocationHdr_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    protected void setParent(MAllocationHdr parent) {
        this.m_parent = parent;
    }

    public Timestamp getDateTrx() {
        return this.getParent().getDateTrx();
    }

    public void setDocInfo(int C_BPartner_ID, int C_Order_ID, int C_Invoice_ID) {
        this.setC_BPartner_ID(C_BPartner_ID);
        this.setC_Order_ID(C_Order_ID);
        this.setC_Invoice_ID(C_Invoice_ID);
    }

    public void setPaymentInfo(int C_Payment_ID, int C_CashLine_ID) {
        if (C_Payment_ID != 0) {
            this.setC_Payment_ID(C_Payment_ID);
        }
        if (C_CashLine_ID != 0) {
            this.setC_CashLine_ID(C_CashLine_ID);
        }
    }

    public MInvoice getInvoice() {
        if (this.m_invoice == null && this.getC_Invoice_ID() != 0) {
            this.m_invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_invoice;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord && (this.is_ValueChanged("C_BPartner_ID") || this.is_ValueChanged("C_Invoice_ID"))) {
            this.log.severe("Cannot Change Business Partner or Invoice");
            return false;
        }
        if (this.getC_BPartner_ID() == 0 && this.getInvoice() != null) {
            this.setC_BPartner_ID(this.getInvoice().getC_BPartner_ID());
        }
        if (this.getC_Order_ID() == 0 && this.getInvoice() != null) {
            this.setC_Order_ID(this.getInvoice().getC_Order_ID());
        }
        return true;
    }

    protected boolean beforeDelete() {
        this.setIsActive(false);
        this.processIt(true);
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MAllocationLine[");
        sb.append(this.get_ID());
        if (this.getC_Payment_ID() != 0) {
            sb.append(",C_Payment_ID=").append(this.getC_Payment_ID());
        }
        if (this.getC_CashLine_ID() != 0) {
            sb.append(",C_CashLine_ID=").append(this.getC_CashLine_ID());
        }
        if (this.getC_Invoice_ID() != 0) {
            sb.append(",C_Invoice_ID=").append(this.getC_Invoice_ID());
        }
        if (this.getC_BPartner_ID() != 0) {
            sb.append(",C_BPartner_ID=").append(this.getC_BPartner_ID());
        }
        sb.append(", Amount=").append(this.getAmount()).append(",Discount=").append(this.getDiscountAmt()).append(",WriteOff=").append(this.getWriteOffAmt()).append(",OverUnder=").append(this.getOverUnderAmt());
        sb.append("]");
        return sb.toString();
    }

    protected int processIt(boolean reverse) {
        String update;
        this.log.fine("Reverse=" + reverse + " - " + this.toString());
        int C_Invoice_ID = this.getC_Invoice_ID();
        MInvoice invoice = this.getInvoice();
        if (invoice != null && this.getC_BPartner_ID() != invoice.getC_BPartner_ID()) {
            this.setC_BPartner_ID(invoice.getC_BPartner_ID());
        }
        int C_Payment_ID = this.getC_Payment_ID();
        int C_CashLine_ID = this.getC_CashLine_ID();
        if (C_Payment_ID != 0) {
            MPayment payment = new MPayment(this.getCtx(), C_Payment_ID, this.get_TrxName());
            if (this.getC_BPartner_ID() != payment.getC_BPartner_ID()) {
                this.log.warning("C_BPartner_ID different - Invoice=" + this.getC_BPartner_ID() + " - Payment=" + payment.getC_BPartner_ID());
            }
            if (reverse) {
                if (!payment.isCashTrx()) {
                    payment.setIsAllocated(false);
                    payment.save();
                }
            } else if (payment.testAllocation()) {
                payment.save();
            }
        }
        if (C_Payment_ID != 0 && invoice != null) {
            if (reverse) {
                invoice.setC_Payment_ID(0);
                this.log.fine("C_Payment_ID=" + C_Payment_ID + " Unlinked from C_Invoice_ID=" + C_Invoice_ID);
            } else if (invoice.isPaid()) {
                invoice.setC_Payment_ID(C_Payment_ID);
                this.log.fine("C_Payment_ID=" + C_Payment_ID + " Linked to C_Invoice_ID=" + C_Invoice_ID);
            }
            update = "UPDATE C_Order o SET C_Payment_ID=" + (reverse ? "NULL " : "(SELECT C_Payment_ID FROM C_Invoice WHERE C_Invoice_ID=" + C_Invoice_ID + ") ") + "WHERE EXISTS (SELECT * FROM C_Invoice i " + "WHERE o.C_Order_ID=i.C_Order_ID AND i.C_Invoice_ID=" + C_Invoice_ID + ")";
            if (DB.executeUpdate(update, this.get_TrxName()) > 0) {
                this.log.fine("C_Payment_ID=" + C_Payment_ID + (reverse ? " UnLinked from" : " Linked to") + " order of C_Invoice_ID=" + C_Invoice_ID);
            }
        }
        if (C_CashLine_ID != 0 && invoice != null) {
            if (reverse) {
                invoice.setC_CashLine_ID(0);
                this.log.fine("C_CashLine_ID=" + C_CashLine_ID + " Unlinked from C_Invoice_ID=" + C_Invoice_ID);
            } else {
                invoice.setC_CashLine_ID(C_CashLine_ID);
                this.log.fine("C_CashLine_ID=" + C_CashLine_ID + " Linked to C_Invoice_ID=" + C_Invoice_ID);
            }
            update = "UPDATE C_Order o SET C_CashLine_ID=" + (reverse ? "NULL " : "(SELECT C_CashLine_ID FROM C_Invoice WHERE C_Invoice_ID=" + C_Invoice_ID + ") ") + "WHERE EXISTS (SELECT * FROM C_Invoice i " + "WHERE o.C_Order_ID=i.C_Order_ID AND i.C_Invoice_ID=" + C_Invoice_ID + ")";
            if (DB.executeUpdate(update, this.get_TrxName()) > 0) {
                this.log.fine("C_CashLine_ID=" + C_CashLine_ID + (reverse ? " UnLinked from" : " Linked to") + " order of C_Invoice_ID=" + C_Invoice_ID);
            }
        }
        if (invoice != null && invoice.testAllocation() && !invoice.save()) {
            this.log.log(Level.SEVERE, "Invoice not updated - " + invoice);
        }
        return this.getC_BPartner_ID();
    }
}

