/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.X_C_AllocationHdr;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MAllocationHdr
extends X_C_AllocationHdr
implements DocAction {
    private static CLogger s_log = CLogger.getCLogger(MAllocationHdr.class);
    private MAllocationLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MAllocationHdr[] getOfPayment(Properties ctx, int C_Payment_ID, String trxName) {
        String sql = "SELECT * FROM C_AllocationHdr h WHERE IsActive='Y' AND EXISTS (SELECT * FROM C_AllocationLine l WHERE h.C_AllocationHdr_ID=l.C_AllocationHdr_ID AND l.C_Payment_ID=?)";
        ArrayList<MAllocationHdr> list = new ArrayList<MAllocationHdr>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_Payment_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAllocationHdr(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MAllocationHdr[] retValue = new MAllocationHdr[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MAllocationHdr[] getOfInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        String sql = "SELECT * FROM C_AllocationHdr h WHERE IsActive='Y' AND EXISTS (SELECT * FROM C_AllocationLine l WHERE h.C_AllocationHdr_ID=l.C_AllocationHdr_ID AND l.C_Invoice_ID=?)";
        ArrayList<MAllocationHdr> list = new ArrayList<MAllocationHdr>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_Invoice_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAllocationHdr(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MAllocationHdr[] retValue = new MAllocationHdr[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MAllocationHdr(Properties ctx, int C_AllocationHdr_ID, String trxName) {
        super(ctx, C_AllocationHdr_ID, trxName);
        if (C_AllocationHdr_ID == 0) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(this.getDateTrx());
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setApprovalAmt(Env.ZERO);
            this.setIsApproved(false);
            this.setIsManual(false);
            this.setPosted(false);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MAllocationHdr(Properties ctx, boolean IsManual, Timestamp DateTrx, int C_Currency_ID, String description, String trxName) {
        this(ctx, 0, trxName);
        this.setIsManual(IsManual);
        if (DateTrx != null) {
            this.setDateTrx(DateTrx);
            this.setDateAcct(DateTrx);
        }
        this.setC_Currency_ID(C_Currency_ID);
        if (description != null) {
            this.setDescription(description);
        }
    }

    public MAllocationHdr(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAllocationLine[] getLines(boolean requery) {
        if (this.m_lines != null && this.m_lines.length != 0 && !requery) {
            return this.m_lines;
        }
        String sql = "SELECT * FROM C_AllocationLine WHERE C_AllocationHdr_ID=?";
        ArrayList<MAllocationLine> list = new ArrayList<MAllocationLine>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_AllocationHdr_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MAllocationLine line = new MAllocationLine(this.getCtx(), rs, this.get_TrxName());
                line.setParent(this);
                list.add(line);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MAllocationLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE C_AllocationHdr SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_AllocationHdr_ID=" + this.getC_AllocationHdr_ID();
        int no = DB.executeUpdate(sql, this.get_TrxName());
        this.m_lines = null;
        this.log.fine(processed + " - #" + no);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord && this.is_ValueChanged("IsActive") && this.isActive()) {
            this.log.severe("Cannot Re-Activate deactivated Allocations");
            return false;
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        String trxName = this.get_TrxName();
        if (trxName == null || trxName.length() == 0) {
            this.log.warning("No transaction");
        }
        if (this.isPosted()) {
            if (!MPeriod.isOpen(this.getCtx(), this.getDateTrx(), "CMA")) {
                this.log.warning("Period Closed");
                return false;
            }
            this.setPosted(false);
            if (MFactAcct.delete(735, this.get_ID(), trxName) < 0) {
                return false;
            }
        }
        this.setIsActive(false);
        String sql = "UPDATE C_AllocationHdr SET IsActive='N' WHERE C_AllocationHdr_ID=?";
        DB.executeUpdate(sql, this.getC_AllocationHdr_ID(), trxName);
        this.getLines(true);
        HashSet<Integer> bps = new HashSet<Integer>();
        for (int i2 = 0; i2 < this.m_lines.length; ++i2) {
            MAllocationLine line = this.m_lines[i2];
            bps.add(new Integer(line.getC_BPartner_ID()));
            if (line.delete(true, trxName)) continue;
            return false;
        }
        this.updateBP(bps);
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        return success;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), "CMA")) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.getLines(false);
        if (this.m_lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal approval = Env.ZERO;
        for (int i2 = 0; i2 < this.m_lines.length; ++i2) {
            MAllocationLine line = this.m_lines[i2];
            approval = approval.add(line.getWriteOffAmt()).add(line.getDiscountAmt());
            if (line.getC_BPartner_ID() != 0) continue;
            this.m_processMsg = "No Business Partner";
            return "IN";
        }
        this.setApprovalAmt(approval);
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        this.getLines(false);
        HashSet<Integer> bps = new HashSet<Integer>();
        for (int i2 = 0; i2 < this.m_lines.length; ++i2) {
            MAllocationLine line = this.m_lines[i2];
            bps.add(new Integer(line.processIt(false)));
        }
        this.updateBP(bps);
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        boolean retValue = this.reverseIt();
        this.setDocAction("--");
        return retValue;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        boolean retValue = this.reverseIt();
        this.setDocAction("--");
        return retValue;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        boolean retValue = this.reverseIt();
        this.setDocAction("--");
        return retValue;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MAllocationHdr[");
        sb.append(this.get_ID()).append("-").append(this.getSummary()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        return Msg.getElement(this.getCtx(), "C_AllocationHdr_ID") + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    private boolean reverseIt() {
        if (!this.isActive()) {
            throw new IllegalStateException("Allocation already reversed (not active)");
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getDateTrx(), "CMA")) {
            throw new IllegalStateException("@PeriodClosed@");
        }
        this.setIsActive(false);
        this.setDocumentNo(this.getDocumentNo() + "^");
        this.setDocStatus("RE");
        if (!this.save() || this.isActive()) {
            throw new IllegalStateException("Cannot de-activate allocation");
        }
        String sql = "DELETE FROM Fact_Acct WHERE AD_Table_ID=735 AND Record_ID=" + this.getC_AllocationHdr_ID();
        int no = DB.executeUpdate(sql, this.get_TrxName());
        this.log.fine("Fact_Acct deleted #" + no);
        this.getLines(true);
        HashSet<Integer> bps = new HashSet<Integer>();
        for (int i2 = 0; i2 < this.m_lines.length; ++i2) {
            MAllocationLine line = this.m_lines[i2];
            line.setIsActive(false);
            line.save();
            bps.add(new Integer(line.processIt(true)));
        }
        this.updateBP(bps);
        return true;
    }

    private void updateBP(HashSet<Integer> bps) {
        this.log.info("#" + bps.size());
        for (int C_BPartner_ID : bps) {
            MBPartner bp = new MBPartner(this.getCtx(), C_BPartner_ID, this.get_TrxName());
            bp.setTotalOpenBalance();
            if (bp.save()) {
                this.log.fine(bp.toString());
                continue;
            }
            this.log.log(Level.SEVERE, "BP not updated - " + bp);
        }
    }
}

