/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MAcctProcessorLog;
import org.compiere.model.MClient;
import org.compiere.model.X_C_AcctProcessor;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MAcctProcessor
extends X_C_AcctProcessor
implements AdempiereProcessor {
    private static CLogger s_log = CLogger.getCLogger(MAcctProcessor.class);

    public static MAcctProcessor[] getActive(Properties ctx) {
        ArrayList<MAcctProcessor> list = new ArrayList<MAcctProcessor>();
        String sql = "SELECT * FROM C_AcctProcessor WHERE IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAcctProcessor(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "getActive", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MAcctProcessor[] retValue = new MAcctProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MAcctProcessor(Properties ctx, int C_AcctProcessor_ID, String trxName) {
        super(ctx, C_AcctProcessor_ID, trxName);
        if (C_AcctProcessor_ID == 0) {
            this.setFrequencyType("H");
            this.setFrequency(1);
            this.setKeepLogDays(7);
        }
    }

    public MAcctProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAcctProcessor(MClient client, int Supervisor_ID) {
        this(client.getCtx(), 0, client.get_TrxName());
        this.setClientOrg(client);
        this.setName(client.getName() + " - " + Msg.translate(this.getCtx(), "C_AcctProcessor_ID"));
        this.setSupervisor_ID(Supervisor_ID);
    }

    public String getServerID() {
        return "AcctProcessor" + this.get_ID();
    }

    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    public AdempiereProcessorLog[] getLogs() {
        ArrayList<MAcctProcessorLog> list = new ArrayList<MAcctProcessorLog>();
        String sql = "SELECT * FROM C_AcctProcessorLog WHERE C_AcctProcessor_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_AcctProcessor_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAcctProcessorLog(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        AdempiereProcessorLog[] retValue = new MAcctProcessorLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE C_AcctProcessorLog WHERE C_AcctProcessor_ID=" + this.getC_AcctProcessor_ID() + " AND (Created+" + this.getKeepLogDays() + ") < SysDate";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        return 0;
    }
}

