/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Lookup;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MAccountLookup
extends Lookup
implements Serializable {
    private Properties m_ctx;
    public int C_ValidCombination_ID;
    private String Combination;
    private String Description;

    public MAccountLookup(Properties ctx, int WindowNo) {
        super(19, WindowNo);
        this.m_ctx = ctx;
    }

    @Override
    public String getDisplay(Object value) {
        if (!this.containsKey(value)) {
            return "<" + value.toString() + ">";
        }
        return this.toString();
    }

    @Override
    public NamePair get(Object value) {
        if (value == null) {
            return null;
        }
        if (!this.containsKey(value)) {
            return null;
        }
        return new KeyNamePair(this.C_ValidCombination_ID, this.toString());
    }

    @Override
    public boolean containsKey(Object key) {
        int intValue = 0;
        if (key instanceof Integer) {
            intValue = (Integer)key;
        } else if (key != null) {
            intValue = Integer.parseInt(key.toString());
        }
        return this.load(intValue);
    }

    public String getDescription() {
        return this.Description;
    }

    public String toString() {
        if (this.C_ValidCombination_ID == 0) {
            return "";
        }
        return this.Combination;
    }

    public boolean load(int ID) {
        if (ID == 0) {
            this.C_ValidCombination_ID = 0;
            this.Combination = "";
            this.Description = "";
            return true;
        }
        if (ID == this.C_ValidCombination_ID) {
            return true;
        }
        String SQL = "SELECT C_ValidCombination_ID, Combination, Description FROM C_ValidCombination WHERE C_ValidCombination_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, ID);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                pstmt.close();
                return false;
            }
            this.C_ValidCombination_ID = rs.getInt(1);
            this.Combination = rs.getString(2);
            this.Description = rs.getString(3);
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    @Override
    public String getColumnName() {
        return "";
    }

    @Override
    public ArrayList<Object> getData(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (!mandatory) {
            list.add(new KeyNamePair(-1, ""));
        }
        StringBuffer sql = new StringBuffer("SELECT C_ValidCombination_ID, Combination, Description FROM C_ValidCombination WHERE AD_Client_ID=?");
        if (onlyActive) {
            sql.append(" AND IsActive='Y'");
        }
        sql.append(" ORDER BY 2");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, Env.getAD_Client_ID(this.m_ctx));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new KeyNamePair(rs.getInt(1), rs.getString(2) + " - " + rs.getString(3)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        return list;
    }
}

