/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import org.compiere.model.MQuery;
import org.compiere.util.CLogger;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Lookup
extends AbstractListModel
implements MutableComboBoxModel,
Serializable {
    protected volatile ArrayList<Object> p_data = new ArrayList();
    private volatile Object m_selectedObject;
    private Object[] m_tempData = null;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private int m_displayType;
    private int m_WindowNo;

    public Lookup(int displayType, int windowNo) {
        this.m_displayType = displayType;
        this.m_WindowNo = windowNo;
    }

    public int getDisplayType() {
        return this.m_displayType;
    }

    public int getWindowNo() {
        return this.m_WindowNo;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this.m_selectedObject != null && !this.m_selectedObject.equals(anObject) || this.m_selectedObject == null && anObject != null) {
            if (this.p_data.contains(anObject) || anObject == null) {
                this.m_selectedObject = anObject;
            } else {
                this.m_selectedObject = null;
                this.log.fine(this.getColumnName() + ": setSelectedItem - Set to NULL");
            }
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.m_selectedObject;
    }

    @Override
    public int getSize() {
        return this.p_data.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.p_data.get(index);
    }

    public int getIndexOf(Object anObject) {
        return this.p_data.indexOf(anObject);
    }

    public void addElement(Object anObject) {
        this.p_data.add(anObject);
        this.fireIntervalAdded(this, this.p_data.size() - 1, this.p_data.size() - 1);
        if (this.p_data.size() == 1 && this.m_selectedObject == null && anObject != null) {
            this.setSelectedItem(anObject);
        }
    }

    public void insertElementAt(Object anObject, int index) {
        this.p_data.add(index, anObject);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.m_selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.p_data.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void removeElement(Object anObject) {
        int index = this.p_data.indexOf(anObject);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void removeAllElements() {
        if (this.p_data.size() > 0) {
            int firstIndex = 0;
            int lastIndex = this.p_data.size() - 1;
            this.p_data.clear();
            this.m_selectedObject = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        }
    }

    public void put(String key, String value) {
        ValueNamePair pp = new ValueNamePair(key, value);
        this.addElement(pp);
    }

    public void put(int key, String value) {
        KeyNamePair pp = new KeyNamePair(key, value);
        this.addElement(pp);
    }

    public void fillComboBox(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary) {
        long startTime = System.currentTimeMillis();
        if (temporary) {
            int size = this.p_data.size();
            this.m_tempData = new Object[size];
            this.p_data.toArray(this.m_tempData);
        }
        Object obj = this.m_selectedObject;
        this.p_data.clear();
        this.p_data = this.getData(mandatory, onlyValidated, onlyActive, temporary);
        if (obj != this.m_selectedObject) {
            this.log.finest(this.getColumnName() + ": SelectedValue Changed=" + obj + "->" + this.m_selectedObject);
            obj = this.m_selectedObject;
        }
        if (obj == null && mandatory && this.p_data.size() > 0) {
            this.m_selectedObject = obj = this.p_data.get(0);
            this.log.finest(this.getColumnName() + ": SelectedValue SetToFirst=" + obj);
        }
        this.fireContentsChanged(this, 0, this.p_data.size());
        if (this.p_data.size() == 0) {
            this.log.fine(this.getColumnName() + ": #0 - ms=" + String.valueOf(System.currentTimeMillis() - startTime));
        } else {
            this.log.fine(this.getColumnName() + ": #" + this.p_data.size() + " - ms=" + String.valueOf(System.currentTimeMillis() - startTime));
        }
    }

    public void fillComboBox(boolean restore) {
        if (restore && this.m_tempData != null) {
            Object obj = this.m_selectedObject;
            this.p_data.clear();
            this.p_data = new ArrayList(this.m_tempData.length);
            for (int i2 = 0; i2 < this.m_tempData.length; ++i2) {
                this.p_data.add(this.m_tempData[i2]);
            }
            this.m_tempData = null;
            if (obj == null && this.p_data.size() > 0) {
                obj = this.p_data.get(0);
            }
            this.setSelectedItem(obj);
            this.fireContentsChanged(this, 0, this.p_data.size());
            return;
        }
        if (this.p_data != null) {
            this.fillComboBox(false, false, false, false);
        }
    }

    public abstract String getDisplay(Object var1);

    public abstract NamePair get(Object var1);

    public abstract ArrayList<Object> getData(boolean var1, boolean var2, boolean var3, boolean var4);

    public abstract String getColumnName();

    public abstract boolean containsKey(Object var1);

    public int refresh() {
        return 0;
    }

    public boolean isValidated() {
        return true;
    }

    public String getValidation() {
        return "";
    }

    public boolean hasInactive() {
        return false;
    }

    public int getZoom() {
        return 0;
    }

    public int getZoom(MQuery query) {
        return 0;
    }

    public MQuery getZoomQuery() {
        return null;
    }

    public NamePair getDirect(Object key, boolean saveInCache, boolean cacheLocal) {
        return this.get(key);
    }

    public void dispose() {
        if (this.p_data != null) {
            this.p_data.clear();
        }
        this.p_data = null;
        this.m_selectedObject = null;
        this.m_tempData = null;
    }

    public void loadComplete() {
    }
}

