/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProductPricing;
import org.compiere.util.Env;

public class CalloutRequisition
extends CalloutEngine {
    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        int C_BPartner_ID = Env.getContextAsInt(ctx, WindowNo, WindowNo, "C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)mTab.getValue("Qty");
        boolean isSOTrx = false;
        MProductPricing pp = new MProductPricing(M_Product_ID, C_BPartner_ID, Qty, isSOTrx);
        int M_PriceList_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        int M_PriceList_Version_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_Version_ID");
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        Timestamp orderDate = (Timestamp)mTab.getValue("DateRequired");
        pp.setPriceDate(orderDate);
        mTab.setValue("PriceActual", (Object)pp.getPriceStd());
        Env.setContext(ctx, WindowNo, "EnforcePriceLimit", pp.isEnforcePriceLimit() ? "Y" : "N");
        Env.setContext(ctx, WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        return "";
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutRequisition.isCalloutActive() || value == null) {
            return "";
        }
        CalloutRequisition.setCalloutActive(true);
        if (mField.getColumnName().equals("Qty") && "Y".equals(Env.getContext(ctx, WindowNo, "DiscountSchema"))) {
            int M_Product_ID = Env.getContextAsInt(ctx, WindowNo, WindowNo, "M_Product_ID");
            int C_BPartner_ID = Env.getContextAsInt(ctx, WindowNo, WindowNo, "C_BPartner_ID");
            BigDecimal Qty = (BigDecimal)value;
            boolean isSOTrx = false;
            MProductPricing pp = new MProductPricing(M_Product_ID, C_BPartner_ID, Qty, isSOTrx);
            int M_PriceList_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_ID");
            pp.setM_PriceList_ID(M_PriceList_ID);
            int M_PriceList_Version_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
            Timestamp orderDate = (Timestamp)mTab.getValue("DateInvoiced");
            pp.setPriceDate(orderDate);
            mTab.setValue("PriceActual", (Object)pp.getPriceStd());
        }
        int StdPrecision = Env.getContextAsInt(ctx, WindowNo, "StdPrecision");
        BigDecimal Qty = (BigDecimal)mTab.getValue("Qty");
        BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
        this.log.fine("amt - Qty=" + Qty + ", Price=" + PriceActual + ", Precision=" + StdPrecision);
        BigDecimal LineNetAmt = Qty.multiply(PriceActual);
        if (LineNetAmt.scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        mTab.setValue("LineNetAmt", (Object)LineNetAmt);
        this.log.info("amt - LineNetAmt=" + LineNetAmt);
        CalloutRequisition.setCalloutActive(false);
        return "";
    }
}

