/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class CalloutInOut
extends CalloutEngine {
    public String order(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Order_ID = (Integer)value;
        if (C_Order_ID == null || C_Order_ID == 0) {
            return "";
        }
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        MOrder order = new MOrder(ctx, C_Order_ID, null);
        if (order.get_ID() != 0) {
            mTab.setValue("DateOrdered", (Object)order.getDateOrdered());
            mTab.setValue("POReference", (Object)order.getPOReference());
            mTab.setValue("AD_Org_ID", (Object)new Integer(order.getAD_Org_ID()));
            mTab.setValue("AD_OrgTrx_ID", (Object)new Integer(order.getAD_OrgTrx_ID()));
            mTab.setValue("C_Activity_ID", (Object)new Integer(order.getC_Activity_ID()));
            mTab.setValue("C_Campaign_ID", (Object)new Integer(order.getC_Campaign_ID()));
            mTab.setValue("C_Project_ID", (Object)new Integer(order.getC_Project_ID()));
            mTab.setValue("User1_ID", (Object)new Integer(order.getUser1_ID()));
            mTab.setValue("User2_ID", (Object)new Integer(order.getUser2_ID()));
            mTab.setValue("M_Warehouse_ID", (Object)new Integer(order.getM_Warehouse_ID()));
            mTab.setValue("DeliveryRule", (Object)order.getDeliveryRule());
            mTab.setValue("DeliveryViaRule", (Object)order.getDeliveryViaRule());
            mTab.setValue("M_Shipper_ID", (Object)new Integer(order.getM_Shipper_ID()));
            mTab.setValue("FreightCostRule", (Object)order.getFreightCostRule());
            mTab.setValue("FreightAmt", (Object)order.getFreightAmt());
            mTab.setValue("C_BPartner_ID", (Object)new Integer(order.getC_BPartner_ID()));
        }
        return "";
    }

    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        String sql = "SELECT d.DocBaseType, d.IsDocNoControlled, s.CurrentNext FROM C_DocType d, AD_Sequence s WHERE C_DocType_ID=? AND d.DocNoSequence_ID=s.AD_Sequence_ID(+)";
        try {
            Env.setContext(ctx, WindowNo, "C_DocTypeTarget_ID", C_DocType_ID);
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_DocType_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                String DocBaseType = rs.getString("DocBaseType");
                if (DocBaseType.equals("MMS")) {
                    mTab.setValue("MovementType", (Object)"C-");
                } else if (DocBaseType.equals("MMR")) {
                    mTab.setValue("MovementType", (Object)"V+");
                }
                if (rs.getString("IsDocNoControlled").equals("Y")) {
                    mTab.setValue("DocumentNo", (Object)("<" + rs.getString("CurrentNext") + ">"));
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            return e.getLocalizedMessage();
        }
        return "";
    }

    public String bpartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID,p.M_PriceList_ID,p.PaymentRule,p.POReference,p.SO_Description,p.IsDiscountPrinted,p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable,l.C_BPartner_Location_ID,c.AD_User_ID FROM C_BPartner p, C_BPartner_Location l, AD_User c WHERE p.C_BPartner_ID=l.C_BPartner_ID(+) AND p.C_BPartner_ID=c.C_BPartner_ID(+) AND p.C_BPartner_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                Integer ii = new Integer(rs.getInt("C_BPartner_Location_ID"));
                if (rs.wasNull()) {
                    mTab.setValue("C_BPartner_Location_ID", null);
                } else {
                    mTab.setValue("C_BPartner_Location_ID", (Object)ii);
                }
                ii = new Integer(rs.getInt("AD_User_ID"));
                if (rs.wasNull()) {
                    mTab.setValue("AD_User_ID", null);
                } else {
                    mTab.setValue("AD_User_ID", (Object)ii);
                }
                double CreditAvailable = rs.getDouble("CreditAvailable");
                if (!rs.wasNull() && CreditAvailable < 0.0) {
                    mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat(12).format(CreditAvailable), false);
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            return e.getLocalizedMessage();
        }
        return "";
    }

    public String warehouse(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        Integer M_Warehouse_ID = (Integer)value;
        if (M_Warehouse_ID == null || M_Warehouse_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        String sql = "SELECT w.AD_Org_ID, l.M_Locator_ID FROM M_Warehouse w LEFT OUTER JOIN M_Locator l ON (l.M_Warehouse_ID=w.M_Warehouse_ID AND l.IsDefault='Y') WHERE w.M_Warehouse_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Warehouse_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                Integer ii = new Integer(rs.getInt(1));
                int AD_Org_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Org_ID");
                if (AD_Org_ID != ii) {
                    mTab.setValue("AD_Org_ID", (Object)ii);
                }
                ii = new Integer(rs.getInt(2));
                if (rs.wasNull()) {
                    Env.setContext(ctx, WindowNo, 0, "M_Locator_ID", null);
                } else {
                    this.log.config("M_Locator_ID=" + ii);
                    Env.setContext(ctx, WindowNo, "M_Locator_ID", ii);
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            CalloutInOut.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String orderLine(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_OrderLine_ID = (Integer)value;
        if (C_OrderLine_ID == null || C_OrderLine_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        MOrderLine ol = new MOrderLine(ctx, C_OrderLine_ID, null);
        if (ol.get_ID() != 0) {
            mTab.setValue("M_Product_ID", (Object)new Integer(ol.getM_Product_ID()));
            mTab.setValue("M_AttributeSetInstance_ID", (Object)new Integer(ol.getM_AttributeSetInstance_ID()));
            mTab.setValue("C_UOM_ID", (Object)new Integer(ol.getC_UOM_ID()));
            BigDecimal MovementQty = ol.getQtyOrdered().subtract(ol.getQtyDelivered());
            mTab.setValue("MovementQty", (Object)MovementQty);
            BigDecimal QtyEntered = MovementQty;
            if (ol.getQtyEntered().compareTo(ol.getQtyOrdered()) != 0) {
                QtyEntered = QtyEntered.multiply(ol.getQtyEntered()).divide(ol.getQtyOrdered(), 12, 4);
            }
            mTab.setValue("QtyEntered", (Object)QtyEntered);
            mTab.setValue("C_Activity_ID", (Object)new Integer(ol.getC_Activity_ID()));
            mTab.setValue("C_Campaign_ID", (Object)new Integer(ol.getC_Campaign_ID()));
            mTab.setValue("C_Project_ID", (Object)new Integer(ol.getC_Project_ID()));
            mTab.setValue("C_ProjectPhase_ID", (Object)new Integer(ol.getC_ProjectPhase_ID()));
            mTab.setValue("C_ProjectTask_ID", (Object)new Integer(ol.getC_ProjectTask_ID()));
            mTab.setValue("AD_OrgTrx_ID", (Object)new Integer(ol.getAD_OrgTrx_ID()));
            mTab.setValue("User1_ID", (Object)new Integer(ol.getUser1_ID()));
            mTab.setValue("User2_ID", (Object)new Integer(ol.getUser2_ID()));
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        int M_Locator_ID = 0;
        if (Env.getContextAsInt(ctx, 1113, 1113, "M_Product_ID") == M_Product_ID && Env.getContextAsInt(ctx, 1113, 1113, "M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)new Integer(Env.getContextAsInt(ctx, 1113, 1113, "M_AttributeSetInstance_ID")));
            M_Locator_ID = Env.getContextAsInt(ctx, 1113, 1113, "M_Locator_ID");
            if (M_Locator_ID != 0) {
                mTab.setValue("M_Locator_ID", (Object)new Integer(M_Locator_ID));
            }
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        int M_Warehouse_ID = Env.getContextAsInt(ctx, WindowNo, "M_Warehouse_ID");
        boolean IsSOTrx = "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
        if (IsSOTrx) {
            CalloutInOut.setCalloutActive(false);
            return "";
        }
        MProduct product = MProduct.get(ctx, M_Product_ID);
        mTab.setValue("C_UOM_ID", (Object)new Integer(product.getC_UOM_ID()));
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        mTab.setValue("MovementQty", (Object)QtyEntered);
        if (M_Locator_ID == 0) {
            if (product.getM_Locator_ID() != 0) {
                MLocator loc = MLocator.get(ctx, product.getM_Locator_ID());
                if (M_Warehouse_ID == loc.getM_Warehouse_ID()) {
                    mTab.setValue("M_Locator_ID", (Object)new Integer(product.getM_Locator_ID()));
                } else {
                    this.log.fine("No Locator for M_Product_ID=" + M_Product_ID + " and M_Warehouse_ID=" + M_Warehouse_ID);
                }
            } else {
                this.log.fine("No Locator for M_Product_ID=" + M_Product_ID);
            }
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String qty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutInOut.isCalloutActive() || value == null) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        int M_Product_ID = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        if (M_Product_ID == 0) {
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("MovementQty", (Object)QtyEntered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal MovementQty;
            BigDecimal QtyEntered1;
            int C_UOM_To_ID = (Integer)value;
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((MovementQty = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                MovementQty = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(MovementQty) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " MovementQty=" + MovementQty);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("MovementQty", (Object)MovementQty);
        } else if (Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID") == 0) {
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("MovementQty", (Object)QtyEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            BigDecimal MovementQty;
            BigDecimal QtyEntered = (BigDecimal)value;
            int C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((MovementQty = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                MovementQty = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(MovementQty) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " MovementQty=" + MovementQty);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("MovementQty", (Object)MovementQty);
        } else if (mField.getColumnName().equals("MovementQty")) {
            BigDecimal QtyEntered;
            int C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
            BigDecimal MovementQty = (BigDecimal)value;
            int precision = MProduct.get(ctx, M_Product_ID).getUOMPrecision();
            BigDecimal MovementQty1 = MovementQty.setScale(precision, 4);
            if (MovementQty.compareTo(MovementQty1) != 0) {
                this.log.fine("Corrected MovementQty " + MovementQty + "->" + MovementQty1);
                MovementQty = MovementQty1;
                mTab.setValue("MovementQty", (Object)MovementQty);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, MovementQty)) == null) {
                QtyEntered = MovementQty;
            }
            boolean conversion = MovementQty.compareTo(QtyEntered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", MovementQty=" + MovementQty + " -> " + conversion + " QtyEntered=" + QtyEntered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String asi(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        int selectedM_Locator_ID;
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        Integer M_ASI_ID = (Integer)value;
        if (M_ASI_ID == null || M_ASI_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        int M_Product_ID = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        int M_Warehouse_ID = Env.getContextAsInt(ctx, WindowNo, "M_Warehouse_ID");
        int M_Locator_ID = Env.getContextAsInt(ctx, WindowNo, "M_Locator_ID");
        this.log.fine("M_Product_ID=" + M_Product_ID + ", M_ASI_ID=" + M_ASI_ID + " - M_Warehouse_ID=" + M_Warehouse_ID + ", M_Locator_ID=" + M_Locator_ID);
        int M_AttributeSetInstance_ID = Env.getContextAsInt(Env.getCtx(), 1113, 1113, "M_AttributeSetInstance_ID");
        if (M_ASI_ID == M_AttributeSetInstance_ID && (selectedM_Locator_ID = Env.getContextAsInt(Env.getCtx(), 1113, 1113, "M_Locator_ID")) != 0) {
            this.log.fine("Selected M_Locator_ID=" + selectedM_Locator_ID);
            mTab.setValue("M_Locator_ID", (Object)new Integer(selectedM_Locator_ID));
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }
}

