/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutGLJournal
extends CalloutEngine {
    public String period(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String colName = mField.getColumnName();
        if (value == null || CalloutGLJournal.isCalloutActive()) {
            return "";
        }
        CalloutGLJournal.setCalloutActive(true);
        int AD_Client_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Client_ID");
        Timestamp DateAcct = null;
        DateAcct = colName.equals("DateAcct") ? (Timestamp)value : (Timestamp)mTab.getValue("DateAcct");
        int C_Period_ID = 0;
        if (colName.equals("C_Period_ID")) {
            C_Period_ID = (Integer)value;
        }
        if (colName.equals("DateDoc")) {
            mTab.setValue("DateAcct", value);
        } else if (colName.equals("DateAcct")) {
            String sql = "SELECT C_Period_ID FROM C_Period WHERE C_Year_ID IN \t(SELECT C_Year_ID FROM C_Year WHERE C_Calendar_ID =  (SELECT C_Calendar_ID FROM AD_ClientInfo WHERE AD_Client_ID=?)) AND ? BETWEEN StartDate AND EndDate AND IsActive='Y' AND PeriodType='S'";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, AD_Client_ID);
                pstmt.setTimestamp(2, DateAcct);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    C_Period_ID = rs.getInt(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                CalloutGLJournal.setCalloutActive(false);
                return e.getLocalizedMessage();
            }
            if (C_Period_ID != 0) {
                mTab.setValue("C_Period_ID", (Object)new Integer(C_Period_ID));
            }
        } else {
            String sql = "SELECT PeriodType, StartDate, EndDate FROM C_Period WHERE C_Period_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_Period_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    String PeriodType = rs.getString(1);
                    Timestamp StartDate = rs.getTimestamp(2);
                    Timestamp EndDate = rs.getTimestamp(3);
                    if (PeriodType.equals("S") && (DateAcct == null || DateAcct.before(StartDate) || DateAcct.after(EndDate))) {
                        mTab.setValue("DateAcct", (Object)EndDate);
                    }
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                CalloutGLJournal.setCalloutActive(false);
                return e.getLocalizedMessage();
            }
        }
        CalloutGLJournal.setCalloutActive(false);
        return "";
    }

    public String rate(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        Integer Currency_ID = (Integer)mTab.getValue("C_Currency_ID");
        int C_Currency_ID = Currency_ID;
        Integer ConversionType_ID = (Integer)mTab.getValue("C_ConversionType_ID");
        int C_ConversionType_ID = ConversionType_ID;
        Timestamp DateAcct = (Timestamp)mTab.getValue("DateAcct");
        if (DateAcct == null) {
            DateAcct = new Timestamp(System.currentTimeMillis());
        }
        int C_AcctSchema_ID = Env.getContextAsInt(ctx, WindowNo, "C_AcctSchema_ID");
        MAcctSchema as = MAcctSchema.get(ctx, C_AcctSchema_ID);
        int AD_Client_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Client_ID");
        int AD_Org_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Org_ID");
        BigDecimal CurrencyRate = MConversionRate.getRate(C_Currency_ID, as.getC_Currency_ID(), DateAcct, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
        this.log.fine("rate = " + CurrencyRate);
        if (CurrencyRate == null) {
            CurrencyRate = Env.ZERO;
        }
        mTab.setValue("CurrencyRate", (Object)CurrencyRate);
        return "";
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal AmtSourceCr;
        BigDecimal AmtSourceDr;
        String colName = mField.getColumnName();
        if (value == null || CalloutGLJournal.isCalloutActive()) {
            return "";
        }
        CalloutGLJournal.setCalloutActive(true);
        int C_AcctSchema_ID = Env.getContextAsInt(ctx, WindowNo, "C_AcctSchema_ID");
        MAcctSchema as = MAcctSchema.get(ctx, C_AcctSchema_ID);
        int Precision = as.getStdPrecision();
        BigDecimal CurrencyRate = (BigDecimal)mTab.getValue("CurrencyRate");
        if (CurrencyRate == null) {
            CurrencyRate = Env.ONE;
            mTab.setValue("CurrencyRate", (Object)CurrencyRate);
        }
        if ((AmtSourceDr = (BigDecimal)mTab.getValue("AmtSourceDr")) == null) {
            AmtSourceDr = Env.ZERO;
        }
        if ((AmtSourceCr = (BigDecimal)mTab.getValue("AmtSourceCr")) == null) {
            AmtSourceCr = Env.ZERO;
        }
        BigDecimal AmtAcctDr = AmtSourceDr.multiply(CurrencyRate);
        AmtAcctDr = AmtAcctDr.setScale(Precision, 4);
        mTab.setValue("AmtAcctDr", (Object)AmtAcctDr);
        BigDecimal AmtAcctCr = AmtSourceCr.multiply(CurrencyRate);
        AmtAcctCr = AmtAcctCr.setScale(Precision, 4);
        mTab.setValue("AmtAcctCr", (Object)AmtAcctCr);
        CalloutGLJournal.setCalloutActive(false);
        return "";
    }
}

