/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutCashJournal
extends CalloutEngine {
    public String invoice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutCashJournal.isCalloutActive()) {
            return "";
        }
        CalloutCashJournal.setCalloutActive(true);
        Integer C_Invoice_ID = (Integer)value;
        if (C_Invoice_ID == null || C_Invoice_ID == 0) {
            mTab.setValue("C_Currency_ID", null);
            CalloutCashJournal.setCalloutActive(false);
            return "";
        }
        Timestamp ts = Env.getContextAsDate(ctx, WindowNo, "DateAcct");
        if (ts == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        String sql = "SELECT C_BPartner_ID, C_Currency_ID,invoiceOpen(C_Invoice_ID, 0), IsSOTrx, paymentTermDiscount(invoiceOpen(C_Invoice_ID, 0),C_Currency_ID,C_PaymentTerm_ID,DateInvoiced,?) FROM C_Invoice WHERE C_Invoice_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setTimestamp(1, ts);
            pstmt.setInt(2, C_Invoice_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("C_Currency_ID", (Object)new Integer(rs.getInt(2)));
                BigDecimal PayAmt = rs.getBigDecimal(3);
                BigDecimal DiscountAmt = rs.getBigDecimal(5);
                boolean isSOTrx = "Y".equals(rs.getString(4));
                if (!isSOTrx) {
                    PayAmt = PayAmt.negate();
                    DiscountAmt = DiscountAmt.negate();
                }
                mTab.setValue("Amount", (Object)PayAmt.subtract(DiscountAmt));
                mTab.setValue("DiscountAmt", (Object)DiscountAmt);
                mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
                Env.setContext(ctx, WindowNo, "InvTotalAmt", PayAmt.toString());
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "invoice", e);
            CalloutCashJournal.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutCashJournal.setCalloutActive(false);
        return "";
    }

    public String amounts(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutCashJournal.isCalloutActive() || !"I".equals(mTab.getValue("CashType"))) {
            return "";
        }
        String total = Env.getContext(ctx, WindowNo, "InvTotalAmt");
        if (total == null || total.length() == 0) {
            return "";
        }
        BigDecimal InvTotalAmt = new BigDecimal(total);
        CalloutCashJournal.setCalloutActive(true);
        BigDecimal PayAmt = (BigDecimal)mTab.getValue("Amount");
        BigDecimal DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt");
        BigDecimal WriteOffAmt = (BigDecimal)mTab.getValue("WriteOffAmt");
        String colName = mField.getColumnName();
        this.log.fine(colName + " - Invoice=" + InvTotalAmt + " - Amount=" + PayAmt + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt);
        if (colName.equals("Amount")) {
            WriteOffAmt = InvTotalAmt.subtract(PayAmt).subtract(DiscountAmt);
            mTab.setValue("WriteOffAmt", (Object)WriteOffAmt);
        } else {
            PayAmt = InvTotalAmt.subtract(DiscountAmt).subtract(WriteOffAmt);
            mTab.setValue("Amount", (Object)PayAmt);
        }
        CalloutCashJournal.setCalloutActive(false);
        return "";
    }
}

