/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import org.compiere.apps.ADialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.install.Translation;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class TranslationDialog
extends CPanel
implements FormPanel,
ActionListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(TranslationDialog.class);
    private GridBagLayout mainLayout = new GridBagLayout();
    private JComboBox cbLanguage = new JComboBox();
    private JLabel lLanguage = new JLabel();
    private JLabel lTable = new JLabel();
    private JComboBox cbTable = new JComboBox();
    private JButton bExport = new JButton();
    private JButton bImport = new JButton();
    private StatusBar statusBar = new StatusBar();
    private JLabel lClient = new JLabel();
    private JComboBox cbClient = new JComboBox();

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.lClient.setText(Msg.translate(Env.getCtx(), "AD_Client_ID"));
        this.lLanguage.setText(Msg.translate(Env.getCtx(), "AD_Language"));
        this.lLanguage.setToolTipText(Msg.translate(Env.getCtx(), "IsSystemLanguage"));
        this.lTable.setText(Msg.translate(Env.getCtx(), "AD_Table_ID"));
        this.bExport.setText(Msg.getMsg(Env.getCtx(), "Export"));
        this.bExport.addActionListener(this);
        this.bImport.setText(Msg.getMsg(Env.getCtx(), "Import"));
        this.bImport.addActionListener(this);
        this.add((Component)this.cbLanguage, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lLanguage, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lTable, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.cbTable, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.bExport, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.bImport, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lClient, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.cbClient, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void dynInit() {
        ValueNamePair vp;
        ResultSet rs;
        CPreparedStatement pstmt;
        this.cbClient.addItem(new KeyNamePair(-1, ""));
        String sql = "SELECT Name, AD_Client_ID FROM AD_Client WHERE IsActive='Y' ORDER BY 2";
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                KeyNamePair kp = new KeyNamePair(rs.getInt(2), rs.getString(1));
                this.cbClient.addItem(kp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        sql = "SELECT Name, AD_Language FROM AD_Language WHERE IsActive='Y' AND (IsSystemLanguage='Y' OR IsBaseLanguage='Y')ORDER BY 1";
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                vp = new ValueNamePair(rs.getString(2), rs.getString(1));
                this.cbLanguage.addItem(vp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        this.cbTable.addItem(new ValueNamePair("", ""));
        sql = "SELECT Name, TableName FROM AD_Table WHERE TableName LIKE '%_Trl' AND TableName<>'AD_Column_Trl' ORDER BY 1";
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                vp = new ValueNamePair(rs.getString(2), rs.getString(1));
                this.cbTable.addItem(vp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        this.statusBar.setStatusLine(" ");
        this.statusBar.setStatusDB(" ");
    }

    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        try {
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    public void dispose() {
        this.m_frame.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        int returnVal;
        ValueNamePair AD_Language = (ValueNamePair)this.cbLanguage.getSelectedItem();
        if (AD_Language == null) {
            this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "LanguageSetupError"), true);
            return;
        }
        ValueNamePair AD_Table = (ValueNamePair)this.cbTable.getSelectedItem();
        if (AD_Table == null) {
            return;
        }
        boolean imp = e.getSource() == this.bImport;
        KeyNamePair AD_Client = (KeyNamePair)this.cbClient.getSelectedItem();
        int AD_Client_ID = -1;
        if (AD_Client != null) {
            AD_Client_ID = AD_Client.getKey();
        }
        String startDir = Ini.getAdempiereHome() + File.separator + "data";
        JFileChooser chooser = new JFileChooser(startDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        int n = returnVal = imp ? chooser.showOpenDialog(this) : chooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        String directory = chooser.getSelectedFile().getAbsolutePath();
        this.statusBar.setStatusLine(directory);
        this.setCursor(Cursor.getPredefinedCursor(3));
        Translation t = new Translation(Env.getCtx());
        String msg = t.validateLanguage(AD_Language.getValue());
        if (msg.length() > 0) {
            ADialog.error(this.m_WindowNo, this, "LanguageSetupError", msg);
            return;
        }
        if (AD_Table.getValue().equals("")) {
            for (int i = 1; i < this.cbTable.getItemCount(); ++i) {
                AD_Table = (ValueNamePair)this.cbTable.getItemAt(i);
                msg = null;
                msg = imp ? t.importTrl(directory, AD_Client_ID, AD_Language.getValue(), AD_Table.getValue()) : t.exportTrl(directory, AD_Client_ID, AD_Language.getValue(), AD_Table.getValue());
                this.statusBar.setStatusLine(msg);
            }
            this.statusBar.setStatusLine(directory);
        } else {
            msg = null;
            msg = imp ? t.importTrl(directory, AD_Client_ID, AD_Language.getValue(), AD_Table.getValue()) : t.exportTrl(directory, AD_Client_ID, AD_Language.getValue(), AD_Table.getValue());
            this.statusBar.setStatusLine(msg);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }
}

