/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.impexp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.util.logging.Level;
import org.compiere.util.CLogger;

public final class OFX1ToXML
extends InputStream
implements Runnable {
    private PipedReader m_reader = new PipedReader();
    private BufferedWriter m_writer;
    private String m_ofx = "";
    private CLogger log = CLogger.getCLogger(this.getClass());

    public OFX1ToXML(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        this.init(br);
    }

    public OFX1ToXML(BufferedReader br) throws IOException {
        this.init(br);
    }

    public void init(BufferedReader br) throws IOException {
        this.m_writer = new BufferedWriter(new PipedWriter(this.m_reader));
        String line = br.readLine();
        this.write("<?xml version=\"1.0\"?>\n");
        this.write("<?OFX ");
        while (line.indexOf("<") != 0) {
            if (line.length() > 0) {
                this.write(line.replaceAll(":", "=\"") + "\" ");
            }
            line = br.readLine();
        }
        this.write("?>\n");
        while (line != null) {
            this.m_ofx = this.m_ofx + line + "\n";
            line = br.readLine();
        }
        br.close();
        new Thread(this).start();
    }

    public void run() {
        String line = "";
        try {
            while (this.m_ofx != "") {
                boolean addCloseTag = false;
                int tagStart = this.m_ofx.indexOf("<");
                if (tagStart == -1) break;
                int tagEnd = this.m_ofx.indexOf(">");
                if (tagEnd <= tagStart + 1) {
                    throw new IOException("PARSE ERROR: Invalid tag");
                }
                String tag = this.m_ofx.substring(tagStart + 1, tagEnd);
                if (tag.indexOf(" ") != -1) {
                    throw new IOException("PARSE ERROR: Invalid tag");
                }
                if (!tag.startsWith("/")) {
                    addCloseTag = this.m_ofx.indexOf("</" + tag + ">") == -1;
                }
                int tag2Start = this.m_ofx.indexOf("<", tagEnd);
                if (this.m_ofx.indexOf("\n", tagEnd) < tag2Start) {
                    tag2Start = this.m_ofx.indexOf("\n", tagEnd);
                }
                if (tag2Start == -1) {
                    tag2Start = this.m_ofx.length();
                }
                String data = this.m_ofx.substring(tagEnd + 1, tag2Start);
                line = this.m_ofx.substring(0, tagEnd + 1) + OFX1ToXML.xmlEncodeTextAsPCDATA(data);
                this.m_ofx = this.m_ofx.substring(tag2Start);
                if (addCloseTag) {
                    line = line + "</" + tag + ">";
                }
                this.write(line);
            }
            this.write(this.m_ofx);
            this.m_writer.close();
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "Ofx1To2Convertor: IO Exception", e);
        }
    }

    private void write(String str) throws IOException {
        this.m_writer.write(str, 0, str.length());
    }

    public int read() throws IOException {
        return this.m_reader.read();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.m_reader.read(cbuf, off, len);
    }

    public static final String xmlEncodeTextAsPCDATA(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer n = new StringBuffer(text.length() * 2);
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    n.append("&amp;");
                    continue block7;
                }
                case '<': {
                    n.append("&lt;");
                    continue block7;
                }
                case '>': {
                    n.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    n.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    n.append("&apos;");
                    continue block7;
                }
                default: {
                    n.append(c);
                }
            }
        }
        return n.toString();
    }
}

