/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.impexp;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.compiere.model.Callout;
import org.compiere.util.CLogger;

public final class ImpFormatRow {
    private int m_seqNo;
    private String m_columnName;
    private int m_startNo = 0;
    private int m_endNo = 0;
    private String m_dataType;
    private String m_dataFormat = "";
    private String m_decimalPoint = ".";
    private boolean m_divideBy100 = false;
    private String m_constantValue = "";
    private boolean m_constantIsString = true;
    private Callout m_callout = null;
    private String m_method = null;
    private SimpleDateFormat m_dformat = null;
    private int m_maxLength = 0;
    private CLogger log = CLogger.getCLogger(this.getClass());
    public static final String DATATYPE_String = "S";
    public static final String DATATYPE_Date = "D";
    public static final String DATATYPE_Number = "N";
    public static final String DATATYPE_Constant = "C";

    public ImpFormatRow(int seqNo, String columnName, int startNo, int endNo, String dataType, int maxLength) {
        this.m_seqNo = seqNo;
        this.setColumnName(columnName);
        this.m_startNo = startNo;
        this.m_endNo = endNo;
        this.setDataType(dataType);
        this.setMaxLength(maxLength);
    }

    public ImpFormatRow(int seqNo, String columnName, String dataType, int maxLength) {
        this.m_seqNo = seqNo;
        this.setColumnName(columnName);
        this.setDataType(dataType);
        this.setMaxLength(maxLength);
    }

    public int getSeqNo() {
        return this.m_seqNo;
    }

    public void setSeqNo(int newSeqNo) {
        this.m_seqNo = newSeqNo;
    }

    public void setStartNo(int newStartNo) {
        this.m_startNo = newStartNo;
    }

    public int getStartNo() {
        return this.m_startNo;
    }

    public void setEndNo(int newEndNo) {
        this.m_endNo = newEndNo;
    }

    public int getEndNo() {
        return this.m_endNo;
    }

    public void setColumnName(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            throw new IllegalArgumentException("ColumnName must be at least 1 char");
        }
        this.m_columnName = columnName;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public void setDataType(String dataType) {
        if (!(dataType.equals(DATATYPE_String) || dataType.equals(DATATYPE_Date) || dataType.equals(DATATYPE_Number) || dataType.equals(DATATYPE_Constant))) {
            throw new IllegalArgumentException("DataType must be S/D/N/C");
        }
        this.m_dataType = dataType;
    }

    public String getDataType() {
        return this.m_dataType;
    }

    public boolean isString() {
        if (this.m_dataType.equals(DATATYPE_Constant)) {
            return this.m_constantIsString;
        }
        return this.m_dataType.equals(DATATYPE_String);
    }

    public boolean isNumber() {
        return this.m_dataType.equals(DATATYPE_Number);
    }

    public boolean isDate() {
        return this.m_dataType.equals(DATATYPE_Date);
    }

    public boolean isConstant() {
        return this.m_dataType.equals(DATATYPE_Constant);
    }

    public void setFormatInfo(String dataFormat, String decimalPoint, boolean divideBy100, String constantValue, String callout) {
        this.m_dataFormat = dataFormat == null ? "" : dataFormat;
        this.m_decimalPoint = decimalPoint == null || !decimalPoint.equals(",") ? "." : ",";
        this.m_divideBy100 = divideBy100;
        if (constantValue == null || constantValue.length() == 0 || !this.m_dataType.equals(DATATYPE_Constant)) {
            this.m_constantValue = "";
            this.m_constantIsString = true;
        } else {
            this.m_constantValue = constantValue;
            this.m_constantIsString = false;
            for (int i = 0; i < this.m_constantValue.length(); ++i) {
                char c = this.m_constantValue.charAt(i);
                if (Character.isDigit(c) || c == '.') continue;
                this.m_constantIsString = true;
                break;
            }
        }
        if (callout != null) {
            int methodStart = callout.lastIndexOf(".");
            try {
                if (methodStart != -1) {
                    Class<?> cClass = Class.forName(callout.substring(0, methodStart));
                    this.m_callout = (Callout)cClass.newInstance();
                    this.m_method = callout.substring(methodStart + 1);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "MTab.setFormatInfo - " + e.toString());
            }
            if (this.m_callout == null || this.m_method == null || this.m_method.length() == 0) {
                this.log.log(Level.SEVERE, "MTab.setFormatInfo - Invalid Callout " + callout);
                this.m_callout = null;
            }
        }
    }

    public String getDataFormat() {
        return this.m_dataFormat;
    }

    public String getDecimalPoint() {
        return this.m_decimalPoint;
    }

    public boolean isDivideBy100() {
        return this.m_divideBy100;
    }

    public String getConstantValue() {
        return this.m_constantValue;
    }

    public void setMaxLength(int maxLength) {
        this.m_maxLength = maxLength;
    }

    public String parse(String info) {
        if (info == null || info.length() == 0) {
            return "";
        }
        if (info.startsWith("[") && info.endsWith("]")) {
            return "";
        }
        String retValue = null;
        retValue = this.isNumber() ? this.parseNumber(info) : (this.isDate() ? this.parseDate(info) : (this.isConstant() ? (this.m_constantIsString ? this.parseString(this.m_constantValue) : this.m_constantValue) : this.parseString(info)));
        if (this.m_callout != null) {
            try {
                retValue = this.m_callout.convert(this.m_method, retValue);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "ImpFormatRow.parse - " + info + " (" + retValue + ")", e);
            }
        }
        if (retValue == null) {
            retValue = "";
        }
        return retValue.trim();
    }

    private String parseDate(String info) {
        if (this.m_dformat == null) {
            try {
                this.m_dformat = new SimpleDateFormat(this.m_dataFormat);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "ImpFormatRow.parseDate Format=" + this.m_dataFormat, e);
            }
            if (this.m_dformat == null) {
                this.m_dformat = (SimpleDateFormat)DateFormat.getDateInstance();
            }
            this.m_dformat.setLenient(true);
        }
        Timestamp ts = null;
        try {
            ts = new Timestamp(this.m_dformat.parse(info).getTime());
        }
        catch (ParseException pe) {
            this.log.log(Level.SEVERE, "ImpFormatRow.parseDate - " + info, pe);
        }
        if (ts == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        String dateString = ts.toString();
        return dateString.substring(0, dateString.indexOf("."));
    }

    private String parseString(String info) {
        String retValue = info;
        if (this.m_maxLength > 0 && retValue.length() > this.m_maxLength) {
            retValue = retValue.substring(0, this.m_maxLength);
        }
        StringBuffer out = new StringBuffer(retValue.length());
        for (int i = 0; i < retValue.length(); ++i) {
            char c = retValue.charAt(i);
            if (c == '\'') {
                out.append("''");
                continue;
            }
            if (c == '\\') {
                out.append("\\\\");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private String parseNumber(String info) {
        boolean hasComma;
        boolean hasPoint = info.indexOf(".") != -1;
        boolean bl = hasComma = info.indexOf(",") != -1;
        if (hasComma && this.m_decimalPoint.equals(".")) {
            info = info.replace(',', ' ');
        }
        if (hasPoint && this.m_decimalPoint.equals(",")) {
            info = info.replace('.', ' ');
        }
        boolean bl2 = hasComma = info.indexOf(",") != -1;
        if (hasComma && this.m_decimalPoint.equals(",")) {
            info = info.replace(',', '.');
        }
        char[] charArray = info.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < charArray.length; ++i) {
            if (!Character.isDigit(charArray[i]) && charArray[i] != '.') continue;
            sb.append(charArray[i]);
        }
        if (sb.length() == 0) {
            return "0";
        }
        BigDecimal bd = new BigDecimal(sb.toString());
        if (this.m_divideBy100) {
            bd = bd.divide(new BigDecimal(100.0), 2, 4);
        }
        return bd.toString();
    }
}

