/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.grid.tree.VTreeCellRenderer;
import org.compiere.grid.tree.VTreePanel_keyAdapter;
import org.compiere.grid.tree.VTreePanel_mouseAdapter;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.swing.ShadowBorder;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public final class VTreePanel
extends CPanel
implements ActionListener,
DragGestureListener,
DragSourceListener,
DropTargetListener {
    protected boolean m_lookAndFeelChanged = false;
    private static CLogger log = CLogger.getCLogger(VTreePanel.class);
    private BorderLayout mainLayout = new BorderLayout();
    private JTree tree = new JTree();
    private DefaultTreeModel treeModel;
    private DefaultTreeSelectionModel treeSelect = new DefaultTreeSelectionModel();
    private CPanel southPanel = new CPanel();
    private CCheckBox treeExpand = new CCheckBox();
    private CTextField treeSearch = new CTextField(10);
    private CLabel treeSearchLabel = new CLabel();
    private JPopupMenu popMenuTree = new JPopupMenu();
    private JPopupMenu popMenuBar = new JPopupMenu();
    private CMenuItem mFrom = new CMenuItem();
    private CMenuItem mTo = new CMenuItem();
    private CPanel bar = new CPanel();
    private JToolBar toolbar = new JToolBar(1);
    private CMenuItem mBarAdd = new CMenuItem();
    private CMenuItem mBarRemove = new CMenuItem();
    private BorderLayout southLayout = new BorderLayout();
    private JSplitPane centerSplitPane = new JSplitPane();
    private JScrollPane treePane = new JScrollPane();
    private MouseListener mouseListener = new VTreePanel_mouseAdapter(this);
    private KeyListener keyListener = new VTreePanel_keyAdapter(this);
    private int m_WindowNo;
    private int m_AD_Tree_ID = 0;
    private String m_nodeTableName = null;
    private boolean m_editable;
    private boolean m_hasBar;
    private MTreeNode m_root = null;
    private MTreeNode m_moveNode;
    private String m_search = "";
    private Enumeration m_nodeEn;
    private MTreeNode m_selectedNode;
    private CButton m_buttonSelected;
    public static final String NODE_SELECTION = "NodeSelected";
    protected DragSource dragSource = DragSource.getDefaultDragSource();
    protected DropTarget dropTarget = new DropTarget(this.tree, 2, this, true, null);
    protected DragGestureRecognizer recognizer = this.dragSource.createDefaultDragGestureRecognizer(this.tree, 2, this);

    public VTreePanel(int WindowNo, boolean hasBar, boolean editable) {
        log.config("Bar=" + hasBar + ", Editable=" + editable);
        this.m_WindowNo = WindowNo;
        this.m_hasBar = hasBar;
        this.m_editable = editable;
        this.jbInit();
        if (!hasBar) {
            this.bar.setPreferredSize(new Dimension(0, 0));
            this.centerSplitPane.setDividerLocation(0);
            this.centerSplitPane.setDividerSize(0);
            this.popMenuTree.remove(this.mBarAdd);
        } else {
            this.centerSplitPane.setDividerLocation(80);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("lookAndFeel".equals(evt.getPropertyName())) {
                        VTreePanel.this.m_lookAndFeelChanged = true;
                    }
                }
            });
        }
        if (editable) {
            this.tree.setDropTarget(this.dropTarget);
        } else {
            this.popMenuTree.remove(this.mFrom);
            this.popMenuTree.remove(this.mTo);
        }
    }

    public boolean initTree(int AD_Tree_ID) {
        log.config("AD_Tree_ID=" + AD_Tree_ID);
        this.m_AD_Tree_ID = AD_Tree_ID;
        MTree vTree = new MTree(Env.getCtx(), AD_Tree_ID, this.m_editable, true, null);
        this.m_root = vTree.getRoot();
        log.config("root=" + this.m_root);
        this.m_nodeTableName = vTree.getNodeTableName();
        this.treeModel = new DefaultTreeModel(this.m_root, true);
        this.tree.setModel(this.treeModel);
        if (this.m_hasBar) {
            this.toolbar.removeAll();
            Enumeration<TreeNode> en = this.m_root.preorderEnumeration();
            while (en.hasMoreElements()) {
                MTreeNode nd = (MTreeNode)en.nextElement();
                if (!nd.isOnBar()) continue;
                this.addToBar(nd);
            }
        }
        return true;
    }

    private void jbInit() {
        this.setLayout(this.mainLayout);
        this.mainLayout.setVgap(5);
        this.treeSelect.setSelectionMode(1);
        this.tree.setSelectionModel(this.treeSelect);
        this.tree.setEditable(false);
        this.tree.addMouseListener(this.mouseListener);
        this.tree.addKeyListener(this.keyListener);
        this.tree.setCellRenderer(new VTreeCellRenderer());
        this.treePane.getViewport().add((Component)this.tree, null);
        this.treePane.setBorder(new ShadowBorder());
        this.tree.setBorder(BorderFactory.createEmptyBorder());
        this.treeExpand.setText(Msg.getMsg(Env.getCtx(), "ExpandTree"));
        this.treeExpand.setActionCommand("Expand");
        this.treeExpand.addMouseListener(this.mouseListener);
        this.treeExpand.addActionListener(this);
        this.treeSearchLabel.setText(Msg.getMsg(Env.getCtx(), "TreeSearch") + " ");
        this.treeSearchLabel.setLabelFor(this.treeSearch);
        this.treeSearchLabel.setToolTipText(Msg.getMsg(Env.getCtx(), "TreeSearchText"));
        this.treeSearch.setBackground(AdempierePLAF.getInfoBackground());
        this.treeSearch.addKeyListener(this.keyListener);
        this.southPanel.setLayout(this.southLayout);
        this.southPanel.add((Component)this.treeExpand, "West");
        this.southPanel.add((Component)this.treeSearchLabel, "Center");
        this.southPanel.add((Component)this.treeSearch, "East");
        this.add((Component)this.southPanel, "South");
        this.centerSplitPane.setOpaque(false);
        this.toolbar.setOpaque(false);
        this.centerSplitPane.add((Component)this.treePane, "right");
        this.centerSplitPane.add((Component)this.bar, "left");
        this.centerSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.removeSplitPaneBorder();
        this.add((Component)this.centerSplitPane, "Center");
        this.mFrom.setText(Msg.getMsg(Env.getCtx(), "ItemMove"));
        this.mFrom.setActionCommand("From");
        this.mFrom.addActionListener(this);
        this.mTo.setEnabled(false);
        this.mTo.setText(Msg.getMsg(Env.getCtx(), "ItemInsert"));
        this.mTo.setActionCommand("To");
        this.mTo.addActionListener(this);
        this.bar.setMinimumSize(new Dimension(50, 50));
        this.bar.setBorder(new ShadowBorder());
        this.bar.setLayout(new FlowLayout());
        ((FlowLayout)this.bar.getLayout()).setAlignment(0);
        this.bar.add(this.toolbar);
        this.toolbar.setLayout(new GridBagLayout());
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setBorder(BorderFactory.createEmptyBorder());
        this.mBarAdd.setText(Msg.getMsg(Env.getCtx(), "BarAdd"));
        this.mBarAdd.setActionCommand("BarAdd");
        this.mBarAdd.addActionListener(this);
        this.mBarRemove.setText(Msg.getMsg(Env.getCtx(), "BarRemove"));
        this.mBarRemove.setActionCommand("BarRemove");
        this.mBarRemove.addActionListener(this);
        this.popMenuTree.setLightWeightPopupEnabled(false);
        this.popMenuTree.add(this.mBarAdd);
        this.popMenuTree.addSeparator();
        this.popMenuTree.add(this.mFrom);
        this.popMenuTree.add(this.mTo);
        this.popMenuBar.setLightWeightPopupEnabled(false);
        this.popMenuBar.add(this.mBarRemove);
    }

    private void removeSplitPaneBorder() {
        SplitPaneUI splitPaneUI;
        if (this.centerSplitPane != null && (splitPaneUI = this.centerSplitPane.getUI()) instanceof BasicSplitPaneUI) {
            BasicSplitPaneUI basicUI = (BasicSplitPaneUI)splitPaneUI;
            basicUI.getDivider().setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public void setDividerLocation(int location) {
        this.centerSplitPane.setDividerLocation(location);
    }

    public int getDividerLocation() {
        return this.centerSplitPane.getDividerLocation();
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        if (!this.m_editable) {
            return;
        }
        try {
            this.m_moveNode = (MTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        }
        catch (Exception ex) {
            return;
        }
        StringSelection content = new StringSelection(this.m_moveNode.toString());
        e.startDrag(DragSource.DefaultMoveDrop, content, this);
        log.fine("Drag: " + this.m_moveNode.toString());
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragEnter(DropTargetDragEvent e) {
        e.acceptDrag(2);
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
        Point mouseLoc = e.getLocation();
        TreePath path = this.tree.getClosestPathForLocation(mouseLoc.x, mouseLoc.y);
        this.tree.setSelectionPath(path);
        MTreeNode toNode = (MTreeNode)path.getLastPathComponent();
        if (this.m_moveNode == null || toNode == null) {
            e.rejectDrag();
        } else {
            e.acceptDrag(2);
        }
    }

    public void drop(DropTargetDropEvent e) {
        Point mouseLoc = e.getLocation();
        TreePath path = this.tree.getClosestPathForLocation(mouseLoc.x, mouseLoc.y);
        this.tree.setSelectionPath(path);
        MTreeNode toNode = (MTreeNode)path.getLastPathComponent();
        log.fine("Drop: " + toNode);
        if (this.m_moveNode == null || toNode == null) {
            e.rejectDrop();
            return;
        }
        e.acceptDrop(2);
        this.moveNode(this.m_moveNode, toNode);
        e.dropComplete(true);
        this.m_moveNode = null;
    }

    private void moveNode(MTreeNode movingNode, MTreeNode toNode) {
        int index;
        MTreeNode newParent;
        log.info(movingNode.toString() + " to " + toNode.toString());
        if (movingNode == toNode) {
            return;
        }
        MTreeNode oldParent = (MTreeNode)movingNode.getParent();
        movingNode.removeFromParent();
        this.treeModel.nodeStructureChanged(oldParent);
        if (!toNode.isSummary()) {
            newParent = (MTreeNode)toNode.getParent();
            index = newParent.getIndex(toNode) + 1;
        } else {
            newParent = toNode;
            index = 0;
        }
        newParent.insert(movingNode, index);
        this.treeModel.nodeStructureChanged(newParent);
        this.setCursor(Cursor.getPredefinedCursor(3));
        Trx trx = Trx.get("VTreePanel", true);
        try {
            StringBuffer sql;
            MTreeNode nd;
            int i;
            for (i = 0; i < oldParent.getChildCount(); ++i) {
                nd = (MTreeNode)oldParent.getChildAt(i);
                sql = new StringBuffer("UPDATE ");
                sql.append(this.m_nodeTableName).append(" SET Parent_ID=").append(oldParent.getNode_ID()).append(", SeqNo=").append(i).append(", Updated=SysDate").append(" WHERE AD_Tree_ID=").append(this.m_AD_Tree_ID).append(" AND Node_ID=").append(nd.getNode_ID());
                log.fine(sql.toString());
                DB.executeUpdate(sql.toString(), trx.getTrxName());
            }
            if (oldParent != newParent) {
                for (i = 0; i < newParent.getChildCount(); ++i) {
                    nd = (MTreeNode)newParent.getChildAt(i);
                    sql = new StringBuffer("UPDATE ");
                    sql.append(this.m_nodeTableName).append(" SET Parent_ID=").append(newParent.getNode_ID()).append(", SeqNo=").append(i).append(", Updated=SysDate").append(" WHERE AD_Tree_ID=").append(this.m_AD_Tree_ID).append(" AND Node_ID=").append(nd.getNode_ID());
                    log.fine(sql.toString());
                    DB.executeUpdate(sql.toString(), trx.getTrxName());
                }
            }
            trx.commit();
        }
        catch (Exception e) {
            trx.rollback();
            log.log(Level.SEVERE, "move", e);
            ADialog.error(this.m_WindowNo, this, "TreeUpdateError", e.getLocalizedMessage());
        }
        trx.close();
        trx = null;
        this.setCursor(Cursor.getDefaultCursor());
        log.config("complete");
    }

    protected void keyPressed(KeyEvent e) {
        if (e.getSource() instanceof JTree || e.getSource() == this.treeSearch && e.getModifiers() != 0) {
            TreePath tp = this.tree.getSelectionPath();
            if (tp == null) {
                ADialog.beep();
            } else {
                MTreeNode tn = (MTreeNode)tp.getLastPathComponent();
                this.setSelectedNode(tn);
            }
        } else if (e.getSource() == this.treeSearch) {
            String search = this.treeSearch.getText();
            boolean found = false;
            if (this.m_nodeEn != null && !this.m_nodeEn.hasMoreElements()) {
                this.m_search = "";
            }
            if (!search.equals(this.m_search)) {
                this.m_nodeEn = this.m_root.preorderEnumeration();
                this.m_search = search;
            }
            while (!found && this.m_nodeEn != null && this.m_nodeEn.hasMoreElements()) {
                MTreeNode nd = (MTreeNode)this.m_nodeEn.nextElement();
                if (nd.toString().toUpperCase().indexOf(search.toUpperCase()) == -1) continue;
                found = true;
                TreePath treePath = new TreePath(nd.getPath());
                this.tree.setSelectionPath(treePath);
                this.tree.makeVisible(treePath);
                this.tree.scrollPathToVisible(treePath);
            }
            if (!found) {
                ADialog.beep();
            }
        }
    }

    protected void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof JTree) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 0) {
                int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    MTreeNode tn = (MTreeNode)this.tree.getPathForLocation(e.getX(), e.getY()).getLastPathComponent();
                    this.setSelectedNode(tn);
                }
            } else if ((this.m_editable || this.m_hasBar) && SwingUtilities.isRightMouseButton(e) && this.tree.getSelectionPath() != null) {
                MTreeNode nd = (MTreeNode)this.tree.getSelectionPath().getLastPathComponent();
                Rectangle r = this.tree.getPathBounds(this.tree.getSelectionPath());
                this.popMenuTree.show(this.tree, (int)r.getMaxX(), (int)r.getY());
            }
        } else if (e.getSource() instanceof JButton && SwingUtilities.isRightMouseButton(e)) {
            this.m_buttonSelected = (CButton)e.getSource();
            this.popMenuBar.show(this.m_buttonSelected, e.getX(), e.getY());
        }
    }

    public MTreeNode getSelectedNode() {
        return this.m_selectedNode;
    }

    public JComponent getSearchField() {
        return this.treeSearch;
    }

    public boolean setSelectedNode(int nodeID) {
        log.config("ID=" + nodeID);
        if (nodeID != -1) {
            return this.selectID(nodeID, true);
        }
        return false;
    }

    private boolean selectID(int nodeID, boolean show) {
        if (this.m_root == null) {
            return false;
        }
        log.config("NodeID=" + nodeID + ", Show=" + show + ", root=" + this.m_root);
        MTreeNode node = this.m_root.findNode(nodeID);
        if (node != null) {
            TreePath treePath = new TreePath(node.getPath());
            log.config("Node=" + node + ", Path=" + treePath.toString());
            this.tree.setSelectionPath(treePath);
            if (show) {
                this.tree.makeVisible(treePath);
                this.tree.scrollPathToVisible(treePath);
            }
            return true;
        }
        log.info("Node not found; ID=" + nodeID);
        return false;
    }

    private void setSelectedNode(MTreeNode nd) {
        log.config("Node = " + nd);
        this.m_selectedNode = nd;
        this.firePropertyChange(NODE_SELECTION, null, nd);
    }

    public void nodeChanged(boolean save, int keyID, String name, String description, boolean isSummary, String imageIndicator) {
        log.config("Save=" + save + ", KeyID=" + keyID + ", Name=" + name + ", Description=" + description + ", IsSummary=" + isSummary + ", ImageInd=" + imageIndicator + ", root=" + this.m_root);
        if (keyID == 0) {
            return;
        }
        MTreeNode node = this.m_root.findNode(keyID);
        if (node == null && save) {
            node = new MTreeNode(keyID, 0, name, description, this.m_root.getNode_ID(), isSummary, imageIndicator, false, null);
            this.m_root.add(node);
        } else if (node != null && save) {
            node.setName(name);
            node.setAllowsChildren(isSummary);
        } else if (node != null && !save) {
            MTreeNode parent = (MTreeNode)node.getParent();
            node.removeFromParent();
            node = parent;
        } else {
            log.log(Level.SEVERE, "Save=" + save + ", KeyID=" + keyID + ", Node=" + node);
            node = null;
        }
        if (node == null) {
            return;
        }
        this.tree.updateUI();
        TreePath treePath = new TreePath(node.getPath());
        this.tree.setSelectionPath(treePath);
        this.tree.makeVisible(treePath);
        this.tree.scrollPathToVisible(treePath);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            this.selectID(Integer.parseInt(e.getActionCommand()), false);
            MTreeNode tn = (MTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            this.setSelectedNode(tn);
        } else if (e.getSource() instanceof JMenuItem) {
            if (e.getActionCommand().equals("From")) {
                this.moveFrom();
            } else if (e.getActionCommand().equals("To")) {
                this.moveTo();
            } else if (e.getActionCommand().equals("BarAdd")) {
                this.barAdd();
            } else if (e.getActionCommand().equals("BarRemove")) {
                this.barRemove();
            }
        } else if (e.getSource() instanceof JCheckBox && e.getActionCommand().equals("Expand")) {
            this.expandTree();
        }
    }

    private void moveFrom() {
        this.m_moveNode = (MTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        if (this.m_moveNode != null) {
            this.mTo.setEnabled(true);
        }
    }

    private void moveTo() {
        this.mFrom.setEnabled(true);
        this.mTo.setEnabled(false);
        if (this.m_moveNode == null) {
            return;
        }
        MTreeNode toNode = (MTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        this.moveNode(this.m_moveNode, toNode);
        this.m_moveNode = null;
    }

    private void barAdd() {
        MTreeNode nd = (MTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        if (this.barDBupdate(true, nd.getNode_ID())) {
            this.addToBar(nd);
        }
    }

    private void addToBar(MTreeNode nd) {
        String label = nd.toString().trim();
        int space = label.indexOf(" ");
        CButton button = new CButton(label);
        button.setOpaque(false);
        button.setHorizontalAlignment(2);
        button.setToolTipText(nd.getDescription());
        button.setActionCommand(String.valueOf(nd.getNode_ID()));
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setIcon(nd.getIcon());
        button.setRequestFocusEnabled(false);
        button.addActionListener(this);
        button.addMouseListener(this.mouseListener);
        this.toolbar.add((Component)button, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(1, 0, 1, 0), 4, 2));
        this.bar.validate();
        if (this.centerSplitPane.getDividerLocation() == -1) {
            this.centerSplitPane.setDividerLocation(button.getPreferredSize().width);
        }
        this.bar.repaint();
    }

    private void barRemove() {
        this.toolbar.remove(this.m_buttonSelected);
        this.bar.validate();
        this.bar.repaint();
        this.barDBupdate(false, Integer.parseInt(this.m_buttonSelected.getActionCommand()));
    }

    private boolean barDBupdate(boolean add, int Node_ID) {
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        int AD_Org_ID = Env.getContextAsInt(Env.getCtx(), "#AD_Org_ID");
        int AD_User_ID = Env.getContextAsInt(Env.getCtx(), "#AD_User_ID");
        StringBuffer sql = new StringBuffer();
        if (add) {
            sql.append("INSERT INTO AD_TreeBar (AD_Tree_ID,AD_User_ID,Node_ID, AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy)VALUES (").append(this.m_AD_Tree_ID).append(",").append(AD_User_ID).append(",").append(Node_ID).append(",").append(AD_Client_ID).append(",").append(AD_Org_ID).append(",").append("'Y',SysDate,").append(AD_User_ID).append(",SysDate,").append(AD_User_ID).append(")");
        } else {
            sql.append("DELETE AD_TreeBar WHERE AD_Tree_ID=").append(this.m_AD_Tree_ID).append(" AND AD_User_ID=").append(AD_User_ID).append(" AND Node_ID=").append(Node_ID);
        }
        int no = DB.executeUpdate(sql.toString(), true, null);
        return no == 1;
    }

    private void expandTree() {
        if (this.treeExpand.isSelected()) {
            for (int row = 0; row < this.tree.getRowCount(); ++row) {
                this.tree.expandRow(row);
            }
        } else {
            for (int row = 0; row < this.tree.getRowCount(); ++row) {
                this.tree.collapseRow(row);
            }
        }
    }

    public void paint(Graphics g) {
        if (this.m_lookAndFeelChanged) {
            this.m_lookAndFeelChanged = false;
            if (this.m_hasBar) {
                this.removeSplitPaneBorder();
            }
        }
        super.paint(g);
    }
}

