/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ValuePreference
extends CDialog
implements ActionListener {
    public static final String NAME = "ValuePreference";
    private static Icon s_icon = new ImageIcon(Adempiere.class.getResource("images/VPreference16.gif"));
    private static CLogger log = CLogger.getCLogger(ValuePreference.class);
    private Properties m_ctx;
    private int m_WindowNo;
    private int m_AD_Client_ID;
    private int m_AD_Org_ID;
    private int m_AD_User_ID;
    private int m_AD_Window_ID;
    private String m_Attribute;
    private String m_DisplayAttribute;
    private String m_Value;
    private String m_DisplayValue;
    private int m_DisplayType;
    private int m_AD_Reference_ID;
    private MRole m_role;
    private CPanel setPanel = new CPanel();
    private GridBagLayout setLayout = new GridBagLayout();
    private CLabel lAttribute = new CLabel();
    private CTextField fAttribute = new CTextField();
    private CLabel lAttributeValue = new CLabel();
    private CLabel lValue = new CLabel();
    private CLabel lValueValue = new CLabel();
    private CTextField fValue = new CTextField();
    private CLabel lSetFor = new CLabel();
    private VCheckBox cbClient = new VCheckBox();
    private VCheckBox cbOrg = new VCheckBox();
    private VCheckBox cbUser = new VCheckBox();
    private VCheckBox cbWindow = new VCheckBox();
    private CLabel lExplanation = new CLabel();
    private CPanel currentPanel = new CPanel();
    private TitledBorder titledBorder;
    private JScrollPane scrollPane = new JScrollPane();
    private BorderLayout currentLayout = new BorderLayout();
    private JTable table = new JTable();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private JButton bDelete;

    public static ValuePreference start(GridField mField, Object aValue) {
        return ValuePreference.start(mField, aValue, null);
    }

    public static ValuePreference start(GridField mField, Object aValue, String aDisplayValue) {
        if (!mField.isEditable(false)) {
            log.info("Field not editable (R/O)");
            return null;
        }
        String Value = null;
        String DisplayValue = null;
        if (aValue != null) {
            Value = aValue.toString();
            DisplayValue = aDisplayValue == null ? Value : aDisplayValue;
        }
        int AD_Window_ID = mField.getAD_Window_ID();
        String Attribute2 = mField.getColumnName();
        String DisplayAttribute = mField.getHeader();
        int displayType = mField.getDisplayType();
        int AD_Reference_ID = 0;
        int WindowNo = mField.getWindowNo();
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        int AD_Org_ID = Env.getContextAsInt(Env.getCtx(), WindowNo, "AD_Org_ID");
        int AD_User_ID = Env.getAD_User_ID(Env.getCtx());
        JFrame frame = Env.getWindow(WindowNo);
        ValuePreference vp = new ValuePreference(frame, WindowNo, AD_Client_ID, AD_Org_ID, AD_User_ID, AD_Window_ID, Attribute2, DisplayAttribute, Value, DisplayValue, displayType, AD_Reference_ID);
        return vp;
    }

    public static CMenuItem addMenu(ActionListener l, JPopupMenu popupMenu) {
        CMenuItem mi = new CMenuItem(Msg.getMsg(Env.getCtx(), NAME), s_icon);
        mi.setActionCommand(NAME);
        mi.addActionListener(l);
        popupMenu.add(mi);
        return mi;
    }

    public ValuePreference(Frame frame, int WindowNo, int AD_Client_ID, int AD_Org_ID, int AD_User_ID, int AD_Window_ID, String Attribute2, String DisplayAttribute, String Value, String DisplayValue, int displayType, int AD_Reference_ID) {
        super(frame, Msg.getMsg(Env.getCtx(), NAME) + " " + DisplayAttribute, true);
        log.config("WindowNo=" + WindowNo + ", Client_ID=" + AD_Client_ID + ", Org_ID=" + AD_Org_ID + ", User_ID=" + AD_User_ID + ", Window_ID=" + AD_Window_ID + ",  Attribute=" + Attribute2 + "/" + DisplayAttribute + ",  Value=" + Value + "/" + DisplayValue + ",  DisplayType=" + displayType + ", Reference_ID=" + AD_Reference_ID);
        this.m_ctx = Env.getCtx();
        this.m_WindowNo = WindowNo;
        this.m_AD_Client_ID = AD_Client_ID;
        this.m_AD_Org_ID = AD_Org_ID;
        this.m_AD_User_ID = AD_User_ID;
        this.m_AD_Window_ID = AD_Window_ID;
        this.m_Attribute = Attribute2;
        this.m_DisplayAttribute = DisplayAttribute;
        this.m_Value = Value;
        this.m_DisplayValue = DisplayValue;
        this.m_DisplayType = displayType;
        this.m_AD_Reference_ID = AD_Reference_ID;
        this.m_role = MRole.getDefault();
        try {
            this.jbInit();
            this.dynInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
        AEnv.showCenterScreen(this);
    }

    void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), Msg.getMsg(this.m_ctx, "CurrentSettings"));
        this.lAttribute.setText(Msg.translate(this.m_ctx, "Attribute"));
        this.lValue.setText(Msg.translate(this.m_ctx, "Value"));
        this.lSetFor.setText(Msg.getMsg(this.m_ctx, "ValuePreferenceSetFor"));
        this.cbClient.setText(Msg.translate(this.m_ctx, "AD_Client_ID"));
        this.cbOrg.setText(Msg.translate(this.m_ctx, "AD_Org_ID"));
        this.cbUser.setText(Msg.translate(this.m_ctx, "AD_User_ID"));
        this.cbUser.setSelected(true);
        this.cbWindow.setText(Msg.translate(this.m_ctx, "AD_Window_ID"));
        this.cbWindow.setSelected(true);
        this.setPanel.setLayout(this.setLayout);
        this.fAttribute.setEditable(false);
        this.fValue.setEditable(false);
        this.getContentPane().add((Component)this.setPanel, "North");
        this.setPanel.add((Component)this.lAttribute, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setPanel.add((Component)this.fAttribute, new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setPanel.add((Component)this.lValue, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setPanel.add((Component)this.fValue, new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setPanel.add((Component)this.lSetFor, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setPanel.add((Component)this.cbClient, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setPanel.add((Component)this.cbOrg, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setPanel.add((Component)this.cbUser, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setPanel.add((Component)this.cbWindow, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setPanel.add((Component)this.lAttributeValue, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setPanel.add((Component)this.lValueValue, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setPanel.add((Component)this.lExplanation, new GridBagConstraints(1, 3, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.currentPanel.setBorder(this.titledBorder);
        this.currentPanel.setLayout(this.currentLayout);
        this.currentPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.table, null);
        this.getContentPane().add((Component)this.confirmPanel, "South");
    }

    private void dynInit() {
        this.fAttribute.setText(this.m_DisplayAttribute);
        this.lAttributeValue.setText(this.m_Attribute);
        this.fValue.setText(this.m_DisplayValue);
        this.lValueValue.setText(this.m_Value);
        if (CLogMgt.isLevelFine()) {
            this.lAttributeValue.setVisible(false);
            this.lValueValue.setVisible(false);
        }
        this.cbClient.setEnabled(false);
        this.cbClient.setSelected(true);
        if ("C".equals(this.m_role.getPreferenceType())) {
            this.cbOrg.addActionListener(this);
        } else {
            this.cbOrg.setEnabled(false);
            this.cbOrg.setSelected(true);
        }
        if ("C".equals(this.m_role.getPreferenceType()) || "O".equals(this.m_role.getPreferenceType())) {
            this.cbUser.addActionListener(this);
        } else {
            this.cbUser.setEnabled(false);
            this.cbUser.setSelected(true);
        }
        this.cbWindow.addActionListener(this);
        this.confirmPanel.addActionListener(this);
        this.bDelete = this.confirmPanel.addButton(ConfirmPanel.createDeleteButton(true));
        this.bDelete.addActionListener(this);
        this.setExplanation();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Ok")) {
            this.insert();
            this.dispose();
        } else if (e.getSource() == this.bDelete) {
            int no = this.delete();
            if (no == 0) {
                ADialog.warn(this.m_WindowNo, this, "ValuePreferenceNotFound");
            } else {
                ADialog.info(this.m_WindowNo, this, "ValuePreferenceDeleted", String.valueOf(no));
            }
            this.dispose();
        } else {
            this.setExplanation();
        }
    }

    private void setExplanation() {
        StringBuffer expl = new StringBuffer("For ");
        if (this.cbClient.isSelected() && this.cbOrg.isSelected()) {
            expl.append("this Client and Organization");
        } else if (this.cbClient.isSelected() && !this.cbOrg.isSelected()) {
            expl.append("all Organizations of this Client");
        } else if (!this.cbClient.isSelected() && this.cbOrg.isSelected()) {
            this.cbOrg.setSelected(false);
            expl.append("entire System");
        } else {
            expl.append("entire System");
        }
        if (this.cbUser.isSelected()) {
            expl.append(", this User");
        } else {
            expl.append(", all Users");
        }
        if (this.cbWindow.isSelected()) {
            expl.append(" and this Window");
        } else {
            expl.append(" and all Windows");
        }
        if (Env.getLanguage(Env.getCtx()).isBaseLanguage()) {
            this.lExplanation.setText(expl.toString());
            this.pack();
        }
    }

    public int delete() {
        log.info("");
        StringBuffer sql = new StringBuffer("DELETE FROM AD_Preference WHERE ");
        sql.append("AD_Client_ID=").append(this.cbClient.isSelected() ? this.m_AD_Client_ID : 0);
        sql.append(" AND AD_Org_ID=").append(this.cbOrg.isSelected() ? this.m_AD_Org_ID : 0);
        if (this.cbUser.isSelected()) {
            sql.append(" AND AD_User_ID=").append(this.m_AD_User_ID);
        } else {
            sql.append(" AND AD_User_ID IS NULL");
        }
        if (this.cbWindow.isSelected()) {
            sql.append(" AND AD_Window_ID=").append(this.m_AD_Window_ID);
        } else {
            sql.append(" AND AD_Window_ID IS NULL");
        }
        sql.append(" AND Attribute='").append(this.m_Attribute).append("'");
        log.fine(sql.toString());
        int no = DB.executeUpdate(sql.toString(), null);
        if (no > 0) {
            Env.setContext(this.m_ctx, this.getContextKey(), (String)null);
        }
        return no;
    }

    private String getContextKey() {
        if (this.cbWindow.isSelected()) {
            return "P" + this.m_AD_Window_ID + "|" + this.m_Attribute;
        }
        return "P|" + this.m_Attribute;
    }

    public void insert() {
        log.info("");
        int no = this.delete();
        if (this.m_Value == null || this.m_Value.length() == 0) {
            if (DisplayType.isLookup(this.m_DisplayType)) {
                this.m_Value = "-1";
            } else if (DisplayType.isDate(this.m_DisplayType)) {
                this.m_Value = " ";
            } else {
                ADialog.warn(this.m_WindowNo, this, "ValuePreferenceNotInserted");
                return;
            }
        }
        int Client_ID = this.cbClient.isSelected() ? this.m_AD_Client_ID : 0;
        int Org_ID = this.cbOrg.isSelected() ? this.m_AD_Org_ID : 0;
        int AD_Preference_ID = DB.getNextID(this.m_ctx, "AD_Preference", null);
        StringBuffer sql = new StringBuffer("INSERT INTO AD_Preference (AD_Preference_ID, AD_Client_ID, AD_Org_ID, IsActive, Created,CreatedBy,Updated,UpdatedBy,AD_Window_ID, AD_User_ID, Attribute, Value) VALUES (");
        sql.append(AD_Preference_ID).append(",").append(Client_ID).append(",").append(Org_ID).append(", 'Y',SysDate,").append(this.m_AD_User_ID).append(",SysDate,").append(this.m_AD_User_ID).append(", ");
        if (this.cbWindow.isSelected()) {
            sql.append(this.m_AD_Window_ID).append(",");
        } else {
            sql.append("NULL,");
        }
        if (this.cbUser.isSelected()) {
            sql.append(this.m_AD_User_ID).append(",");
        } else {
            sql.append("NULL,");
        }
        sql.append("'").append(this.m_Attribute).append("','").append(this.m_Value).append("')");
        log.fine(sql.toString());
        no = DB.executeUpdate(sql.toString(), null);
        if (no == 1) {
            Env.setContext(this.m_ctx, this.getContextKey(), this.m_Value);
            ADialog.info(this.m_WindowNo, this, "ValuePreferenceInserted");
        } else {
            ADialog.warn(this.m_WindowNo, this, "ValuePreferenceNotInserted");
        }
    }
}

