/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.grid.ed.HTMLEditor;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VTextLong_mouseAdapter;
import org.compiere.model.GridField;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CTextPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VTextLong
extends CTextPane
implements VEditor,
KeyListener,
ActionListener {
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem menuEditor;
    private String m_columnName;
    private String m_oldText;
    private String m_initialText;
    private volatile boolean m_setting = false;
    private static CLogger log = CLogger.getCLogger(VTextLong.class);

    public static String startEditor(Container jc, String header, String text, boolean editable) {
        JFrame frame = Env.getFrame(jc);
        HTMLEditor ed = new HTMLEditor((Frame)frame, header, text, editable);
        String s = ed.getHtmlText();
        ed = null;
        return s;
    }

    public VTextLong(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int displayLength, int fieldLength) {
        super.setName(columnName);
        LookAndFeel.installBorder(this, "TextField.border");
        this.setPreferredSize(new Dimension(500, 80));
        this.setForeground(AdempierePLAF.getTextColor_Normal());
        this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        this.setMandatory(mandatory);
        this.m_columnName = columnName;
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        }
        this.addKeyListener(this);
        this.addMouseListener(new VTextLong_mouseAdapter(this));
        this.menuEditor = new CMenuItem(Msg.getMsg(Env.getCtx(), "Editor"), Env.getImageIcon("Editor16.gif"));
        this.menuEditor.addActionListener(this);
        this.popupMenu.add(this.menuEditor);
    }

    public void dispose() {
    }

    public void setValue(Object value) {
        this.m_oldText = value == null ? "" : value.toString();
        if (this.m_setting) {
            return;
        }
        super.setValue(this.m_oldText);
        this.m_initialText = this.m_oldText;
        this.setCaretPosition(0);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    public void actionPerformed(ActionEvent e) {
        log.finest("VTestLong.actionPerformed - " + e.getActionCommand());
        if (e.getSource() == this.menuEditor) {
            this.menuEditor.setEnabled(false);
            String s = VTextLong.startEditor(this, Msg.translate(Env.getCtx(), this.m_columnName), this.getText(), this.isEditable());
            this.menuEditor.setEnabled(true);
            try {
                this.fireVetoableChange(this.m_columnName, this.m_oldText, s);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void addActionListener(ActionListener listener) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setText(this.m_initialText);
        }
        this.m_setting = true;
        try {
            this.fireVetoableChange(this.m_columnName, this.m_oldText, this.getText());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.m_setting = false;
    }

    public void setField(GridField mField) {
    }
}

