/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ScriptEditor;
import org.compiere.grid.ed.Editor;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VText_mouseAdapter;
import org.compiere.model.GridField;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CTextArea;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VText
extends CTextArea
implements VEditor,
KeyListener,
ActionListener {
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem menuEditor;
    private int m_fieldLength;
    private String m_columnName;
    private String m_oldText;
    private String m_initialText;
    private volatile boolean m_setting = false;

    public VText(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int displayLength, int fieldLength) {
        super(fieldLength < 300 ? 2 : 3, 50);
        super.setName(columnName);
        LookAndFeel.installBorder(this, "TextField.border");
        this.setColumns(displayLength > 60 ? 60 : displayLength);
        this.setForeground(AdempierePLAF.getTextColor_Normal());
        this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setMandatory(mandatory);
        this.m_columnName = columnName;
        this.m_fieldLength = fieldLength;
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        }
        this.addKeyListener(this);
        this.addMouseListener(new VText_mouseAdapter(this));
        this.menuEditor = columnName.equals("Script") ? new CMenuItem(Msg.getMsg(Env.getCtx(), "Script"), Env.getImageIcon("Script16.gif")) : new CMenuItem(Msg.getMsg(Env.getCtx(), "Editor"), Env.getImageIcon("Editor16.gif"));
        this.menuEditor.addActionListener(this);
        this.popupMenu.add(this.menuEditor);
    }

    public void dispose() {
    }

    public void setValue(Object value) {
        this.m_oldText = value == null ? "" : value.toString();
        if (this.m_setting) {
            return;
        }
        super.setValue(this.m_oldText);
        this.m_initialText = this.m_oldText;
        this.setCaretPosition(0);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuEditor) {
            this.menuEditor.setEnabled(false);
            String s = null;
            s = this.m_columnName.equals("Script") ? ScriptEditor.start(Msg.translate(Env.getCtx(), this.m_columnName), this.getText(), this.isEditable(), 0) : Editor.startEditor(this, Msg.translate(Env.getCtx(), this.m_columnName), this.getText(), this.isEditable(), this.m_fieldLength);
            this.menuEditor.setEnabled(true);
            try {
                this.fireVetoableChange(this.m_columnName, this.m_oldText, s);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void addActionListener(ActionListener listener) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setText(this.m_initialText);
        }
        this.m_setting = true;
        try {
            this.fireVetoableChange(this.m_columnName, this.m_oldText, this.getText());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.m_setting = false;
    }

    public void setField(GridField mField) {
    }
}

