/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.JPopupMenu;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.grid.ed.Editor;
import org.compiere.grid.ed.MDocString;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VOvrCaret;
import org.compiere.grid.ed.VString_mouseAdapter;
import org.compiere.grid.ed.ValuePreference;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.model.Obscure;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public final class VString
extends CTextField
implements VEditor,
ActionListener,
FocusListener {
    public static final int MAXDISPLAY_LENGTH = 60;
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mEditor;
    private GridField m_mField = null;
    private String m_columnName;
    private String m_oldText;
    private String m_initialText;
    private String m_VFormat;
    private int m_fieldLength;
    private Obscure m_obscure = null;
    private Font m_stdFont = null;
    private Font m_obscureFont = null;
    private volatile boolean m_setting = false;
    private volatile boolean m_infocus = false;
    private static CLogger log = CLogger.getCLogger(VString.class);

    public VString() {
        this("String", false, false, true, 30, 30, "", null);
    }

    public VString(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int displayLength, int fieldLength, String VFormat, String ObscureType) {
        super(displayLength > 60 ? 60 : displayLength);
        super.setName(columnName);
        this.m_columnName = columnName;
        if (VFormat == null) {
            VFormat = "";
        }
        this.m_VFormat = VFormat;
        this.m_fieldLength = fieldLength;
        if (this.m_VFormat.length() != 0 || this.m_fieldLength != 0) {
            this.setDocument(new MDocString(this.m_VFormat, this.m_fieldLength, this));
        }
        if (this.m_VFormat.length() != 0) {
            this.setCaret(new VOvrCaret());
        }
        this.setMandatory(mandatory);
        if (ObscureType != null && ObscureType.length() > 0) {
            this.m_obscure = new Obscure("", ObscureType);
            this.m_stdFont = this.getFont();
            this.m_obscureFont = new Font("SansSerif", 2, this.m_stdFont.getSize());
            this.addFocusListener(this);
        }
        if (isReadOnly || !isUpdateable) {
            this.setEditable(false);
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        }
        this.addKeyListener(this);
        this.addActionListener(this);
        if (fieldLength > displayLength) {
            this.addMouseListener(new VString_mouseAdapter(this));
            this.mEditor = new CMenuItem(Msg.getMsg(Env.getCtx(), "Editor"), Env.getImageIcon("Editor16.gif"));
            this.mEditor.addActionListener(this);
            this.popupMenu.add(this.mEditor);
        }
        this.setForeground(AdempierePLAF.getTextColor_Normal());
        this.setBackground(AdempierePLAF.getFieldBackground_Normal());
    }

    public void dispose() {
        this.m_mField = null;
    }

    public void setValue(Object value) {
        this.m_oldText = value == null ? "" : value.toString();
        if (this.m_setting) {
            return;
        }
        this.setText(this.m_oldText);
        this.m_initialText = this.m_oldText;
        if (!this.isEditable() || !this.isEnabled()) {
            this.setCaretPosition(0);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    public Object getValue() {
        return this.getText();
    }

    public String getDisplay() {
        return super.getText();
    }

    public void keyReleased(KeyEvent e) {
        log.finest("Key=" + e.getKeyCode() + " - " + e.getKeyChar() + " -> " + this.getText());
        if (e.getKeyCode() == 27) {
            this.setText(this.m_initialText);
        }
        this.m_setting = true;
        try {
            String clear = this.getText();
            if (clear.length() > this.m_fieldLength) {
                clear = clear.substring(0, this.m_fieldLength);
            }
            this.fireVetoableChange(this.m_columnName, this.m_oldText, clear);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.m_setting = false;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ValuePreference")) {
            if (MRole.getDefault().isShowPreference()) {
                ValuePreference.start(this.m_mField, this.getValue());
            }
            return;
        }
        if (e.getSource() == this.mEditor) {
            String s = Editor.startEditor(this, Msg.translate(Env.getCtx(), this.m_columnName), this.getText(), this.isEditable(), this.m_fieldLength);
            this.setText(s);
        }
        try {
            this.fireVetoableChange(this.m_columnName, this.m_oldText, this.getText());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setField(GridField mField) {
        this.m_mField = mField;
        if (this.m_mField != null && MRole.getDefault().isShowPreference()) {
            ValuePreference.addMenu(this, this.popupMenu);
        }
    }

    public void setText(String text) {
        if (this.m_obscure != null && !this.m_infocus) {
            super.setFont(this.m_obscureFont);
            super.setText(this.m_obscure.getObscuredValue(text));
            super.setForeground(Color.gray);
        } else {
            if (this.m_stdFont != null) {
                super.setFont(this.m_stdFont);
                super.setForeground(AdempierePLAF.getTextColor_Normal());
            }
            super.setText(text);
        }
    }

    public String getText() {
        String text = super.getText();
        if (this.m_obscure != null && text != null && text.length() > 0 && text.equals(this.m_obscure.getObscuredValue())) {
            text = this.m_obscure.getClearValue();
        }
        return text;
    }

    public void focusGained(FocusEvent e) {
        this.m_infocus = true;
        this.setText(this.getText());
    }

    public void focusLost(FocusEvent e) {
        this.m_infocus = false;
        this.setText(this.getText());
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.m_stdFont = f;
        this.m_obscureFont = new Font("SansSerif", 2, this.m_stdFont.getSize());
    }
}

