/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.text.Document;
import org.compiere.apps.AEnv;
import org.compiere.apps.AGlassPane;
import org.compiere.grid.ed.Calculator;
import org.compiere.grid.ed.MDocNumber;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.ValuePreference;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public final class VNumber
extends JComponent
implements VEditor,
ActionListener,
KeyListener,
FocusListener {
    public static final int SIZE = 12;
    private String m_columnName;
    protected int m_displayType;
    private DecimalFormat m_format;
    private String m_title;
    private boolean m_setting;
    private String m_oldText;
    private String m_initialText;
    private boolean m_rangeSet = false;
    private Double m_minValue;
    private Double m_maxValue;
    private boolean m_modified = false;
    private CTextField m_text = new CTextField(12);
    private CButton m_button = new CButton();
    private GridField m_mField = null;
    private static CLogger log = CLogger.getCLogger(VNumber.class);

    public VNumber() {
        this("Number", false, false, true, 22, "Number");
    }

    public VNumber(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int displayType, String title) {
        super.setName(columnName);
        this.m_columnName = columnName;
        this.m_title = title;
        this.setDisplayType(displayType);
        LookAndFeel.installBorder(this, "TextField.border");
        this.setLayout(new BorderLayout());
        this.m_text.setBorder(null);
        this.m_text.setHorizontalAlignment(11);
        this.m_text.addKeyListener(this);
        this.m_text.addFocusListener(this);
        this.setMandatory(mandatory);
        this.add((Component)this.m_text, "Center");
        this.m_button.setIcon(Env.getImageIcon("Calculator10.gif"));
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setFocusable(false);
        this.m_button.addActionListener(this);
        this.add((Component)this.m_button, "East");
        this.setPreferredSize(this.getPreferredSize());
        this.setColumns(12, CComboBox.FIELD_HIGHT - 4);
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
    }

    public void dispose() {
        this.m_text = null;
        this.m_button = null;
        this.m_mField = null;
    }

    protected void setDocument(Document doc) {
        this.m_text.setDocument(doc);
    }

    public void setColumns(int columns, int height) {
        this.m_text.setPreferredSize(null);
        this.m_text.setColumns(columns);
        Dimension size = this.m_text.getPreferredSize();
        if (height > size.height) {
            size.height = height;
        }
        if (CComboBox.FIELD_HIGHT - 4 > size.height) {
            size.height = VLookup.FIELD_HIGHT - 4;
        }
        this.setPreferredSize(size);
        this.setMinimumSize(new Dimension(columns * 10, size.height));
        this.m_button.setPreferredSize(new Dimension(size.height, size.height));
    }

    public boolean setRange(Double minValue, Double maxValue) {
        this.m_rangeSet = true;
        this.m_minValue = minValue;
        this.m_maxValue = maxValue;
        return this.m_rangeSet;
    }

    public boolean setRange(String minValue, String maxValue) {
        if (minValue == null || maxValue == null) {
            return false;
        }
        try {
            this.m_minValue = Double.valueOf(minValue);
            this.m_maxValue = Double.valueOf(maxValue);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        this.m_rangeSet = true;
        return this.m_rangeSet;
    }

    public void setDisplayType(int displayType) {
        this.m_displayType = displayType;
        if (!DisplayType.isNumeric(displayType)) {
            this.m_displayType = 22;
        }
        this.m_format = DisplayType.getNumberFormat(displayType);
        this.m_text.setDocument(new MDocNumber(displayType, this.m_format, this.m_text, this.m_title));
    }

    public void setReadWrite(boolean value) {
        if (this.m_text.isReadWrite() != value) {
            this.m_text.setReadWrite(value);
        }
        if (this.m_button.isReadWrite() != value) {
            this.m_button.setReadWrite(value);
        }
        if (this.m_button.isVisible() != value) {
            this.m_button.setVisible(value);
        }
    }

    public boolean isReadWrite() {
        return this.m_text.isReadWrite();
    }

    public void setMandatory(boolean mandatory) {
        this.m_text.setMandatory(mandatory);
    }

    public boolean isMandatory() {
        return this.m_text.isMandatory();
    }

    public void setBackground(Color color) {
        this.m_text.setBackground(color);
    }

    public void setBackground(boolean error) {
        this.m_text.setBackground(error);
    }

    public void setForeground(Color fg) {
        this.m_text.setForeground(fg);
    }

    public void setValue(Object value) {
        log.finest("Value=" + value);
        this.m_oldText = value == null ? "" : this.m_format.format(value);
        if (this.m_setting) {
            return;
        }
        this.m_text.setText(this.m_oldText);
        this.m_initialText = this.m_oldText;
        this.m_modified = false;
    }

    public void requestFocus() {
        this.m_text.requestFocus();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    public Object getValue() {
        if (this.m_text == null || this.m_text.getText() == null || this.m_text.getText().length() == 0) {
            return null;
        }
        String value = this.m_text.getText();
        if (value == null || value.length() == 0) {
            if (!this.m_modified) {
                return null;
            }
            if (this.m_displayType == 11) {
                return new Integer(0);
            }
            return Env.ZERO;
        }
        if (value.equals(".") || value.equals(",") || value.equals("-")) {
            value = "0";
        }
        try {
            Number number = this.m_format.parse(value);
            value = number.toString();
            BigDecimal bd = new BigDecimal(value);
            if (this.m_displayType == 11) {
                return new Integer(bd.intValue());
            }
            if (bd.signum() == 0) {
                return bd;
            }
            return bd.setScale(this.m_format.getMaximumFractionDigits(), 4);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Value=" + value, e);
            if (this.m_displayType == 11) {
                return new Integer(0);
            }
            return Env.ZERO;
        }
    }

    public String getDisplay() {
        return this.m_text.getText();
    }

    public String getTitle() {
        return this.m_title;
    }

    public Object plus() {
        Object value = this.getValue();
        if (value == null) {
            value = this.m_displayType == 11 ? new Integer(0) : Env.ZERO;
        }
        value = value instanceof BigDecimal ? ((BigDecimal)value).add(Env.ONE) : new Integer((Integer)value + 1);
        this.setValue(value);
        return value;
    }

    public Object minus(int minimum) {
        Object value = this.getValue();
        if (value == null) {
            value = this.m_displayType == 11 ? new Integer(minimum) : new BigDecimal(minimum);
            this.setValue(value);
            return value;
        }
        if (value instanceof BigDecimal) {
            BigDecimal min;
            BigDecimal bd = ((BigDecimal)value).subtract(Env.ONE);
            value = bd.compareTo(min = new BigDecimal(minimum)) < 0 ? min : bd;
        } else {
            int i = (Integer)value;
            if (--i < minimum) {
                i = minimum;
            }
            value = new Integer(i);
        }
        this.setValue(value);
        return value;
    }

    public void actionPerformed(ActionEvent e) {
        log.config(e.getActionCommand());
        if ("ValuePreference".equals(e.getActionCommand())) {
            if (MRole.getDefault().isShowPreference()) {
                ValuePreference.start(this.m_mField, this.getValue());
            }
            return;
        }
        if (e.getSource() == this.m_button) {
            this.m_button.setEnabled(false);
            String str = VNumber.startCalculator(this, this.m_text.getText(), this.m_format, this.m_displayType, this.m_title);
            this.m_text.setText(str);
            this.m_button.setEnabled(true);
            try {
                this.fireVetoableChange(this.m_columnName, this.m_oldText, this.getValue());
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.m_text.requestFocus();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        log.finest("Key=" + e.getKeyCode() + " - " + e.getKeyChar() + " -> " + this.m_text.getText());
        if (e.getKeyCode() == 27) {
            this.m_text.setText(this.m_initialText);
        }
        this.m_modified = true;
        this.m_setting = true;
        try {
            if (e.getKeyCode() == 10) {
                this.fireVetoableChange(this.m_columnName, this.m_oldText, this.getValue());
                this.fireActionPerformed();
            } else {
                this.fireVetoableChange(this.m_columnName, this.m_oldText, null);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.m_setting = false;
    }

    public void focusGained(FocusEvent e) {
        if (this.m_text != null) {
            this.m_text.selectAll();
        }
    }

    public void focusLost(FocusEvent e) {
        if (e.getOppositeComponent() instanceof AGlassPane) {
            this.m_text.setText(this.m_initialText);
            return;
        }
        try {
            this.fireVetoableChange(this.m_columnName, this.m_initialText, this.getValue());
            this.fireActionPerformed();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public static String startCalculator(Container jc, String value, DecimalFormat format, int displayType, String title) {
        log.config("Value=" + value);
        BigDecimal startValue = new BigDecimal(0.0);
        try {
            if (value != null && value.length() > 0) {
                Number number = format.parse(value);
                startValue = new BigDecimal(number.toString());
            }
        }
        catch (ParseException pe) {
            log.info("InvalidEntry - " + pe.getMessage());
        }
        JFrame frame = Env.getFrame(jc);
        Calculator calc = new Calculator(frame, title, displayType, format, startValue);
        AEnv.showCenterWindow(frame, calc);
        BigDecimal result = calc.getNumber();
        log.config("Result=" + result);
        calc = null;
        if (result != null) {
            return format.format(result);
        }
        return value;
    }

    public void setField(GridField mField) {
        this.m_mField = mField;
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        ActionEvent ae = new ActionEvent(this, 1001, "VNumber", EventQueue.getMostRecentEventTime(), modifiers);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(ae);
        }
    }
}

