/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.InfoBPartner;
import org.compiere.apps.search.InfoProduct;
import org.compiere.grid.ed.VBPartner;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VLookup_mouseAdapter;
import org.compiere.grid.ed.ValuePreference;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;

public class VLookup
extends JComponent
implements VEditor,
ActionListener,
FocusListener {
    public static final int DISPLAY_LENGTH = 15;
    public static int FIELD_HIGHT = 0;
    private CTextField m_text = new CTextField(15);
    private CButton m_button = new CButton();
    private VComboBox m_combo = new VComboBox();
    private volatile boolean m_settingValue = false;
    private volatile boolean m_settingFocus = false;
    private volatile boolean m_haveFocus = false;
    private volatile boolean m_inserting = false;
    private String m_lastDisplay = "";
    private String m_columnName;
    private Lookup m_lookup;
    private boolean m_comboActive = true;
    private Object m_value;
    private boolean m_zoomStarted = false;
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mZoom;
    private CMenuItem mRefresh;
    private CMenuItem mBPartnerNew;
    private CMenuItem mBPartnerUpd;
    private GridField m_mField = null;
    private static CLogger log = CLogger.getCLogger(VLookup.class);
    private String m_tableName = null;
    private String m_keyColumnName = null;

    public static VLookup createBPartner(int WindowNo) {
        int AD_Column_ID = 3499;
        try {
            MLookup lookup = MLookupFactory.get(Env.getCtx(), WindowNo, 0, AD_Column_ID, 30);
            return new VLookup("C_BPartner_ID", false, false, true, lookup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public static VLookup createProduct(int WindowNo) {
        int AD_Column_ID = 3840;
        try {
            MLookup lookup = MLookupFactory.get(Env.getCtx(), WindowNo, 0, AD_Column_ID, 30);
            return new VLookup("M_Product_ID", false, false, true, lookup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public static VLookup createUser(int WindowNo) {
        int AD_Column_ID = 10443;
        try {
            MLookup lookup = MLookupFactory.get(Env.getCtx(), WindowNo, 0, AD_Column_ID, 30);
            return new VLookup("AD_User_ID", false, false, true, lookup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public VLookup(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, Lookup lookup) {
        super.setName(columnName);
        this.m_combo.setName(columnName);
        this.m_columnName = columnName;
        this.setMandatory(mandatory);
        this.m_lookup = lookup;
        this.setLayout(new BorderLayout());
        VLookup_mouseAdapter mouse = new VLookup_mouseAdapter(this);
        this.m_text.addActionListener(this);
        this.m_text.addFocusListener(this);
        this.m_text.addMouseListener(mouse);
        this.m_button.addActionListener(this);
        this.m_button.addMouseListener(mouse);
        this.m_button.setFocusable(false);
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        if (columnName.equals("C_BPartner_ID")) {
            this.m_button.setIcon(Env.getImageIcon("BPartner10.gif"));
        } else if (columnName.equals("M_Product_ID")) {
            this.m_button.setIcon(Env.getImageIcon("Product10.gif"));
        } else {
            this.m_button.setIcon(Env.getImageIcon("PickOpen10.gif"));
        }
        if (this.m_lookup != null && this.m_lookup.getDisplayType() != 30) {
            this.m_lookup.fillComboBox(this.isMandatory(), false, false, false);
            this.m_combo.setModel(this.m_lookup);
            this.m_combo.addActionListener(this);
            this.m_combo.addMouseListener(mouse);
            this.m_combo.addFocusListener(this);
        }
        this.setUI(true);
        if (isReadOnly || !isUpdateable || this.m_lookup == null) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        if (this.m_lookup != null) {
            if (this.m_lookup.getDisplayType() == 17 && Env.getContextAsInt(Env.getCtx(), "#AD_Role_ID") == 0 || this.m_lookup.getDisplayType() != 17) {
                this.mZoom = new CMenuItem(Msg.getMsg(Env.getCtx(), "Zoom"), Env.getImageIcon("Zoom16.gif"));
                this.mZoom.addActionListener(this);
                this.popupMenu.add(this.mZoom);
            }
            this.mRefresh = new CMenuItem(Msg.getMsg(Env.getCtx(), "Refresh"), Env.getImageIcon("Refresh16.gif"));
            this.mRefresh.addActionListener(this);
            this.popupMenu.add(this.mRefresh);
        }
        if (columnName.equals("C_BPartner_ID")) {
            this.mBPartnerNew = new CMenuItem(Msg.getMsg(Env.getCtx(), "New"), Env.getImageIcon("InfoBPartner16.gif"));
            this.mBPartnerNew.addActionListener(this);
            this.popupMenu.add(this.mBPartnerNew);
            this.mBPartnerUpd = new CMenuItem(Msg.getMsg(Env.getCtx(), "Update"), Env.getImageIcon("InfoBPartner16.gif"));
            this.mBPartnerUpd.addActionListener(this);
            this.popupMenu.add(this.mBPartnerUpd);
        }
        if (this.m_lookup != null && this.m_lookup.getZoom() == 0) {
            this.mZoom.setEnabled(false);
        }
    }

    public void dispose() {
        this.m_text = null;
        this.m_button = null;
        this.m_lookup = null;
        this.m_mField = null;
        this.m_combo.removeFocusListener(this);
        this.m_combo.removeActionListener(this);
        this.m_combo.setModel(new DefaultComboBoxModel());
        this.m_combo = null;
    }

    private void setUI(boolean initial) {
        if (initial) {
            Dimension size = this.m_text.getPreferredSize();
            this.setPreferredSize(new Dimension(size));
            this.m_combo.setPreferredSize(new Dimension(size));
            this.setMinimumSize(new Dimension(30, size.height));
            FIELD_HIGHT = size.height;
            this.m_text.setBorder(null);
            Dimension bSize = new Dimension(size.height, size.height);
            this.m_button.setPreferredSize(bSize);
        }
        this.remove(this.m_combo);
        this.remove(this.m_button);
        this.remove(this.m_text);
        if (!this.isReadWrite()) {
            LookAndFeel.installBorder(this, "TextField.border");
            this.add((Component)this.m_text, "Center");
            this.m_text.setReadWrite(false);
            this.m_combo.setReadWrite(false);
            this.m_comboActive = false;
        } else if (this.m_lookup != null && this.m_lookup.getDisplayType() != 30) {
            this.setBorder(null);
            this.add((Component)this.m_combo, "Center");
            this.m_comboActive = true;
        } else {
            LookAndFeel.installBorder(this, "TextField.border");
            this.add((Component)this.m_text, "Center");
            this.add((Component)this.m_button, "East");
            this.m_text.setReadWrite(true);
            this.m_comboActive = false;
        }
    }

    public void setReadWrite(boolean value) {
        boolean rw = value;
        if (this.m_lookup == null) {
            rw = false;
        }
        if (this.m_combo.isReadWrite() != value) {
            this.m_combo.setReadWrite(rw);
            this.setUI(false);
            if (this.m_comboActive) {
                this.setValue(this.m_value);
            }
        }
    }

    public boolean isReadWrite() {
        return this.m_combo.isReadWrite();
    }

    public void setMandatory(boolean mandatory) {
        this.m_combo.setMandatory(mandatory);
        this.m_text.setMandatory(mandatory);
    }

    public boolean isMandatory() {
        return this.m_combo.isMandatory();
    }

    public void setBackground(Color color) {
        this.m_text.setBackground(color);
        this.m_combo.setBackground(color);
    }

    public void setBackground(boolean error) {
        this.m_text.setBackground(error);
        this.m_combo.setBackground(error);
    }

    public void setForeground(Color fg) {
        this.m_text.setForeground(fg);
        this.m_combo.setForeground(fg);
    }

    public void requestFocus() {
        if (this.m_lookup != null && this.m_lookup.getDisplayType() != 30) {
            this.m_combo.requestFocus();
        } else {
            this.m_text.requestFocus();
        }
    }

    public void setValue(Object value) {
        log.fine(this.m_columnName + "=" + value);
        this.m_settingValue = true;
        this.m_value = value;
        this.m_combo.setValue(value);
        if (value == null) {
            this.m_text.setText(null);
            this.m_lastDisplay = "";
            this.m_settingValue = false;
            return;
        }
        if (this.m_lookup == null) {
            this.m_text.setText(value.toString());
            this.m_lastDisplay = value.toString();
            this.m_settingValue = false;
            return;
        }
        if (this.m_zoomStarted) {
            this.m_lookup.removeAllElements();
        }
        this.m_zoomStarted = false;
        this.m_lastDisplay = this.m_lookup.getDisplay(value);
        if (this.m_lastDisplay.equals("<-1>")) {
            this.m_lastDisplay = "";
            this.m_value = null;
        }
        boolean notFound = this.m_lastDisplay.startsWith("<") && this.m_lastDisplay.endsWith(">");
        this.m_text.setText(this.m_lastDisplay);
        this.m_text.setCaretPosition(0);
        if (this.m_combo.getSelectedItem() == null && (this.m_comboActive || this.m_inserting && this.m_lookup.getDisplayType() != 30)) {
            NamePair pp;
            if (notFound) {
                log.finest(this.m_columnName + "=" + value + ": Not found - " + this.m_lastDisplay);
                this.m_lookup.refresh();
                this.m_combo.setValue(value);
                this.m_lastDisplay = this.m_lookup.getDisplay(value);
                this.m_text.setText(this.m_lastDisplay);
                this.m_text.setCaretPosition(0);
                boolean bl = notFound = this.m_lastDisplay.startsWith("<") && this.m_lastDisplay.endsWith(">");
            }
            if (notFound) {
                this.m_value = null;
                this.actionCombo(null);
                log.fine(this.m_columnName + "=" + value + ": Not found");
            } else if (this.m_combo.getSelectedItem() == null && (pp = this.m_lookup.get(value)) != null) {
                log.fine(this.m_columnName + " added to combo - " + pp);
                this.m_combo.addItem(pp);
                this.m_combo.setValue(value);
            }
            if (this.m_combo.getSelectedItem() == null) {
                log.info(this.m_columnName + "=" + value + ": not in Lookup - set to NULL");
                this.actionCombo(null);
                this.m_value = null;
            }
        }
        this.m_settingValue = false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.m_inserting = "FieldValueInserting".equals(evt.getOldValue());
            this.setValue(evt.getNewValue());
            this.m_inserting = false;
        }
    }

    public Object getValue() {
        if (this.m_comboActive) {
            return this.m_combo.getValue();
        }
        return this.m_value;
    }

    public String getDisplay() {
        String retValue = null;
        retValue = this.m_comboActive ? this.m_combo.getDisplay() : (this.m_lookup == null ? (this.m_value == null ? null : this.m_value.toString()) : this.m_lookup.getDisplay(this.m_value));
        return retValue;
    }

    public void setField(GridField mField) {
        this.m_mField = mField;
        if (this.m_mField != null && MRole.getDefault().isShowPreference()) {
            ValuePreference.addMenu(this, this.popupMenu);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.m_settingValue || this.m_settingFocus) {
            return;
        }
        log.config(this.m_columnName + " - " + e.getActionCommand() + ", ComboValue=" + this.m_combo.getSelectedItem());
        if (e.getActionCommand().equals("ValuePreference")) {
            if (MRole.getDefault().isShowPreference()) {
                ValuePreference.start(this.m_mField, this.getValue(), this.getDisplay());
            }
            return;
        }
        if (e.getSource() == this.m_combo) {
            String s;
            Object value = this.getValue();
            Object o = this.m_combo.getSelectedItem();
            if (o != null && (s = o.toString()).startsWith("~") && s.endsWith("~")) {
                log.info(this.m_columnName + " - selection inactive set to NULL");
                value = null;
            }
            this.actionCombo(value);
        } else if (e.getSource() == this.m_button) {
            this.actionButton("");
        } else if (e.getSource() == this.m_text) {
            this.actionText();
        } else if (e.getSource() == this.mZoom) {
            this.actionZoom(this.m_combo.getSelectedItem());
        } else if (e.getSource() == this.mRefresh) {
            this.actionRefresh();
        } else if (e.getSource() == this.mBPartnerNew) {
            this.actionBPartner(true);
        } else if (e.getSource() == this.mBPartnerUpd) {
            this.actionBPartner(false);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.m_combo.addActionListener(listener);
        this.m_text.addActionListener(listener);
    }

    private void actionCombo(Object value) {
        log.fine("Value=" + value);
        try {
            this.fireVetoableChange(this.m_columnName, null, value);
        }
        catch (PropertyVetoException pve) {
            log.log(Level.SEVERE, this.m_columnName, pve);
        }
        boolean updated = false;
        if (value == null && this.m_value == null) {
            updated = true;
        } else if (value != null && value.equals(this.m_value)) {
            updated = true;
        }
        if (!updated) {
            log.fine(this.m_columnName + " - Value explicitly set - new=" + value + ", old=" + this.m_value);
            this.setValue(value);
        }
    }

    private void actionButton(String queryValue) {
        this.m_button.setEnabled(false);
        if (this.m_lookup == null) {
            return;
        }
        this.m_text.requestFocus();
        JFrame frame = Env.getFrame(this);
        Object result = null;
        boolean cancelled = false;
        String col = this.m_lookup.getColumnName();
        if (col.indexOf(".") != -1) {
            col = col.substring(col.indexOf(".") + 1);
        }
        String whereClause = this.getWhereClause();
        log.fine(col + ", Zoom=" + this.m_lookup.getZoom() + " (" + whereClause + ")");
        boolean resetValue = false;
        if (col.equals("M_Product_ID")) {
            Env.setContext(Env.getCtx(), 1113, 1113, "M_Product_ID", "0");
            Env.setContext(Env.getCtx(), 1113, 1113, "M_AttributeSetInstance_ID", "0");
            Env.setContext(Env.getCtx(), 1113, 1113, "M_Lookup_ID", "0");
            if (queryValue.length() == 0 && this.m_text.getText().length() > 0) {
                queryValue = "@" + this.m_text.getText() + "@";
            }
            int M_Warehouse_ID = Env.getContextAsInt(Env.getCtx(), this.m_lookup.getWindowNo(), "M_Warehouse_ID");
            int M_PriceList_ID = Env.getContextAsInt(Env.getCtx(), this.m_lookup.getWindowNo(), "M_PriceList_ID");
            InfoProduct ip = new InfoProduct(frame, true, this.m_lookup.getWindowNo(), M_Warehouse_ID, M_PriceList_ID, queryValue, false, whereClause);
            ip.setVisible(true);
            cancelled = ip.isCancelled();
            result = ip.getSelectedKey();
            resetValue = true;
        } else if (col.equals("C_BPartner_ID")) {
            if (queryValue.length() == 0 && this.m_text.getText().length() > 0) {
                queryValue = this.m_text.getText();
            }
            boolean isSOTrx = true;
            if (Env.getContext(Env.getCtx(), this.m_lookup.getWindowNo(), "IsSOTrx").equals("N")) {
                isSOTrx = false;
            }
            InfoBPartner ip = new InfoBPartner((Frame)frame, true, this.m_lookup.getWindowNo(), queryValue, isSOTrx, false, whereClause);
            ip.setVisible(true);
            cancelled = ip.isCancelled();
            result = ip.getSelectedKey();
        } else {
            if (this.m_tableName == null) {
                this.getDirectAccessSQL("*");
            }
            Info ig = Info.create(frame, true, this.m_lookup.getWindowNo(), this.m_tableName, this.m_keyColumnName, queryValue, false, whereClause);
            ig.setVisible(true);
            cancelled = ig.isCancelled();
            result = ig.getSelectedKey();
        }
        if (result != null) {
            log.config(this.m_columnName + " - Result = " + result.toString() + " (" + result.getClass().getName() + ")");
            this.m_lookup.getDirect(result, false, true);
            if (resetValue) {
                this.actionCombo(null);
            }
            this.actionCombo(result);
        } else if (cancelled) {
            log.config(this.m_columnName + " - Result = null (cancelled)");
            this.actionCombo(null);
        } else {
            log.config(this.m_columnName + " - Result = null (not cancelled)");
            this.setValue(this.m_value);
        }
        this.m_button.setEnabled(true);
        this.m_text.requestFocus();
    }

    private String getWhereClause() {
        String validation;
        String whereClause = "";
        if (this.m_lookup == null) {
            return "";
        }
        if (this.m_lookup.getZoomQuery() != null) {
            whereClause = this.m_lookup.getZoomQuery().getWhereClause();
        }
        if ((validation = this.m_lookup.getValidation()) == null) {
            validation = "";
        }
        if (whereClause.length() == 0) {
            whereClause = validation;
        } else if (validation.length() > 0) {
            whereClause = whereClause + " AND " + validation;
        }
        if (whereClause.indexOf(64) != -1) {
            String validated = Env.parseContext(Env.getCtx(), this.m_lookup.getWindowNo(), whereClause, false);
            if (validated.length() == 0) {
                log.severe(this.m_columnName + " - Cannot Parse=" + whereClause);
            } else {
                log.fine(this.m_columnName + " - Parsed: " + validated);
                return validated;
            }
        }
        return whereClause;
    }

    private void actionText() {
        ResultSet rs;
        String text = this.m_text.getText();
        if (text == null || text.length() == 0 || text.equals("%")) {
            this.actionButton(text);
            return;
        }
        text = text.toUpperCase();
        log.config(this.m_columnName + " - " + text);
        CPreparedStatement pstmt = null;
        String finalSQL = Msg.parseTranslation(Env.getCtx(), this.getDirectAccessSQL(text));
        int id = -3;
        try {
            pstmt = DB.prepareStatement(finalSQL, null);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                id = rs.getInt(1);
                if (rs.next()) {
                    id = -1;
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, finalSQL, e);
            id = -2;
        }
        if (id == -3 && !text.endsWith("%")) {
            text = text + "%";
            finalSQL = Msg.parseTranslation(Env.getCtx(), this.getDirectAccessSQL(text));
            try {
                pstmt = DB.prepareStatement(finalSQL, null);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    id = rs.getInt(1);
                    if (rs.next()) {
                        id = -1;
                    }
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, finalSQL, e);
                id = -2;
            }
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (id <= 0) {
            if (id == -3) {
                log.fine(this.m_columnName + " - Not Found - " + finalSQL);
            } else {
                log.fine(this.m_columnName + " - Not Unique - " + finalSQL);
            }
            this.m_value = null;
            this.actionButton(this.m_text.getText());
            return;
        }
        log.fine(this.m_columnName + " - Unique ID=" + id);
        this.m_value = null;
        this.actionCombo(new Integer(id));
        this.m_text.requestFocus();
    }

    private String getDirectAccessSQL(String text) {
        int AD_Reference_ID;
        StringBuffer sql = new StringBuffer();
        this.m_tableName = this.m_columnName.substring(0, this.m_columnName.length() - 3);
        this.m_keyColumnName = this.m_columnName;
        if (this.m_columnName.equals("M_Product_ID")) {
            Env.setContext(Env.getCtx(), 1113, 1113, "M_Product_ID", "0");
            Env.setContext(Env.getCtx(), 1113, 1113, "M_AttributeSetInstance_ID", "0");
            Env.setContext(Env.getCtx(), 1113, 1113, "M_Locator_ID", "0");
            sql.append("SELECT M_Product_ID FROM M_Product WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING(text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING(text)).append(" OR UPC LIKE ").append(DB.TO_STRING(text)).append(")");
        } else if (this.m_columnName.equals("C_BPartner_ID")) {
            sql.append("SELECT C_BPartner_ID FROM C_BPartner WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING(text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING(text)).append(")");
        } else if (this.m_columnName.equals("C_Order_ID")) {
            sql.append("SELECT C_Order_ID FROM C_Order WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (this.m_columnName.equals("C_Invoice_ID")) {
            sql.append("SELECT C_Invoice_ID FROM C_Invoice WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (this.m_columnName.equals("M_InOut_ID")) {
            sql.append("SELECT M_InOut_ID FROM M_InOut WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (this.m_columnName.equals("C_Payment_ID")) {
            sql.append("SELECT C_Payment_ID FROM C_Payment WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (this.m_columnName.equals("GL_JournalBatch_ID")) {
            sql.append("SELECT GL_JournalBatch_ID FROM GL_JournalBatch WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (this.m_columnName.equals("SalesRep_ID")) {
            sql.append("SELECT AD_User_ID FROM AD_User WHERE UPPER(Name) LIKE ").append(DB.TO_STRING(text));
            this.m_tableName = "AD_User";
            this.m_keyColumnName = "AD_User_ID";
        }
        if (sql.length() > 0) {
            String wc = this.getWhereClause();
            if (wc != null && wc.length() > 0) {
                sql.append(" AND ").append(wc);
            }
            sql.append(" AND IsActive='Y'");
            log.finest(this.m_columnName + " (predefined) " + sql.toString());
            return MRole.getDefault().addAccessSQL(sql.toString(), this.m_tableName, false, false);
        }
        if (this.m_lookup != null && this.m_lookup instanceof MLookup && (AD_Reference_ID = ((MLookup)this.m_lookup).getAD_Reference_Value_ID()) != 0) {
            String query = "SELECT kc.ColumnName, dc.ColumnName, t.TableName FROM AD_Ref_Table rt INNER JOIN AD_Column kc ON (rt.AD_Key=kc.AD_Column_ID) INNER JOIN AD_Column dc ON (rt.AD_Display=dc.AD_Column_ID) INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) WHERE rt.AD_Reference_ID=?";
            String displayColumnName = null;
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(query, null);
                pstmt.setInt(1, AD_Reference_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_keyColumnName = rs.getString(1);
                    displayColumnName = rs.getString(2);
                    this.m_tableName = rs.getString(3);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, query, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            if (displayColumnName != null) {
                sql = new StringBuffer();
                sql.append("SELECT ").append(this.m_keyColumnName).append(" FROM ").append(this.m_tableName).append(" WHERE UPPER(").append(displayColumnName).append(") LIKE ").append(DB.TO_STRING(text)).append(" AND IsActive='Y'");
                String wc = this.getWhereClause();
                if (wc != null && wc.length() > 0) {
                    sql.append(" AND ").append(wc);
                }
                log.finest(this.m_columnName + " (Table) " + sql.toString());
                return MRole.getDefault().addAccessSQL(sql.toString(), this.m_tableName, false, false);
            }
        }
        String query = "SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID AND t.IsView='N') WHERE (c.ColumnName IN ('DocumentNo', 'Value', 'Name') OR c.IsIdentifier='Y') AND c.AD_Reference_ID IN (10,14) AND EXISTS (SELECT * FROM AD_Column cc WHERE cc.AD_Table_ID=t.AD_Table_ID AND cc.IsKey='Y' AND cc.ColumnName=?)";
        this.m_keyColumnName = this.m_columnName;
        sql = new StringBuffer();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(query, null);
            pstmt.setString(1, this.m_keyColumnName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (sql.length() != 0) {
                    sql.append(" OR ");
                }
                this.m_tableName = rs.getString(1);
                sql.append("UPPER(").append(rs.getString(2)).append(") LIKE ").append(DB.TO_STRING(text));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, query, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        if (sql.length() == 0) {
            log.log(Level.SEVERE, this.m_columnName + " (TableDir) - no standard/identifier columns");
            return "";
        }
        StringBuffer retValue = new StringBuffer("SELECT ").append(this.m_columnName).append(" FROM ").append(this.m_tableName).append(" WHERE ").append(sql).append(" AND IsActive='Y'");
        String wc = this.getWhereClause();
        if (wc != null && wc.length() > 0) {
            retValue.append(" AND ").append(wc);
        }
        log.finest(this.m_columnName + " (TableDir) " + sql.toString());
        return MRole.getDefault().addAccessSQL(retValue.toString(), this.m_tableName, false, false);
    }

    private void actionBPartner(boolean newRecord) {
        VBPartner vbp = new VBPartner((Frame)Env.getFrame(this), this.m_lookup.getWindowNo());
        int BPartner_ID = 0;
        if (!newRecord) {
            if (this.m_value instanceof Integer) {
                BPartner_ID = (Integer)this.m_value;
            } else if (this.m_value != null) {
                BPartner_ID = Integer.parseInt(this.m_value.toString());
            }
        }
        vbp.loadBPartner(BPartner_ID);
        vbp.setVisible(true);
        int result = vbp.getC_BPartner_ID();
        if (result == 0 && result == BPartner_ID) {
            return;
        }
        this.m_lookup.getDirect(new Integer(result), false, true);
        this.actionCombo(new Integer(result));
    }

    private void actionZoom(Object selectedItem) {
        if (this.m_lookup == null) {
            return;
        }
        MQuery zoomQuery = this.m_lookup.getZoomQuery();
        Object value = this.getValue();
        if (value == null) {
            value = selectedItem;
        }
        if (zoomQuery == null || value != null) {
            zoomQuery = new MQuery();
            zoomQuery.addRestriction(this.m_columnName, "=", value);
            zoomQuery.setRecordCount(1);
        }
        int AD_Window_ID = this.m_lookup.getZoom(zoomQuery);
        log.info(this.m_columnName + " - AD_Window_ID=" + AD_Window_ID + " - Query=" + zoomQuery + " - Value=" + value);
        this.setCursor(Cursor.getPredefinedCursor(3));
        AWindow frame = new AWindow();
        if (!frame.initWindow(AD_Window_ID, zoomQuery)) {
            this.setCursor(Cursor.getDefaultCursor());
            ValueNamePair pp = CLogger.retrieveError();
            String msg = pp == null ? "AccessTableNoView" : pp.getValue();
            ADialog.error(this.m_lookup.getWindowNo(), this, msg, pp == null ? "" : pp.getName());
        } else {
            AEnv.addToWindowManager(frame);
            AEnv.showCenterScreen(frame);
        }
        frame = null;
        this.m_zoomStarted = true;
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void actionRefresh() {
        if (this.m_lookup == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Object obj = this.m_combo.getSelectedItem();
        log.info(this.m_columnName + " #" + this.m_lookup.getSize() + ", Selected=" + obj);
        this.m_lookup.refresh();
        if (this.m_lookup.isValidated()) {
            this.m_lookup.fillComboBox(this.isMandatory(), false, false, false);
        } else {
            this.m_lookup.fillComboBox(this.isMandatory(), true, false, false);
        }
        this.m_combo.setSelectedItem(obj);
        this.setCursor(Cursor.getDefaultCursor());
        log.info(this.m_columnName + " #" + this.m_lookup.getSize() + ", Selected=" + this.m_combo.getSelectedItem());
    }

    public void focusGained(FocusEvent e) {
        if (e.getSource() != this.m_combo || e.isTemporary() || this.m_haveFocus || this.m_lookup == null) {
            return;
        }
        if (this.m_lookup.isValidated() && !this.m_lookup.hasInactive()) {
            return;
        }
        this.m_haveFocus = true;
        this.m_settingFocus = true;
        Object obj = this.m_lookup.getSelectedItem();
        log.config(this.m_columnName + " - Start    Count=" + this.m_combo.getItemCount() + ", Selected=" + obj);
        this.m_lookup.fillComboBox(this.isMandatory(), true, true, true);
        log.config(this.m_columnName + " - Update   Count=" + this.m_combo.getItemCount() + ", Selected=" + this.m_lookup.getSelectedItem());
        this.m_lookup.setSelectedItem(obj);
        log.config(this.m_columnName + " - Selected Count=" + this.m_combo.getItemCount() + ", Selected=" + this.m_lookup.getSelectedItem());
        this.m_settingFocus = false;
    }

    public void focusLost(FocusEvent e) {
        if (e.isTemporary() || this.m_lookup == null || !this.m_button.isEnabled()) {
            return;
        }
        if (e.getSource() == this.m_text) {
            String text = this.m_text.getText();
            log.config(this.m_columnName + " (Text) " + this.m_columnName + " = " + this.m_value + " - " + text);
            this.m_haveFocus = false;
            if (this.m_value == null && this.m_text.getText().length() == 0) {
                return;
            }
            if (this.m_lastDisplay.equals(text)) {
                return;
            }
            this.actionText();
            return;
        }
        if (e.getSource() != this.m_combo) {
            return;
        }
        if (this.m_lookup.isValidated() && !this.m_lookup.hasInactive()) {
            return;
        }
        this.m_settingFocus = true;
        log.config(this.m_columnName + " = " + this.m_combo.getSelectedItem());
        Object obj = this.m_combo.getSelectedItem();
        if (!this.m_lookup.isValidated()) {
            this.m_lookup.fillComboBox(true);
        }
        if (obj != null) {
            this.m_combo.setSelectedItem(obj);
            if (!this.m_combo.getSelectedItem().equals(obj)) {
                log.fine(this.m_columnName + " - added to combo - " + obj);
                this.m_combo.addItem(obj);
                this.m_combo.setSelectedItem(obj);
            }
        }
        this.m_settingFocus = false;
        this.m_haveFocus = false;
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.m_button.setToolTipText(text);
        this.m_text.setToolTipText(text);
        this.m_combo.setToolTipText(text);
    }

    public int refresh() {
        if (this.m_lookup == null) {
            return -1;
        }
        return this.m_lookup.refresh();
    }
}

