/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.Adempiere;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VLocatorDialog;
import org.compiere.grid.ed.VLocator_mouseAdapter;
import org.compiere.model.GridField;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CMenuItem;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VLocator
extends JComponent
implements VEditor,
ActionListener {
    private JTextField m_text = new JTextField(15);
    private CButton m_button = new CButton();
    private MLocatorLookup m_mLocator;
    private Object m_value;
    private String m_columnName;
    private int m_WindowNo;
    private static CLogger log = CLogger.getCLogger(VLocator.class);
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mZoom;
    private CMenuItem mRefresh;

    public VLocator() {
        this("M_Locator_ID", false, false, true, null, 0);
    }

    public VLocator(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, MLocatorLookup mLocator, int WindowNo) {
        super.setName(columnName);
        this.m_columnName = columnName;
        this.m_mLocator = mLocator;
        this.m_WindowNo = WindowNo;
        LookAndFeel.installBorder(this, "TextField.border");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(this.m_text.getPreferredSize());
        int height = this.m_text.getPreferredSize().height;
        this.m_text.setBorder(null);
        this.m_text.setEditable(true);
        this.m_text.setFocusable(true);
        this.m_text.addMouseListener(new VLocator_mouseAdapter(this));
        this.m_text.setFont(AdempierePLAF.getFont_Field());
        this.m_text.setForeground(AdempierePLAF.getTextColor_Normal());
        this.m_text.addActionListener(this);
        this.add((Component)this.m_text, "Center");
        this.m_button.setIcon(new ImageIcon(Adempiere.class.getResource("images/Locator10.gif")));
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setPreferredSize(new Dimension(height, height));
        this.m_button.addActionListener(this);
        this.add((Component)this.m_button, "East");
        this.setPreferredSize(this.getPreferredSize());
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        this.setMandatory(mandatory);
        this.mZoom = new CMenuItem(Msg.getMsg(Env.getCtx(), "Zoom"), Env.getImageIcon("Zoom16.gif"));
        this.mZoom.addActionListener(this);
        this.popupMenu.add(this.mZoom);
        this.mRefresh = new CMenuItem(Msg.getMsg(Env.getCtx(), "Refresh"), Env.getImageIcon("Refresh16.gif"));
        this.mRefresh.addActionListener(this);
        this.popupMenu.add(this.mRefresh);
    }

    public void dispose() {
        this.m_text = null;
        this.m_button = null;
        this.m_mLocator = null;
    }

    public void setReadWrite(boolean value) {
        this.m_button.setReadWrite(value);
        if (this.m_button.isVisible() != value) {
            this.m_button.setVisible(value);
        }
        this.setBackground(false);
    }

    public boolean isReadWrite() {
        return this.m_button.isReadWrite();
    }

    public void setMandatory(boolean mandatory) {
        this.m_button.setMandatory(mandatory);
        this.setBackground(false);
    }

    public boolean isMandatory() {
        return this.m_button.isMandatory();
    }

    public void setBackground(Color color) {
        if (!color.equals(this.m_text.getBackground())) {
            this.m_text.setBackground(color);
        }
    }

    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.isMandatory()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        }
    }

    public void setForeground(Color fg) {
        this.m_text.setForeground(fg);
    }

    public void requestFocus() {
        this.m_text.requestFocus();
    }

    public void setValue(Object value) {
        this.setValue(value, false);
    }

    private void setValue(Object value, boolean fire) {
        if (value != null) {
            this.m_mLocator.setOnly_Warehouse_ID(this.getOnly_Warehouse_ID());
            this.m_mLocator.setOnly_Product_ID(this.getOnly_Product_ID());
            if (!this.m_mLocator.isValid(value)) {
                value = null;
            }
        }
        this.m_value = value;
        this.m_text.setText(this.m_mLocator.getDisplay(value));
        try {
            this.fireVetoableChange(this.m_columnName, null, value);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    public Object getValue() {
        if (this.getM_Locator_ID() == 0) {
            return null;
        }
        return this.m_value;
    }

    public int getM_Locator_ID() {
        if (this.m_value != null && this.m_value instanceof Integer) {
            return (Integer)this.m_value;
        }
        return 0;
    }

    public String getDisplay() {
        return this.m_text.getText();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mRefresh) {
            this.m_mLocator.refresh();
            return;
        }
        if (e.getSource() == this.mZoom) {
            this.actionZoom();
            return;
        }
        int only_Warehouse_ID = this.getOnly_Warehouse_ID();
        int only_Product_ID = this.getOnly_Product_ID();
        log.config("Only Warehouse_ID=" + only_Warehouse_ID + ", Product_ID=" + only_Product_ID);
        if (e.getSource() == this.m_text && this.actionText(only_Warehouse_ID, only_Product_ID)) {
            return;
        }
        int M_Locator_ID = 0;
        if (this.m_value instanceof Integer) {
            M_Locator_ID = (Integer)this.m_value;
        }
        this.m_mLocator.setOnly_Warehouse_ID(only_Warehouse_ID);
        this.m_mLocator.setOnly_Product_ID(this.getOnly_Product_ID());
        VLocatorDialog ld = new VLocatorDialog(Env.getFrame(this), Msg.translate(Env.getCtx(), this.m_columnName), this.m_mLocator, M_Locator_ID, this.isMandatory(), only_Warehouse_ID);
        ld.setVisible(true);
        this.m_mLocator.setOnly_Warehouse_ID(0);
        if (!ld.isChanged()) {
            return;
        }
        this.setValue(ld.getValue(), true);
    }

    private boolean actionText(int only_Warehouse_ID, int only_Product_ID) {
        String text = this.m_text.getText();
        log.fine(text);
        if (text == null || text.length() == 0) {
            if (this.isMandatory()) {
                return false;
            }
            this.setValue(null, true);
            return true;
        }
        text = text.endsWith("%") ? text.toUpperCase() : text.toUpperCase() + "%";
        StringBuffer sql = new StringBuffer("SELECT M_Locator_ID FROM M_Locator ").append(" WHERE IsActive='Y' AND UPPER(Value) LIKE ").append(DB.TO_STRING(text));
        if (this.getOnly_Warehouse_ID() != 0) {
            sql.append(" AND M_Warehouse_ID=?");
        }
        if (this.getOnly_Product_ID() != 0) {
            sql.append(" AND (IsDefault='Y' ").append("OR EXISTS (SELECT * FROM M_Product p ").append("WHERE p.M_Locator_ID=M_Locator.M_Locator_ID AND p.M_Product_ID=?)").append("OR EXISTS (SELECT * FROM M_Storage s ").append("WHERE s.M_Locator_ID=M_Locator.M_Locator_ID AND s.M_Product_ID=?))");
        }
        String finalSql = MRole.getDefault(Env.getCtx(), false).addAccessSQL(sql.toString(), "M_Locator", false, false);
        int M_Locator_ID = 0;
        CPreparedStatement pstmt = null;
        try {
            ResultSet rs;
            pstmt = DB.prepareStatement(finalSql, null);
            int index = 1;
            if (only_Warehouse_ID != 0) {
                pstmt.setInt(index++, only_Warehouse_ID);
            }
            if (only_Product_ID != 0) {
                pstmt.setInt(index++, only_Product_ID);
                pstmt.setInt(index++, only_Product_ID);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                M_Locator_ID = rs.getInt(1);
                if (rs.next()) {
                    M_Locator_ID = 0;
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, finalSql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        if (M_Locator_ID == 0) {
            return false;
        }
        this.setValue(new Integer(M_Locator_ID), true);
        return true;
    }

    public void addActionListener(ActionListener listener) {
        this.m_text.addActionListener(listener);
    }

    private void actionZoom() {
        int AD_Window_ID = 139;
        log.info("");
        this.setCursor(Cursor.getPredefinedCursor(3));
        AWindow frame = new AWindow();
        if (!frame.initWindow(AD_Window_ID, null)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        AEnv.showCenterScreen(frame);
        frame = null;
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void setField(GridField mField) {
    }

    private int getOnly_Warehouse_ID() {
        String only_Warehouse = Env.getContext(Env.getCtx(), this.m_WindowNo, "M_Warehouse_ID", true);
        int only_Warehouse_ID = 0;
        try {
            if (only_Warehouse != null && only_Warehouse.length() > 0) {
                only_Warehouse_ID = Integer.parseInt(only_Warehouse);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return only_Warehouse_ID;
    }

    private int getOnly_Product_ID() {
        if (!Env.isSOTrx(Env.getCtx(), this.m_WindowNo)) {
            return 0;
        }
        String only_Product = Env.getContext(Env.getCtx(), this.m_WindowNo, "M_Product_ID", true);
        int only_Product_ID = 0;
        try {
            if (only_Product != null && only_Product.length() > 0) {
                only_Product_ID = Integer.parseInt(only_Product);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return only_Product_ID;
    }
}

