/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.model.MCountry;
import org.compiere.model.MLocation;
import org.compiere.model.MRegion;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VLocationDialog
extends CDialog
implements ActionListener {
    private boolean m_change = false;
    private MLocation m_location;
    private int m_origCountry_ID;
    private int s_oldCountry_ID = 0;
    private static CLogger log = CLogger.getCLogger(VLocationDialog.class);
    private CPanel panel = new CPanel();
    private CPanel mainPanel = new CPanel();
    private CPanel southPanel = new CPanel();
    private BorderLayout panelLayout = new BorderLayout();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private BorderLayout southLayout = new BorderLayout();
    private CLabel lAddress1 = new CLabel(Msg.getMsg(Env.getCtx(), "Address") + " 1");
    private CLabel lAddress2 = new CLabel(Msg.getMsg(Env.getCtx(), "Address") + " 2");
    private CLabel lAddress3 = new CLabel(Msg.getMsg(Env.getCtx(), "Address") + " 3");
    private CLabel lAddress4 = new CLabel(Msg.getMsg(Env.getCtx(), "Address") + " 4");
    private CLabel lCity = new CLabel(Msg.getMsg(Env.getCtx(), "City"));
    private CLabel lCountry = new CLabel(Msg.getMsg(Env.getCtx(), "Country"));
    private CLabel lRegion = new CLabel(Msg.getMsg(Env.getCtx(), "Region"));
    private CLabel lPostal = new CLabel(Msg.getMsg(Env.getCtx(), "Postal"));
    private CLabel lPostalAdd = new CLabel(Msg.getMsg(Env.getCtx(), "PostalAdd"));
    private CTextField fAddress1 = new CTextField(20);
    private CTextField fAddress2 = new CTextField(20);
    private CTextField fAddress3 = new CTextField(20);
    private CTextField fAddress4 = new CTextField(20);
    private CTextField fCity = new CTextField(15);
    private CComboBox fCountry;
    private CComboBox fRegion;
    private CTextField fPostal = new CTextField(5);
    private CTextField fPostalAdd = new CTextField(5);
    private GridBagConstraints gbc = new GridBagConstraints();
    private Insets labelInsets = new Insets(2, 15, 2, 0);
    private Insets fieldInsets = new Insets(2, 5, 2, 10);

    public VLocationDialog(Frame frame, String title, MLocation location) {
        super(frame, title, true);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
        this.m_location = location;
        if (this.m_location == null) {
            this.m_location = new MLocation(Env.getCtx(), 0, null);
        }
        if (this.m_location.getC_Location_ID() == 0) {
            this.setTitle(Msg.getMsg(Env.getCtx(), "LocationNew"));
        } else {
            this.setTitle(Msg.getMsg(Env.getCtx(), "LocationUpdate"));
        }
        MCountry.setDisplayLanguage(Env.getAD_Language(Env.getCtx()));
        this.fCountry = new CComboBox(MCountry.getCountries(Env.getCtx()));
        this.fCountry.setSelectedItem(this.m_location.getCountry());
        this.m_origCountry_ID = this.m_location.getC_Country_ID();
        this.fRegion = new CComboBox(MRegion.getRegions(Env.getCtx(), this.m_origCountry_ID));
        if (this.m_location.getCountry().isHasRegion()) {
            this.lRegion.setText(this.m_location.getCountry().getRegionName());
        }
        this.fRegion.setSelectedItem(this.m_location.getRegion());
        this.initLocation();
        this.fCountry.addActionListener(this);
        AEnv.positionCenterWindow(frame, this);
    }

    void jbInit() throws Exception {
        this.panel.setLayout(this.panelLayout);
        this.southPanel.setLayout(this.southLayout);
        this.mainPanel.setLayout(this.gridBagLayout);
        this.panelLayout.setHgap(5);
        this.panelLayout.setVgap(10);
        this.getContentPane().add(this.panel);
        this.panel.add((Component)this.mainPanel, "Center");
        this.panel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.confirmPanel, "North");
        this.confirmPanel.addActionListener(this);
    }

    private void initLocation() {
        MCountry country = this.m_location.getCountry();
        log.fine(country.getName() + ", Region=" + country.isHasRegion() + " " + country.getDisplaySequence() + ", C_Location_ID=" + this.m_location.getC_Location_ID());
        if (this.m_location.getC_Country_ID() != this.s_oldCountry_ID && country.isHasRegion()) {
            this.fRegion = new CComboBox(MRegion.getRegions(Env.getCtx(), country.getC_Country_ID()));
            if (this.m_location.getRegion() != null) {
                this.fRegion.setSelectedItem(this.m_location.getRegion());
            }
            this.lRegion.setText(country.getRegionName());
            this.s_oldCountry_ID = this.m_location.getC_Country_ID();
        }
        this.gbc.anchor = 18;
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        this.gbc.insets = this.fieldInsets;
        this.gbc.fill = 2;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.mainPanel.add(Box.createVerticalStrut(5), this.gbc);
        int line = 1;
        this.addLine(line++, this.lAddress1, this.fAddress1);
        this.addLine(line++, this.lAddress2, this.fAddress2);
        this.addLine(line++, this.lAddress3, this.fAddress3);
        this.addLine(line++, this.lAddress4, this.fAddress4);
        String ds = country.getDisplaySequence();
        if (ds == null || ds.length() == 0) {
            log.log(Level.SEVERE, "DisplaySequence empty - " + country);
            ds = "";
        }
        StringTokenizer st = new StringTokenizer(ds, "@", false);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("C")) {
                this.addLine(line++, this.lCity, this.fCity);
                continue;
            }
            if (s.startsWith("P")) {
                this.addLine(line++, this.lPostal, this.fPostal);
                continue;
            }
            if (s.startsWith("A")) {
                this.addLine(line++, this.lPostalAdd, this.fPostalAdd);
                continue;
            }
            if (!s.startsWith("R") || !this.m_location.getCountry().isHasRegion()) continue;
            this.addLine(line++, this.lRegion, this.fRegion);
        }
        this.addLine(line++, this.lCountry, this.fCountry);
        if (this.m_location.getC_Location_ID() != 0) {
            this.fAddress1.setText(this.m_location.getAddress1());
            this.fAddress2.setText(this.m_location.getAddress2());
            this.fAddress3.setText(this.m_location.getAddress3());
            this.fAddress4.setText(this.m_location.getAddress4());
            this.fCity.setText(this.m_location.getCity());
            this.fPostal.setText(this.m_location.getPostal());
            this.fPostalAdd.setText(this.m_location.getPostal_Add());
            if (this.m_location.getCountry().isHasRegion()) {
                this.lRegion.setText(this.m_location.getCountry().getRegionName());
                this.fRegion.setSelectedItem(this.m_location.getRegion());
            }
            this.fCountry.setSelectedItem(country);
        }
        this.pack();
    }

    private void addLine(int line, JLabel label, JComponent field) {
        this.gbc.gridy = line;
        this.gbc.insets = this.labelInsets;
        this.gbc.gridx = 0;
        this.gbc.weightx = 0.0;
        this.gbc.fill = 2;
        label.setHorizontalAlignment(4);
        this.mainPanel.add((Component)label, this.gbc);
        this.gbc.insets = this.fieldInsets;
        this.gbc.gridx = 1;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 0;
        this.mainPanel.add((Component)field, this.gbc);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.action_OK();
            this.m_change = true;
            this.dispose();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.m_change = false;
            this.dispose();
        } else if (e.getSource() == this.fCountry) {
            MCountry c = (MCountry)this.fCountry.getSelectedItem();
            this.m_location.setCountry(c);
            this.mainPanel.removeAll();
            this.initLocation();
            this.fCountry.requestFocus();
        }
    }

    private void action_OK() {
        this.m_location.setAddress1(this.fAddress1.getText());
        this.m_location.setAddress2(this.fAddress2.getText());
        this.m_location.setAddress3(this.fAddress3.getText());
        this.m_location.setAddress4(this.fAddress4.getText());
        this.m_location.setCity(this.fCity.getText());
        this.m_location.setPostal(this.fPostal.getText());
        this.m_location.setPostal_Add(this.fPostalAdd.getText());
        MCountry c = (MCountry)this.fCountry.getSelectedItem();
        this.m_location.setCountry(c);
        if (this.m_location.getCountry().isHasRegion()) {
            MRegion r = (MRegion)this.fRegion.getSelectedItem();
            this.m_location.setRegion(r);
        } else {
            this.m_location.setC_Region_ID(0);
        }
        this.m_location.save();
    }

    public boolean isChanged() {
        return this.m_change;
    }

    public MLocation getValue() {
        return this.m_location;
    }
}

