/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VLocationDialog;
import org.compiere.grid.ed.VLocation_mouseAdapter;
import org.compiere.model.GridField;
import org.compiere.model.MLocation;
import org.compiere.model.MLocationLookup;
import org.compiere.swing.CButton;
import org.compiere.swing.CMenuItem;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VLocation
extends JComponent
implements VEditor,
ActionListener {
    private JTextField m_text = new JTextField(15);
    private CButton m_button = new CButton();
    private MLocationLookup m_mLocation;
    private MLocation m_value;
    private String m_columnName;
    private static CLogger log = CLogger.getCLogger(VLocation.class);
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mDelete;

    public VLocation(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, MLocationLookup mLocation) {
        super.setName(columnName);
        this.m_columnName = columnName;
        this.m_mLocation = mLocation;
        LookAndFeel.installBorder(this, "TextField.border");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(this.m_text.getPreferredSize());
        int height = this.m_text.getPreferredSize().height;
        this.m_button.setIcon(Env.getImageIcon("Location10.gif"));
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setPreferredSize(new Dimension(height, height));
        this.m_button.addActionListener(this);
        this.add((Component)this.m_button, "East");
        this.m_text.setBorder(null);
        this.m_text.setEditable(false);
        this.m_text.setFocusable(false);
        this.m_text.setFont(AdempierePLAF.getFont_Field());
        this.m_text.setForeground(AdempierePLAF.getTextColor_Normal());
        this.m_text.addMouseListener(new VLocation_mouseAdapter(this));
        this.add((Component)this.m_text, "Center");
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        this.setMandatory(mandatory);
        this.mDelete = new CMenuItem(Msg.getMsg(Env.getCtx(), "Delete"), Env.getImageIcon("Delete16.gif"));
        this.mDelete.addActionListener(this);
        this.popupMenu.add(this.mDelete);
    }

    public void dispose() {
        this.m_text = null;
        this.m_button = null;
        this.m_mLocation = null;
    }

    public void setReadWrite(boolean value) {
        this.m_button.setReadWrite(value);
        if (this.m_button.isVisible() != value) {
            this.m_button.setVisible(value);
        }
        this.setBackground(false);
    }

    public boolean isReadWrite() {
        return this.m_button.isReadWrite();
    }

    public void setMandatory(boolean mandatory) {
        this.m_button.setMandatory(mandatory);
        this.setBackground(false);
    }

    public boolean isMandatory() {
        return this.m_button.isMandatory();
    }

    public void setBackground(Color color) {
        if (!color.equals(this.m_text.getBackground())) {
            this.m_text.setBackground(color);
        }
    }

    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.isMandatory()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        }
    }

    public void setForeground(Color fg) {
        this.m_text.setForeground(fg);
    }

    public void setValue(Object value) {
        if (value == null) {
            this.m_value = null;
            this.m_text.setText(null);
        } else {
            this.m_value = this.m_mLocation.getLocation(value, null);
            if (this.m_value == null) {
                this.m_text.setText("<" + value + ">");
            } else {
                this.m_text.setText(this.m_value.toString());
            }
        }
    }

    public void requestFocus() {
        this.m_text.requestFocus();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    public Object getValue() {
        if (this.m_value == null) {
            return null;
        }
        return new Integer(this.m_value.getC_Location_ID());
    }

    public int getC_Location_ID() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.getC_Location_ID();
    }

    public String getDisplay() {
        return this.m_text.getText();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mDelete) {
            this.m_value = null;
        }
        log.config("actionPerformed - " + this.m_value);
        VLocationDialog ld = new VLocationDialog((Frame)Env.getFrame(this), Msg.getMsg(Env.getCtx(), "Location"), this.m_value);
        ld.setVisible(true);
        this.m_value = ld.getValue();
        if (e.getSource() != this.mDelete && !ld.isChanged()) {
            return;
        }
        try {
            int C_Location_ID = 0;
            if (this.m_value != null) {
                C_Location_ID = this.m_value.getC_Location_ID();
            }
            Integer ii = new Integer(C_Location_ID);
            this.fireVetoableChange(this.m_columnName, null, null);
            if (C_Location_ID != 0) {
                this.fireVetoableChange(this.m_columnName, null, ii);
            }
            this.setValue(ii);
        }
        catch (PropertyVetoException pve) {
            log.log(Level.SEVERE, "VLocation.actionPerformed", pve);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.m_text.addActionListener(listener);
    }

    public void setField(GridField mField) {
    }
}

