/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.model.MImage;
import org.compiere.swing.CButton;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VImageDialog
extends CDialog
implements ActionListener {
    private MImage m_mImage = null;
    private static CLogger log = CLogger.getCLogger(VImageDialog.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CLabel fileLabel = new CLabel();
    private CButton fileButton = new CButton();
    private CLabel imageLabel = new CLabel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);

    public VImageDialog(Frame owner, MImage mImage) {
        super(owner, Msg.translate(Env.getCtx(), "AD_Image_ID"), true);
        log.info("MImage=" + mImage);
        this.m_mImage = mImage;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
        if (this.m_mImage == null) {
            this.m_mImage = MImage.get(Env.getCtx(), 0);
        }
        this.fileButton.setText(this.m_mImage.getName());
        this.imageLabel.setIcon(this.m_mImage.getIcon());
        AEnv.positionCenterWindow(owner, this);
    }

    void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.fileLabel.setText(Msg.getMsg(Env.getCtx(), "SelectFile"));
        this.fileButton.setText("-");
        this.imageLabel.setBackground(Color.white);
        this.imageLabel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.imageLabel.setHorizontalAlignment(0);
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.fileLabel, null);
        this.parameterPanel.add((Component)this.fileButton, null);
        this.mainPanel.add((Component)this.imageLabel, "Center");
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.fileButton.addActionListener(this);
        this.confirmPanel.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.fileButton) {
            this.cmd_file();
        } else if (e.getActionCommand().equals("Ok")) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_mImage.save()) {
                this.dispose();
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.m_mImage = null;
            this.dispose();
        }
    }

    private void cmd_file() {
        JFileChooser jfc = new JFileChooser();
        jfc.setMultiSelectionEnabled(false);
        jfc.setFileSelectionMode(0);
        jfc.showOpenDialog(this);
        File imageFile = jfc.getSelectedFile();
        if (imageFile == null || imageFile.isDirectory() || !imageFile.exists()) {
            return;
        }
        String fileName = imageFile.getAbsolutePath();
        byte[] data = null;
        try {
            FileInputStream fis = new FileInputStream(imageFile);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int length = -1;
            while ((length = fis.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            fis.close();
            data = os.toByteArray();
            os.close();
            ImageIcon image = new ImageIcon(data, fileName);
            this.imageLabel.setIcon(image);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "load image", e);
            return;
        }
        this.fileButton.setText(imageFile.getAbsolutePath());
        this.pack();
        this.m_mImage.setName(fileName);
        this.m_mImage.setImageURL(fileName);
        this.m_mImage.setBinaryData(data);
    }

    public int getAD_Image_ID() {
        if (this.m_mImage != null) {
            return this.m_mImage.getAD_Image_ID();
        }
        return 0;
    }
}

