/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.JButton;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VImageDialog;
import org.compiere.model.GridField;
import org.compiere.model.MImage;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class VImage
extends JButton
implements VEditor,
ActionListener {
    private int m_WindowNo;
    private MImage m_mImage = null;
    private boolean m_mandatory = false;
    private String m_columnName = "AD_Image_ID";
    private static CLogger log = CLogger.getCLogger(VImage.class);

    public VImage(String columnName, int WindowNo) {
        super("-");
        this.m_columnName = columnName;
        this.m_WindowNo = WindowNo;
        super.addActionListener(this);
    }

    public void dispose() {
        this.m_mImage = null;
    }

    public void setValue(Object value) {
        log.warning("=" + value);
        int newValue = 0;
        if (value instanceof Integer) {
            newValue = (Integer)value;
        }
        if (newValue == 0) {
            this.m_mImage = null;
            super.setText("-");
            super.setIcon(null);
            super.setToolTipText(null);
            return;
        }
        if (this.m_mImage == null || newValue != this.m_mImage.get_ID()) {
            this.m_mImage = MImage.get(Env.getCtx(), newValue);
        }
        log.fine(this.m_mImage.toString());
        super.setText(null);
        super.setIcon(this.m_mImage.getIcon());
        super.setToolTipText(this.m_mImage.getName());
        this.invalidate();
    }

    public Object getValue() {
        if (this.m_mImage == null || this.m_mImage.get_ID() == 0) {
            return null;
        }
        return new Integer(this.m_mImage.get_ID());
    }

    public String getDisplay() {
        return this.m_mImage.getName();
    }

    public void setReadWrite(boolean rw) {
        if (this.isEnabled() != rw) {
            this.setEnabled(rw);
        }
    }

    public boolean isReadWrite() {
        return super.isEnabled();
    }

    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public void setBackground(Color color) {
    }

    public void setBackground() {
    }

    public void setBackground(boolean error) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    public void actionPerformed(ActionEvent e) {
        VImageDialog vid = new VImageDialog((Frame)Env.getWindow(this.m_WindowNo), this.m_mImage);
        vid.setVisible(true);
        int AD_Image_ID = vid.getAD_Image_ID();
        Integer newValue = null;
        if (AD_Image_ID != 0) {
            newValue = new Integer(AD_Image_ID);
        }
        this.m_mImage = null;
        this.setValue(newValue);
        try {
            this.fireVetoableChange(this.m_columnName, null, newValue);
        }
        catch (PropertyVetoException pve) {
            // empty catch block
        }
    }

    public void setField(GridField mField) {
    }
}

