/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VFile_mouseAdapter;
import org.compiere.model.GridField;
import org.compiere.swing.CButton;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VFile
extends JComponent
implements VEditor,
ActionListener {
    private JTextField m_text = new JTextField(15);
    private CButton m_button = new CButton();
    private String m_columnName;
    private int m_selectionMode = 1;
    private int m_dialogType = 2;
    private static CLogger log = CLogger.getCLogger(VFile.class);

    public VFile(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, boolean files) {
        String col;
        super.setName(columnName);
        this.m_columnName = columnName;
        if (files) {
            this.m_selectionMode = 0;
        }
        if ((col = columnName.toLowerCase()).indexOf("open") != -1 || col.indexOf("load") != -1) {
            this.m_dialogType = 0;
        } else if (col.indexOf("save") != -1) {
            this.m_dialogType = 1;
        }
        LookAndFeel.installBorder(this, "TextField.border");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(this.m_text.getPreferredSize());
        int height = this.m_text.getPreferredSize().height;
        this.m_button.setIcon(Env.getImageIcon("Open16.gif"));
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setPreferredSize(new Dimension(height, height));
        this.m_button.addActionListener(this);
        this.add((Component)this.m_button, "East");
        this.m_text.setBorder(null);
        this.m_text.setEditable(true);
        this.m_text.setFocusable(true);
        this.m_text.setFont(AdempierePLAF.getFont_Field());
        this.m_text.setForeground(AdempierePLAF.getTextColor_Normal());
        this.m_text.addMouseListener(new VFile_mouseAdapter(this));
        this.add((Component)this.m_text, "Center");
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        this.setMandatory(mandatory);
    }

    public void dispose() {
        this.m_text = null;
        this.m_button = null;
    }

    public void setReadWrite(boolean value) {
        this.m_button.setReadWrite(value);
        if (this.m_button.isVisible() != value) {
            this.m_button.setVisible(value);
        }
        this.setBackground(false);
    }

    public boolean isReadWrite() {
        return this.m_button.isReadWrite();
    }

    public void setMandatory(boolean mandatory) {
        this.m_button.setMandatory(mandatory);
        this.setBackground(false);
    }

    public boolean isMandatory() {
        return this.m_button.isMandatory();
    }

    public void setBackground(Color color) {
        if (!color.equals(this.m_text.getBackground())) {
            this.m_text.setBackground(color);
        }
    }

    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.isMandatory()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        }
    }

    public void setForeground(Color fg) {
        this.m_text.setForeground(fg);
    }

    public void setValue(Object value) {
        if (value == null) {
            this.m_text.setText(null);
        } else {
            this.m_text.setText(value.toString());
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    public Object getValue() {
        return this.m_text.getText();
    }

    public String getDisplay() {
        return this.m_text.getText();
    }

    public void actionPerformed(ActionEvent e) {
        String m_value = this.m_text.getText();
        log.config(m_value);
        JFileChooser chooser = new JFileChooser(m_value);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(this.m_selectionMode);
        chooser.setDialogTitle(Msg.getElement(Env.getCtx(), this.m_columnName));
        chooser.setDialogType(this.m_dialogType);
        int returnVal = -1;
        returnVal = this.m_dialogType == 1 ? chooser.showSaveDialog(this) : (this.m_dialogType == 0 ? chooser.showOpenDialog(this) : chooser.showDialog(this, Msg.getElement(Env.getCtx(), this.m_columnName)));
        if (returnVal != 0) {
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        this.m_text.setText(selectedFile.getAbsolutePath());
    }

    public void addActionListener(ActionListener listener) {
        this.m_text.addActionListener(listener);
    }

    public void setField(GridField mField) {
    }
}

