/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.VButton;
import org.compiere.model.GridTab;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFActivity;

public class VDocAction
extends CDialog
implements ActionListener {
    private int m_WindowNo = 0;
    private int m_AD_Table_ID;
    private boolean m_OKpressed = false;
    private boolean m_batch = false;
    private GridTab m_mTab;
    private static String[] s_value = null;
    private static String[] s_name;
    private static String[] s_description;
    private static CLogger log;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private CComboBox actionCombo = new CComboBox();
    private JLabel actionLabel = new JLabel();
    private JScrollPane centerPane = new JScrollPane();
    private JTextArea message = new JTextArea();
    private FlowLayout northLayout = new FlowLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private JButton batchButton = ConfirmPanel.createProcessButton(Msg.getMsg(Env.getCtx(), "StartBackground"));

    public VDocAction(int WindowNo, GridTab mTab, VButton button, int Record_ID) {
        super(Env.getWindow(WindowNo), Msg.translate(Env.getCtx(), "DocAction"), true);
        log.config("");
        this.m_WindowNo = WindowNo;
        this.m_mTab = mTab;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
        this.m_AD_Table_ID = Env.getContextAsInt(Env.getCtx(), WindowNo, "BaseTable_ID");
        if (s_value == null) {
            this.readReference();
        }
        this.dynInit(Record_ID);
        AEnv.positionCenterWindow(Env.getWindow(WindowNo), this);
    }

    void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.actionLabel.setText(Msg.translate(Env.getCtx(), "DocAction"));
        this.actionCombo.addActionListener(this);
        this.message.setLineWrap(true);
        this.message.setPreferredSize(new Dimension(350, 35));
        this.message.setWrapStyleWord(true);
        this.message.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.message.setEditable(false);
        this.northPanel.setLayout(this.northLayout);
        this.northLayout.setAlignment(2);
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.actionLabel, null);
        this.northPanel.add((Component)this.actionCombo, null);
        this.mainPanel.add((Component)this.centerPane, "Center");
        this.centerPane.getViewport().add((Component)this.message, null);
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.confirmPanel.addButton(this.batchButton);
        this.confirmPanel.addActionListener(this);
        this.batchButton.addActionListener(this);
    }

    private void dynInit(int Record_ID) {
        String DocStatus = (String)this.m_mTab.getValue("DocStatus");
        String DocAction2 = (String)this.m_mTab.getValue("DocAction");
        Object Processing = this.m_mTab.getValue("Processing");
        String OrderType = Env.getContext(Env.getCtx(), this.m_WindowNo, "OrderType");
        String IsSOTrx = Env.getContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx");
        if (DocStatus == null) {
            this.message.setText("*** ERROR ***");
            return;
        }
        log.fine("DocStatus=" + DocStatus + ", DocAction=" + DocAction2 + ", OrderType=" + OrderType + ", IsSOTrx=" + IsSOTrx + ", Processing=" + Processing + ", AD_Table_ID=" + this.m_AD_Table_ID + ", Record_ID=" + Record_ID);
        String[] options = new String[s_value.length];
        int index = 0;
        String wfStatus = MWFActivity.getActiveInfo(Env.getCtx(), this.m_AD_Table_ID, Record_ID);
        if (wfStatus != null) {
            ADialog.error(this.m_WindowNo, this, "WFActiveForRecord", wfStatus);
            return;
        }
        if (!this.checkStatus(this.m_mTab.getTableName(), Record_ID, DocStatus)) {
            ADialog.error(this.m_WindowNo, this, "DocumentStatusChanged");
            return;
        }
        if (Processing != null) {
            boolean locked = "Y".equals(Processing);
            if (!locked && Processing instanceof Boolean) {
                locked = (Boolean)Processing;
            }
            if (locked) {
                options[index++] = "XL";
            }
        }
        if (DocStatus.equals("NA")) {
            options[index++] = "PR";
            options[index++] = "VO";
        } else if (DocStatus.equals("DR") || DocStatus.equals("IN")) {
            options[index++] = "CO";
            options[index++] = "VO";
        } else if (DocStatus.equals("IP") || DocStatus.equals("AP")) {
            options[index++] = "CO";
            options[index++] = "VO";
        } else if (DocStatus.equals("CO")) {
            options[index++] = "CL";
        } else if (DocStatus.equals("WP") || DocStatus.equals("WC")) {
            options[index++] = "VO";
            options[index++] = "PR";
        } else if (DocStatus.equals("CL") || DocStatus.equals("VO") || DocStatus.equals("RE")) {
            return;
        }
        if (this.m_AD_Table_ID == 259) {
            if (DocStatus.equals("DR") || DocStatus.equals("IP") || DocStatus.equals("IN")) {
                options[index++] = "PR";
                options[index++] = "CL";
                if ("Y".equals(IsSOTrx) && ("OB".equals(OrderType) || "ON".equals(OrderType))) {
                    DocAction2 = "PR";
                }
            } else if (DocStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            } else if (DocStatus.equals("WP")) {
                options[index++] = "RE";
                options[index++] = "CL";
            }
        } else if (this.m_AD_Table_ID == 319) {
            if (DocStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
            }
        } else if (this.m_AD_Table_ID == 318) {
            if (DocStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
            }
        } else if (this.m_AD_Table_ID == 335) {
            if (DocStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
            }
        } else if (this.m_AD_Table_ID == 224 || this.m_AD_Table_ID == 225) {
            if (DocStatus.equals("CO")) {
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (this.m_AD_Table_ID == 735) {
            if (DocStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
            }
        } else if (this.m_AD_Table_ID == 392) {
            if (DocStatus.equals("CO")) {
                options[index++] = "VO";
            }
        } else if ((this.m_AD_Table_ID == 323 || this.m_AD_Table_ID == 321) && DocStatus.equals("CO")) {
            options[index++] = "VO";
            options[index++] = "RC";
        }
        for (int i = 0; i < index; ++i) {
            boolean added = false;
            for (int j = 0; j < s_value.length && !added; ++j) {
                if (!options[i].equals(s_value[j])) continue;
                this.actionCombo.addItem(s_name[j]);
                added = true;
            }
        }
        if (DocAction2.equals("--")) {
            DocAction2 = "CL";
        }
        String defaultV = "";
        for (int i = 0; i < s_value.length && defaultV.equals(""); ++i) {
            if (!DocAction2.equals(s_value[i])) continue;
            defaultV = s_name[i];
        }
        if (!defaultV.equals("")) {
            this.actionCombo.setSelectedItem(defaultV);
        }
    }

    private boolean checkStatus(String TableName, int Record_ID, String DocStatus) {
        String sql = "SELECT 2 FROM " + TableName + " WHERE " + TableName + "_ID=" + Record_ID + " AND DocStatus='" + DocStatus + "'";
        int result = DB.getSQLValue(null, sql);
        return result == 2;
    }

    public int getNumberOfOptions() {
        return this.actionCombo.getItemCount();
    }

    public boolean isStartProcess() {
        return this.m_OKpressed;
    }

    public boolean isBatch() {
        return this.m_batch;
    }

    private void readReference() {
        String sql = Env.isBaseLanguage(Env.getCtx(), "AD_Ref_List") ? "SELECT Value, Name, Description FROM AD_Ref_List WHERE AD_Reference_ID=135 ORDER BY Name" : "SELECT l.Value, t.Name, t.Description FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "'" + " AND l.AD_Reference_ID=135 ORDER BY t.Name";
        ArrayList<String> v_value = new ArrayList<String>();
        ArrayList<String> v_name = new ArrayList<String>();
        ArrayList<String> v_description = new ArrayList<String>();
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String value = rs.getString(1);
                String name = rs.getString(2);
                String description = rs.getString(3);
                if (description == null) {
                    description = "";
                }
                v_value.add(value);
                v_name.add(name);
                v_description.add(description);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        int size = v_value.size();
        s_value = new String[size];
        s_name = new String[size];
        s_description = new String[size];
        for (int i = 0; i < size; ++i) {
            VDocAction.s_value[i] = (String)v_value.get(i);
            VDocAction.s_name[i] = (String)v_name.get(i);
            VDocAction.s_description[i] = (String)v_description.get(i);
        }
    }

    public void actionPerformed(ActionEvent e) {
        int index;
        boolean bl = this.m_batch = e.getSource() == this.batchButton;
        if (this.m_batch || e.getActionCommand().equals("Ok")) {
            if (this.save()) {
                this.dispose();
                this.m_OKpressed = true;
                return;
            }
        } else {
            if (e.getActionCommand().equals("Cancel")) {
                this.dispose();
                return;
            }
            if (e.getSource() != this.actionCombo) {
                return;
            }
        }
        if ((index = this.getSelectedIndex()) != -1) {
            this.message.setText(s_description[index]);
        }
    }

    private int getSelectedIndex() {
        int index = -1;
        String sel = (String)this.actionCombo.getSelectedItem();
        if (sel == null) {
            return index;
        }
        for (int i = 0; i < s_name.length && index == -1; ++i) {
            if (!sel.equals(s_name[i])) continue;
            index = i;
        }
        return index;
    }

    private boolean save() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return false;
        }
        log.config("DocAction=" + s_value[index]);
        this.m_mTab.setValue("DocAction", (Object)s_value[index]);
        return true;
    }

    static {
        log = CLogger.getCLogger(VDocAction.class);
    }
}

