/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.swing.CCheckBox;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VCheckBox
extends CCheckBox
implements VEditor,
ActionListener {
    private char m_savedMnemonic = '\u0000';
    private String m_columnName;

    public VCheckBox() {
        this("", false, false, true, "", null, false);
    }

    public VCheckBox(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, String title, String description, boolean tableEditor) {
        super.setName(columnName);
        this.m_columnName = columnName;
        this.setMandatory(mandatory);
        if (isReadOnly || !isUpdateable) {
            this.setEditable(false);
        } else {
            this.setEditable(true);
        }
        if (!tableEditor) {
            this.setText(title);
            if (description != null && description.length() > 0) {
                this.setToolTipText(description);
            }
        } else {
            this.setHorizontalAlignment(0);
        }
        this.addActionListener(this);
    }

    public void dispose() {
    }

    public void setEditable(boolean value) {
        super.setReadWrite(value);
    }

    public boolean isEditable() {
        return super.isReadWrite();
    }

    public void setValue(Object value) {
        boolean sel = false;
        if (value != null) {
            sel = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
        }
        this.setSelected(sel);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    public Object getValue() {
        return new Boolean(this.isSelected());
    }

    public String getDisplay() {
        String value = this.isSelected() ? "Y" : "N";
        return Msg.translate(Env.getCtx(), value);
    }

    public void setBackground() {
    }

    public void actionPerformed(ActionEvent e) {
        try {
            this.fireVetoableChange(this.m_columnName, null, this.getValue());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setField(GridField mField) {
    }

    public char getSavedMnemonic() {
        return this.m_savedMnemonic;
    }

    public void setSavedMnemonic(char savedMnemonic) {
        this.m_savedMnemonic = savedMnemonic;
    }
}

