/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.GridField;
import org.compiere.model.GridTable;
import org.compiere.util.CLogger;

public final class VCellEditor
extends AbstractCellEditor
implements TableCellEditor,
VetoableChangeListener,
ActionListener {
    private GridField m_mField = null;
    private VEditor m_editor = null;
    private JTable m_table = null;
    private static int CLICK_TO_START = 2;
    private static CLogger log = CLogger.getCLogger(VCellEditor.class);

    public VCellEditor(GridField mField) {
        this.m_mField = mField;
    }

    private void createEditor() {
        this.m_editor = VEditorFactory.getEditor(this.m_mField, true);
        this.m_editor.addVetoableChangeListener(this);
        this.m_editor.addActionListener(this);
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (!this.m_mField.isEditable(true)) {
            return false;
        }
        log.fine(this.m_mField.getHeader());
        if (anEvent instanceof MouseEvent && ((MouseEvent)anEvent).getClickCount() < CLICK_TO_START) {
            return false;
        }
        if (this.m_editor == null) {
            this.createEditor();
        }
        return true;
    }

    public Component getTableCellEditorComponent(JTable table2, Object value, boolean isSelected, int row, int col) {
        log.finest(this.m_mField.getColumnName() + ": Value=" + value + ", row=" + row + ", col=" + col);
        if (row >= 0) {
            table2.setRowSelectionInterval(row, row);
        }
        if (this.m_editor == null) {
            this.createEditor();
        }
        this.m_table = table2;
        this.m_editor.setValue(value);
        this.m_editor.setBackground(this.m_mField.isError());
        this.m_editor.setForeground(AdempierePLAF.getTextColor_Normal());
        this.m_editor.setFont(table2.getFont());
        if (this.m_editor instanceof VLookup) {
            VLookup lookup = (VLookup)this.m_editor;
            if (lookup.getComponents()[0] instanceof JComboBox) {
                lookup.setBorder(BorderFactory.createEmptyBorder());
            } else {
                lookup.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            }
        } else {
            this.m_editor.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        }
        return (Component)((Object)this.m_editor);
    }

    public boolean shouldSelectCell(EventObject e) {
        log.finest(this.m_mField.getColumnName());
        return true;
    }

    public Object getCellEditorValue() {
        log.finest(this.m_mField.getColumnName() + ": " + this.m_editor.getValue());
        return this.m_editor.getValue();
    }

    public void vetoableChange(PropertyChangeEvent e) {
        if (this.m_table == null) {
            return;
        }
        log.fine(e.getPropertyName() + "=" + e.getNewValue());
        ((GridTable)this.m_table.getModel()).setChanged(true);
    }

    public VEditor getEditor() {
        return this.m_editor;
    }

    public void actionPerformed(ActionEvent e) {
        log.finer(this.m_mField.getColumnName() + ": Value=" + this.m_editor.getValue());
    }

    public void dispose() {
        this.m_editor = null;
        this.m_mField = null;
        this.m_table = null;
    }
}

