/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;

public class VBinary
extends JButton
implements VEditor,
ActionListener {
    private String m_columnName;
    private int m_WindowNo;
    private Object m_data = null;
    private static CLogger log = CLogger.getCLogger(VBinary.class);

    public VBinary(String columnName, int WindowNo) {
        super("");
        this.m_columnName = columnName;
        this.m_WindowNo = WindowNo;
        super.addActionListener(this);
    }

    public void dispose() {
        this.m_data = null;
    }

    public void setValue(Object value) {
        log.config("=" + value);
        this.m_data = value;
        if (this.m_data == null) {
            this.setText("-");
        } else {
            String text = "?";
            if (this.m_data instanceof byte[]) {
                byte[] bb = (byte[])this.m_data;
                text = "#" + bb.length;
            } else {
                text = this.m_data.getClass().getName();
                int index = text.lastIndexOf(".");
                if (index != -1) {
                    text = text.substring(index + 1);
                }
            }
            this.setText(text);
        }
    }

    public Object getValue() {
        return this.m_data;
    }

    public String getDisplay() {
        return this.getText();
    }

    public void setReadWrite(boolean rw) {
        if (this.isEnabled() != rw) {
            this.setEnabled(rw);
        }
    }

    public boolean isReadWrite() {
        return super.isEnabled();
    }

    public void setMandatory(boolean mandatory) {
    }

    public boolean isMandatory() {
        return false;
    }

    public void setBackground(Color color) {
    }

    public void setBackground() {
    }

    public void setBackground(boolean error) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        log.info(evt.toString());
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser("");
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(0);
        int option = 0;
        boolean save = this.m_data != null;
        option = save ? fc.showSaveDialog(this) : fc.showOpenDialog(this);
        if (option != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (file == null) {
            return;
        }
        log.info(file.toString());
        try {
            if (save) {
                FileOutputStream os = new FileOutputStream(file);
                byte[] buffer = (byte[])this.m_data;
                os.write(buffer);
                os.flush();
                os.close();
                log.config("Save to " + file + " #" + buffer.length);
            } else {
                FileInputStream is = new FileInputStream(file);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                int length = -1;
                while ((length = is.read(buffer)) != -1) {
                    os.write(buffer, 0, length);
                }
                is.close();
                byte[] data = os.toByteArray();
                this.m_data = data;
                log.config("Load from " + file + " #" + data.length);
                os.close();
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Save=" + save, ex);
        }
        try {
            this.fireVetoableChange(this.m_columnName, null, this.m_data);
        }
        catch (PropertyVetoException pve) {
            // empty catch block
        }
    }

    public void setField(GridField mField) {
    }
}

