/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.compiere.Adempiere;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.HTMLEditor_MenuAction;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class HTMLEditor
extends CDialog {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private String m_text;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private JScrollPane editorScrollPane = new JScrollPane();
    private JTextPane editorPane = new JTextPane();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private JToolBar toolBar = new JToolBar();
    private JButton bImport = AEnv.getButton("Import");
    private JButton bExport = AEnv.getButton("Export");
    private JButton bBold = AEnv.getButton("Bold");
    private JButton bItalic = AEnv.getButton("Italic");
    private JButton bUnderline = AEnv.getButton("Underline");
    private JMenuBar menuBar = new JMenuBar();
    private static String NAME_SIZE = Msg.getMsg(Env.getCtx(), "Size");
    private static String NAME_HEADING = Msg.getMsg(Env.getCtx(), "Heading");
    private static HTMLEditor_MenuAction[] sizeMenu = new HTMLEditor_MenuAction[]{new HTMLEditor_MenuAction(NAME_SIZE + "  8", "font-size-8"), new HTMLEditor_MenuAction(NAME_SIZE + " 10", "font-size-10"), new HTMLEditor_MenuAction(NAME_SIZE + " 12", "font-size-12"), new HTMLEditor_MenuAction(NAME_SIZE + " 14", "font-size-14"), new HTMLEditor_MenuAction(NAME_SIZE + " 16", "font-size-16"), new HTMLEditor_MenuAction(NAME_SIZE + " 18", "font-size-18"), new HTMLEditor_MenuAction(NAME_SIZE + " 24", "font-size-24"), new HTMLEditor_MenuAction(NAME_SIZE + " 36", "font-size-36"), new HTMLEditor_MenuAction(NAME_SIZE + " 48", "font-size-48")};
    private static HTMLEditor_MenuAction[] familyMenu = new HTMLEditor_MenuAction[]{new HTMLEditor_MenuAction("Sans Serif", "font-family-SansSerif"), new HTMLEditor_MenuAction("Monospaced", "font-family-Monospaced"), new HTMLEditor_MenuAction("Serif", "font-family-Serif")};
    private static HTMLEditor_MenuAction[] styleMenu = new HTMLEditor_MenuAction[]{new HTMLEditor_MenuAction(Msg.getMsg(Env.getCtx(), "Bold"), "font-bold"), new HTMLEditor_MenuAction(Msg.getMsg(Env.getCtx(), "Italic"), "font-italic"), new HTMLEditor_MenuAction(Msg.getMsg(Env.getCtx(), "Underline"), "font-underline")};
    private static HTMLEditor_MenuAction[] headingMenu = new HTMLEditor_MenuAction[]{new HTMLEditor_MenuAction(NAME_HEADING + " 1", "Heading 1"), new HTMLEditor_MenuAction(NAME_HEADING + " 2", "Heading 2"), new HTMLEditor_MenuAction(NAME_HEADING + " 3", "Heading 3"), new HTMLEditor_MenuAction(NAME_HEADING + " 4", "Heading 4"), new HTMLEditor_MenuAction(NAME_HEADING + " 5", "Heading 5")};
    private static HTMLEditor_MenuAction[] fontMenu = new HTMLEditor_MenuAction[]{new HTMLEditor_MenuAction(NAME_SIZE, sizeMenu), new HTMLEditor_MenuAction(Msg.getMsg(Env.getCtx(), "FontFamily"), familyMenu), new HTMLEditor_MenuAction(Msg.getMsg(Env.getCtx(), "FontStyle"), styleMenu), new HTMLEditor_MenuAction(NAME_HEADING, headingMenu)};
    private static HTMLEditor_MenuAction[] alignMenu = new HTMLEditor_MenuAction[]{new HTMLEditor_MenuAction(Msg.getMsg(Env.getCtx(), "Left"), "left-justify"), new HTMLEditor_MenuAction(Msg.getMsg(Env.getCtx(), "Center"), "center-justify"), new HTMLEditor_MenuAction(Msg.getMsg(Env.getCtx(), "Right"), "right-justify")};
    private static HTMLEditor_MenuAction[] htmlMenu = new HTMLEditor_MenuAction[]{new HTMLEditor_MenuAction("Paragraph", "Paragraph"), new HTMLEditor_MenuAction("Table", "InsertTable"), new HTMLEditor_MenuAction("Table Row", "InsertTableRow"), new HTMLEditor_MenuAction("Table Cell", "InsertTableDataCell"), new HTMLEditor_MenuAction("Unordered List", "InsertUnorderedList"), new HTMLEditor_MenuAction("Unordered List Item", "InsertUnorderedListItem"), new HTMLEditor_MenuAction("Ordered List", "InsertOrderedList"), new HTMLEditor_MenuAction("Ordered List Item", "InsertOrderedListItem"), new HTMLEditor_MenuAction("Preformatted Paragraph", "InsertPre"), new HTMLEditor_MenuAction("Horizontal Rule", "InsertHR")};
    private static HTMLEditorKit.InsertHTMLTextAction[] extraActions = new HTMLEditorKit.InsertHTMLTextAction[]{new HTMLEditorKit.InsertHTMLTextAction("Heading 1", "<h1>h1</h1>", HTML.Tag.BODY, HTML.Tag.H1), new HTMLEditorKit.InsertHTMLTextAction("Heading 2", "<h2>h2</h2>", HTML.Tag.BODY, HTML.Tag.H2), new HTMLEditorKit.InsertHTMLTextAction("Heading 3", "<h2>h3</h2>", HTML.Tag.BODY, HTML.Tag.H3), new HTMLEditorKit.InsertHTMLTextAction("Heading 4", "<h2>h4</h2>", HTML.Tag.BODY, HTML.Tag.H4), new HTMLEditorKit.InsertHTMLTextAction("Heading 5", "<h2>h5</h2>", HTML.Tag.BODY, HTML.Tag.H5), new HTMLEditorKit.InsertHTMLTextAction("Paragraph", "<p>p</p>", HTML.Tag.BODY, HTML.Tag.P)};

    public HTMLEditor(Frame owner, String title, String htmlText, boolean editable) {
        super(owner, title == null ? Msg.getMsg(Env.getCtx(), "Editor") : title, true);
        this.init(owner, htmlText, editable);
    }

    public HTMLEditor(Dialog owner, String title, String htmlText, boolean editable) {
        super(owner, title == null ? Msg.getMsg(Env.getCtx(), "Editor") : title, true);
        this.init(owner, htmlText, editable);
    }

    private void init(Window owner, String htmlText, boolean editable) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "HTMLEditor", e);
        }
        this.setHtmlText(htmlText);
        this.editorPane.setEditable(editable);
        AEnv.showCenterWindow(owner, this);
    }

    private void jbInit() throws Exception {
        this.bImport.setToolTipText(Msg.getMsg(Env.getCtx(), "Import"));
        this.bImport.addActionListener(this);
        this.bExport.setToolTipText(Msg.getMsg(Env.getCtx(), "Export"));
        this.bExport.addActionListener(this);
        this.bBold.setToolTipText(Msg.getMsg(Env.getCtx(), "Bold"));
        this.bItalic.setToolTipText(Msg.getMsg(Env.getCtx(), "Italic"));
        this.bUnderline.setToolTipText(Msg.getMsg(Env.getCtx(), "Underline"));
        this.toolBar.add((Component)this.bImport, null);
        this.toolBar.add((Component)this.bExport, null);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.bBold, null);
        this.toolBar.add((Component)this.bItalic, null);
        this.toolBar.add((Component)this.bUnderline, null);
        this.toolBar.addSeparator();
        this.editorPane.setContentType("text/html");
        this.setJMenuBar(this.menuBar);
        this.createMenuBar();
        this.mainPanel.setLayout(this.mainLayout);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.toolBar, "North");
        this.mainPanel.add((Component)this.editorScrollPane, "Center");
        this.editorScrollPane.setPreferredSize(new Dimension(600, 600));
        this.editorScrollPane.getViewport().add((Component)this.editorPane, null);
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.confirmPanel.addActionListener(this);
    }

    private void createMenuBar() {
        Object name;
        int i;
        Action[] actionArray = this.editorPane.getActions();
        Hashtable<Object, Action> actions = new Hashtable<Object, Action>();
        for (i = 0; i < actionArray.length; ++i) {
            name = actionArray[i].getValue("Name");
            actions.put(name, actionArray[i]);
        }
        for (i = 0; i < extraActions.length; ++i) {
            name = extraActions[i].getValue("Name");
            actions.put(name, extraActions[i]);
        }
        JMenu menu = this.buildMenu(Msg.getMsg(Env.getCtx(), "Font"), fontMenu, actions);
        if (menu != null) {
            this.menuBar.add(menu);
        }
        if ((menu = this.buildMenu(Msg.getMsg(Env.getCtx(), "Align"), alignMenu, actions)) != null) {
            this.menuBar.add(menu);
        }
        if ((menu = this.buildMenu("HTML", htmlMenu, actions)) != null) {
            this.menuBar.add(menu);
        }
        Action targetAction = (Action)actions.get("font-bold");
        this.bBold.addActionListener(targetAction);
        targetAction = (Action)actions.get("font-italic");
        this.bItalic.addActionListener(targetAction);
        targetAction = (Action)actions.get("font-underline");
        this.bUnderline.addActionListener(targetAction);
    }

    private JMenu buildMenu(String name, HTMLEditor_MenuAction[] menuActions, Hashtable actions) {
        JMenu menu = new JMenu(name);
        for (int i = 0; i < menuActions.length; ++i) {
            HTMLEditor_MenuAction item = menuActions[i];
            if (item.isSubMenu()) {
                JMenu subMenu = this.buildMenu(item.getName(), item.getSubMenus(), actions);
                if (subMenu == null) continue;
                menu.add(subMenu);
                continue;
            }
            if (item.isAction()) {
                menu.add(item.getAction());
                continue;
            }
            String actionName = item.getActionName();
            Action targetAction = (Action)actions.get(actionName);
            JMenuItem menuItem = menu.add(item.getName());
            if (targetAction != null) {
                menuItem.addActionListener(targetAction);
                continue;
            }
            menuItem.setEnabled(false);
        }
        if (menu.getMenuComponentCount() == 0) {
            menu = null;
        }
        return menu;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bImport) {
            this.cmd_import();
        } else if (e.getSource() == this.bExport) {
            this.cmd_export();
        } else if (e.getActionCommand().equals("Ok")) {
            this.m_text = this.editorPane.getText();
            this.dispose();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    private void cmd_import() {
        JFileChooser jc = new JFileChooser();
        jc.setDialogTitle(Msg.getMsg(Env.getCtx(), "Import"));
        jc.setDialogType(0);
        jc.setFileSelectionMode(0);
        if (jc.showOpenDialog(this) != 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        try {
            int count;
            InputStreamReader in = new InputStreamReader(new FileInputStream(jc.getSelectedFile()));
            char[] cbuf = new char[1024];
            while ((count = in.read(cbuf)) > 0) {
                sb.append(cbuf, 0, count);
            }
            in.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "HTMLEditor.import" + e.getMessage());
            return;
        }
        this.setHtmlText(sb.toString());
    }

    private void cmd_export() {
        JFileChooser jc = new JFileChooser();
        jc.setDialogTitle(Msg.getMsg(Env.getCtx(), "Export"));
        jc.setDialogType(1);
        jc.setFileSelectionMode(0);
        if (jc.showSaveDialog(this) != 0) {
            return;
        }
        try {
            EditorKit kit = this.editorPane.getEditorKit();
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(jc.getSelectedFile()));
            this.editorPane.write(writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "HTMLEditor.export" + e.getMessage());
        }
    }

    public String getHtmlText() {
        return this.m_text;
    }

    public void setHtmlText(String htmlText) {
        this.m_text = htmlText;
        this.editorPane.setText(htmlText);
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(true);
        JFrame frame = new JFrame("test");
        frame.setVisible(true);
        String text = "<html><p>this is a line<br>with <b>bold</> info</html>";
        int i = 0;
        while (true) {
            HTMLEditor ed = new HTMLEditor((Frame)frame, "heading " + ++i, text, true);
            text = ed.getHtmlText();
        }
    }
}

