/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.table.TableModel;
import org.compiere.grid.ed.VCellEditor;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridTable;
import org.compiere.swing.CTable;
import org.compiere.util.CLogger;

public final class VTable
extends CTable
implements PropertyChangeListener {
    private static CLogger log = CLogger.getCLogger(VTable.class);

    public VTable() {
        this.setAutoscrolls(true);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("CurrentRow")) {
            int selRow;
            int row = (Integer)evt.getNewValue();
            if (row == (selRow = this.getSelectedRow())) {
                return;
            }
            log.config("CurrentRow=" + row + " from " + selRow);
            this.setRowSelectionInterval(row, row);
            Rectangle cellRect = this.getCellRect(row, 1, false);
            if (cellRect != null) {
                this.scrollRectToVisible(cellRect);
            }
            log.config("CurrentRow=" + row + " from " + selRow);
        }
    }

    public int getColorCode(int row) {
        return ((GridTable)this.getModel()).getColorCode(row);
    }

    protected void sort(int modelColumnIndex) {
        int rows = this.getRowCount();
        if (rows == 0) {
            return;
        }
        TableModel model = this.getModel();
        if (!(model instanceof GridTable)) {
            super.sort(modelColumnIndex);
            return;
        }
        this.p_asc = modelColumnIndex != this.p_lastSortIndex ? true : !this.p_asc;
        this.p_lastSortIndex = modelColumnIndex;
        log.config("#" + modelColumnIndex + " - rows=" + rows + ", asc=" + this.p_asc);
        ((GridTable)model).sort(modelColumnIndex, this.p_asc);
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        if (!super.editCellAt(row, column, e)) {
            return false;
        }
        Object ed = this.getCellEditor();
        if (ed instanceof VEditor) {
            ((Component)ed).requestFocus();
        } else if (ed instanceof VCellEditor) {
            ed = ((VCellEditor)ed).getEditor();
            ((Component)ed).requestFocus();
        }
        return true;
    }

    public String toString() {
        return new StringBuffer("VTable[").append(this.getModel()).append("]").toString();
    }
}

