/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;
import org.compiere.apps.ADialog;
import org.compiere.apps.APanel;
import org.compiere.grid.GridController;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.GridTab;
import org.compiere.swing.CTabbedPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Evaluator;
import org.compiere.util.Language;

public class VTabbedPane
extends CTabbedPane {
    private static CLogger log = CLogger.getCLogger(VTabbedPane.class);
    private boolean m_workbenchTab = false;
    private ArrayList<String> m_dependents = new ArrayList();
    private static Icon s_disabledIcon = null;

    public VTabbedPane(boolean isWorkbench) {
        this.setTabLayoutPolicy(1);
        this.setWorkbench(isWorkbench);
        this.setFocusable(false);
    }

    public String toString() {
        return (this.m_workbenchTab ? "WorkbenchTab" : "WindowTab") + " - selected " + this.getSelectedIndex() + " of " + this.getTabCount();
    }

    public void addTab(String tabName, GridTab gTab, Component tabElement) {
        int index = this.getTabCount();
        super.addTab(tabName, gTab.getIcon(), tabElement, gTab.getDescription());
        ArrayList<String> dependents = gTab.getDependentOn();
        for (int i = 0; i < dependents.size(); ++i) {
            String name = dependents.get(i);
            if (this.m_dependents.contains(name)) continue;
            this.m_dependents.add(name);
        }
        if (s_disabledIcon == null) {
            s_disabledIcon = Env.getImageIcon("Cancel10.gif");
        }
        this.setDisabledIconAt(index, s_disabledIcon);
    }

    public void setWorkbench(boolean isWorkbench) {
        this.m_workbenchTab = isWorkbench;
        if (this.m_workbenchTab) {
            super.setTabPlacement(3);
        } else {
            super.setTabPlacement(Language.getLoginLanguage().isLeftToRight() ? 2 : 4);
        }
    }

    public boolean isWorkbench() {
        return this.m_workbenchTab;
    }

    public void setTabPlacement(int notUsed) {
        new IllegalAccessError("Do not use VTabbedPane.setTabPlacement directly");
    }

    public void dispose(APanel aPanel) {
        Component[] comp = this.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (comp[i] instanceof VTabbedPane) {
                VTabbedPane tp = (VTabbedPane)comp[i];
                tp.removeChangeListener(aPanel);
                tp.dispose(aPanel);
                continue;
            }
            if (!(comp[i] instanceof GridController)) continue;
            GridController gc = (GridController)comp[i];
            gc.addDataStatusListener(aPanel);
            gc.dispose();
        }
        this.removeAll();
    }

    public void setSelectedIndex(int index) {
        Component oldC;
        boolean display;
        String logic;
        Component newC = this.getComponentAt(index);
        GridController newGC = null;
        if (newC instanceof GridController) {
            newGC = (GridController)newC;
        }
        if (newGC != null && (logic = newGC.getDisplayLogic()) != null && logic.length() > 0 && !(display = Evaluator.evaluateLogic(newGC, logic))) {
            log.info("Not displayed - " + logic);
            return;
        }
        int oldIndex = this.getSelectedIndex();
        if (newGC != null && oldIndex >= 0 && index != oldIndex && (oldC = this.getComponentAt(oldIndex)) != null && oldC instanceof GridController) {
            GridController oldGC = (GridController)oldC;
            if (newGC.getTabLevel() > oldGC.getTabLevel() + 1) {
                for (int i = index - 1; i >= 0; --i) {
                    Component rightC = this.getComponentAt(i);
                    GridController rightGC = null;
                    if (!(rightC instanceof GridController) || (rightGC = (GridController)rightC).getTabLevel() != oldGC.getTabLevel() + 1) continue;
                    ADialog.warn(0, this, "TabSwitchJumpGo", rightGC.getTitle());
                    return;
                }
                ADialog.warn(0, this, "TabSwitchJump");
                return;
            }
            oldGC.setMnemonics(false);
        }
        super.setSelectedIndex(index);
        if (newGC != null) {
            newGC.setMnemonics(true);
        }
    }

    public void evaluate(DataStatusEvent e) {
        boolean process = e == null;
        String columnName = null;
        if (!process) {
            columnName = e.getColumnName();
            process = columnName != null ? this.m_dependents.contains(columnName) : true;
        }
        if (process) {
            log.config(columnName == null ? "" : columnName);
            for (int i = 0; i < this.getTabCount(); ++i) {
                Component c = this.getComponentAt(i);
                if (!(c instanceof GridController)) continue;
                GridController gc = (GridController)c;
                String logic = gc.getDisplayLogic();
                boolean display = true;
                if (logic != null && logic.length() > 0) {
                    display = Evaluator.evaluateLogic(gc, logic);
                }
                this.setEnabledAt(i, display);
            }
        }
    }
}

