/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.compiere.apps.APanel;
import org.compiere.grid.APanelTab;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VSortTab
extends CPanel
implements APanelTab,
ActionListener {
    private int m_WindowNo;
    private String m_TableName = null;
    private String m_ColumnSortName = null;
    private String m_ColumnYesNoName = null;
    private String m_KeyColumnName = null;
    private String m_IdentifierColumnName = null;
    private boolean m_IdentifierTranslated = false;
    private String m_ParentColumnName = null;
    private boolean m_saveSequence = false;
    private APanel m_aPanel = null;
    private static CLogger log = CLogger.getCLogger(VSortTab.class);
    private GridBagLayout mainLayout = new GridBagLayout();
    private CLabel noLabel = new CLabel();
    private CLabel yesLabel = new CLabel();
    private CButton bAdd = new CButton();
    private CButton bRemove = new CButton();
    private CButton bUp = new CButton();
    private CButton bDown = new CButton();
    private DefaultListModel noModel = new DefaultListModel();
    private DefaultListModel yesModel = new DefaultListModel();
    private JList noList = new JList(this.noModel);
    private JList yesList = new JList(this.yesModel);
    private JScrollPane noPane = new JScrollPane(this.noList);
    private JScrollPane yesPane = new JScrollPane(this.yesList);

    public VSortTab(int WindowNo, int AD_Table_ID, int AD_ColumnSortOrder_ID, int AD_ColumnSortYesNo_ID) {
        log.config("SortOrder=" + AD_ColumnSortOrder_ID + ", SortYesNo=" + AD_ColumnSortYesNo_ID);
        this.m_WindowNo = WindowNo;
        try {
            this.jbInit();
            this.dynInit(AD_Table_ID, AD_ColumnSortOrder_ID, AD_ColumnSortYesNo_ID);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.noLabel.setText("No");
        this.yesLabel.setText("Yes");
        this.bAdd.setIcon(Env.getImageIcon("Detail24.gif"));
        this.bAdd.setMargin(new Insets(2, 2, 2, 2));
        this.bAdd.addActionListener(this);
        this.bRemove.setIcon(Env.getImageIcon("Parent24.gif"));
        this.bRemove.setMargin(new Insets(2, 2, 2, 2));
        this.bRemove.addActionListener(this);
        this.bUp.setIcon(Env.getImageIcon("Previous24.gif"));
        this.bUp.setMargin(new Insets(2, 2, 2, 2));
        this.bUp.addActionListener(this);
        this.bDown.setIcon(Env.getImageIcon("Next24.gif"));
        this.bDown.setMargin(new Insets(2, 2, 2, 2));
        this.bDown.addActionListener(this);
        this.yesPane.setPreferredSize(new Dimension(200, 300));
        this.yesList.setSelectionMode(2);
        this.noPane.setPreferredSize(new Dimension(200, 300));
        this.noList.setSelectionMode(2);
        this.add((Component)this.noLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.yesLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.bDown, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.noPane, new GridBagConstraints(0, 1, 1, 3, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.yesPane, new GridBagConstraints(2, 1, 1, 3, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.bUp, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.bRemove, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.bAdd, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
    }

    private void dynInit(int AD_Table_ID, int AD_ColumnSortOrder_ID, int AD_ColumnSortYesNo_ID) {
        boolean trl;
        String sql = "SELECT t.TableName, c.AD_Column_ID, c.ColumnName, e.Name,c.IsParent, c.IsKey, c.IsIdentifier, c.IsTranslated FROM AD_Table t, AD_Column c, AD_Element e WHERE t.AD_Table_ID=? AND t.AD_Table_ID=c.AD_Table_ID AND (c.AD_Column_ID=? OR AD_Column_ID=? OR c.IsParent='Y' OR c.IsKey='Y' OR c.IsIdentifier='Y') AND c.AD_Element_ID=e.AD_Element_ID";
        boolean bl = trl = !Env.isBaseLanguage(Env.getCtx(), "AD_Element");
        if (trl) {
            sql = "SELECT t.TableName, c.AD_Column_ID, c.ColumnName, et.Name,c.IsParent, c.IsKey, c.IsIdentifier, c.IsTranslated FROM AD_Table t, AD_Column c, AD_Element_Trl et WHERE t.AD_Table_ID=? AND t.AD_Table_ID=c.AD_Table_ID AND (c.AD_Column_ID=? OR AD_Column_ID=?\tOR c.IsParent='Y' OR c.IsKey='Y' OR c.IsIdentifier='Y') AND c.AD_Element_ID=et.AD_Element_ID AND et.AD_Language=?";
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Table_ID);
            pstmt.setInt(2, AD_ColumnSortOrder_ID);
            pstmt.setInt(3, AD_ColumnSortYesNo_ID);
            if (trl) {
                pstmt.setString(4, Env.getAD_Language(Env.getCtx()));
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.m_TableName = rs.getString(1);
                if (AD_ColumnSortOrder_ID == rs.getInt(2)) {
                    log.fine("Sort=" + rs.getString(1) + "." + rs.getString(3));
                    this.m_ColumnSortName = rs.getString(3);
                    this.yesLabel.setText(rs.getString(4));
                    continue;
                }
                if (AD_ColumnSortYesNo_ID == rs.getInt(2)) {
                    log.fine("YesNo=" + rs.getString(1) + "." + rs.getString(3));
                    this.m_ColumnYesNoName = rs.getString(3);
                    continue;
                }
                if (rs.getString(5).equals("Y")) {
                    log.fine("Parent=" + rs.getString(1) + "." + rs.getString(3));
                    this.m_ParentColumnName = rs.getString(3);
                    continue;
                }
                if (rs.getString(6).equals("Y")) {
                    log.fine("Key=" + rs.getString(1) + "." + rs.getString(3));
                    this.m_KeyColumnName = rs.getString(3);
                    continue;
                }
                if (rs.getString(7).equals("Y")) {
                    log.fine("Identifier=" + rs.getString(1) + "." + rs.getString(3));
                    this.m_IdentifierColumnName = rs.getString(3);
                    if (!trl) continue;
                    this.m_IdentifierTranslated = "Y".equals(rs.getString(8));
                    continue;
                }
                log.fine("??NotUsed??=" + rs.getString(1) + "." + rs.getString(3));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        this.noLabel.setText(Msg.getMsg(Env.getCtx(), "Available"));
        log.info(this.m_ColumnSortName);
    }

    public void registerAPanel(APanel panel) {
        this.m_aPanel = panel;
    }

    public void unregisterPanel() {
        this.saveData();
        this.m_aPanel = null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bAdd) {
            Object[] objects = this.noList.getSelectedValues();
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null || !this.noModel.removeElement(objects[i])) continue;
                log.config("Add=" + objects[i]);
                this.yesModel.addElement(objects[i]);
                this.yesList.setSelectedValue(objects[i], true);
                this.m_saveSequence = true;
            }
        } else if (e.getSource() == this.bRemove) {
            Object[] objects = this.yesList.getSelectedValues();
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null || !this.yesModel.removeElement(objects[i])) continue;
                log.config("Remove=" + objects[i]);
                this.noModel.addElement(objects[i]);
                this.m_saveSequence = true;
            }
        } else if (e.getSource() == this.bUp) {
            int[] indexes = this.yesList.getSelectedIndices();
            Object[] objects = this.yesList.getSelectedValues();
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] <= 0) continue;
                Object obj = this.yesList.getSelectedValue();
                log.config("Up=" + obj);
                if (this.yesModel.removeElement(obj)) {
                    this.yesModel.insertElementAt(obj, indexes[i] - 1);
                }
                this.m_saveSequence = true;
                int n = i;
                indexes[n] = indexes[n] - 1;
            }
            this.yesList.setSelectedIndices(indexes);
        } else if (e.getSource() == this.bDown) {
            int[] indexes = this.yesList.getSelectedIndices();
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] == -1 || indexes[i] >= this.yesModel.size() - 1) continue;
                Object obj = this.yesList.getSelectedValue();
                log.config("Down=" + obj);
                if (this.yesModel.removeElement(obj)) {
                    this.yesModel.insertElementAt(obj, indexes[i] + 1);
                }
                this.m_saveSequence = true;
                int n = i;
                indexes[n] = indexes[n] + 1;
            }
            this.yesList.setSelectedIndices(indexes);
        }
        if (this.m_saveSequence && this.m_aPanel != null) {
            this.m_aPanel.aSave.setEnabled(true);
        }
    }

    public void loadData() {
        this.yesModel.removeAllElements();
        this.noModel.removeAllElements();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT t.").append(this.m_KeyColumnName).append(this.m_IdentifierTranslated ? ",tt." : ",t.").append(this.m_IdentifierColumnName).append(",t.").append(this.m_ColumnSortName);
        if (this.m_ColumnYesNoName != null) {
            sql.append(",t.").append(this.m_ColumnYesNoName);
        }
        sql.append(" FROM ").append(this.m_TableName).append(" t");
        if (this.m_IdentifierTranslated) {
            sql.append(", ").append(this.m_TableName).append("_Trl tt");
        }
        sql.append(" WHERE t.").append(this.m_ParentColumnName).append("=?");
        if (this.m_IdentifierTranslated) {
            sql.append(" AND t.").append(this.m_KeyColumnName).append("=tt.").append(this.m_KeyColumnName).append(" AND tt.AD_Language=?");
        }
        sql.append(" ORDER BY ");
        if (this.m_ColumnYesNoName != null) {
            sql.append("4 DESC,");
        }
        sql.append("3,2");
        int ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, this.m_ParentColumnName);
        log.config(sql.toString() + " - ID=" + ID);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, ID);
            if (this.m_IdentifierTranslated) {
                pstmt.setString(2, Env.getAD_Language(Env.getCtx()));
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                boolean isYes;
                int key = rs.getInt(1);
                String name = rs.getString(2);
                int seq = rs.getInt(3);
                boolean bl = isYes = seq != 0;
                if (this.m_ColumnYesNoName != null) {
                    isYes = rs.getString(4).equals("Y");
                }
                KeyNamePair pp = new KeyNamePair(key, name);
                if (isYes) {
                    this.yesModel.addElement(pp);
                    continue;
                }
                this.noModel.addElement(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        this.m_saveSequence = false;
    }

    public void saveData() {
        KeyNamePair pp;
        int i;
        if (!this.m_saveSequence) {
            return;
        }
        log.info("");
        StringBuffer sql = null;
        for (i = 0; i < this.noModel.getSize(); ++i) {
            pp = (KeyNamePair)this.noModel.getElementAt(i);
            sql = new StringBuffer();
            sql.append("UPDATE ").append(this.m_TableName).append(" SET ").append(this.m_ColumnSortName).append("=0");
            if (this.m_ColumnYesNoName != null) {
                sql.append(",").append(this.m_ColumnYesNoName).append("='N'");
            }
            sql.append(" WHERE ").append(this.m_KeyColumnName).append("=").append(pp.getKey());
            if (DB.executeUpdate(sql.toString(), null) == 1) continue;
            log.log(Level.SEVERE, "NoModel - Not updated: " + this.m_KeyColumnName + "=" + pp.getKey());
        }
        for (i = 0; i < this.yesModel.getSize(); ++i) {
            pp = (KeyNamePair)this.yesModel.getElementAt(i);
            sql = new StringBuffer();
            sql.append("UPDATE ").append(this.m_TableName).append(" SET ").append(this.m_ColumnSortName).append("=").append(i + 1).append("0");
            if (this.m_ColumnYesNoName != null) {
                sql.append(",").append(this.m_ColumnYesNoName).append("='Y'");
            }
            sql.append(" WHERE ").append(this.m_KeyColumnName).append("=").append(pp.getKey());
            if (DB.executeUpdate(sql.toString(), null) == 1) continue;
            log.log(Level.SEVERE, "YesModel - Not updated: " + this.m_KeyColumnName + "=" + pp.getKey());
        }
    }
}

