/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.KeyStroke;
import org.compiere.grid.ed.VButton;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.grid.ed.VLine;
import org.compiere.model.GridField;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Language;

public final class VPanel
extends CPanel {
    private GridBagConstraints m_gbc = new GridBagConstraints();
    private final boolean m_leftToRight = Language.getLoginLanguage().isLeftToRight();
    private final Insets m_labelInset = this.m_leftToRight ? new Insets(2, 12, 3, 0) : new Insets(2, 5, 3, 0);
    private final Insets m_fieldInset = this.m_leftToRight ? new Insets(2, 5, 3, 0) : new Insets(2, 12, 3, 0);
    private final Insets m_zeroInset = new Insets(0, 0, 0, 0);
    private int m_line = 0;
    private boolean m_hGapAdded = false;
    private String m_oldFieldGroup = null;
    private static CLogger log = CLogger.getCLogger(VPanel.class);
    private ArrayList<Character> m_mnemonics = new ArrayList(30);
    private ArrayList<Component> m_fields = new ArrayList(30);

    public VPanel() {
        super(new GridBagLayout());
        this.setName("VPanel");
        this.setBorder(null);
        this.m_gbc.anchor = 18;
        this.m_gbc.gridy = 0;
        this.m_gbc.gridx = 0;
        this.m_gbc.gridheight = 1;
        this.m_gbc.gridwidth = 1;
        this.m_gbc.insets = this.m_zeroInset;
        this.m_gbc.fill = 2;
        this.m_gbc.weightx = 0.0;
        this.m_gbc.weighty = 0.0;
        this.m_gbc.ipadx = 0;
        this.m_gbc.ipady = 0;
    }

    public void setMnemonic(GridField mField) {
        char mnemonic;
        if (mField.isCreateMnemonic()) {
            return;
        }
        String text = mField.getHeader();
        int pos = text.indexOf("&");
        if (pos != -1 && text.length() > pos && (mnemonic = text.toUpperCase().charAt(pos + 1)) != ' ') {
            if (!this.m_mnemonics.contains(Character.valueOf(mnemonic))) {
                mField.setMnemonic(mnemonic);
                this.m_mnemonics.add(Character.valueOf(mnemonic));
            } else {
                log.warning(mField.getColumnName() + " - Conflict - Already exists: " + mnemonic + " (" + text + ")");
            }
        }
    }

    public void addField(VEditor editor, GridField mField) {
        CLabel label = VEditorFactory.getLabel(mField);
        if (label == null && editor == null) {
            return;
        }
        boolean sameLine = mField.isSameLine();
        if (this.addGroup(mField.getFieldGroup())) {
            sameLine = false;
        }
        this.m_gbc.gridy = sameLine ? this.m_line - 1 : this.m_line++;
        if (label != null) {
            this.m_gbc.gridwidth = 1;
            this.m_gbc.insets = this.m_labelInset;
            this.m_gbc.fill = 2;
            this.m_gbc.gridx = this.m_leftToRight ? (sameLine ? 2 : 0) : (sameLine | mField.isLongField() ? 3 : 1);
            this.m_gbc.weightx = 0.0;
            if (mField.isCreateMnemonic()) {
                this.setMnemonic(label, mField.getMnemonic());
            }
            this.add((Component)label, this.m_gbc);
        }
        if (editor != null) {
            Component field = (Component)((Object)editor);
            this.m_gbc.gridwidth = mField.isLongField() ? 3 : 1;
            this.m_gbc.insets = this.m_fieldInset;
            this.m_gbc.fill = 2;
            this.m_gbc.gridx = this.m_leftToRight ? (sameLine ? 3 : 1) : (sameLine ? 2 : 0);
            this.m_gbc.weightx = 1.0;
            this.add(field, this.m_gbc);
            if (label != null) {
                label.setLabelFor(field);
            } else if (mField.isCreateMnemonic()) {
                this.setMnemonic(editor, mField.getMnemonic());
            }
        }
    }

    private boolean addGroup(String fieldGroup) {
        if (this.m_oldFieldGroup == null) {
            this.addTop();
            this.m_oldFieldGroup = "";
        }
        if (fieldGroup == null || fieldGroup.length() == 0 || fieldGroup.equals(this.m_oldFieldGroup)) {
            return false;
        }
        this.m_oldFieldGroup = fieldGroup;
        CPanel group = new CPanel();
        group.setBorder(new VLine(fieldGroup));
        group.add(Box.createVerticalStrut(4));
        this.m_gbc.gridx = 0;
        this.m_gbc.gridy = this.m_line++;
        this.m_gbc.gridwidth = 4;
        this.add((Component)group, this.m_gbc);
        this.m_gbc.gridwidth = 1;
        return true;
    }

    private void addTop() {
        this.m_gbc.gridy = this.m_line++;
        this.add(Box.createVerticalStrut(10), this.m_gbc);
        this.m_gbc.gridx = 4;
        this.m_gbc.gridwidth = 1;
        this.m_gbc.weightx = 0.0;
        this.m_gbc.insets = this.m_zeroInset;
        this.m_gbc.fill = 0;
        this.add(Box.createHorizontalStrut(12), this.m_gbc);
    }

    public void addEnd() {
        this.m_gbc.gridx = 0;
        this.m_gbc.gridy = this.m_line;
        this.m_gbc.gridwidth = 1;
        this.m_gbc.insets = this.m_zeroInset;
        this.m_gbc.fill = 2;
        this.m_gbc.weightx = 0.0;
        this.add(Box.createVerticalStrut(9), this.m_gbc);
    }

    private void setMnemonic(CLabel label, char predefinedMnemonic) {
        String text = label.getText();
        int pos = text.indexOf("&");
        if (pos != -1 && predefinedMnemonic != '\u0000') {
            text = text.substring(0, pos) + text.substring(pos + 1);
            label.setText(text);
            label.setSavedMnemonic(predefinedMnemonic);
            this.m_fields.add(label);
            log.finest(predefinedMnemonic + " - " + label.getName());
        } else {
            char mnemonic = this.getMnemonic(text, label);
            if (mnemonic != '\u0000') {
                label.setSavedMnemonic(mnemonic);
            }
        }
    }

    private void setMnemonic(VEditor editor, char predefinedMnemonic) {
        if (editor instanceof VCheckBox) {
            VCheckBox cb = (VCheckBox)editor;
            String text = cb.getText();
            int pos = text.indexOf("&");
            if (pos != -1 && predefinedMnemonic != '\u0000') {
                text = text.substring(0, pos) + text.substring(pos + 1);
                cb.setText(text);
                cb.setSavedMnemonic(predefinedMnemonic);
                this.m_fields.add(cb);
                log.finest(predefinedMnemonic + " - " + cb.getName());
            } else {
                char mnemonic = this.getMnemonic(text, cb);
                if (mnemonic != '\u0000') {
                    cb.setSavedMnemonic(mnemonic);
                }
            }
        } else if (editor instanceof VButton) {
            VButton b = (VButton)editor;
            String text = b.getText();
            int pos = text.indexOf("&");
            if (pos != -1 && predefinedMnemonic != '\u0000') {
                text = text.substring(0, pos) + text.substring(pos + 1);
                b.setText(text);
                b.setSavedMnemonic(predefinedMnemonic);
                this.m_fields.add(b);
                log.finest(predefinedMnemonic + " - " + b.getName());
            } else if (b.getColumnName().equals("DocAction")) {
                b.getInputMap(2).put(KeyStroke.getKeyStroke(115, 1, false), "pressed");
                b.getInputMap(2).put(KeyStroke.getKeyStroke(115, 1, true), "released");
            } else if (b.getColumnName().equals("Posted")) {
                b.getInputMap(2).put(KeyStroke.getKeyStroke(116, 1, false), "pressed");
                b.getInputMap(2).put(KeyStroke.getKeyStroke(116, 1, true), "released");
            } else {
                char mnemonic = this.getMnemonic(text, b);
                if (mnemonic != '\u0000') {
                    b.setSavedMnemonic(mnemonic);
                }
            }
        }
    }

    private char getMnemonic(String text, Component source) {
        if (text == null || text.length() == 0) {
            return '\u0000';
        }
        String oText = text;
        char mnemonic = (text = text.trim().toUpperCase()).charAt(0);
        if (this.m_mnemonics.contains(Character.valueOf(mnemonic))) {
            mnemonic = '\u0000';
            int index = text.indexOf(32);
            while (index != -1 && text.length() > index) {
                char c = text.charAt(index + 1);
                if (Character.isLetterOrDigit(c) && !this.m_mnemonics.contains(Character.valueOf(c))) {
                    mnemonic = c;
                    break;
                }
                index = text.indexOf(32, index + 1);
            }
            if (mnemonic == '\u0000') {
                for (int i = 1; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (!Character.isLetterOrDigit(c) || this.m_mnemonics.contains(Character.valueOf(c))) continue;
                    mnemonic = c;
                    break;
                }
            }
            if (mnemonic == '\u0000') {
                log.finest("None for: " + oText);
                return '\u0000';
            }
        }
        this.m_mnemonics.add(Character.valueOf(mnemonic));
        this.m_fields.add(source);
        log.finest(mnemonic + " - " + source.getName());
        return mnemonic;
    }

    public void setMnemonics(boolean set) {
        int size = this.m_fields.size();
        for (int i = 0; i < size; ++i) {
            Component c = this.m_fields.get(i);
            if (c instanceof CLabel) {
                CLabel l = (CLabel)c;
                if (set) {
                    l.setDisplayedMnemonic(l.getSavedMnemonic());
                    continue;
                }
                l.setDisplayedMnemonic(0);
                continue;
            }
            if (c instanceof VCheckBox) {
                VCheckBox cb = (VCheckBox)c;
                if (set) {
                    cb.setMnemonic(cb.getSavedMnemonic());
                    continue;
                }
                cb.setMnemonic(0);
                continue;
            }
            if (!(c instanceof VButton)) continue;
            VButton b = (VButton)c;
            if (set) {
                b.setMnemonic(b.getSavedMnemonic());
                continue;
            }
            b.setMnemonic(0);
        }
    }

    public void setBackground(int AD_Color_ID) {
    }
}

