/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.compiere.apps.ADialog;
import org.compiere.grid.VCreateFrom;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.GridTab;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPayment;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VCreateFromStatement
extends VCreateFrom
implements VetoableChangeListener {
    VCreateFromStatement(GridTab mTab) {
        super(mTab);
        this.log.info("");
    }

    protected boolean dynInit() throws Exception {
        if (this.p_mTab.getValue("C_BankStatement_ID") == null) {
            ADialog.error(0, this, "SaveErrorRowNotFound");
            return false;
        }
        this.setTitle(Msg.translate(Env.getCtx(), "C_BankStatement_ID") + " .. " + Msg.translate(Env.getCtx(), "CreateFrom"));
        this.parameterStdPanel.setVisible(false);
        int AD_Column_ID = 4917;
        MLookup lookup = MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, AD_Column_ID, 19);
        this.bankAccountField = new VLookup("C_BankAccount_ID", true, false, true, lookup);
        this.bankAccountField.addVetoableChangeListener(this);
        int C_BankAccount_ID = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "C_BankAccount_ID");
        this.bankAccountField.setValue(new Integer(C_BankAccount_ID));
        this.loadBankAccount(C_BankAccount_ID);
        return true;
    }

    protected void initBPDetails(int C_BPartner_ID) {
    }

    public void vetoableChange(PropertyChangeEvent e) {
        this.log.config(e.getPropertyName() + "=" + e.getNewValue());
        if (e.getPropertyName() == "C_BankAccount_ID") {
            int C_BankAccount_ID = (Integer)e.getNewValue();
            this.loadBankAccount(C_BankAccount_ID);
        }
        this.tableChanged(null);
    }

    private void loadBankAccount(int C_BankAccount_ID) {
        this.log.config("C_BankAccount_ID=" + C_BankAccount_ID);
        Vector data = new Vector();
        String sql = "SELECT p.DateTrx,p.C_Payment_ID,p.DocumentNo, p.C_Currency_ID,c.ISO_Code, p.PayAmt,currencyConvert(p.PayAmt,p.C_Currency_ID,ba.C_Currency_ID,?,null,p.AD_Client_ID,p.AD_Org_ID), bp.Name FROM C_BankAccount ba INNER JOIN C_Payment_v p ON (p.C_BankAccount_ID=ba.C_BankAccount_ID) INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID) LEFT OUTER JOIN C_BPartner bp ON (p.C_BPartner_ID=bp.C_BPartner_ID) WHERE p.Processed='Y' AND p.IsReconciled='N' AND p.DocStatus IN ('CO','CL','RE','VO') AND p.PayAmt<>0 AND p.C_BankAccount_ID=? AND NOT EXISTS (SELECT * FROM C_BankStatementLine l WHERE p.C_Payment_ID=l.C_Payment_ID AND l.StmtAmt <> 0)";
        Timestamp ts = (Timestamp)this.p_mTab.getValue("StatementDate");
        if (ts == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setTimestamp(1, ts);
            pstmt.setInt(2, C_BankAccount_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>(6);
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                KeyNamePair pp = new KeyNamePair(rs.getInt(2), rs.getString(3));
                line.add(pp);
                pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                line.add(pp);
                line.add(rs.getBigDecimal(6));
                line.add(rs.getBigDecimal(7));
                line.add(rs.getString(8));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        Vector<String> columnNames = new Vector<String>(6);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Msg.getElement(Env.getCtx(), "C_Payment_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        columnNames.add(Msg.translate(Env.getCtx(), "ConvertedAmount"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.dataTable.getModel().removeTableModelListener(this);
        DefaultTableModel model = new DefaultTableModel(data, columnNames);
        model.addTableModelListener(this);
        this.dataTable.setModel(model);
        this.dataTable.setColumnClass(0, Boolean.class, false);
        this.dataTable.setColumnClass(1, Timestamp.class, true);
        this.dataTable.setColumnClass(2, String.class, true);
        this.dataTable.setColumnClass(3, String.class, true);
        this.dataTable.setColumnClass(4, BigDecimal.class, true);
        this.dataTable.setColumnClass(5, BigDecimal.class, true);
        this.dataTable.setColumnClass(6, String.class, true);
        this.dataTable.autoSize();
    }

    protected void info() {
        DecimalFormat format = DisplayType.getNumberFormat(12);
        TableModel model = this.dataTable.getModel();
        BigDecimal total = new BigDecimal(0.0);
        int rows = model.getRowCount();
        int count = 0;
        for (int i = 0; i < rows; ++i) {
            if (!((Boolean)model.getValueAt(i, 0)).booleanValue()) continue;
            total = total.add((BigDecimal)model.getValueAt(i, 4));
            ++count;
        }
        this.statusBar.setStatusLine(String.valueOf(count) + " - " + Msg.getMsg(Env.getCtx(), "Sum") + "  " + format.format(total));
    }

    protected boolean save() {
        this.log.config("");
        TableModel model = this.dataTable.getModel();
        int rows = model.getRowCount();
        if (rows == 0) {
            return false;
        }
        int C_BankStatement_ID = (Integer)this.p_mTab.getValue("C_BankStatement_ID");
        MBankStatement bs = new MBankStatement(Env.getCtx(), C_BankStatement_ID, null);
        this.log.config(bs.toString());
        for (int i = 0; i < rows; ++i) {
            if (!((Boolean)model.getValueAt(i, 0)).booleanValue()) continue;
            Timestamp trxDate = (Timestamp)model.getValueAt(i, 1);
            KeyNamePair pp = (KeyNamePair)model.getValueAt(i, 2);
            int C_Payment_ID = pp.getKey();
            pp = (KeyNamePair)model.getValueAt(i, 3);
            int C_Currency_ID = pp.getKey();
            BigDecimal TrxAmt = (BigDecimal)model.getValueAt(i, 4);
            this.log.fine("Line Date=" + trxDate + ", Payment=" + C_Payment_ID + ", Currency=" + C_Currency_ID + ", Amt=" + TrxAmt);
            MBankStatementLine bsl = new MBankStatementLine(bs);
            bsl.setStatementLineDate(trxDate);
            bsl.setPayment(new MPayment(Env.getCtx(), C_Payment_ID, null));
            if (bsl.save()) continue;
            this.log.log(Level.SEVERE, "Line not created #" + i);
        }
        return true;
    }
}

