/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.table.TableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.grid.VCreateFrom;
import org.compiere.grid.ed.VLocator;
import org.compiere.model.GridTab;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.X_C_OrderLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VCreateFromShipment
extends VCreateFrom
implements VetoableChangeListener {
    private MInvoice m_invoice = null;

    VCreateFromShipment(GridTab mTab) {
        super(mTab);
    }

    protected boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(Msg.getElement(Env.getCtx(), "M_InOut_ID", false) + " .. " + Msg.translate(Env.getCtx(), "CreateFrom"));
        this.parameterBankPanel.setVisible(false);
        this.shipmentLabel.setVisible(false);
        this.shipmentField.setVisible(false);
        int AD_Column_ID = 3537;
        MLocatorLookup locator = new MLocatorLookup(Env.getCtx(), this.p_WindowNo);
        this.locatorField = new VLocator("M_Locator_ID", true, false, true, locator, this.p_WindowNo);
        this.initBPartner(false);
        this.bPartnerField.addVetoableChangeListener(this);
        return true;
    }

    protected void initBPDetails(int C_BPartner_ID) {
        this.log.config("C_BPartner_ID=" + C_BPartner_ID);
        this.invoiceField.removeActionListener(this);
        this.invoiceField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.invoiceField.addItem(pp);
        StringBuffer display = new StringBuffer("i.DocumentNo||' - '||").append(DB.TO_CHAR("DateInvoiced", 15, Env.getAD_Language(Env.getCtx()))).append("|| ' - ' ||").append(DB.TO_CHAR("GrandTotal", 12, Env.getAD_Language(Env.getCtx())));
        StringBuffer sql = new StringBuffer("SELECT i.C_Invoice_ID,").append(display).append(" FROM C_Invoice i WHERE i.C_BPartner_ID=? AND i.IsSOTrx='N' AND i.DocStatus IN ('CL','CO') AND i.C_Invoice_ID IN (SELECT il.C_Invoice_ID FROM C_InvoiceLine il LEFT OUTER JOIN M_MatchInv mi ON (il.C_InvoiceLine_ID=mi.C_InvoiceLine_ID) GROUP BY il.C_Invoice_ID,mi.C_InvoiceLine_ID,il.QtyInvoiced HAVING (il.QtyInvoiced<>SUM(mi.Qty) AND mi.C_InvoiceLine_ID IS NOT NULL) OR mi.C_InvoiceLine_ID IS NULL) ORDER BY i.DateInvoiced");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                this.invoiceField.addItem(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        this.invoiceField.setSelectedIndex(0);
        this.invoiceField.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        KeyNamePair pp;
        super.actionPerformed(e);
        this.log.config("Action=" + e.getActionCommand());
        if (e.getSource().equals(this.orderField)) {
            KeyNamePair pp2 = (KeyNamePair)this.orderField.getSelectedItem();
            if (pp2 != null && pp2.getKey() != 0) {
                int C_Order_ID = pp2.getKey();
                this.invoiceField.setSelectedIndex(-1);
                this.shipmentField.setSelectedIndex(-1);
                this.loadOrder(C_Order_ID, false);
                this.m_invoice = null;
            }
        } else if (e.getSource().equals(this.invoiceField) && (pp = (KeyNamePair)this.invoiceField.getSelectedItem()) != null && pp.getKey() != 0) {
            int C_Invoice_ID = pp.getKey();
            this.orderField.setSelectedIndex(-1);
            this.shipmentField.setSelectedIndex(-1);
            this.loadInvoice(C_Invoice_ID);
        }
    }

    public void vetoableChange(PropertyChangeEvent e) {
        this.log.config(e.getPropertyName() + "=" + e.getNewValue());
        if (e.getPropertyName() == "C_BPartner_ID") {
            int C_BPartner_ID = (Integer)e.getNewValue();
            this.initBPartnerOIS(C_BPartner_ID, false);
        }
        this.tableChanged(null);
    }

    private void loadInvoice(int C_Invoice_ID) {
        this.log.config("C_Invoice_ID=" + C_Invoice_ID);
        this.m_invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
        this.p_order = null;
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("SELECT l.QtyInvoiced-SUM(NVL(mi.Qty,0)),l.QtyEntered/l.QtyInvoiced, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name), l.M_Product_ID,p.Name, l.C_InvoiceLine_ID,l.Line, l.C_OrderLine_ID ");
        if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
            sql.append("FROM C_UOM uom, C_InvoiceLine l, M_Product p, M_MatchInv mi ");
            sql.append("WHERE l.C_UOM_ID=uom.C_UOM_ID");
        } else {
            sql.append("FROM C_UOM_Trl uom, C_InvoiceLine_v l, M_Product p, M_MatchInv mi ");
            sql.append("WHERE l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language(Env.getCtx())).append("'");
        }
        sql.append(" AND l.M_Product_ID=p.M_Product_ID AND l.C_InvoiceLine_ID=mi.C_InvoiceLine_ID(+) AND l.C_Invoice_ID=? GROUP BY l.QtyInvoiced,l.QtyEntered/l.QtyInvoiced,l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name),l.M_Product_ID,p.Name, l.C_InvoiceLine_ID,l.Line,l.C_OrderLine_ID ORDER BY l.Line");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, C_Invoice_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>(7);
                line.add(new Boolean(false));
                BigDecimal qtyInvoiced = rs.getBigDecimal(1);
                BigDecimal multiplier = rs.getBigDecimal(2);
                BigDecimal qtyEntered = qtyInvoiced.multiply(multiplier);
                line.add(new Double(qtyEntered.doubleValue()));
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                line.add(pp);
                pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                line.add(pp);
                int C_OrderLine_ID = rs.getInt(9);
                if (rs.wasNull()) {
                    line.add(null);
                } else {
                    line.add(new KeyNamePair(C_OrderLine_ID, "."));
                }
                line.add(null);
                pp = new KeyNamePair(rs.getInt(7), rs.getString(8));
                line.add(pp);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        this.loadTableOIS(data);
    }

    protected void info() {
        TableModel model = this.dataTable.getModel();
        int rows = model.getRowCount();
        int count = 0;
        for (int i = 0; i < rows; ++i) {
            if (!((Boolean)model.getValueAt(i, 0)).booleanValue()) continue;
            ++count;
        }
        this.statusBar.setStatusLine(String.valueOf(count));
    }

    protected boolean save() {
        this.log.config("");
        TableModel model = this.dataTable.getModel();
        int rows = model.getRowCount();
        if (rows == 0) {
            return false;
        }
        Integer loc = (Integer)this.locatorField.getValue();
        if (loc == null || loc == 0) {
            this.locatorField.setBackground(AdempierePLAF.getFieldBackground_Error());
            return false;
        }
        int M_Locator_ID = loc;
        int M_InOut_ID = (Integer)this.p_mTab.getValue("M_InOut_ID");
        MInOut inout = new MInOut(Env.getCtx(), M_InOut_ID, null);
        this.log.config(inout + ", C_Locator_ID=" + M_Locator_ID);
        for (int i = 0; i < rows; ++i) {
            if (!((Boolean)model.getValueAt(i, 0)).booleanValue()) continue;
            Double d = (Double)model.getValueAt(i, 1);
            BigDecimal QtyEntered = new BigDecimal(d);
            KeyNamePair pp = (KeyNamePair)model.getValueAt(i, 2);
            int C_UOM_ID = pp.getKey();
            pp = (KeyNamePair)model.getValueAt(i, 3);
            int M_Product_ID = pp.getKey();
            int C_OrderLine_ID = 0;
            pp = (KeyNamePair)model.getValueAt(i, 4);
            if (pp != null) {
                C_OrderLine_ID = pp.getKey();
            }
            int C_InvoiceLine_ID = 0;
            MInvoiceLine il = null;
            pp = (KeyNamePair)model.getValueAt(i, 6);
            if (pp != null) {
                C_InvoiceLine_ID = pp.getKey();
            }
            if (C_InvoiceLine_ID != 0) {
                il = new MInvoiceLine(Env.getCtx(), C_InvoiceLine_ID, null);
            }
            boolean isInvoiced = C_InvoiceLine_ID != 0;
            int precision = 2;
            if (M_Product_ID != 0) {
                MProduct product = MProduct.get(Env.getCtx(), M_Product_ID);
                precision = product.getUOMPrecision();
            }
            QtyEntered = QtyEntered.setScale(precision, 5);
            this.log.fine("Line QtyEntered=" + QtyEntered + ", Product=" + M_Product_ID + ", OrderLine=" + C_OrderLine_ID + ", InvoiceLine=" + C_InvoiceLine_ID);
            if (this.m_invoice != null && this.m_invoice.isCreditMemo()) {
                QtyEntered = QtyEntered.negate();
            }
            MInOutLine iol = new MInOutLine(inout);
            iol.setM_Product_ID(M_Product_ID, C_UOM_ID);
            iol.setQty(QtyEntered);
            X_C_OrderLine ol = null;
            if (C_OrderLine_ID != 0) {
                iol.setC_OrderLine_ID(C_OrderLine_ID);
                ol = new MOrderLine(Env.getCtx(), C_OrderLine_ID, null);
                if (ol.getQtyEntered().compareTo(ol.getQtyOrdered()) != 0) {
                    iol.setMovementQty(QtyEntered.multiply(ol.getQtyOrdered()).divide(ol.getQtyEntered(), 12, 4));
                    iol.setC_UOM_ID(ol.getC_UOM_ID());
                }
                iol.setM_AttributeSetInstance_ID(ol.getM_AttributeSetInstance_ID());
                iol.setDescription(ol.getDescription());
                iol.setC_Project_ID(((MOrderLine)ol).getC_Project_ID());
                iol.setC_ProjectPhase_ID(ol.getC_ProjectPhase_ID());
                iol.setC_ProjectTask_ID(ol.getC_ProjectTask_ID());
                iol.setC_Activity_ID(((MOrderLine)ol).getC_Activity_ID());
                iol.setC_Campaign_ID(((MOrderLine)ol).getC_Campaign_ID());
                iol.setAD_OrgTrx_ID(((MOrderLine)ol).getAD_OrgTrx_ID());
                iol.setUser1_ID(((MOrderLine)ol).getUser1_ID());
                iol.setUser2_ID(((MOrderLine)ol).getUser2_ID());
            } else if (il != null) {
                if (il.getQtyEntered().compareTo(il.getQtyInvoiced()) != 0) {
                    iol.setQtyEntered(QtyEntered.multiply(il.getQtyInvoiced()).divide(il.getQtyEntered(), 12, 4));
                    iol.setC_UOM_ID(il.getC_UOM_ID());
                }
                iol.setDescription(il.getDescription());
                iol.setC_Project_ID(il.getC_Project_ID());
                iol.setC_ProjectPhase_ID(il.getC_ProjectPhase_ID());
                iol.setC_ProjectTask_ID(il.getC_ProjectTask_ID());
                iol.setC_Activity_ID(il.getC_Activity_ID());
                iol.setC_Campaign_ID(il.getC_Campaign_ID());
                iol.setAD_OrgTrx_ID(il.getAD_OrgTrx_ID());
                iol.setUser1_ID(il.getUser1_ID());
                iol.setUser2_ID(il.getUser2_ID());
            }
            if (M_Product_ID == 0) {
                if (ol != null && ol.getC_Charge_ID() != 0) {
                    iol.setC_Charge_ID(ol.getC_Charge_ID());
                } else if (il != null && il.getC_Charge_ID() != 0) {
                    iol.setC_Charge_ID(il.getC_Charge_ID());
                }
            }
            iol.setM_Locator_ID(M_Locator_ID);
            if (!iol.save()) {
                this.log.log(Level.SEVERE, "Line NOT created #" + i);
                continue;
            }
            if (il == null) continue;
            il.setM_InOutLine_ID(iol.getM_InOutLine_ID());
            il.save();
        }
        if (this.p_order != null && this.p_order.getC_Order_ID() != 0) {
            inout.setC_Order_ID(this.p_order.getC_Order_ID());
            inout.setAD_OrgTrx_ID(this.p_order.getAD_OrgTrx_ID());
            inout.setC_Project_ID(this.p_order.getC_Project_ID());
            inout.setC_Campaign_ID(this.p_order.getC_Campaign_ID());
            inout.setC_Activity_ID(this.p_order.getC_Activity_ID());
            inout.setUser1_ID(this.p_order.getUser1_ID());
            inout.setUser2_ID(this.p_order.getUser2_ID());
        }
        if (this.m_invoice != null && this.m_invoice.getC_Invoice_ID() != 0) {
            if (inout.getC_Order_ID() == 0) {
                inout.setC_Order_ID(this.m_invoice.getC_Order_ID());
            }
            inout.setC_Invoice_ID(this.m_invoice.getC_Invoice_ID());
            inout.setAD_OrgTrx_ID(this.m_invoice.getAD_OrgTrx_ID());
            inout.setC_Project_ID(this.m_invoice.getC_Project_ID());
            inout.setC_Campaign_ID(this.m_invoice.getC_Campaign_ID());
            inout.setC_Activity_ID(this.m_invoice.getC_Activity_ID());
            inout.setUser1_ID(this.m_invoice.getUser1_ID());
            inout.setUser2_ID(this.m_invoice.getUser2_ID());
        }
        inout.save();
        return true;
    }
}

