/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.table.TableModel;
import org.compiere.grid.VCreateFrom;
import org.compiere.model.GridTab;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VCreateFromInvoice
extends VCreateFrom
implements VetoableChangeListener {
    private boolean m_actionActive = false;
    private MInOut m_inout = null;

    VCreateFromInvoice(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
    }

    protected boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(Msg.getElement(Env.getCtx(), "C_Invoice_ID", false) + " .. " + Msg.translate(Env.getCtx(), "CreateFrom"));
        this.parameterBankPanel.setVisible(false);
        this.invoiceLabel.setVisible(false);
        this.invoiceField.setVisible(false);
        this.locatorLabel.setVisible(false);
        this.locatorField.setVisible(false);
        this.initBPartner(true);
        this.bPartnerField.addVetoableChangeListener(this);
        return true;
    }

    protected void initBPDetails(int C_BPartner_ID) {
        this.log.config("C_BPartner_ID" + C_BPartner_ID);
        this.shipmentField.removeActionListener(this);
        this.shipmentField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.shipmentField.addItem(pp);
        StringBuffer display = new StringBuffer("s.DocumentNo||' - '||").append(DB.TO_CHAR("s.MovementDate", 15, Env.getAD_Language(Env.getCtx())));
        StringBuffer sql = new StringBuffer("SELECT s.M_InOut_ID,").append(display).append(" FROM M_InOut s WHERE s.C_BPartner_ID=? AND s.IsSOTrx='N' AND s.DocStatus IN ('CL','CO') AND s.M_InOut_ID IN (SELECT sl.M_InOut_ID FROM M_InOutLine sl LEFT OUTER JOIN M_MatchInv mi ON (sl.M_InOutLine_ID=mi.M_InOutLine_ID) GROUP BY sl.M_InOut_ID,mi.M_InOutLine_ID,sl.MovementQty HAVING (sl.MovementQty<>SUM(mi.Qty) AND mi.M_InOutLine_ID IS NOT NULL) OR mi.M_InOutLine_ID IS NULL) ORDER BY s.MovementDate");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                this.shipmentField.addItem(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        this.shipmentField.setSelectedIndex(0);
        this.shipmentField.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (this.m_actionActive) {
            return;
        }
        this.m_actionActive = true;
        this.log.config("Action=" + e.getActionCommand());
        if (e.getSource().equals(this.orderField)) {
            KeyNamePair pp = (KeyNamePair)this.orderField.getSelectedItem();
            int C_Order_ID = 0;
            if (pp != null) {
                C_Order_ID = pp.getKey();
            }
            this.invoiceField.setSelectedIndex(-1);
            this.shipmentField.setSelectedIndex(-1);
            this.loadOrder(C_Order_ID, true);
        } else if (e.getSource().equals(this.shipmentField)) {
            KeyNamePair pp = (KeyNamePair)this.shipmentField.getSelectedItem();
            int M_InOut_ID = 0;
            if (pp != null) {
                M_InOut_ID = pp.getKey();
            }
            this.orderField.setSelectedIndex(-1);
            this.invoiceField.setSelectedIndex(-1);
            this.loadShipment(M_InOut_ID);
        }
        this.m_actionActive = false;
    }

    public void vetoableChange(PropertyChangeEvent e) {
        this.log.config(e.getPropertyName() + "=" + e.getNewValue());
        if (e.getPropertyName() == "C_BPartner_ID") {
            int C_BPartner_ID = (Integer)e.getNewValue();
            this.initBPartnerOIS(C_BPartner_ID, true);
        }
        this.tableChanged(null);
    }

    private void loadShipment(int M_InOut_ID) {
        this.log.config("M_InOut_ID=" + M_InOut_ID);
        this.m_inout = new MInOut(Env.getCtx(), M_InOut_ID, null);
        this.p_order = null;
        if (this.m_inout.getC_Order_ID() != 0) {
            this.p_order = new MOrder(Env.getCtx(), this.m_inout.getC_Order_ID(), null);
        }
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("SELECT l.MovementQty-SUM(NVL(mi.Qty, 0)), l.QtyEntered/l.MovementQty, l.C_UOM_ID, COALESCE(uom.UOMSymbol, uom.Name), l.M_Product_ID, p.Name, l.M_InOutLine_ID, l.Line, l.C_OrderLine_ID ");
        if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
            sql.append("FROM C_UOM uom, M_InOutLine l, M_Product p, M_MatchInv mi ");
            sql.append("WHERE l.C_UOM_ID=uom.C_UOM_ID");
        } else {
            sql.append("FROM C_UOM_Trl uom, M_InOutLine l, M_Product p, M_MatchInv mi ");
            sql.append("WHERE l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language(Env.getCtx())).append("'");
        }
        sql.append(" AND l.M_Product_ID=p.M_Product_ID").append(" AND l.M_InOutLine_ID=mi.M_InOutLine_ID(+)").append(" AND l.M_InOut_ID=? ").append("GROUP BY l.MovementQty, l.QtyEntered/l.MovementQty, l.C_UOM_ID, COALESCE(uom.UOMSymbol, uom.Name), l.M_Product_ID, p.Name, l.M_InOutLine_ID, l.Line, l.C_OrderLine_ID ").append("ORDER BY l.Line");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, M_InOut_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>(7);
                line.add(new Boolean(false));
                BigDecimal qtyMovement = rs.getBigDecimal(1);
                BigDecimal multiplier = rs.getBigDecimal(2);
                BigDecimal qtyEntered = qtyMovement.multiply(multiplier);
                line.add(new Double(qtyEntered.doubleValue()));
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                line.add(pp);
                pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                line.add(pp);
                int C_OrderLine_ID = rs.getInt(9);
                if (rs.wasNull()) {
                    line.add(null);
                } else {
                    line.add(new KeyNamePair(C_OrderLine_ID, "."));
                }
                pp = new KeyNamePair(rs.getInt(7), rs.getString(8));
                line.add(pp);
                line.add(null);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        this.loadTableOIS(data);
    }

    protected void info() {
        TableModel model = this.dataTable.getModel();
        int rows = model.getRowCount();
        int count = 0;
        for (int i = 0; i < rows; ++i) {
            if (!((Boolean)model.getValueAt(i, 0)).booleanValue()) continue;
            ++count;
        }
        this.statusBar.setStatusLine(String.valueOf(count));
    }

    protected boolean save() {
        this.log.config("");
        TableModel model = this.dataTable.getModel();
        int rows = model.getRowCount();
        if (rows == 0) {
            return false;
        }
        int C_Invoice_ID = (Integer)this.p_mTab.getValue("C_Invoice_ID");
        MInvoice invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
        this.log.config(invoice.toString());
        if (this.p_order != null) {
            invoice.setOrder(this.p_order);
            invoice.save();
        }
        if (this.m_inout != null && this.m_inout.getM_InOut_ID() != 0 && this.m_inout.getC_Invoice_ID() == 0) {
            this.m_inout.setC_Invoice_ID(C_Invoice_ID);
            this.m_inout.save();
        }
        for (int i = 0; i < rows; ++i) {
            if (!((Boolean)model.getValueAt(i, 0)).booleanValue()) continue;
            Double d = (Double)model.getValueAt(i, 1);
            BigDecimal QtyEntered = new BigDecimal(d);
            KeyNamePair pp = (KeyNamePair)model.getValueAt(i, 2);
            int C_UOM_ID = pp.getKey();
            pp = (KeyNamePair)model.getValueAt(i, 3);
            int M_Product_ID = 0;
            if (pp != null) {
                M_Product_ID = pp.getKey();
            }
            boolean C_Charge_ID = false;
            int C_OrderLine_ID = 0;
            pp = (KeyNamePair)model.getValueAt(i, 4);
            if (pp != null) {
                C_OrderLine_ID = pp.getKey();
            }
            int M_InOutLine_ID = 0;
            pp = (KeyNamePair)model.getValueAt(i, 5);
            if (pp != null) {
                M_InOutLine_ID = pp.getKey();
            }
            int precision = 2;
            if (M_Product_ID != 0) {
                MProduct product = MProduct.get(Env.getCtx(), M_Product_ID);
                precision = product.getUOMPrecision();
            }
            QtyEntered = QtyEntered.setScale(precision, 5);
            this.log.fine("Line QtyEntered=" + QtyEntered + ", Product_ID=" + M_Product_ID + ", OrderLine_ID=" + C_OrderLine_ID + ", InOutLine_ID=" + M_InOutLine_ID);
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setM_Product_ID(M_Product_ID, C_UOM_ID);
            invoiceLine.setQty(QtyEntered);
            MOrderLine orderLine = null;
            if (C_OrderLine_ID != 0) {
                orderLine = new MOrderLine(Env.getCtx(), C_OrderLine_ID, null);
            }
            MInOutLine inoutLine = null;
            if (M_InOutLine_ID != 0) {
                inoutLine = new MInOutLine(Env.getCtx(), M_InOutLine_ID, null);
                if (orderLine == null && inoutLine.getC_OrderLine_ID() != 0) {
                    C_OrderLine_ID = inoutLine.getC_OrderLine_ID();
                    orderLine = new MOrderLine(Env.getCtx(), C_OrderLine_ID, null);
                }
            } else {
                MInOutLine[] lines = MInOutLine.getOfOrderLine(Env.getCtx(), C_OrderLine_ID, null, null);
                this.log.fine("Receipt Lines with OrderLine = #" + lines.length);
                if (lines.length > 0) {
                    for (int j = 0; j < lines.length; ++j) {
                        MInOutLine line = lines[j];
                        if (line.getQtyEntered().compareTo(QtyEntered) != 0) continue;
                        inoutLine = line;
                        M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                        break;
                    }
                    if (inoutLine == null) {
                        inoutLine = lines[0];
                        M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                    }
                }
            }
            if (inoutLine != null) {
                invoiceLine.setShipLine(inoutLine);
                if (inoutLine.getQtyEntered().compareTo(inoutLine.getMovementQty()) != 0) {
                    invoiceLine.setQtyInvoiced(QtyEntered.multiply(inoutLine.getMovementQty()).divide(inoutLine.getQtyEntered(), 12, 4));
                }
            } else {
                this.log.fine("No Receipt Line");
            }
            if (orderLine != null) {
                invoiceLine.setOrderLine(orderLine);
                if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                    invoiceLine.setQtyInvoiced(QtyEntered.multiply(orderLine.getQtyOrdered()).divide(orderLine.getQtyEntered(), 12, 4));
                }
            } else {
                this.log.fine("No Order Line");
                invoiceLine.setPrice();
                invoiceLine.setTax();
            }
            if (invoiceLine.save()) continue;
            this.log.log(Level.SEVERE, "Line NOT created #" + i);
        }
        return true;
    }
}

