/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.compiere.apps.AEnv;
import org.compiere.apps.AppsAction;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.grid.VCreateFromInvoice;
import org.compiere.grid.VCreateFromShipment;
import org.compiere.grid.VCreateFromStatement;
import org.compiere.grid.ed.VLocator;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.swing.CButton;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class VCreateFrom
extends CDialog
implements ActionListener,
TableModelListener {
    protected int p_WindowNo;
    protected GridTab p_mTab;
    private boolean p_initOK = false;
    protected MOrder p_order = null;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private static CLogger s_log = CLogger.getCLogger(VCreateFrom.class);
    private CPanel parameterPanel = new CPanel();
    protected CPanel parameterBankPanel = new CPanel();
    private BorderLayout parameterLayout = new BorderLayout();
    private JLabel bankAccountLabel = new JLabel();
    protected CPanel parameterStdPanel = new CPanel();
    private JLabel bPartnerLabel = new JLabel();
    protected VLookup bankAccountField;
    private GridBagLayout parameterStdLayout = new GridBagLayout();
    private GridBagLayout parameterBankLayout = new GridBagLayout();
    protected VLookup bPartnerField;
    private JLabel orderLabel = new JLabel();
    protected JComboBox orderField = new JComboBox();
    protected JLabel invoiceLabel = new JLabel();
    protected JComboBox invoiceField = new JComboBox();
    protected JLabel shipmentLabel = new JLabel();
    protected JComboBox shipmentField = new JComboBox();
    private JScrollPane dataPane = new JScrollPane();
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    protected StatusBar statusBar = new StatusBar();
    protected MiniTable dataTable = new MiniTable();
    protected JLabel locatorLabel = new JLabel();
    protected VLocator locatorField = new VLocator();
    public static final String SELECT_ALL = "Select All";
    public static final String SELECT_ALL_TOOLTIP = "Select all records";

    public static VCreateFrom create(GridTab mTab) {
        int AD_Table_ID = Env.getContextAsInt(Env.getCtx(), mTab.getWindowNo(), "BaseTable_ID");
        VCreateFrom retValue = null;
        if (AD_Table_ID == 392) {
            retValue = new VCreateFromStatement(mTab);
        } else if (AD_Table_ID == 318) {
            retValue = new VCreateFromInvoice(mTab);
        } else if (AD_Table_ID == 319) {
            retValue = new VCreateFromShipment(mTab);
        } else {
            if (AD_Table_ID == 426) {
                return null;
            }
            s_log.info("Unsupported AD_Table_ID=" + AD_Table_ID);
            return null;
        }
        return retValue;
    }

    VCreateFrom(GridTab mTab) {
        super((Frame)Env.getWindow(mTab.getWindowNo()), true);
        this.log.info(mTab.toString());
        this.p_WindowNo = mTab.getWindowNo();
        this.p_mTab = mTab;
        try {
            if (!this.dynInit()) {
                return;
            }
            this.jbInit();
            this.confirmPanel.addActionListener(this);
            this.statusBar.setStatusDB("");
            this.tableChanged(null);
            this.p_initOK = true;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            this.p_initOK = false;
        }
        AEnv.positionCenterWindow(Env.getWindow(this.p_WindowNo), this);
    }

    private void jbInit() throws Exception {
        this.parameterPanel.setLayout(this.parameterLayout);
        this.parameterStdPanel.setLayout(this.parameterStdLayout);
        this.parameterBankPanel.setLayout(this.parameterBankLayout);
        this.bankAccountLabel.setText(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
        this.bPartnerLabel.setText(Msg.getElement(Env.getCtx(), "C_BPartner_ID"));
        this.orderLabel.setText(Msg.getElement(Env.getCtx(), "C_Order_ID", false));
        this.invoiceLabel.setText(Msg.getElement(Env.getCtx(), "C_Invoice_ID", false));
        this.shipmentLabel.setText(Msg.getElement(Env.getCtx(), "M_InOut_ID", false));
        this.locatorLabel.setText(Msg.translate(Env.getCtx(), "M_Locator_ID"));
        this.getContentPane().add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.parameterBankPanel, "North");
        this.parameterBankPanel.add((Component)this.bankAccountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.bankAccountField != null) {
            this.parameterBankPanel.add((Component)this.bankAccountField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        this.parameterPanel.add((Component)this.parameterStdPanel, "Center");
        this.parameterStdPanel.add((Component)this.bPartnerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.bPartnerField != null) {
            this.parameterStdPanel.add((Component)this.bPartnerField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        this.parameterStdPanel.add((Component)this.orderLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterStdPanel.add((Component)this.orderField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterStdPanel.add((Component)this.invoiceLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterStdPanel.add((Component)this.invoiceField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterStdPanel.add((Component)this.shipmentLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterStdPanel.add((Component)this.shipmentField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterStdPanel.add((Component)this.locatorLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterStdPanel.add((Component)this.locatorField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.dataPane, "Center");
        this.dataPane.getViewport().add((Component)this.dataTable, null);
        AppsAction selectAllAction = new AppsAction(Msg.getMsg(Env.getCtx(), SELECT_ALL), KeyStroke.getKeyStroke(65, 8), Msg.getMsg(Env.getCtx(), SELECT_ALL));
        CButton selectAllButton = (CButton)selectAllAction.getButton();
        selectAllButton.setMargin(new Insets(0, 10, 0, 10));
        selectAllButton.setDefaultCapable(true);
        selectAllButton.addActionListener(this);
        selectAllButton.setToolTipText(Msg.getMsg(Env.getCtx(), SELECT_ALL_TOOLTIP));
        this.confirmPanel.addButton(selectAllButton);
        this.getContentPane().add((Component)this.southPanel, "South");
        this.southPanel.setLayout(this.southLayout);
        this.southPanel.add((Component)this.confirmPanel, "Center");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.southPanel.setLayout(this.southLayout);
        this.southPanel.add((Component)this.confirmPanel, "Center");
        this.southPanel.add((Component)this.statusBar, "South");
    }

    public boolean isInitOK() {
        return this.p_initOK;
    }

    abstract boolean dynInit() throws Exception;

    abstract void initBPDetails(int var1);

    abstract void info();

    abstract boolean save();

    public void actionPerformed(ActionEvent e) {
        this.log.config("Action=" + e.getActionCommand());
        if (e.getActionCommand().equals("Ok")) {
            if (this.save()) {
                this.dispose();
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals(SELECT_ALL)) {
            TableModel model = this.dataTable.getModel();
            int rows = model.getRowCount();
            for (int i = 0; i < rows; ++i) {
                model.setValueAt(new Boolean(true), i, 0);
            }
            this.info();
        }
    }

    public void tableChanged(TableModelEvent e) {
        int type = -1;
        if (e != null && (type = e.getType()) != 0) {
            return;
        }
        this.log.config("Type=" + type);
        this.info();
    }

    protected void initBPartner(boolean forInvoice) throws Exception {
        int AD_Column_ID = 3499;
        MLookup lookup = MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, AD_Column_ID, 30);
        this.bPartnerField = new VLookup("C_BPartner_ID", true, false, true, lookup);
        int C_BPartner_ID = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "C_BPartner_ID");
        this.bPartnerField.setValue(new Integer(C_BPartner_ID));
        this.initBPartnerOIS(C_BPartner_ID, forInvoice);
    }

    protected void initBPartnerOIS(int C_BPartner_ID, boolean forInvoice) {
        this.log.config("C_BPartner_ID=" + C_BPartner_ID);
        KeyNamePair pp = new KeyNamePair(0, "");
        this.orderField.removeActionListener(this);
        this.orderField.removeAllItems();
        this.orderField.addItem(pp);
        StringBuffer display = new StringBuffer("o.DocumentNo||' - ' ||").append(DB.TO_CHAR("o.DateOrdered", 15, Env.getAD_Language(Env.getCtx()))).append("||' - '||").append(DB.TO_CHAR("o.GrandTotal", 12, Env.getAD_Language(Env.getCtx())));
        String column = "m.M_InOutLine_ID";
        if (forInvoice) {
            column = "m.C_InvoiceLine_ID";
        }
        StringBuffer sql = new StringBuffer("SELECT o.C_Order_ID,").append(display).append(" FROM C_Order o WHERE o.C_BPartner_ID=? AND o.IsSOTrx='N' AND o.DocStatus IN ('CL','CO') AND o.C_Order_ID IN (SELECT ol.C_Order_ID FROM C_OrderLine ol LEFT OUTER JOIN M_MatchPO m ON (ol.C_OrderLine_ID=m.C_OrderLine_ID) GROUP BY ol.C_Order_ID,ol.C_OrderLine_ID, ol.QtyOrdered,").append(column).append(" HAVING (ol.QtyOrdered <> SUM(m.Qty) AND ").append(column).append(" IS NOT NULL) OR ").append(column).append(" IS NULL) ORDER BY o.DateOrdered");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                this.orderField.addItem(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        this.orderField.setSelectedIndex(0);
        this.orderField.addActionListener(this);
        this.initBPDetails(C_BPartner_ID);
    }

    protected void loadOrder(int C_Order_ID, boolean forInvoice) {
        this.log.config("C_Order_ID=" + C_Order_ID);
        this.p_order = new MOrder(Env.getCtx(), C_Order_ID, null);
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("SELECT l.QtyOrdered-SUM(COALESCE(m.Qty,0)),CASE WHEN l.QtyOrdered=0 THEN 0 ELSE l.QtyEntered/l.QtyOrdered END, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name), COALESCE(l.M_Product_ID,0),COALESCE(p.Name,c.Name), l.C_OrderLine_ID,l.Line FROM C_OrderLine l LEFT OUTER JOIN M_MatchPO m ON (l.C_OrderLine_ID=m.C_OrderLine_ID AND ");
        sql.append(forInvoice ? "m.C_InvoiceLine_ID" : "m.M_InOutLine_ID");
        sql.append(" IS NOT NULL)").append(" LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_Charge c ON (l.C_Charge_ID=c.C_Charge_ID)");
        if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
            sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
        } else {
            sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language(Env.getCtx())).append("')");
        }
        sql.append(" WHERE l.C_Order_ID=? GROUP BY l.QtyOrdered,CASE WHEN l.QtyOrdered=0 THEN 0 ELSE l.QtyEntered/l.QtyOrdered END, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name), l.M_Product_ID,COALESCE(p.Name,c.Name), l.Line,l.C_OrderLine_ID ORDER BY l.Line");
        this.log.finer(sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, C_Order_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>();
                line.add(new Boolean(false));
                BigDecimal qtyOrdered = rs.getBigDecimal(1);
                BigDecimal multiplier = rs.getBigDecimal(2);
                BigDecimal qtyEntered = qtyOrdered.multiply(multiplier);
                line.add(new Double(qtyEntered.doubleValue()));
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                line.add(pp);
                pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                line.add(pp);
                pp = new KeyNamePair(rs.getInt(7), rs.getString(8));
                line.add(pp);
                line.add(null);
                line.add(null);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        this.loadTableOIS(data);
    }

    protected void loadTableOIS(Vector data) {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Quantity"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_UOM_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "M_Product_ID"));
        columnNames.add(Msg.getElement(Env.getCtx(), "C_Order_ID", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "M_InOut_ID", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "C_Invoice_ID", false));
        this.dataTable.getModel().removeTableModelListener(this);
        DefaultTableModel model = new DefaultTableModel(data, columnNames);
        model.addTableModelListener(this);
        this.dataTable.setModel(model);
        this.dataTable.setColumnClass(0, Boolean.class, false);
        this.dataTable.setColumnClass(1, Double.class, true);
        this.dataTable.setColumnClass(2, String.class, true);
        this.dataTable.setColumnClass(3, String.class, true);
        this.dataTable.setColumnClass(4, String.class, true);
        this.dataTable.setColumnClass(5, String.class, true);
        this.dataTable.setColumnClass(6, String.class, true);
        this.dataTable.autoSize();
    }
}

