/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.compiere.apps.ADialog;
import org.compiere.apps.APanel;
import org.compiere.apps.AppsAction;
import org.compiere.grid.VPanel;
import org.compiere.grid.VTable;
import org.compiere.grid.ed.TableCellNone;
import org.compiere.grid.ed.VCellEditor;
import org.compiere.grid.ed.VCellRenderer;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.grid.ed.VHeaderRenderer;
import org.compiere.grid.ed.VRowIDEditor;
import org.compiere.grid.ed.VRowIDRenderer;
import org.compiere.grid.tree.VTreePanel;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.GridWindow;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;

public class GridController
extends CPanel
implements DataStatusListener,
ListSelectionListener,
Evaluatee,
VetoableChangeListener,
PropertyChangeListener,
MouseListener {
    private static CLogger log = CLogger.getCLogger(GridController.class);
    private BorderLayout mainLayout = new BorderLayout();
    private JSplitPane splitPane = new JSplitPane();
    private CPanel graphPanel = new CPanel();
    private BorderLayout graphLayout = new BorderLayout();
    private CPanel cardPanel = new CPanel();
    private CardLayout cardLayout = new CardLayout();
    private JSplitPane srPane = new JSplitPane();
    private JScrollPane vPane = new JScrollPane();
    private GridController vIncludedGC = null;
    private CScrollPane mrPane = new CScrollPane();
    private CPanel xPanel = new CPanel();
    private FlowLayout xLayout = new FlowLayout();
    private VTable vTable = new VTable();
    private VPanel vPanel = new VPanel();
    private GridTab m_mTab = null;
    private int m_WindowNo;
    private boolean m_onlyMultiRow = false;
    private boolean m_singleRow = true;
    private boolean m_vetoActive = false;
    private VTreePanel m_tree;

    public GridController() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    public String toString() {
        return "GridController for " + this.m_mTab;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setOpaque(false);
        this.graphPanel.setLayout(this.graphLayout);
        this.splitPane.add((Component)this.graphPanel, "left");
        this.splitPane.add((Component)this.cardPanel, "right");
        this.splitPane.setBorder(null);
        this.splitPane.setName("gc_splitPane");
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.add((Component)this.srPane, "srPane");
        this.cardPanel.add((Component)this.mrPane, "mrPane");
        this.cardPanel.setBorder(null);
        this.cardPanel.setName("gc_cardPanel");
        this.srPane.setBorder(null);
        this.srPane.setName("gc_srPane");
        this.srPane.setOrientation(0);
        this.srPane.add((Component)this.vPane, "top");
        this.srPane.setTopComponent(this.vPane);
        this.srPane.setBottomComponent(null);
        this.vPane.getViewport().add((Component)this.xPanel, null);
        this.xPanel.add(this.vPanel);
        this.vPane.setBorder(null);
        this.xPanel.setLayout(this.xLayout);
        this.xPanel.setName("gc_xPanel");
        this.xLayout.setAlignment(0);
        this.xLayout.setHgap(0);
        this.xLayout.setVgap(0);
        this.mrPane.setBorder(null);
        this.mrPane.getViewport().add((Component)this.vTable, null);
        this.mrPane.setName("gc_mrPane");
        this.graphPanel.setBorder(null);
        this.graphPanel.setName("gc_graphPanel");
        this.srPane.setDividerLocation(200);
    }

    public void dispose() {
        log.config("(" + this.m_mTab.toString() + ")");
        this.stopEditor(false);
        if (this.m_mTab.needSave(true, false)) {
            this.m_mTab.dataIgnore();
        }
        this.vIncludedGC = null;
        this.m_mTab.getTableModel().removeDataStatusListener(this);
        this.m_mTab.getTableModel().removeVetoableChangeListener(this);
        this.vTable.getSelectionModel().removeListSelectionListener(this);
        this.m_mTab.removePropertyChangeListener(this.vTable);
        Component[] comp = this.vPanel.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof VEditor)) continue;
            VEditor vEditor = (VEditor)((Object)comp[i]);
            vEditor.removeVetoableChangeListener(this);
            String columnName = comp[i].getName();
            GridField mField = this.m_mTab.getField(columnName);
            if (mField != null) {
                mField.removePropertyChangeListener(vEditor);
            }
            vEditor.dispose();
        }
        this.vTable.removeAll();
        this.vTable.setModel(new DefaultTableModel());
        this.vTable = null;
        this.vPanel.removeAll();
        this.vPanel = null;
        this.srPane.removeAll();
        this.srPane = null;
        this.splitPane.removeAll();
        this.splitPane = null;
        this.m_mTab = null;
        this.m_tree = null;
        this.removeAll();
    }

    public boolean initGrid(GridTab mTab, boolean onlyMultiRow, int WindowNo, APanel aPanel, GridWindow mWindow) {
        log.config("(" + mTab.toString() + ")");
        this.m_mTab = mTab;
        this.m_WindowNo = WindowNo;
        this.m_onlyMultiRow = onlyMultiRow;
        this.setName("GC-" + mTab);
        this.vTable.setModel(this.m_mTab.getTableModel());
        int size = this.setupVTable(aPanel, this.m_mTab, this.vTable);
        if (!this.m_onlyMultiRow) {
            GridField mField;
            int i;
            for (i = 0; i < size; ++i) {
                mField = this.m_mTab.getField(i);
                if (!mField.isDisplayed()) continue;
                this.vPanel.setMnemonic(mField);
            }
            for (i = 0; i < size; ++i) {
                mField = this.m_mTab.getField(i);
                if (!mField.isDisplayed()) continue;
                VEditor vEditor = VEditorFactory.getEditor(this.m_mTab, mField, false);
                if (vEditor == null) {
                    log.warning("Editor not created for " + mField.getColumnName());
                    continue;
                }
                mField.addPropertyChangeListener(vEditor);
                vEditor.addVetoableChangeListener(this);
                this.vPanel.addField(vEditor, mField);
                if (mField.getDisplayType() != 28 || aPanel == null) continue;
                ((JButton)((Object)vEditor)).addActionListener(aPanel);
            }
            this.srPane.setResizeWeight(1.0);
            this.srPane.setDividerSize(0);
            this.srPane.setDividerLocation(9999);
            this.mrPane.setPreferredSize(this.vPanel.getPreferredSize());
        }
        int AD_Tree_ID = 0;
        if (this.m_mTab.isTreeTab()) {
            AD_Tree_ID = MTree.getDefaultAD_Tree_ID(Env.getAD_Client_ID(Env.getCtx()), this.m_mTab.getKeyColumnName());
        }
        if (this.m_mTab.isTreeTab() && AD_Tree_ID != 0) {
            this.m_tree = new VTreePanel(this.m_WindowNo, false, true);
            if (this.m_mTab.getTabNo() == 0) {
                this.m_tree.initTree(AD_Tree_ID);
            }
            this.m_tree.addPropertyChangeListener("NodeSelected", this);
            this.graphPanel.add((Component)this.m_tree, "Center");
            this.splitPane.setDividerLocation(250);
        } else {
            this.graphPanel.setPreferredSize(new Dimension(0, 0));
            this.splitPane.setDividerSize(0);
            this.splitPane.setDividerLocation(0);
        }
        this.m_mTab.addDataStatusListener(this);
        this.m_mTab.getTableModel().addVetoableChangeListener(this);
        this.vTable.getSelectionModel().addListSelectionListener(this);
        this.m_mTab.addPropertyChangeListener(this.vTable);
        this.vTable.autoSize(true);
        this.setTabLevel(this.m_mTab.getTabLevel());
        if (onlyMultiRow || !this.m_mTab.isSingleRow()) {
            this.switchMultiRow();
        } else {
            this.switchSingleRow();
        }
        return true;
    }

    public boolean includeTab(GridController gc) {
        GridTab imcludedMTab = gc.getMTab();
        if (this.m_mTab.getIncluded_Tab_ID() != imcludedMTab.getAD_Tab_ID()) {
            return false;
        }
        this.vIncludedGC = gc;
        this.vIncludedGC.switchMultiRow();
        Dimension size = this.getPreferredSize();
        this.srPane.setResizeWeight(0.75);
        this.srPane.add((Component)this.vIncludedGC, "bottom");
        this.srPane.setBottomComponent(this.vIncludedGC);
        this.srPane.setDividerSize(5);
        int height = 150;
        this.vIncludedGC.setPreferredSize(new Dimension(600, height));
        this.setPreferredSize(new Dimension(size.width, size.height + height));
        this.srPane.setDividerLocation(size.height);
        imcludedMTab.setIncluded(true);
        imcludedMTab.query(false, 0, 0);
        JRootPane rt = SwingUtilities.getRootPane(this);
        if (rt == null) {
            System.out.println("Root pane null");
        } else {
            System.out.println("Root=" + rt);
            rt.addMouseListener(this.vIncludedGC);
            Component gp = rt.getGlassPane();
            if (gp == null) {
                System.out.println("No Glass Pane");
            } else {
                System.out.println("Glass=" + gp);
                gp.addMouseListener(this.vIncludedGC);
            }
        }
        this.vIncludedGC.addMouseListener(this.vIncludedGC);
        this.vIncludedGC.enableEvents(32784L);
        return true;
    }

    public String getTitle() {
        return this.m_mTab.getName();
    }

    private int setupVTable(APanel aPanel, GridTab mTab, VTable table2) {
        TableColumnModel tcm;
        if (!mTab.isDisplayed()) {
            return 0;
        }
        int size = mTab.getFieldCount();
        if (size != (tcm = table2.getColumnModel()).getColumnCount()) {
            throw new IllegalStateException("TableColumn Size <> TableModel");
        }
        for (int i = 0; i < size; ++i) {
            GridField mField = mTab.getField(i);
            TableColumn tc = tcm.getColumn(i);
            tc.setMinWidth(30);
            if (mField.getColumnName().equals(tc.getIdentifier().toString())) {
                if (mField.getDisplayType() == 26) {
                    tc.setCellRenderer(new VRowIDRenderer(false));
                    tc.setCellEditor(new VRowIDEditor(false));
                    tc.setHeaderValue("");
                    tc.setMaxWidth(2);
                    continue;
                }
                if (mField.isDisplayed()) {
                    VEditor button;
                    tc.setCellRenderer(new VCellRenderer(mField));
                    VCellEditor ce = new VCellEditor(mField);
                    tc.setCellEditor(ce);
                    tc.setHeaderValue(mField.getHeader());
                    tc.setPreferredWidth(Math.max(mField.getDisplayLength(), 30));
                    tc.setHeaderRenderer(new VHeaderRenderer(mField.getDisplayType()));
                    if (mField.getDisplayType() != 28 || (button = ce.getEditor()) == null || aPanel == null) continue;
                    ((JButton)((Object)button)).addActionListener(aPanel);
                    continue;
                }
                TableCellNone tcn = new TableCellNone(mField.getColumnName());
                tc.setCellRenderer(tcn);
                tc.setCellEditor(tcn);
                tc.setHeaderValue(null);
                tc.setMinWidth(0);
                tc.setMaxWidth(0);
                tc.setPreferredWidth(0);
                continue;
            }
            log.log(Level.SEVERE, "TableColumn " + tc.getIdentifier() + " <> MField " + mField.getColumnName() + mField.getHeader());
        }
        return size;
    }

    public void activate() {
        if (this.m_mTab.isTreeTab() && this.m_mTab.getTabNo() != 0) {
            String keyColumnName = this.m_mTab.getKeyColumnName();
            String treeName = "AD_Tree_ID";
            if (keyColumnName.startsWith("CM")) {
                if (keyColumnName.equals("CM_Container_ID")) {
                    treeName = "AD_TreeCMC_ID";
                } else if (keyColumnName.equals("CM_CStage_ID")) {
                    treeName = "AD_TreeCMS_ID";
                } else if (keyColumnName.equals("CM_Template_ID")) {
                    treeName = "AD_TreeCMT_ID";
                } else if (keyColumnName.equals("CM_Media_ID")) {
                    treeName = "AD_TreeCMM_ID";
                }
            }
            int AD_Tree_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, treeName);
            log.config(keyColumnName + " -> " + treeName + " = " + AD_Tree_ID);
            if (AD_Tree_ID == 0) {
                AD_Tree_ID = MTree.getDefaultAD_Tree_ID(Env.getAD_Client_ID(Env.getCtx()), this.m_mTab.getKeyColumnName());
            }
            if (this.m_tree != null) {
                this.m_tree.initTree(AD_Tree_ID);
            }
        }
    }

    public void registerESCAction(AppsAction aIgnore) {
        int c = 1;
        this.vTable.getInputMap(c).put(KeyStroke.getKeyStroke(27, 0), aIgnore.getName());
        this.vTable.getActionMap().put(aIgnore.getName(), aIgnore);
    }

    public void query(boolean onlyCurrentRows, int onlyCurrentDays, int maxRows) {
        this.m_mTab.query(onlyCurrentRows, onlyCurrentDays, maxRows);
        if (!this.isSingleRow()) {
            this.vTable.autoSize(true);
        }
    }

    public boolean isNeedToSaveParent() {
        return this.m_mTab.isNeedToSaveParent();
    }

    public void switchRowPresentation() {
        this.stopEditor(true);
        if (this.m_singleRow) {
            this.switchMultiRow();
        } else {
            this.switchSingleRow();
        }
    }

    public void switchSingleRow() {
        if (this.m_onlyMultiRow) {
            return;
        }
        this.cardLayout.first(this.cardPanel);
        this.m_singleRow = true;
        this.dynamicDisplay(0);
    }

    public void switchMultiRow() {
        this.cardLayout.last(this.cardPanel);
        this.m_singleRow = false;
        this.vTable.autoSize(true);
    }

    public boolean isSingleRow() {
        return this.m_singleRow;
    }

    public synchronized void removeDataStatusListener(DataStatusListener l) {
        this.m_mTab.removeDataStatusListener(l);
    }

    public synchronized void addDataStatusListener(DataStatusListener l) {
        this.m_mTab.addDataStatusListener(l);
    }

    public void dataStatusChanged(DataStatusEvent e) {
        String msg;
        int col = e.getChangedColumn();
        log.config("(" + this.m_mTab + ") Col=" + col + ": " + e.toString());
        GridField mField = this.m_mTab.getField(col);
        if (mField != null && (mField.getCallout().length() > 0 || this.m_mTab.hasDependants(mField.getColumnName())) && (msg = this.m_mTab.processFieldChange(mField)).length() > 0) {
            ADialog.error(this.m_WindowNo, this, msg);
        }
        this.dynamicDisplay(col);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.m_mTab.getRowCount() == 0) {
            return;
        }
        int rowTable = this.vTable.getSelectedRow();
        int rowCurrent = this.m_mTab.getCurrentRow();
        log.config("(" + this.m_mTab.toString() + ") Row in Table=" + rowTable + ", in Model=" + rowCurrent);
        if (rowTable == -1) {
            if (rowCurrent >= 0) {
                this.vTable.setRowSelectionInterval(rowCurrent, rowCurrent);
                return;
            }
        } else {
            if (rowTable != rowCurrent) {
                this.m_mTab.navigate(rowTable);
            }
            this.dynamicDisplay(0);
        }
        if (this.m_tree != null) {
            this.m_tree.setSelectedNode(this.m_mTab.getRecord_ID());
        }
        if (this.vIncludedGC != null) {
            this.vIncludedGC.getMTab().query(false, 0, 0);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e == null) {
            return;
        }
        Object value = e.getNewValue();
        if (value == null) {
            return;
        }
        log.config(e.getPropertyName() + "=" + value + " - " + value.getClass().toString());
        if (!(value instanceof MTreeNode)) {
            return;
        }
        int nodeID = ((MTreeNode)value).getNode_ID();
        if (nodeID == 0) {
            return;
        }
        int size = this.m_mTab.getRowCount();
        int row = -1;
        for (int i = 0; i < size; ++i) {
            if (this.m_mTab.getKeyID(i) != nodeID) continue;
            row = i;
            break;
        }
        if (row == -1) {
            log.log(Level.SEVERE, "Tab does not have ID with Node_ID=" + nodeID);
            return;
        }
        this.m_mTab.navigate(row);
    }

    public void dynamicDisplay(int col) {
        if (!this.isSingleRow() || this.m_onlyMultiRow) {
            return;
        }
        if (!this.m_mTab.isOpen()) {
            return;
        }
        if (col != 0) {
            GridField changedField = this.m_mTab.getField(col);
            String columnName = changedField.getColumnName();
            ArrayList<GridField> dependants = this.m_mTab.getDependantFields(columnName);
            log.config("(" + this.m_mTab.toString() + ") " + columnName + " - Dependents=" + dependants.size());
            if (dependants.size() == 0 && changedField.getCallout().length() > 0) {
                Component[] comp = this.vPanel.getComponents();
                for (int i = 0; i < comp.length; ++i) {
                    boolean noValue;
                    if (!columnName.equals(comp[i].getName()) || !(comp[i] instanceof VEditor)) continue;
                    VEditor ve = (VEditor)((Object)comp[i]);
                    boolean manMissing = false;
                    boolean bl = noValue = changedField.getValue() == null || changedField.getValue().toString().length() == 0;
                    if (noValue && changedField.isEditable(true) && changedField.isMandatory(true)) {
                        manMissing = true;
                    }
                    ve.setBackground(manMissing || changedField.isError());
                    break;
                }
                return;
            }
        }
        boolean noData = this.m_mTab.getRowCount() == 0;
        log.config(this.m_mTab.toString() + " - Rows=" + this.m_mTab.getRowCount());
        Component[] comps = this.vPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            GridField mField;
            Component comp = comps[i];
            String columnName = comp.getName();
            if (columnName == null || (mField = this.m_mTab.getField(columnName)) == null) continue;
            if (mField.isDisplayed(true)) {
                if (!comp.isVisible()) {
                    comp.setVisible(true);
                }
                if (!(comp instanceof VEditor)) continue;
                VEditor ve = (VEditor)((Object)comp);
                if (noData) {
                    ve.setReadWrite(false);
                    continue;
                }
                boolean rw = mField.isEditable(true);
                ve.setReadWrite(rw);
                boolean manMissing = false;
                if (rw && mField.getValue() == null && mField.isMandatory(true)) {
                    manMissing = true;
                }
                ve.setBackground(manMissing || mField.isError());
                continue;
            }
            if (!comp.isVisible()) continue;
            comp.setVisible(false);
        }
        log.config(this.m_mTab.toString() + " - fini - " + (col == 0 ? "complete" : "seletive"));
    }

    public void rowChanged(boolean save, int keyID) {
        if (this.m_tree == null || keyID <= 0) {
            return;
        }
        String name = (String)this.m_mTab.getValue("Name");
        String description = (String)this.m_mTab.getValue("Description");
        Boolean IsSummary = (Boolean)this.m_mTab.getValue("IsSummary");
        boolean summary = IsSummary != null && IsSummary != false;
        String imageIndicator = (String)this.m_mTab.getValue("Action");
        this.m_tree.nodeChanged(save, keyID, name, description, summary, imageIndicator);
    }

    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (this.m_mTab.isProcessed()) {
            Object source = e.getSource();
            if (source instanceof VEditor) {
                if (!((VEditor)source).isReadWrite()) {
                    log.config("(" + this.m_mTab.toString() + ") " + e.getPropertyName());
                    return;
                }
            } else {
                log.config("(" + this.m_mTab.toString() + ") " + e.getPropertyName());
                return;
            }
        }
        log.config("(" + this.m_mTab.toString() + ") " + e.getPropertyName() + "=" + e.getNewValue() + " (" + e.getOldValue() + ") " + (e.getOldValue() == null ? "" : e.getOldValue().getClass().getName()));
        if (e.getPropertyName().equals("MTable-RowSave")) {
            if (this.m_vetoActive) {
                this.m_vetoActive = false;
                return;
            }
            if (!(Env.isAutoCommit(Env.getCtx(), this.m_WindowNo) && this.m_mTab.getCommitWarning().length() <= 0 || ADialog.ask(this.m_WindowNo, this, "SaveChanges?", this.m_mTab.getCommitWarning()))) {
                this.m_vetoActive = true;
                throw new PropertyVetoException("UserDeniedSave", e);
            }
            return;
        }
        GridTable mTable = this.m_mTab.getTableModel();
        int row = this.m_mTab.getCurrentRow();
        int col = mTable.findColumn(e.getPropertyName());
        if (e.getNewValue() == null && e.getOldValue() != null && e.getOldValue().toString().length() > 0) {
            mTable.setChanged(true);
        } else {
            GridField mField;
            mTable.setValueAt(e.getNewValue(), row, col);
            if (e.getPropertyName().equals("S_ResourceAssignment_ID") && (mField = this.m_mTab.getField(col)) != null && mField.getCallout().length() > 0) {
                this.m_mTab.processFieldChange(mField);
            }
        }
    }

    public GridTab getMTab() {
        return this.m_mTab;
    }

    public String getDisplayLogic() {
        return this.m_mTab.getDisplayLogic();
    }

    public VTable getTable() {
        return this.vTable;
    }

    public void setMnemonics(boolean set) {
        if (this.vPanel != null) {
            this.vPanel.setMnemonics(set);
        }
    }

    public void stopEditor(boolean saveValue) {
        log.config("(" + this.m_mTab.toString() + ") TableEditing=" + this.vTable.isEditing());
        this.vTable.stopEditor(saveValue);
        if (this.m_singleRow) {
            this.vPanel.transferFocus();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (CLogMgt.isLevelFinest()) {
            log.finest("" + this + " - " + e);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (CLogMgt.isLevelFinest()) {
            log.finest("" + this + " - " + e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (CLogMgt.isLevelFinest()) {
            log.finest("" + this + " - " + e);
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (CLogMgt.isLevelFinest()) {
            log.finest("" + this + " - " + e);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (CLogMgt.isLevelFinest()) {
            log.finest("" + this + " - " + e);
        }
    }

    public String get_ValueAsString(String variableName) {
        return Env.getContext(Env.getCtx(), this.m_WindowNo, variableName);
    }
}

