/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.dbPort;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.compiere.dbPort.ConvertMap_PostgreSQL;
import org.compiere.dbPort.Convert_SQL92;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Convert_PostgreSQL
extends Convert_SQL92 {
    public static final int REGEX_FLAGS = 34;
    private TreeMap m_map = ConvertMap_PostgreSQL.getConvertMap();
    private static CLogger log = CLogger.getCLogger(Convert_PostgreSQL.class);

    @Override
    public boolean isOracle() {
        return false;
    }

    @Override
    protected ArrayList<String> convertStatement(String sqlStatement) {
        ArrayList<String> result = new ArrayList<String>();
        String statement = this.removeComments(sqlStatement);
        String cmpString = statement.toUpperCase();
        boolean isCreate = cmpString.startsWith("CREATE ");
        if (isCreate && cmpString.indexOf(" FUNCTION ") != -1) {
            result.addAll(this.convertFunction(statement));
        } else if (isCreate && cmpString.indexOf(" TRIGGER ") != -1) {
            result.addAll(this.convertTrigger(statement));
        } else if (isCreate && cmpString.indexOf(" PROCEDURE ") != -1) {
            result.addAll(this.convertProcedure(statement));
        } else if (isCreate && cmpString.indexOf(" VIEW ") != -1) {
            result.addAll(this.convertView(statement));
        } else if (cmpString.indexOf("ALTER TABLE") != -1) {
            result.add(this.convertDDL(statement));
        } else if (cmpString.indexOf("ROWNUM") != -1) {
            result.add(this.convertRowNum(this.convertAlias(this.converSimpleStatement(statement))));
        } else if (cmpString.indexOf("DELETE ") != -1 && cmpString.indexOf("DELETE FROM") == -1) {
            cmpString = statement = this.convertDelete(statement);
            result.add(this.converSimpleStatement(this.convertAlias(cmpString)));
        } else if (cmpString.indexOf("DELETE FROM") != -1) {
            result.add(this.converSimpleStatement(this.convertAlias(statement)));
        } else if (cmpString.indexOf("UPDATE") != -1) {
            result.add(this.converSimpleStatement(this.convertUpdate(this.convertAlias(statement))));
        } else {
            result.add(this.converSimpleStatement(this.convertAlias(statement)));
        }
        return result;
    }

    private String converSimpleStatement(String sqlStatement) {
        if (sqlStatement.toUpperCase().indexOf("EXCEPTION WHEN") != -1) {
            String error = "Exception clause needs to be converted: " + sqlStatement;
            log.info(error);
            this.m_conversionError = error;
            return sqlStatement;
        }
        String retValue = sqlStatement;
        Iterator iter = this.m_map.keySet().iterator();
        while (iter.hasNext()) {
            Vector<String> retVars = new Vector<String>();
            Pattern p2 = Pattern.compile("'[[\\w]*[-:,\\(\\)]*[ ]*]*'");
            Matcher m = p2.matcher(retValue);
            while (m.find()) {
                retVars.addElement(new String(retValue.substring(m.start(), m.end())));
            }
            retVars.addElement(new String(m.replaceAll("<-->")));
            String regex = (String)iter.next();
            String replacement = (String)this.m_map.get(regex);
            try {
                p2 = Pattern.compile(regex, 34);
                m = p2.matcher((String)retVars.get(retVars.size() - 1));
                retValue = m.replaceAll(replacement);
                p2 = Pattern.compile("<-->", 34);
                m = p2.matcher(retValue);
                for (int cont = 0; cont < retVars.size() - 1; ++cont) {
                    retValue = m.replaceFirst((String)retVars.get(cont));
                    m = p2.matcher(retValue);
                }
            }
            catch (Exception e) {
                String error = "Error expression: " + regex + " - " + e;
                log.info(error);
                this.m_conversionError = error;
            }
        }
        return this.convertComplexStatement(retValue);
    }

    protected String removeComments(String statement) {
        String clean = statement.trim();
        Matcher m = Pattern.compile("\\/\\*ORACLE>.*<ORACLE\\*\\/", 32).matcher(clean);
        clean = m.replaceAll("");
        m = Pattern.compile("\\/\\*POSTGRESQL>").matcher(clean);
        clean = m.replaceAll("");
        m = Pattern.compile("<POSTGRESQL\\*\\/").matcher(clean);
        clean = m.replaceAll("");
        m = Pattern.compile("\\/\\*.*\\*\\/", 32).matcher(clean);
        clean = m.replaceAll("");
        m = Pattern.compile("\\s+").matcher(clean);
        clean = m.replaceAll(" ");
        clean = clean.trim();
        return clean;
    }

    private ArrayList<String> convertFunction(String sqlStatement) {
        ArrayList<String> result = new ArrayList<String>();
        String stmt = this.converSimpleStatement(sqlStatement);
        stmt = Pattern.compile("'").matcher(stmt).replaceAll("''");
        int orReplacePos = stmt.toUpperCase().indexOf(" OR REPLACE ");
        if (orReplacePos != -1) {
            stmt = "CREATE" + stmt.substring(orReplacePos + 11);
        }
        String match = "(\\([^\\)]*\\))|(\\bRETURN \\w+ (AS)|(IS))|(;)|(\\bBEGIN\\b)|(\\bTHEN\\b)|(\\bELSE\\b)|(\\bELSIF\\b)";
        Matcher m = Pattern.compile(match, 2).matcher(stmt);
        StringBuffer sb = new StringBuffer();
        m.find();
        m.appendReplacement(sb, "");
        String name = sb.substring(6).trim();
        StringBuffer signature = new StringBuffer();
        String group = m.group().trim();
        StringBuffer alias = new StringBuffer();
        if (group.startsWith("(") && group.endsWith(")")) {
            if (group.toUpperCase().indexOf(" DEFAULT ") != -1) {
                String error = "DEFAULT in Parameter not supported";
                log.info(error);
                this.m_conversionError = error;
                return result;
            }
            signature.append("(");
            if (group.length() > 2) {
                group = group.substring(1, group.length() - 1);
                String[] parameters = group.split(",");
                for (int i = 0; i < parameters.length; ++i) {
                    if (i != 0) {
                        signature.append(", ");
                    }
                    String p2 = parameters[i].trim();
                    alias.append(p2.substring(0, p2.indexOf(" "))).append(" ALIAS FOR $").append(i + 1).append(";\n");
                    signature.append(p2.substring(p2.lastIndexOf(" ") + 1));
                }
            }
        } else {
            String error = "Missing Parameter ()";
            log.info(error);
            this.m_conversionError = error;
            return result;
        }
        signature.append(")");
        sb.append(signature);
        sb.append("\n");
        if (orReplacePos != -1) {
            String drop = "DROP " + name + signature.toString();
            result.add(drop);
        }
        m.find();
        group = m.group();
        m.appendReplacement(sb, "");
        if (group.startsWith("RETURN")) {
            sb.append("RETURNS").append(group.substring(group.indexOf(" ")));
        }
        sb.append(" '\nDECLARE\n").append(alias);
        while (m.find()) {
            String group2 = m.group();
            if (group2.indexOf(36) != -1) {
                group2 = Util.replace(group2, "$", "\\$");
            }
            m.appendReplacement(sb, group2);
            sb.append("\n");
        }
        m.appendTail(sb);
        sb.append("' LANGUAGE 'plpgsql';");
        result.add(sb.toString());
        return result;
    }

    private ArrayList<String> convertProcedure(String sqlStatement) {
        ArrayList<String> result = new ArrayList<String>();
        String stmt = this.converSimpleStatement(sqlStatement);
        stmt = Pattern.compile("'").matcher(stmt).replaceAll("''");
        int orReplacePos = stmt.toUpperCase().indexOf(" OR REPLACE ");
        if (orReplacePos != -1) {
            stmt = "CREATE" + stmt.substring(orReplacePos + 11);
        }
        String match = "(\\([^\\)]*\\))|(\\bRETURN \\w+ (AS)|(IS))|(;)|(\\bBEGIN\\b)|(\\bTHEN\\b)|(\\bELSE\\b)|(\\bELSIF\\b)";
        Matcher m = Pattern.compile(match, 2).matcher(stmt);
        StringBuffer sb = new StringBuffer();
        m.find();
        m.appendReplacement(sb, "");
        String name = sb.substring(6).trim();
        StringBuffer signature = new StringBuffer();
        String group = m.group().trim();
        StringBuffer alias = new StringBuffer();
        if (group.startsWith("(") && group.endsWith(")")) {
            if (group.toUpperCase().indexOf(" DEFAULT ") != -1) {
                String error = "DEFAULT in Parameter not supported";
                log.info(error);
                this.m_conversionError = error;
                return result;
            }
            signature.append("(");
            if (group.length() > 2) {
                group = group.substring(1, group.length() - 1);
                String[] parameters = group.split(",");
                for (int i = 0; i < parameters.length; ++i) {
                    if (i != 0) {
                        signature.append(", ");
                    }
                    String p2 = parameters[i].trim();
                    alias.append(p2.substring(0, p2.indexOf(" "))).append(" ALIAS FOR $").append(i + 1).append(";\n");
                    signature.append(p2.substring(p2.lastIndexOf(" ") + 1));
                }
            }
        } else {
            String error = "Missing Parameter ()";
            log.info(error);
            this.m_conversionError = error;
            return result;
        }
        signature.append(")");
        sb.append(signature);
        sb.append("\n");
        if (orReplacePos != -1) {
            String drop = "DROP " + name + signature.toString();
            result.add(drop);
        }
        m.find();
        group = m.group();
        m.appendReplacement(sb, "");
        if (group.startsWith("RETURN")) {
            sb.append("RETURNS").append(group.substring(group.indexOf(" ")));
        }
        sb.append(" '\nDECLARE\n").append(alias);
        while (m.find()) {
            String group2 = m.group();
            if (group2.indexOf(36) != -1) {
                group2 = Util.replace(group2, "$", "\\$");
            }
            m.appendReplacement(sb, group2);
            sb.append("\n");
        }
        m.appendTail(sb);
        sb.append("' LANGUAGE 'plpgsql';");
        result.add(sb.toString());
        return result;
    }

    private ArrayList<String> convertTrigger(String sqlStatement) {
        int pos;
        ArrayList<String> result = new ArrayList<String>();
        String stmt = this.converSimpleStatement(sqlStatement);
        stmt = Pattern.compile("\\bINSERTING\\b").matcher(stmt).replaceAll("TG_OP='INSERT'");
        stmt = Pattern.compile("\\bUPDATING\\b").matcher(stmt).replaceAll("TG_OP='UPDATE'");
        stmt = Pattern.compile("\\bDELETING\\b").matcher(stmt).replaceAll("TG_OP='DELETE'");
        stmt = Pattern.compile(":new.").matcher(stmt).replaceAll("NEW.");
        stmt = Pattern.compile(":old.").matcher(stmt).replaceAll("OLD.");
        stmt = Pattern.compile("'").matcher(stmt).replaceAll("''");
        int orReplacePos = stmt.toUpperCase().indexOf(" OR REPLACE ");
        int triggerPos = stmt.toUpperCase().indexOf(" TRIGGER ") + 9;
        String triggerName = stmt.substring(triggerPos);
        triggerName = triggerName.substring(0, triggerName.indexOf(" "));
        String tableName = stmt.substring(stmt.toUpperCase().indexOf(" ON ") + 4);
        tableName = tableName.substring(0, tableName.indexOf(" "));
        if (orReplacePos != -1) {
            String drop = "DROP FUNCTION " + triggerName + "F()";
            result.add(drop);
        }
        if ((pos = stmt.indexOf("DECLARE ")) == -1) {
            pos = stmt.indexOf("BEGIN ");
        }
        String functionCode = stmt.substring(pos);
        StringBuffer triggerCode = new StringBuffer("CREATE TRIGGER ");
        triggerCode.append(triggerName).append("\n").append(stmt.substring(triggerPos + triggerName.length(), pos)).append("\nEXECUTE PROCEDURE ").append(triggerName).append("F();");
        functionCode = Pattern.compile("\\bRETURN;", 2).matcher(functionCode).replaceAll("RETURN NEW;");
        functionCode = Pattern.compile("\\bEND " + triggerName + ";", 2).matcher(functionCode).replaceAll("\nRETURN NEW;\nEND " + triggerName + "F;");
        String match = "(\\(.*\\))|(;)|(\\bBEGIN\\b)|(\\bTHEN\\b)|(\\bELSE\\b)|(\\bELSIF\\b)";
        Matcher m = Pattern.compile(match, 2).matcher(functionCode);
        StringBuffer sb = new StringBuffer("CREATE FUNCTION ");
        sb.append(triggerName).append("F() RETURNS OPAQUE AS '\n");
        while (m.find()) {
            String group = m.group();
            if (group.indexOf(36) != -1) {
                group = Util.replace(group, "$", "\\$");
            }
            m.appendReplacement(sb, group);
            sb.append("\n");
        }
        m.appendTail(sb);
        sb.append("' LANGUAGE 'plpgsql';");
        result.add(sb.toString());
        if (orReplacePos != -1) {
            String drop = "DROP TRIGGER " + triggerName.toLowerCase() + " ON " + tableName;
            result.add(drop);
        }
        String trigger = Pattern.compile("\\sOF.*ON\\s").matcher(triggerCode).replaceAll(" ON ");
        result.add(trigger);
        return result;
    }

    private ArrayList<String> convertView(String sqlStatement) {
        ArrayList<String> result = new ArrayList<String>();
        String stmt = this.converSimpleStatement(sqlStatement);
        int orReplacePos = stmt.toUpperCase().indexOf(" OR REPLACE ");
        if (orReplacePos != -1) {
            int index = stmt.indexOf(" VIEW ");
            int space = stmt.indexOf(32, index + 6);
            String drop = "DROP VIEW " + stmt.substring(index + 6, space);
            result.add(drop);
            String create = "CREATE" + stmt.substring(index);
            result.add(create);
        } else {
            result.add(stmt);
        }
        return result;
    }

    private String convertComplexStatement(String sqlStatement) {
        String group;
        String retValue = sqlStatement;
        StringBuffer sb = null;
        while (retValue.indexOf("DECODE") != -1) {
            retValue = this.convertDecode(retValue);
        }
        Matcher m = Pattern.compile("\\w+\\.(nextval)|(curval)", 2).matcher(retValue);
        sb = new StringBuffer();
        while (m.find()) {
            group = m.group();
            int pos = group.indexOf(".");
            String seqName = group.substring(0, pos);
            String funcName = group.substring(pos + 1);
            if ((group = funcName + "('" + seqName + "')").indexOf(36) != -1) {
                group = Util.replace(group, "$", "\\$");
            }
            m.appendReplacement(sb, group);
        }
        m.appendTail(sb);
        retValue = sb.toString();
        m = Pattern.compile("RAISE_APPLICATION_ERROR\\s*\\(.+'\\)", 2).matcher(retValue);
        sb = new StringBuffer();
        while (m.find()) {
            group = m.group();
            System.out.print("-> " + group);
            String result = "RAISE EXCEPTION " + group.substring(group.indexOf(39), group.lastIndexOf(39) + 1);
            log.info(" => " + result);
            if (result.indexOf(36) != -1) {
                result = Util.replace(result, "$", "\\$");
            }
            m.appendReplacement(sb, result);
        }
        m.appendTail(sb);
        retValue = sb.toString();
        if (retValue.indexOf("TRUNC(((TRUNC(") != -1 && DB.isPostgreSQL()) {
            retValue = Util.replace(retValue, "TRUNC(((TRUNC(", "(((TRUNC(");
        }
        while (retValue.indexOf("TRUNC") != -1) {
            retValue = this.convertTrunc(retValue);
        }
        int index = retValue.indexOf("SELECT ");
        if (index != -1 && retValue.indexOf("(+)", index) != -1) {
            retValue = this.convertOuterJoin(retValue);
        }
        return retValue;
    }

    private String convertRowNum(String sqlStatement) {
        log.info("RowNum<== " + sqlStatement);
        if (DB.isPostgreSQL()) {
            int rownum;
            log.info("RowNum<== " + sqlStatement);
            String retValue = null;
            int s_end = 0;
            int s_start = -1;
            String select = sqlStatement;
            String convert = "";
            while (true) {
                String subselect;
                s_end = 0;
                s_start = select.indexOf("(SELECT");
                if (s_start == -1) break;
                convert = convert + select.substring(0, s_start);
                int open = -1;
                for (int i = s_start; i < select.length(); ++i) {
                    char c = select.charAt(i);
                    if (c == '(') {
                        ++open;
                    }
                    if (c == ')') {
                        --open;
                    }
                    if (open != -1) continue;
                    s_end = i + 1;
                    break;
                }
                if ((subselect = select.substring(s_start, s_end)).indexOf("AND ROWNUM=1") > 1) {
                    subselect = subselect.substring(0, subselect.length() - 1) + " LIMIT 1 )";
                    convert = convert + Util.replace(subselect, "AND ROWNUM=1", "");
                } else if (subselect.indexOf(" WHERE ROWNUM=1 AND") > 1) {
                    subselect = subselect.substring(0, subselect.length() - 1) + " LIMIT 1 )";
                    convert = convert + Util.replace(subselect, " WHERE ROWNUM=1 AND", " WHERE ");
                } else {
                    convert = convert + subselect;
                }
                retValue = select = select.substring(s_end);
            }
            if (retValue == null) {
                retValue = sqlStatement;
            }
            if (retValue.indexOf("AND ROWNUM=1") > 1) {
                rownum = retValue.indexOf("AND ROWNUM=1");
                if (retValue.substring(0, rownum).contains("WHERE")) {
                    retValue = Util.replace(retValue, "AND ROWNUM=1", " LIMIT 1");
                    return convert + retValue;
                }
                retValue = Util.replace(retValue, "AND ROWNUM=1", "");
                return convert + retValue + " LIMIT 1";
            }
            if (retValue.indexOf("AND ROWNUM= 1") > 1) {
                rownum = retValue.indexOf("AND ROWNUM= 1");
                if (retValue.substring(0, rownum).contains("WHERE")) {
                    retValue = Util.replace(retValue, "AND ROWNUM= 1", " LIMIT 1");
                    return convert + retValue;
                }
                retValue = Util.replace(retValue, "AND ROWNUM= 1", "");
                return convert + retValue + " LIMIT 1";
            }
            if (retValue.indexOf("AND ROWNUM = 1") > 1) {
                rownum = retValue.indexOf("AND ROWNUM = 1");
                if (retValue.substring(0, rownum).contains("WHERE")) {
                    retValue = Util.replace(sqlStatement, "AND ROWNUM = 1", " LIMIT 1");
                    return convert + retValue;
                }
                retValue = Util.replace(sqlStatement, "AND ROWNUM = 1", "");
                return convert + retValue + " LIMIT 1";
            }
            if (retValue.indexOf("AND ROWNUM =1") > 1) {
                rownum = retValue.indexOf("AND ROWNUM =1");
                if (retValue.substring(0, rownum).contains("WHERE")) {
                    retValue = Util.replace(retValue, "AND ROWNUM =1", " LIMIT 1");
                    return convert + retValue;
                }
                retValue = Util.replace(retValue, "AND ROWNUM =1", "");
                return convert + retValue + " LIMIT 1";
            }
            if (retValue.indexOf("ROWNUM=1") > 1) {
                rownum = retValue.indexOf("ROWNUM=1");
                System.out.println("retValue" + retValue);
                if (retValue.substring(0, rownum).contains("WHERE")) {
                    retValue = Util.replace(retValue, "ROWNUM=1 ", " LIMIT 1");
                    return convert + retValue;
                }
                retValue = Util.replace(retValue, "ROWNUM=1", "");
                return convert + retValue + " LIMIT 1";
            }
            return convert + retValue;
        }
        return sqlStatement;
    }

    private String convertTrunc(String sqlStatement) {
        int find = -1;
        find = sqlStatement.indexOf(",'Q'");
        if (find != -1) {
            sqlStatement = sqlStatement.replaceFirst("TRUNC\\(", "DATE_Trunc('quarter',");
            sqlStatement = sqlStatement.replaceFirst(",'Q'", "");
            return sqlStatement;
        }
        find = sqlStatement.indexOf(",'Y'");
        if (find != -1) {
            sqlStatement = sqlStatement.replaceFirst("TRUNC\\(", "DATE_Trunc('year',");
            sqlStatement = sqlStatement.replaceFirst(",'Y'", "");
            return sqlStatement;
        }
        find = sqlStatement.indexOf(",'MM'");
        if (find != -1) {
            sqlStatement = sqlStatement.replaceFirst("TRUNC\\(", "DATE_Trunc('month',");
            sqlStatement = sqlStatement.replaceFirst(",'MM'", "");
            return sqlStatement;
        }
        find = sqlStatement.indexOf(",'DD'");
        if (find != -1) {
            sqlStatement = sqlStatement.replaceFirst("TRUNC\\(", "DATE_Trunc('day',");
            sqlStatement = sqlStatement.replaceFirst(",'DD'", "");
            return sqlStatement;
        }
        find = sqlStatement.indexOf(",'DY'");
        if (find != -1) {
            sqlStatement = sqlStatement.replaceFirst("TRUNC\\(", "DATE_Trunc('day',");
            sqlStatement = sqlStatement.replaceFirst(",'DY'", "");
            return sqlStatement;
        }
        if (find == -1) {
            sqlStatement = sqlStatement.replaceFirst("TRUNC\\(", "DATE_Trunc('day',");
            return sqlStatement;
        }
        System.out.println("SQL=" + sqlStatement);
        return sqlStatement;
    }

    private String convertUpdate(String sqlStatement) {
        if (DB.isPostgreSQL()) {
            String sqlUpdate = sqlStatement;
            int index = 0;
            int begintable = 0;
            int begin = 0;
            int end = 0;
            Object alias = null;
            end = 0;
            begin = Util.findIndexOf(sqlUpdate, "SET (");
            if (begin != -1) {
                if (sqlUpdate.toUpperCase().indexOf("UPDATE ") == 0) {
                    index = sqlUpdate.toUpperCase().indexOf("UPDATE ");
                    begintable = sqlUpdate.indexOf(32, 6);
                    begin = sqlUpdate.indexOf(32, 7);
                    end = sqlUpdate.toUpperCase().indexOf(" SET", 0);
                }
                String table2 = sqlUpdate.substring(begin, end).trim();
                String select = "";
                begin = Util.findIndexOf(sqlUpdate, " SET (");
                end = sqlUpdate.indexOf(")=(");
                if (end != -1) {
                    select = sqlUpdate.substring(end + 2);
                } else {
                    end = sqlUpdate.indexOf(") = (");
                    if (end != -1) {
                        select = sqlUpdate.substring(end + 4);
                    } else {
                        end = sqlUpdate.indexOf(")= (");
                        if (end != -1) {
                            select = sqlUpdate.substring(end + 3);
                        } else {
                            end = sqlUpdate.indexOf(") =(");
                            if (end != -1) {
                                select = sqlUpdate.substring(end + 3);
                            }
                        }
                    }
                }
                int where_begin = -1;
                String rest = "";
                int s_end = 0;
                int s_start = select.indexOf("(");
                String where = null;
                int open = -1;
                for (int i = s_start; i < select.length(); ++i) {
                    char c = select.charAt(i);
                    if (c == '(') {
                        ++open;
                    }
                    if (c == ')') {
                        --open;
                    }
                    if (open != -1) continue;
                    s_end = i + 1;
                    break;
                }
                where = select.substring(s_end);
                where = where.substring(where.indexOf(" WHERE ") + 7);
                String s = select.substring(s_start, s_end);
                String from = s.substring(s.toUpperCase().indexOf(" FROM ") + 6);
                String tablejoin = from.substring(from.toUpperCase().indexOf(" "), from.toUpperCase().indexOf(" WHERE "));
                String tablealias = from.substring(0, from.toUpperCase().indexOf(" WHERE "));
                String swhere = select.substring(s_end);
                String s_where = s.substring(s.toUpperCase().indexOf(" WHERE ") + 7, s.length() - 1);
                String Update = sqlUpdate.substring(0, begin);
                Update = Update + " SET ";
                int f_begin = begin + 6;
                int f_beginjoin = 0;
                String fields = sqlUpdate.substring(f_begin, end);
                int beginfrom = select.toUpperCase().indexOf(" FROM ");
                String fieldsjoin = select.substring(select.toUpperCase().indexOf("(SELECT ") + 8, beginfrom);
                int f = fields.length();
                int fj = fieldsjoin.length();
                String field = null;
                String fieldjoin = null;
                while (f > 0) {
                    f = Util.findIndexOf(fields, ',');
                    if (f < 0) {
                        field = fields;
                        fieldjoin = fieldsjoin;
                        if (fieldjoin.indexOf(".") < 0) {
                            fieldjoin = tablejoin + "." + fieldjoin;
                        }
                        Update = Update + field.trim() + "=" + fieldjoin.trim() + rest + " FROM " + tablealias + " WHERE " + s_where;
                        where = where != null ? " AND " + where : "";
                        String sqlkey = "AND,OR,FROM,WHERE,JOIN,BY,GROUP,IN,INTO,SELECT,NOT,SET,UPDATE,DELETE,HAVING,IS,NULL,EXISTS";
                        int o = -1;
                        StringTokenizer st = new StringTokenizer(where);
                        String result = "";
                        String word = "";
                        do {
                            if (sqlkey.indexOf(word = st.nextToken()) == -1) {
                                for (int i = 0; i < word.length(); ++i) {
                                    char c = word.charAt(i);
                                    if (c == '(') {
                                        ++o;
                                    }
                                    if (c != ')') continue;
                                    --o;
                                }
                                if (o == -1 && !word.contains(")") | !word.contains("(")) {
                                    result = result + " " + table2 + "." + word;
                                    continue;
                                }
                                result = result + " " + word;
                                continue;
                            }
                            result = result + " " + word;
                        } while (st.hasMoreElements());
                        Update = Update + result;
                    } else {
                        field = fields.substring(0, f);
                        fj = Util.findIndexOf(fieldsjoin, ',');
                        fieldjoin = fieldsjoin.substring(0, fj);
                        if (fieldjoin.indexOf(".") < 0 != fieldjoin.equals("SysDate")) {
                            fieldjoin = tablejoin + "." + fieldjoin;
                        }
                        Update = Update + field.trim() + "=" + fieldjoin.trim() + ",";
                        f_beginjoin = fj;
                        fieldsjoin = fieldsjoin.substring(f_beginjoin + 1);
                        f_beginjoin = fj;
                    }
                    f_begin = f;
                    fields = fields.substring(f_begin + 1);
                }
                sqlUpdate = Update;
            }
            return sqlUpdate;
        }
        return sqlStatement;
    }

    private String convertDelete(String sqlStatement) {
        int index = sqlStatement.toUpperCase().indexOf("DELETE ");
        if (index < 7) {
            return "DELETE FROM " + sqlStatement.substring(index + 7);
        }
        return sqlStatement;
    }

    private String convertAlias(String sqlStatement) {
        return sqlStatement;
    }

    private String convertDDL(String sqlStatement) {
        if (sqlStatement.toUpperCase().indexOf("ALTER TABLE ") == 0) {
            String action = null;
            int begin_col = -1;
            if (sqlStatement.toUpperCase().indexOf(" MODIFY ") > 0) {
                action = " ALTER ";
                begin_col = sqlStatement.toUpperCase().indexOf(" MODIFY ") + action.length();
            } else if (sqlStatement.toUpperCase().indexOf(" ADD ") > 0) {
                action = " ADD ";
                begin_col = sqlStatement.toUpperCase().indexOf(" ADD ") + action.length();
            }
            if (begin_col < 0) {
                return sqlStatement;
            }
            int end_col = 0;
            int begin_default = -1;
            int begin_type = -1;
            String column = null;
            String type = null;
            String defaultvalue = null;
            String DDL = null;
            if (begin_col != -1) {
                column = sqlStatement.substring(begin_col);
                end_col = begin_col + column.indexOf(" ");
                column = sqlStatement.substring(begin_col, end_col);
                type = sqlStatement.substring(end_col + 1) + " ";
                type = type.substring(0, type.indexOf(" "));
                if (action.equals(" ADD ")) {
                    DDL = sqlStatement.substring(0, begin_col - action.length()) + action + "COLUMN " + column + " " + type + "; ";
                } else if (action.equals(" ALTER ")) {
                    DDL = sqlStatement.substring(0, begin_col - action.length()) + action + "COLUMN " + column + " TYPE " + type + "; ";
                }
                if (sqlStatement.toUpperCase().indexOf(" DEFAULT ") != -1) {
                    begin_default = sqlStatement.toUpperCase().indexOf(" DEFAULT ") + 9;
                    defaultvalue = sqlStatement.substring(begin_default);
                    String rest = defaultvalue.substring(defaultvalue.indexOf(" "));
                    defaultvalue = defaultvalue.substring(0, defaultvalue.indexOf(" "));
                    DDL = DDL + sqlStatement.substring(0, begin_col - action.length()) + " ALTER COLUMN " + column + " SET DEFAULT '" + defaultvalue + "'; ";
                    if (rest != null && rest.indexOf(" NOT NULL ") == 0) {
                        DDL = DDL + sqlStatement.substring(0, begin_col) + " ALTER COLUMN " + column + " SET " + rest + ";";
                    }
                }
                return DDL;
            }
        }
        return sqlStatement;
    }

    private String convertIgnore(String sqlStatement) {
        String[] vars = new String[20];
        int cont = 1;
        Pattern p2 = Pattern.compile("'[[\\w]*[,]*[ ]*]*'", 2);
        Matcher m = p2.matcher(sqlStatement);
        while (m.find()) {
            vars[cont++] = sqlStatement.substring(m.start(), m.end());
        }
        vars[0] = m.replaceAll("<-->");
        String[] retVar = new String[cont];
        for (int i = 0; i < cont; ++i) {
            retVar[i] = vars[i];
        }
        p2 = Pattern.compile("<-->");
        m = p2.matcher(retVar[0]);
        cont = 1;
        for (cont = 1; cont < retVar.length; ++cont) {
            retVar[0] = m.replaceFirst(retVar[cont]);
            m = p2.matcher(retVar[0]);
        }
        return null;
    }
}

