/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.dbPort;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.compiere.util.CLogger;
import org.compiere.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Convert {
    public static final int REGEX_FLAGS = 34;
    protected Statement m_stmt = null;
    protected String m_conversionError = null;
    protected Exception m_exception = null;
    protected boolean m_verbose = true;
    private static CLogger log = CLogger.getCLogger(Convert.class);

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public boolean execute(String sqlStatements, Connection conn) {
        if (conn == null) {
            throw new IllegalStateException("Require connection");
        }
        String[] sql = this.convert(sqlStatements);
        this.m_exception = null;
        if (this.m_conversionError != null || sql == null) {
            return false;
        }
        boolean ok = true;
        int i = 0;
        String statement = null;
        try {
            if (this.m_stmt == null) {
                this.m_stmt = conn.createStatement();
            }
            for (i = 0; ok && i < sql.length; ++i) {
                statement = sql[i];
                if (statement.length() == 0) {
                    if (!this.m_verbose) continue;
                    log.finer("Skipping empty (" + i + ")");
                    continue;
                }
                if (this.m_verbose) {
                    log.info("Executing (" + i + ") <<" + statement + ">>");
                } else {
                    log.info("Executing " + i);
                }
                try {
                    this.m_stmt.clearWarnings();
                    int no = this.m_stmt.executeUpdate(statement);
                    SQLWarning warn = this.m_stmt.getWarnings();
                    if (warn != null) {
                        if (this.m_verbose) {
                            log.info("- " + warn);
                        } else {
                            log.info("Executing (" + i + ") <<" + statement + ">>");
                            log.info("- " + warn);
                        }
                    }
                    if (!this.m_verbose) continue;
                    log.fine("- ok " + no);
                    continue;
                }
                catch (SQLException ex) {
                    if (!statement.startsWith("DROP ")) {
                        ok = false;
                        this.m_exception = ex;
                    }
                    if (!this.m_verbose) {
                        log.info("Executing (" + i + ") <<" + statement + ">>");
                    }
                    log.info("Error executing " + i + "/" + sql.length + " = " + ex);
                }
            }
        }
        catch (SQLException e) {
            this.m_exception = e;
            if (!this.m_verbose) {
                log.info("Executing (" + i + ") <<" + statement + ">>");
            }
            log.info("Error executing " + i + "/" + sql.length + " = " + e);
            return false;
        }
        return ok;
    }

    public Exception getException() {
        return this.m_exception;
    }

    public boolean hasError() {
        return this.m_exception != null | this.m_conversionError != null;
    }

    public String convertAll(String sqlStatements) {
        String[] sql = this.convert(sqlStatements);
        StringBuffer sb = new StringBuffer(sqlStatements.length() + 10);
        for (int i = 0; i < sql.length; ++i) {
            sb.append(sql[i]).append("\n/\n");
            if (!this.m_verbose) continue;
            log.info("Statement " + i + ": " + sql[i]);
        }
        return sb.toString();
    }

    public String[] convert(String sqlStatements) {
        this.m_conversionError = null;
        if (sqlStatements == null || sqlStatements.length() == 0) {
            this.m_conversionError = "SQL_Statement is null or has zero length";
            log.info(this.m_conversionError);
            return null;
        }
        return this.convertIt(sqlStatements);
    }

    public String getConversionError() {
        return this.m_conversionError;
    }

    protected String[] convertIt(String sqlStatements) {
        int MASK = 31;
        StringBuffer masked = new StringBuffer(sqlStatements.length());
        Matcher m = Pattern.compile("'[^']+'", 32).matcher(sqlStatements);
        while (m.find()) {
            String group = m.group();
            if (group.indexOf("/") != -1) {
                group = group.replace('/', '\u001f');
            }
            if (group.indexOf(36) != -1) {
                group = Util.replace(group, "$", "\\$");
            }
            m.appendReplacement(masked, group);
        }
        m.appendTail(masked);
        String tempResult = masked.toString();
        String[] sql = tempResult.split("\\s/\\s");
        ArrayList<String> result = new ArrayList<String>(sql.length);
        for (int i = 0; i < sql.length; ++i) {
            String statement = sql[i];
            if (statement.indexOf(31) != -1) {
                statement = statement.replace('\u001f', '/');
            }
            result.addAll(this.convertStatement(statement));
        }
        sql = new String[result.size()];
        result.toArray(sql);
        return sql;
    }

    protected abstract ArrayList<String> convertStatement(String var1);

    public abstract boolean isOracle();
}

