/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.io.File;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.derby.impl.drda.NetworkServerControlImpl;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Ini;

public class DerbyServer
extends Thread {
    private static DerbyServer s_server = null;
    public static final int PORT = 1527;
    private static CLogger log = CLogger.getCLogger(DerbyServer.class);
    private static NetworkServerControlImpl s_impl = null;
    private static String s_derbyHome = "";
    private static InetAddress s_address = null;
    private static int s_port = 0;

    public static synchronized DerbyServer get() {
        if (s_server == null) {
            InetAddress address = null;
            int port = 1527;
            try {
                address = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
                s_server = new DerbyServer(address, port);
                s_server.start();
            }
            catch (Exception e) {
                String msg = null;
                msg = address == null ? "" : address.toString();
                msg = msg + ":" + port;
                log.log(Level.SEVERE, msg, e);
            }
        }
        return s_server;
    }

    public static boolean startServer() {
        if (DerbyServer.get() == null) {
            return false;
        }
        return s_server.isServerStarted();
    }

    public static boolean stopServer() {
        if (s_server == null) {
            return true;
        }
        try {
            s_server.shutdown();
            s_server = null;
            return true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    private DerbyServer(InetAddress address, int port) throws Exception {
        super("CompiereDerby");
        if (s_impl != null) {
            throw new IllegalStateException("Derby Server already started");
        }
        String compiereHome = Ini.getAdempiereHome();
        s_derbyHome = compiereHome + File.separator + "derby";
        File dir = new File(s_derbyHome);
        if (!dir.exists()) {
            dir.mkdir();
        }
        System.setProperty("derby.system.home", s_derbyHome);
        System.setProperty("derby.drda.traceDirectory", s_derbyHome);
        String logIt = "false";
        if (CLogMgt.isLevelFiner()) {
            logIt = "true";
        }
        System.setProperty("derby.drda.logConnections", logIt);
        System.setProperty("derby.drda.traceAll", logIt);
        System.setProperty("derby.connection.requireAuthentication", "true");
        System.setProperty("derby.authentication.provider", "BUILTIN");
        this.addUser("compiere", "compiere");
        s_address = address;
        s_port = port;
        s_impl = new NetworkServerControlImpl(s_address, s_port);
    }

    public void run() {
        log.info("starting ...");
        PrintWriter consoleWriter = new PrintWriter(System.out, true);
        try {
            s_impl.blockingStart(consoleWriter);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            s_impl = null;
        }
        log.info("done");
    }

    public void interrupt() {
        super.interrupt();
        this.shutdown();
    }

    public boolean isServerStarted() {
        if (s_impl == null) {
            return false;
        }
        try {
            s_impl.ping();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean shutdown() {
        if (s_impl != null) {
            try {
                log.info("shutting down ...");
                s_impl.shutdown();
                log.info("shutdown");
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DerbyServer[");
        sb.append(s_derbyHome).append(";").append(s_address).append(":").append(s_port).append(";Alive=").append(this.isAlive()).append(";Started=").append(this.isServerStarted());
        sb.append("]");
        return sb.toString();
    }

    public String getDerbyHome() {
        return s_derbyHome;
    }

    public String getRuntimeInfo() {
        try {
            if (s_impl != null) {
                return s_impl.runtimeInfo();
            }
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "";
    }

    public String getSysInfo() {
        try {
            if (s_impl != null) {
                return s_impl.sysinfo();
            }
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "";
    }

    public Properties getCurrentProperties() throws Exception {
        return s_impl.getCurrentProperties();
    }

    public void addUser(String dbUid, String dbPwd) {
        System.setProperty("derby.user." + dbUid, dbPwd);
        Properties dp = new Properties();
    }

    public boolean createDatabase(String dbName, String dbUid, String dbPwd) {
        this.addUser(dbUid, dbPwd);
        try {
            EmbeddedDriver driver = new EmbeddedDriver();
            DriverManager.registerDriver((Driver)driver);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "DriverIssue", e);
            return false;
        }
        String dbUrl = "jdbc:derby:" + dbName;
        Connection conn = null;
        try {
            String urlAttributes = ";create=true;user=" + dbUid + ";password=" + dbPwd;
            conn = DriverManager.getConnection(dbUrl + urlAttributes);
            log.info("Created DB: " + dbName);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        try {
            if (conn != null) {
                conn.close();
            }
            conn = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            conn = DriverManager.getConnection(dbUrl, dbUid, dbPwd);
            log.info("Connected to DB: " + dbName);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            conn = null;
            return false;
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate("CREATE TABLE XX (XX VARCHAR(5))");
            stmt.executeUpdate("INSERT INTO XX (XX) VALUES ('A')");
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
            conn = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    public static void main(String[] args) {
        CLogMgt.setLevel(Level.FINE);
        DerbyServer server = DerbyServer.get();
        DerbyServer.startServer();
        server.createDatabase("compiere", "compiere", "compiere");
        try {
            log.info("Sleeping " + DerbyServer.get());
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

