/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import org.compiere.db.AdempiereDatabase;
import org.compiere.db.DB_DB2;
import org.compiere.db.DB_Fyracle;
import org.compiere.db.DB_Oracle;
import org.compiere.db.DB_PostgreSQL;
import org.compiere.util.CLogger;

public class Database {
    private static CLogger log = CLogger.getCLogger(Database.class);
    public static String DB_ORACLE = "Oracle";
    public static String DB_DB2 = "DB2";
    public static String DB_DERBY = "Derby";
    public static String DB_MSSQLServer = "SQLServer";
    public static String DB_POSTGRESQL = "PostgreSQL";
    public static String DB_FYRACLE = "Fyracle(beta)";
    public static String[] DB_NAMES = new String[]{DB_ORACLE, DB_DB2, DB_POSTGRESQL, DB_FYRACLE};
    protected static Class[] DB_CLASSES = new Class[]{DB_Oracle.class, DB_DB2.class, DB_PostgreSQL.class, DB_Fyracle.class};
    public static int CONNECTION_TIMEOUT = 10;

    public static AdempiereDatabase getDatabase(String type) throws Exception {
        AdempiereDatabase db = null;
        for (int i = 0; i < DB_NAMES.length; ++i) {
            if (!DB_NAMES[i].equals(type)) continue;
            db = (AdempiereDatabase)DB_CLASSES[i].newInstance();
            break;
        }
        return db;
    }

    public static AdempiereDatabase getDatabaseFromURL(String url) {
        if (url == null) {
            log.severe("No Database URL");
            return null;
        }
        if (url.indexOf("oracle") != -1) {
            return new DB_Oracle();
        }
        if (url.indexOf("db2") != -1) {
            return new DB_DB2();
        }
        if (url.indexOf("postgresql") != -1) {
            return new DB_PostgreSQL();
        }
        if (url.indexOf("firebirdsql") != -1) {
            return new DB_Fyracle();
        }
        log.severe("No Database for " + url);
        return null;
    }
}

