/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.RowSet;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.dbPort.Convert;
import org.compiere.dbPort.Convert_PostgreSQL;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.postgresql.Driver;
import org.postgresql.ds.PGPoolingDataSource;
import org.postgresql.jdbc3.Jdbc3PoolingDataSource;

public class DB_PostgreSQL
implements AdempiereDatabase {
    private Driver s_driver = null;
    public static final int DEFAULT_PORT = 5432;
    private PGPoolingDataSource m_ds = null;
    private Convert_PostgreSQL m_convert = new Convert_PostgreSQL();
    private String m_connection;
    private String m_dbName = null;
    private String m_userName = null;
    private String m_connectionURL;
    private static CLogger log = CLogger.getCLogger(DB_PostgreSQL.class);

    public Convert getConvert() {
        return this.m_convert;
    }

    public String getName() {
        return Database.DB_POSTGRESQL;
    }

    public String getDescription() {
        try {
            if (this.s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.s_driver != null) {
            return this.s_driver.toString();
        }
        return "No Driver";
    }

    public int getStandardPort() {
        return 5432;
    }

    public java.sql.Driver getDriver() throws SQLException {
        if (this.s_driver == null) {
            this.s_driver = new Driver();
            DriverManager.registerDriver((java.sql.Driver)this.s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return this.s_driver;
    }

    public String getConnectionURL(CConnection connection) {
        StringBuffer sb = new StringBuffer("jdbc:postgresql:");
        sb.append("//").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append("/").append(connection.getDbName()).append("?encoding=UNICODE");
        this.m_connection = sb.toString();
        return this.m_connection;
    }

    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        return "jdbc:postgresql://" + dbHost + ":" + dbPort + "/" + dbName;
    }

    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    public String getCatalog() {
        if (this.m_dbName != null) {
            return this.m_dbName;
        }
        return null;
    }

    public String getSchema() {
        return "adempiere";
    }

    public boolean supportsBLOB() {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DB_PostgreSQL[");
        sb.append(this.m_connection).append("]");
        return sb.toString();
    }

    public String getStatus() {
        return "";
    }

    public String convertStatement(String oraStatement) {
        String[] retValue = this.m_convert.convert(oraStatement);
        if (retValue.length == 0) {
            return oraStatement;
        }
        if (retValue == null) {
            log.log(Level.SEVERE, "DB_PostgreSQL.convertStatement - Not Converted (" + oraStatement + ") - " + this.m_convert.getConversionError());
            throw new IllegalArgumentException("DB_PostgreSQL.convertStatement - Not Converted (" + oraStatement + ") - " + this.m_convert.getConversionError());
        }
        if (retValue.length != 1) {
            log.log(Level.SEVERE, "DB_PostgreSQL.convertStatement - Convert Command Number=" + retValue.length + " (" + oraStatement + ") - " + this.m_convert.getConversionError());
            throw new IllegalArgumentException("DB_PostgreSQL.convertStatement - Convert Command Number=" + retValue.length + " (" + oraStatement + ") - " + this.m_convert.getConversionError());
        }
        if (!oraStatement.equals(retValue[0]) && retValue[0].indexOf("AD_Error") == -1) {
            log.log(Level.INFO, "PostgreSQL =>" + retValue[0] + "<= <" + oraStatement + ">");
        }
        return retValue[0];
    }

    public String getSystemUser() {
        return "postgres";
    }

    public String getSystemDatabase(String databaseName) {
        return "template1";
    }

    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "current_date()";
            }
            return "current_date()";
        }
        StringBuffer dateString = new StringBuffer("TO_DATE('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("','YYYY-MM-DD')");
        } else {
            dateString.append(myDate.substring(0, myDate.indexOf(".")));
            dateString.append("','YYYY-MM-DD HH24:MI:SS')");
        }
        return dateString.toString();
    }

    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        StringBuffer retValue = new StringBuffer("CAST (");
        retValue.append(columnName);
        retValue.append(" AS Text)");
        return retValue.toString();
    }

    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        BigDecimal result = number;
        int scale = DisplayType.getDefaultPrecision(displayType);
        if (scale > number.scale()) {
            try {
                result = number.setScale(scale, 4);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result.toString();
    }

    public String[] getCommands(int cmdType) {
        if (0 == cmdType) {
            return new String[]{"CREATE USER compiere;"};
        }
        if (1 == cmdType) {
            return new String[]{"CREATE DATABASE compiere OWNER compiere;", "GRANT ALL PRIVILEGES ON compiere TO compiere;", "CREATE SCHEMA compiere;", "SET search_path TO compiere;"};
        }
        if (2 == cmdType) {
            return new String[]{"DROP DATABASE compiere;"};
        }
        return null;
    }

    public RowSet getRowSet(ResultSet rs) throws SQLException {
        throw new UnsupportedOperationException("PostgreSQL does not support RowSets");
    }

    public Connection getCachedConnection(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        if (this.m_ds == null) {
            this.getDataSource(connection);
        }
        Connection conn = this.m_ds.getConnection();
        conn.setAutoCommit(autoCommit);
        conn.setTransactionIsolation(transactionIsolation);
        return conn;
    }

    public DataSource getDataSource(CConnection connection) {
        if (this.m_ds != null) {
            return this.m_ds;
        }
        Jdbc3PoolingDataSource ds = new Jdbc3PoolingDataSource();
        ds.setDataSourceName("CompiereDS");
        ds.setServerName(connection.getDbHost());
        ds.setDatabaseName(connection.getDbName());
        ds.setUser(connection.getDbUid());
        ds.setPassword(connection.getDbPwd());
        ds.setPortNumber(connection.getDbPort());
        ds.setMaxConnections(50);
        ds.setInitialConnections(20);
        this.m_ds = ds;
        return this.m_ds;
    }

    public ConnectionPoolDataSource createPoolDataSource(CConnection connection) {
        throw new UnsupportedOperationException("Not supported/implemented");
    }

    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
    }

    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    public void close() {
        log.config(this.toString());
        if (this.m_ds != null) {
            try {
                this.m_ds.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_ds = null;
    }

    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }

    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        if (IXName.endsWith("_KEY")) {
            return "1" + IXName;
        }
        return "0";
    }

    public boolean isSupported(String sql) {
        return true;
    }

    public static void main(String[] args) {
        DB_PostgreSQL postgresql = new DB_PostgreSQL();
        String databaseName = "adempiere";
        String uid = "adempiere";
        String pwd = "adempiere";
        String jdbcURL = postgresql.getConnectionURL("vpj", 5432, databaseName, uid);
        System.out.println(jdbcURL);
        try {
            postgresql.getDriver();
            Connection conn = DriverManager.getConnection(jdbcURL, uid, pwd);
            conn.close();
            conn = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

