/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.dbPort.Convert;
import org.compiere.dbPort.Convert_Oracle;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Language;
import org.firebirdsql.jdbc.FBDriver;
import org.firebirdsql.pool.FBWrappingDataSource;

public class DB_Fyracle
implements AdempiereDatabase {
    private static final int MAX_STATEMENTS = 20;
    private FBDriver s_driver = null;
    public static final int DEFAULT_PORT = 3050;
    private String m_connection;
    private FBWrappingDataSource m_ds;
    private static CLogger log = CLogger.getCLogger(DB_Fyracle.class);
    private Convert m_convert = new Convert_Oracle();
    private String m_userName;
    private String m_connectionURL;

    public String getName() {
        return Database.DB_FYRACLE;
    }

    public String getDescription() {
        return this.s_driver.toString();
    }

    public int getStandardPort() {
        return 3050;
    }

    public Driver getDriver() {
        if (this.s_driver == null) {
            this.s_driver = new FBDriver();
        }
        return this.s_driver;
    }

    public String getConnectionURL(CConnection connection) {
        StringBuffer sb = new StringBuffer("jdbc:firebirdsql:oracle:");
        sb.append(connection.getDbHost()).append("/").append(connection.getDbPort()).append(":").append(connection.getDbName());
        this.m_connection = sb.toString();
        this.m_userName = connection.getDbUid();
        return this.m_connection;
    }

    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        StringBuffer sb = new StringBuffer("jdbc:firebirdsql:oracle:");
        sb.append(dbHost).append("/").append(dbPort).append(":").append(dbName);
        this.m_connection = sb.toString();
        this.m_userName = userName;
        return this.m_connection;
    }

    public boolean supportsBLOB() {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DB_Firebird[");
        sb.append(this.m_connection).append("]");
        return sb.toString();
    }

    public String convertStatement(String oraStatement) {
        return oraStatement;
    }

    public void setRowID(PreparedStatement pstmt, int pos, Object rowID) throws SQLException {
        pstmt.setString(pos, (String)rowID);
    }

    public Object getRowID(ResultSet rs, int pos) throws SQLException {
        return rs.getString(pos);
    }

    public Connection getCachedConnection(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        if (this.m_ds == null) {
            this.getDataSource(connection);
        }
        Connection conn = null;
        conn = this.getDriverConnection(connection);
        if (conn != null) {
            if (conn.getTransactionIsolation() != transactionIsolation) {
                conn.setTransactionIsolation(transactionIsolation);
            }
            if (conn.getAutoCommit() != autoCommit) {
                conn.setAutoCommit(autoCommit);
            }
        } else {
            throw new RuntimeException("Cann't connect to database");
        }
        return conn;
    }

    public String getSchema() {
        if (this.m_userName != null) {
            return this.m_userName.toUpperCase();
        }
        log.severe("User Name not set (yet) - call getConnectionURL first");
        return null;
    }

    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
    }

    public DataSource getDataSource(CConnection connection) {
        if (this.m_ds != null) {
            return this.m_ds;
        }
        try {
            this.m_ds = new FBWrappingDataSource();
            StringBuffer db = new StringBuffer().append(connection.getDbHost()).append("/").append(connection.getDbPort()).append(":").append(connection.getDbName());
            this.m_ds.setDatabase(db.toString());
            this.m_ds.setUserName(connection.getDbUid());
            this.m_ds.setPassword(connection.getDbPwd());
            this.m_ds.setDescription("Compiere DS");
            this.m_ds.setType("ORACLE_MODE");
            this.m_ds.setLoginTimeout(10);
            this.m_ds.setMaxStatements(20);
            this.m_ds.setLoginTimeout(10);
            this.m_ds.setMaxStatements(20);
            return this.m_ds;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, this.toString(), e);
            return null;
        }
    }

    public String getStatus() {
        return null;
    }

    public void close() {
        this.m_ds = null;
    }

    public static void main(String[] a) {
        try {
            FBWrappingDataSource m_ds = new FBWrappingDataSource();
            m_ds.setDatabase("localhost/3050:c:/devspace/apps/fyracle/data/compiere.fdb");
            m_ds.setUserName("sysdba");
            m_ds.setPassword("masterkey");
            m_ds.setDescription("Compiere DS");
            m_ds.setLoginTimeout(10);
            m_ds.setMaxStatements(20);
            m_ds.setType("ORACLE_MODE");
            Connection c = null;
            c = m_ds.getConnection();
            c.createStatement().executeQuery("SELECT * FROM ad_CLIENT WHERE created>TO_DATE('2001-01-01')");
            new DB_Fyracle().getDriver();
            c = DriverManager.getConnection("jdbc:firebirdsql:oracle:localhost/3050:c:/devspace/apps/fyracle/data/compiere.fdb", "SYSDBA", "masterkey");
            c.createStatement().executeQuery("SELECT * FROM ad_CLIENT WHERE created>TO_DATE('2001-01-01')");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCatalog() {
        return null;
    }

    public String[] getCommands(int cmdType) {
        if (0 == cmdType) {
            return new String[0];
        }
        if (1 == cmdType) {
            return new String[0];
        }
        if (2 == cmdType) {
            return new String[0];
        }
        return null;
    }

    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "TRUNC(SysDate)";
            }
            return "SysDate";
        }
        StringBuffer dateString = new StringBuffer("TO_DATE('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("','YYYY-MM-DD')");
        } else {
            dateString.append(myDate.substring(0, myDate.indexOf(".")));
            dateString.append("','YYYY-MM-DD HH24:MI:SS')");
        }
        return dateString.toString();
    }

    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        StringBuffer retValue = new StringBuffer("TRIM(TO_CHAR(");
        retValue.append(columnName);
        if (DisplayType.isNumeric(displayType)) {
            if (displayType == 12) {
                retValue.append(",'9G999G990D00'");
            } else {
                retValue.append(",'TM9'");
            }
            if (!Language.isDecimalPoint(AD_Language)) {
                retValue.append(",'NLS_NUMERIC_CHARACTERS='',.'''");
            }
        } else if (DisplayType.isDate(displayType)) {
            retValue.append(",'").append(Language.getLanguage(AD_Language).getDBdatePattern()).append("'");
        }
        retValue.append("))");
        return retValue.toString();
    }

    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        return number.toString();
    }

    public String getSystemUser() {
        return "sysdba";
    }

    public String getSystemDatabase(String databaseName) {
        return databaseName;
    }

    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }

    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        if (IXName.endsWith("_KEY")) {
            return "1" + IXName;
        }
        return "0";
    }

    public Convert getConvert() {
        return this.m_convert;
    }

    public boolean isSupported(String sql) {
        return true;
    }
}

