/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import com.ibm.db2.jcc.DB2Driver;
import com.ibm.db2.jcc.DB2SimpleDataSource;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.dbPort.Convert;
import org.compiere.util.CLogger;

public class DB_DB2
implements AdempiereDatabase {
    private static DB2Driver s_driver = null;
    public static final String DRIVER = "com.ibm.db2.jcc.DB2Driver";
    public static final String DRIVER2 = "COM.ibm.db2.jdbc.app.DB2Driver";
    public static final int DEFAULT_PORT = 446;
    public static final int DEFAULT_PORT_0 = 50000;
    private String m_userName = null;
    private String m_connectionURL;
    private DB2SimpleDataSource m_ds = null;
    private static CLogger log = CLogger.getCLogger(DB_DB2.class);

    public String getName() {
        return Database.DB_DB2;
    }

    public String getDescription() {
        try {
            if (s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s_driver != null) {
            return s_driver.toString();
        }
        return "No Driver";
    }

    public int getStandardPort() {
        return 50000;
    }

    public Driver getDriver() throws SQLException {
        if (s_driver == null) {
            s_driver = new DB2Driver();
            DriverManager.registerDriver((Driver)s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return s_driver;
    }

    public String getConnectionURL(CConnection connection) {
        StringBuffer sb = null;
        sb = new StringBuffer("jdbc:db2:");
        sb.append("//").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append("/").append(connection.getDbName());
        this.m_connectionURL = sb.toString();
        this.m_userName = connection.getDbUid();
        return this.m_connectionURL;
    }

    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = "jdbc:db2://" + dbHost + ":" + dbPort + "/" + dbName;
        return this.m_connectionURL;
    }

    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    public String getCatalog() {
        return null;
    }

    public String getSchema() {
        if (this.m_userName != null) {
            return this.m_userName.toUpperCase();
        }
        log.severe("User Name not set (yet) - call getConnectionURL first");
        return null;
    }

    public boolean supportsBLOB() {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DB_DB2[");
        sb.append(this.m_connectionURL);
        sb.append("]");
        return sb.toString();
    }

    public String getStatus() {
        StringBuffer sb = new StringBuffer();
        return sb.toString();
    }

    public String convertStatement(String oraStatement) {
        return oraStatement;
    }

    public boolean isSupported(String sql) {
        return true;
    }

    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        return "0";
    }

    public String getSystemUser() {
        return "db2adm";
    }

    public String getSystemDatabase(String databaseName) {
        return databaseName;
    }

    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "trunc(CURRENT TIMESTAMP)";
            }
            return "CURRENT TIMESTAMP";
        }
        StringBuffer dateString = new StringBuffer("TIMESTAMP('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("-00.00.00.000000')");
        } else {
            myDate = myDate.replace('-', ' ');
            myDate = myDate.replace(':', '.');
            dateString.append(myDate);
            dateString.append("00')");
        }
        return dateString.toString();
    }

    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        return columnName;
    }

    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        return number.toString();
    }

    public String[] getCommands(int cmdType) {
        if (0 == cmdType) {
            return new String[0];
        }
        if (1 == cmdType) {
            return new String[0];
        }
        if (2 == cmdType) {
            return new String[0];
        }
        return null;
    }

    public DataSource getDataSource(CConnection connection) {
        if (this.m_ds == null) {
            this.m_ds = new DB2SimpleDataSource();
            this.m_ds.setServerName(connection.getDbHost());
            this.m_ds.setPortNumber(connection.getDbPort());
            this.m_ds.setDatabaseName(connection.getDbName());
            this.m_ds.setDescription("Adempiere DataSource");
            this.m_ds.setUser(connection.getDbUid());
            this.m_ds.setPassword(connection.getDbPwd());
            this.m_ds.setLoginTimeout(5);
        }
        return this.m_ds;
    }

    public Connection getCachedConnection(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        Connection conn = this.getDataSource(connection).getConnection();
        conn.setAutoCommit(autoCommit);
        conn.setTransactionIsolation(transactionIsolation);
        return conn;
    }

    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
    }

    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    public void close() {
        log.config(this.toString());
        this.m_ds = null;
    }

    public void cleanup() {
        log.config("");
    }

    public String getDataType(int displayType, int precision, boolean defaultValue) {
        String retValue = null;
        switch (displayType) {
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                retValue = "INTEGER";
                break;
            }
            case 12: {
                retValue = "DECIMAL(18,2)";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT 0";
                break;
            }
            case 23: {
                retValue = "BLOB";
                break;
            }
            case 28: {
                retValue = "CHAR(1)";
                break;
            }
            case 37: {
                retValue = "DECIMAL(22,6)";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT 0";
                break;
            }
            case 15: 
            case 16: 
            case 24: {
                retValue = "Timestamp";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT 0";
                break;
            }
            case 11: {
                retValue = "NUMBER(10)";
                break;
            }
            case 17: {
                retValue = "CHAR(" + precision + ")";
                break;
            }
            case 10: 
            case 14: 
            case 34: {
                retValue = "NVARCHAR(" + precision + ")";
                break;
            }
            case 36: {
                retValue = "CLOB";
                break;
            }
            case 29: {
                retValue = "NUMBER";
                break;
            }
            case 20: {
                retValue = "CHAR(1)";
                break;
            }
            default: {
                log.severe("Unknown: " + displayType);
            }
        }
        return retValue;
    }

    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }

    public static void main(String[] args) {
        try {
            DB2Driver driver = new DB2Driver();
            DriverManager.registerDriver((Driver)driver);
            Connection con = DriverManager.getConnection("jdbc:db2://dev1:50000/sample", "db2admin", "db2admin");
            System.out.println("Connection Catalog = " + con.getCatalog());
            DatabaseMetaData md = con.getMetaData();
            System.out.println(md.getDatabaseProductName() + " - " + md.getDatabaseProductVersion());
            System.out.println(md.getDriverName() + " - " + md.getDriverVersion());
            System.out.println("URL=" + md.getURL());
            System.out.println("User=" + md.getUserName());
            System.out.println(md.getNumericFunctions());
            System.out.println(md.getStringFunctions());
            System.out.println(md.getTimeDateFunctions());
            System.out.println(md.getSystemFunctions());
            System.out.println("Catalogs - " + md.getCatalogTerm());
            ResultSet rs = md.getCatalogs();
            while (rs.next()) {
                System.out.println("- " + rs.getString(1));
            }
            System.out.println("Schemas - " + md.getSchemaTerm());
            rs = md.getSchemas();
            while (rs.next()) {
                System.out.println("- " + rs.getString(1));
            }
            String sql = "SELECT GRANTOR,GRANTEE,DBADMAUTH FROM SYSCAT.DBAUTH";
            PreparedStatement pstmt = null;
            try {
                pstmt = con.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String GRANTOR = rs.getString(1);
                    String GRANTEE = rs.getString(2);
                    String DBADMAUTH = rs.getString(3);
                    System.out.println(GRANTOR + " -> " + GRANTEE + " = " + DBADMAUTH);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            System.out.println("SysCat Table");
            rs = md.getTables(null, "SYSCAT", null, new String[]{"TABLE", "VIEW"});
            while (rs.next()) {
                System.out.println("- User=" + rs.getString(2) + " | Table=" + rs.getString(3) + " | Type=" + rs.getString(4) + " | " + rs.getString(5));
            }
            System.out.println("Column");
            rs = md.getColumns(null, "SYSCAT", "DBAUTH", null);
            while (rs.next()) {
                System.out.println("- Tab=" + rs.getString(3) + " | Col=" + rs.getString(4) + " | Type=" + rs.getString(5) + ", " + rs.getString(6) + " | Size=" + rs.getString(7) + " | " + rs.getString(8) + " | Digits=" + rs.getString(9) + " | Radix=" + rs.getString(10) + " | Null=" + rs.getString(11) + " | Rem=" + rs.getString(12) + " | Def=" + rs.getString(13) + " | " + rs.getString(14) + " | " + rs.getString(15) + " | " + rs.getString(16) + " | Ord=" + rs.getString(17) + " | Null=" + rs.getString(18));
            }
            con.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public Convert getConvert() {
        throw new UnsupportedOperationException("Not implemented.");
    }
}

