/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.Database;
import org.compiere.db.JDBCInfo;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DBException;
import org.compiere.util.DisplayType;
import org.compiere.util.Util;

public class CreateAdempiere {
    private AdempiereDatabase m_dbTarget = null;
    private AdempiereDatabase m_dbSource = null;
    private String m_databaseHost = null;
    private int m_databasePort = 0;
    private String m_systemPassword = null;
    private String m_adempiereUser = null;
    private String m_adempierePassword = null;
    private String m_databaseName = null;
    private String m_databaseDevice = null;
    private Properties m_ctx = new Properties();
    private Connection m_conn = null;
    private static CLogger log = CLogger.getCLogger(CreateAdempiere.class);
    private PrintWriter m_writer = null;

    public CreateAdempiere(String databaseType, String databaseHost, int databasePort, String systemPassword) {
        this.initDatabase(databaseType);
        this.m_databaseHost = databaseHost;
        this.m_databasePort = databasePort == 0 ? this.m_dbTarget.getStandardPort() : databasePort;
        this.m_systemPassword = systemPassword;
        log.info(this.m_dbTarget.getName() + " on " + databaseHost);
    }

    private void initDatabase(String databaseType) {
        try {
            for (int i = 0; i < Database.DB_NAMES.length; ++i) {
                if (!Database.DB_NAMES[i].equals(databaseType)) continue;
                this.m_dbTarget = (AdempiereDatabase)Database.DB_CLASSES[i].newInstance();
                break;
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
            e.printStackTrace();
        }
        if (this.m_dbTarget == null) {
            throw new IllegalStateException("No database: " + databaseType);
        }
        this.m_dbSource = DB.getDatabase();
    }

    public void cleanStart() {
        Connection conn = this.getConnection(true, true);
        if (conn == null) {
            throw new IllegalStateException("No Database");
        }
        this.dropDatabase(conn);
        this.createUser(conn);
        this.createDatabase(conn);
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            log.log(Level.SEVERE, "close connection", e2);
        }
        conn = null;
    }

    public void setAdempiereUser(String adempiereUser, String adempierePassword) {
        this.m_adempiereUser = adempiereUser;
        this.m_adempierePassword = adempierePassword;
    }

    public void setDatabaseName(String databaseName, String databaseDevice) {
        this.m_databaseName = databaseName;
        this.m_databaseDevice = databaseDevice;
    }

    public boolean testConnection() {
        String dbUrl = this.m_dbTarget.getConnectionURL(this.m_databaseHost, this.m_databasePort, this.m_databaseName, this.m_dbTarget.getSystemUser());
        log.info(dbUrl + " - " + this.m_dbTarget.getSystemUser() + "/" + this.m_systemPassword);
        try {
            Connection conn = this.m_dbTarget.getDriverConnection(dbUrl, this.m_dbTarget.getSystemUser(), this.m_systemPassword);
            JDBCInfo info = new JDBCInfo(conn);
            if (CLogMgt.isLevelFinest()) {
                info.listCatalogs();
                info.listSchemas();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "test", e);
            return false;
        }
        return true;
    }

    public boolean createUser(Connection sysConn) {
        log.info(this.m_adempiereUser + "/" + this.m_adempierePassword);
        return this.executeCommands(this.m_dbTarget.getCommands(0), sysConn, true, false);
    }

    public boolean createDatabase(Connection sysConn) {
        log.info(this.m_databaseName + "(" + this.m_databaseDevice + ")");
        return this.executeCommands(this.m_dbTarget.getCommands(1), sysConn, true, false);
    }

    public boolean dropDatabase(Connection sysConn) {
        log.info(this.m_databaseName);
        return this.executeCommands(this.m_dbTarget.getCommands(2), sysConn, true, false);
    }

    public boolean copy(String whereClause, boolean dropFirst) {
        log.info(whereClause);
        if (this.getConnection(false, true) == null) {
            return false;
        }
        boolean success = true;
        int count = 0;
        ArrayList<String> list = new ArrayList<String>();
        String sql = "SELECT * FROM AD_Table";
        if (whereClause != null && whereClause.length() > 0) {
            sql = sql + " WHERE " + whereClause;
        }
        sql = sql + " ORDER BY TableName";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            Connection conn = pstmt.getConnection();
            DatabaseMetaData md = null;
            if (conn == null) {
                throw new DBException("No Connection");
            }
            md = conn.getMetaData();
            ResultSet rs = pstmt.executeQuery();
            while (rs.next() && success) {
                MTable table2 = new MTable(this.m_ctx, rs, null);
                if (table2.isView()) continue;
                if (dropFirst) {
                    this.executeCommands(new String[]{"DROP TABLE " + table2.getTableName()}, this.m_conn, false, false);
                }
                if (this.createTable(table2, md)) {
                    list.add(table2.getTableName());
                    ++count;
                    continue;
                }
                success = false;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
            success = false;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (!success) {
            return false;
        }
        this.enableConstraints(list);
        this.databaseBuild();
        log.info("#" + count);
        try {
            if (this.m_conn != null) {
                this.m_conn.close();
            }
        }
        catch (SQLException e2) {
            log.log(Level.SEVERE, "close connection", e2);
        }
        this.m_conn = null;
        return success;
    }

    public boolean execute(File script) {
        return false;
    }

    private boolean createTable(MTable mTable, DatabaseMetaData md) {
        String tableName = mTable.getTableName();
        log.info(tableName);
        String catalog = this.m_dbSource.getCatalog();
        String schema = this.m_dbSource.getSchema();
        String table2 = tableName.toUpperCase();
        MColumn[] columns = mTable.getColumns(false);
        StringBuffer sb = new StringBuffer("CREATE TABLE ");
        sb.append(tableName).append(" (");
        try {
            boolean first = true;
            ResultSet sourceColumns = md.getColumns(catalog, schema, table2, null);
            while (sourceColumns.next()) {
                sb.append(first ? "" : ", ");
                first = false;
                MColumn column = null;
                String columnName = sourceColumns.getString("COLUMN_NAME");
                for (int i = 0; i < columns.length; ++i) {
                    String cn = columns[i].getColumnName();
                    if (!cn.equalsIgnoreCase(columnName)) continue;
                    columnName = cn;
                    column = columns[i];
                    break;
                }
                sb.append(columnName).append(" ");
                int sqlType = sourceColumns.getInt("DATA_TYPE");
                String typeName = sourceColumns.getString("TYPE_NAME");
                int size = sourceColumns.getInt("COLUMN_SIZE");
                int decDigits = sourceColumns.getInt("DECIMAL_DIGITS");
                if (sourceColumns.wasNull()) {
                    decDigits = -1;
                }
                if (typeName.equals("NUMBER")) {
                    int dt = column.getAD_Reference_ID();
                    if (DisplayType.isID(dt)) {
                        sb.append("INTEGER");
                    } else {
                        int scale = DisplayType.getDefaultPrecision(dt);
                        sb.append("DECIMAL(").append(18 + scale).append(",").append(scale).append(")");
                    }
                } else if (typeName.equals("DATE") || typeName.equals("BLOB") || typeName.equals("CLOB")) {
                    sb.append(typeName);
                } else if (typeName.equals("CHAR") || typeName.startsWith("VARCHAR")) {
                    sb.append(typeName).append("(").append(size).append(")");
                } else if (typeName.startsWith("NCHAR") || typeName.startsWith("NVAR")) {
                    sb.append(typeName).append("(").append(size / 2).append(")");
                } else if (typeName.startsWith("TIMESTAMP")) {
                    sb.append("DATE");
                } else {
                    log.severe("Do not support data type " + typeName);
                }
                String def = sourceColumns.getString("COLUMN_DEF");
                if (def != null) {
                    def.replaceAll("''", "\\'");
                    sb.append(" DEFAULT ").append(def);
                }
                if (sourceColumns.getInt("NULLABLE") == 0) {
                    sb.append(" NOT NULL");
                    continue;
                }
                sb.append(" NULL");
            }
            sourceColumns.close();
            ResultSet sourcePK = md.getPrimaryKeys(catalog, schema, table2);
            first = true;
            boolean hasPK = false;
            while (sourcePK.next()) {
                hasPK = true;
                if (first) {
                    sb.append(", CONSTRAINT ").append(sourcePK.getString("PK_NAME")).append(" PRIMARY KEY (");
                } else {
                    sb.append(",");
                }
                first = false;
                String columnName = sourcePK.getString("COLUMN_NAME");
                sb.append(this.checkColumnName(columnName));
            }
            if (hasPK) {
                sb.append(")");
            }
            sourcePK.close();
            sb.append(")");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "createTable", ex);
            return false;
        }
        if (!this.executeCommands(new String[]{sb.toString()}, this.m_conn, false, true)) {
            return true;
        }
        this.createTableIndexes(mTable, md);
        return this.createTableData(mTable);
    }

    private String checkColumnName(String columnName) {
        return M_Element.getColumnName(columnName);
    }

    private void createTableIndexes(MTable mTable, DatabaseMetaData md) {
        String tableName = mTable.getTableName();
        log.info(tableName);
        String catalog = this.m_dbSource.getCatalog();
        String schema = this.m_dbSource.getSchema();
        String table2 = tableName.toUpperCase();
        try {
            ResultSet sourceIndex = md.getIndexInfo(catalog, schema, table2, false, false);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private boolean createTableData(MTable mTable) {
        boolean success = true;
        int count = 0;
        int errors = 0;
        long start = System.currentTimeMillis();
        String sql = "SELECT * FROM " + mTable.getTableName();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, mTable.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (this.createTableDataRow(rs, mTable)) {
                    ++count;
                    continue;
                }
                ++errors;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
            success = false;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        long elapsed = System.currentTimeMillis() - start;
        log.config("Inserted=" + count + " - Errors=" + errors + " - " + elapsed + " ms");
        return success;
    }

    private boolean createTableDataRow(ResultSet rs, MTable mTable) {
        StringBuffer insert = new StringBuffer("INSERT INTO ").append(mTable.getTableName()).append(" (");
        StringBuffer values = new StringBuffer();
        MColumn[] columns = mTable.getColumns(false);
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                insert.append(",");
                values.append(",");
            }
            MColumn column = columns[i];
            String columnName = column.getColumnName();
            insert.append(columnName);
            int dt = column.getAD_Reference_ID();
            try {
                Object value = rs.getObject(columnName);
                if (rs.wasNull()) {
                    values.append("NULL");
                    continue;
                }
                if (columnName.endsWith("_ID") || DisplayType.isNumeric(dt) || DisplayType.isID(dt) && !columnName.equals("AD_Language")) {
                    BigDecimal bd = rs.getBigDecimal(columnName);
                    String s = this.m_dbTarget.TO_NUMBER(bd, dt);
                    values.append(s);
                    continue;
                }
                if (DisplayType.isDate(dt)) {
                    Timestamp ts = rs.getTimestamp(columnName);
                    String tsString = this.m_dbTarget.TO_DATE(ts, dt == 15);
                    values.append(tsString);
                    continue;
                }
                if (DisplayType.isLOB(dt)) {
                    values.append("NULL");
                    continue;
                }
                if (DisplayType.isText(dt) || dt == 20 || dt == 17 || dt == 28 || columnName.equals("AD_Language")) {
                    String s = rs.getString(columnName);
                    values.append(DB.TO_STRING(s));
                    continue;
                }
                log.warning("Unknown DisplayType=" + dt + " - " + value + " [" + value.getClass().getName() + "]");
                values.append("NuLl");
                continue;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, columnName, e);
            }
        }
        insert.append(") VALUES (").append(values).append(")");
        return this.executeCommands(new String[]{insert.toString()}, this.m_conn, false, false);
    }

    private boolean enableConstraints(ArrayList list) {
        log.info("");
        return false;
    }

    private void databaseBuild() {
        String fileName = "C:\\Adempiere\\adempiere-all2\\db\\database\\DatabaseBuild.sql";
        File file = new File(fileName);
        if (!file.exists()) {
            log.severe("No file: " + fileName);
        }
    }

    private Connection getConnection(boolean asSystem, boolean createNew) {
        if (!createNew && this.m_conn != null) {
            return this.m_conn;
        }
        String dbUrl = this.m_dbTarget.getConnectionURL(this.m_databaseHost, this.m_databasePort, asSystem ? this.m_dbTarget.getSystemDatabase(this.m_databaseName) : this.m_databaseName, asSystem ? this.m_dbTarget.getSystemUser() : this.m_adempiereUser);
        try {
            this.m_conn = asSystem ? this.m_dbTarget.getDriverConnection(dbUrl, this.m_dbTarget.getSystemUser(), this.m_systemPassword) : this.m_dbTarget.getDriverConnection(dbUrl, this.m_adempiereUser, this.m_adempierePassword);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, dbUrl, e);
        }
        return this.m_conn;
    }

    private boolean executeCommands(String[] cmds, Connection conn, boolean batch, boolean doConvert) {
        if (cmds == null || cmds.length == 0) {
            log.warning("No Commands");
            return false;
        }
        Statement stmt = null;
        String cmd = null;
        String cmdOriginal = null;
        try {
            if (conn == null && (conn = this.getConnection(false, false)) == null) {
                return false;
            }
            if (conn.getAutoCommit() == batch) {
                conn.setAutoCommit(!batch);
            }
            stmt = conn.createStatement();
            for (int i = 0; i < cmds.length; ++i) {
                cmd = cmds[i];
                cmdOriginal = cmds[i];
                if (cmd == null || cmd.length() == 0) continue;
                if (cmd.indexOf(64) != -1) {
                    cmd = Util.replace(cmd, "@SystemPassword@", this.m_systemPassword);
                    cmd = Util.replace(cmd, "@AdempiereUser@", this.m_adempiereUser);
                    cmd = Util.replace(cmd, "@AdempierePassword@", this.m_adempierePassword);
                    cmd = Util.replace(cmd, "@SystemPassword@", this.m_systemPassword);
                    cmd = Util.replace(cmd, "@DatabaseName@", this.m_databaseName);
                    if (this.m_databaseDevice != null) {
                        cmd = Util.replace(cmd, "@DatabaseDevice@", this.m_databaseDevice);
                    }
                }
                if (doConvert) {
                    cmd = this.m_dbTarget.convertStatement(cmd);
                }
                this.writeLog(cmd);
                log.finer(cmd);
                int no = stmt.executeUpdate(cmd);
                log.finest("# " + no);
            }
            stmt.close();
            stmt = null;
            if (batch) {
                conn.commit();
            }
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = e.toString();
            }
            msg = msg + " (";
            if (e instanceof SQLException) {
                msg = msg + "State=" + ((SQLException)e).getSQLState() + ",ErrorCode=" + ((SQLException)e).getErrorCode();
            }
            msg = msg + ")";
            if (cmdOriginal != null && !cmdOriginal.equals(cmd)) {
                msg = msg + " - " + cmdOriginal;
            }
            msg = msg + "\n=>" + cmd;
            log.log(Level.SEVERE, msg);
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e1) {
                log.log(Level.SEVERE, "close statement", e1);
            }
            stmt = null;
            return false;
        }
    }

    private void writeLog(String cmd) {
        try {
            if (this.m_writer == null) {
                File file = File.createTempFile("create", ".log");
                this.m_writer = new PrintWriter(new FileWriter(file));
                log.info(file.toString());
            }
            this.m_writer.println(cmd);
            this.m_writer.flush();
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        CLogMgt.setLevel(Level.FINE);
        CLogMgt.setLoggerLevel(Level.FINE, null);
        CreateAdempiere cc = new CreateAdempiere(Database.DB_POSTGRESQL, "127.0.0.2", 5432, "adempiere");
        cc.setAdempiereUser("adempiere", "adempiere");
        cc.setDatabaseName("adempiere", "adempiere");
        if (!cc.testConnection()) {
            return;
        }
        cc.cleanStart();
        cc.copy("TableName > 'C_RfQResponseLineQty'", false);
    }
}

