/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnectionDialog;
import org.compiere.db.Database;
import org.compiere.interfaces.Server;
import org.compiere.interfaces.ServerHome;
import org.compiere.interfaces.Status;
import org.compiere.interfaces.StatusHome;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogMgtLog4J;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.ValueNamePair;

public class CConnection
implements Serializable {
    private static CConnection s_cc = null;
    private static CLogger log = CLogger.getCLogger(CConnection.class);
    public static ValueNamePair[] CONNECTIONProfiles = new ValueNamePair[]{new ValueNamePair("L", "LAN"), new ValueNamePair("T", "Terminal Server"), new ValueNamePair("V", "VPN"), new ValueNamePair("W", "WAN")};
    public static final String PROFILE_LAN = "L";
    public static final String PROFILE_TERMINAL = "T";
    public static final String PROFILE_VPN = "V";
    public static final String PROFILE_WAN = "W";
    private String m_name = "Standard";
    private String m_apps_host = "MyAppsServer";
    private int m_apps_port = 1099;
    private String m_type = "";
    private String m_db_host = "MyDBServer";
    private int m_db_port = 0;
    private String m_db_name = "MyDBName";
    private String m_connectionProfile = null;
    private boolean m_bequeath = false;
    private boolean m_firewall = false;
    private String m_fw_host = "";
    private int m_fw_port = 0;
    private String m_db_uid = "adempiere";
    private String m_db_pwd = "adempiere";
    private AdempiereDatabase m_db = null;
    private Exception m_dbException = null;
    private Exception m_appsException = null;
    private boolean m_okDB = false;
    private boolean m_okApps = false;
    private String[] m_info = new String[2];
    private String m_version = null;
    private DataSource m_ds = null;
    private Server m_server = null;
    private String m_dbInfo = null;
    private boolean m_queryAppsServer = false;
    private InitialContext m_iContext = null;
    private Hashtable m_env = null;

    public static CConnection get() {
        return CConnection.get(null);
    }

    public static CConnection get(String apps_host) {
        if (s_cc == null) {
            String attributes = Ini.getProperty("Connection");
            if (attributes == null || attributes.length() == 0) {
                CConnectionDialog ccd = new CConnectionDialog(new CConnection(apps_host));
                s_cc = ccd.getConnection();
                Ini.setProperty("Connection", s_cc.toStringLong());
                Ini.saveProperties(Ini.isClient());
            } else {
                s_cc = new CConnection(null);
                s_cc.setAttributes(attributes);
            }
            log.fine(s_cc.toString());
        }
        return s_cc;
    }

    public static CConnection get(String type, String db_host, int db_port, String db_name) {
        return CConnection.get(type, db_host, db_port, db_name, null, null);
    }

    public static CConnection get(String type, String db_host, int db_port, String db_name, String db_uid, String db_pwd) {
        CConnection cc = new CConnection(db_host);
        cc.setAppsHost(db_host);
        cc.setType(type);
        cc.setDbHost(db_host);
        cc.setDbPort(db_port);
        cc.setDbName(db_name);
        if (db_uid != null) {
            cc.setDbUid(db_uid);
        }
        if (db_pwd != null) {
            cc.setDbPwd(db_pwd);
        }
        return cc;
    }

    private CConnection(String host) {
        if (host != null) {
            this.m_apps_host = host;
            this.m_db_host = host;
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    protected void setName() {
        this.m_name = this.toString();
    }

    public String getAppsHost() {
        return this.m_apps_host;
    }

    public void setAppsHost(String apps_host) {
        this.m_apps_host = apps_host;
        this.m_name = this.toString();
        this.m_okApps = false;
        this.m_queryAppsServer = false;
    }

    public int getAppsPort() {
        return this.m_apps_port;
    }

    public void setAppsPort(int apps_port) {
        this.m_apps_port = apps_port;
        this.m_okApps = false;
        this.m_queryAppsServer = false;
    }

    public void setAppsPort(String apps_portString) {
        try {
            if (apps_portString != null && apps_portString.length() != 0) {
                this.setAppsPort(Integer.parseInt(apps_portString));
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public boolean isAppsServerOK(boolean tryContactAgain) {
        if (!tryContactAgain && this.m_queryAppsServer) {
            return this.m_okApps;
        }
        this.m_queryAppsServer = true;
        if (this.m_iContext == null) {
            this.getInitialContext(false);
            if (!this.m_okApps) {
                return false;
            }
        }
        try {
            StatusHome statusHome = (StatusHome)this.m_iContext.lookup("adempiere/Status");
            Status status = statusHome.create();
            this.m_version = status.getDateVersion();
            status.remove();
            this.m_okApps = true;
        }
        catch (Exception ce) {
            this.m_okApps = false;
        }
        catch (Throwable t) {
            this.m_okApps = false;
        }
        return this.m_okApps;
    }

    public Exception testAppsServer() {
        this.queryAppsServerInfo();
        return this.getAppsServerException();
    }

    public Server getServer() {
        if (this.m_server == null) {
            try {
                ServerHome serverHome;
                InitialContext ic = this.getInitialContext(true);
                if (ic != null && (serverHome = (ServerHome)ic.lookup("adempiere/Server")) != null) {
                    this.m_server = serverHome.create();
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "", ex);
                this.m_iContext = null;
            }
        }
        return this.m_server;
    }

    public String getServerVersion() {
        return this.m_version;
    }

    public String getDbHost() {
        return this.m_db_host;
    }

    public void setDbHost(String db_host) {
        this.m_db_host = db_host;
        this.m_name = this.toString();
        this.m_okDB = false;
    }

    public String getDbName() {
        return this.m_db_name;
    }

    public void setDbName(String db_name) {
        this.m_db_name = db_name;
        this.m_name = this.toString();
        this.m_okDB = false;
    }

    public int getDbPort() {
        return this.m_db_port;
    }

    public void setDbPort(int db_port) {
        this.m_db_port = db_port;
        this.m_okDB = false;
    }

    public void setDbPort(String db_portString) {
        try {
            if (db_portString != null && db_portString.length() != 0) {
                this.setDbPort(Integer.parseInt(db_portString));
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public String getDbPwd() {
        return this.m_db_pwd;
    }

    public void setDbPwd(String db_pwd) {
        this.m_db_pwd = db_pwd;
        this.m_okDB = false;
    }

    public String getDbUid() {
        return this.m_db_uid;
    }

    public void setDbUid(String db_uid) {
        this.m_db_uid = db_uid;
        this.m_name = this.toString();
        this.m_okDB = false;
    }

    public boolean isRMIoverHTTP() {
        return Ini.isClient() && this.getConnectionProfile().equals(PROFILE_WAN);
    }

    public void setConnectionProfile(ValueNamePair connectionProfile) {
        if (connectionProfile != null) {
            this.setConnectionProfile(connectionProfile.getValue());
        }
    }

    public void setConnectionProfile(String connectionProfile) {
        if (connectionProfile == null || this.m_connectionProfile != null && this.m_connectionProfile.equals(connectionProfile)) {
            return;
        }
        if (PROFILE_LAN.equals(connectionProfile) || PROFILE_TERMINAL.equals(connectionProfile) || PROFILE_VPN.equals(connectionProfile) || PROFILE_WAN.equals(connectionProfile)) {
            if (this.m_connectionProfile != null) {
                log.config(this.m_connectionProfile + " -> " + connectionProfile);
                this.m_connectionProfile = connectionProfile;
                Ini.setProperty("Connection", this.toStringLong());
            } else {
                this.m_connectionProfile = connectionProfile;
            }
        } else {
            log.warning("Invalid: " + connectionProfile);
        }
    }

    public String getConnectionProfile() {
        if (this.m_connectionProfile != null) {
            return this.m_connectionProfile;
        }
        return PROFILE_LAN;
    }

    public String getConnectionProfileText(String connectionProfile) {
        for (int i = 0; i < CONNECTIONProfiles.length; ++i) {
            if (!CONNECTIONProfiles[i].getValue().equals(connectionProfile)) continue;
            return CONNECTIONProfiles[i].getName();
        }
        return CONNECTIONProfiles[0].getName();
    }

    public String getConnectionProfileText() {
        return this.getConnectionProfileText(this.getConnectionProfile());
    }

    public ValueNamePair getConnectionProfilePair() {
        for (int i = 0; i < CONNECTIONProfiles.length; ++i) {
            if (!CONNECTIONProfiles[i].getValue().equals(this.getConnectionProfile())) continue;
            return CONNECTIONProfiles[i];
        }
        return CONNECTIONProfiles[0];
    }

    public boolean isServerObjects() {
        return Ini.isClient() && (this.getConnectionProfile().equals(PROFILE_VPN) || this.getConnectionProfile().equals(PROFILE_WAN));
    }

    public boolean isServerProcess() {
        return Ini.isClient() && (this.getConnectionProfile().equals(PROFILE_TERMINAL) || this.getConnectionProfile().equals(PROFILE_VPN) || this.getConnectionProfile().equals(PROFILE_WAN));
    }

    public boolean isTerminalServer() {
        return Ini.isClient() && this.getConnectionProfile().equals(PROFILE_TERMINAL);
    }

    public boolean isViaFirewall() {
        return this.m_firewall;
    }

    public void setViaFirewall(boolean viaFirewall) {
        this.m_firewall = viaFirewall;
        this.m_okDB = false;
    }

    public void setViaFirewall(String viaFirewallString) {
        try {
            this.setViaFirewall(Boolean.valueOf(viaFirewallString));
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public String getFwHost() {
        return this.m_fw_host;
    }

    public void setFwHost(String fw_host) {
        this.m_fw_host = fw_host;
        this.m_okDB = false;
    }

    public int getFwPort() {
        return this.m_fw_port;
    }

    public void setFwPort(int fw_port) {
        this.m_fw_port = fw_port;
        this.m_okDB = false;
    }

    public void setFwPort(String fw_portString) {
        try {
            if (fw_portString != null && fw_portString.length() != 0) {
                this.setFwPort(Integer.parseInt(fw_portString));
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public boolean isBequeath() {
        return this.m_bequeath;
    }

    public void setBequeath(boolean bequeath) {
        this.m_bequeath = bequeath;
        this.m_okDB = false;
    }

    public void setBequeath(String bequeathString) {
        try {
            this.setBequeath(Boolean.valueOf(bequeathString));
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        for (int i = 0; i < Database.DB_NAMES.length; ++i) {
            if (!Database.DB_NAMES[i].equals(type)) continue;
            this.m_type = type;
            this.m_okDB = false;
            break;
        }
        if (this.isOracle()) {
            if (this.getDbPort() != 1521) {
                this.setDbPort(1521);
            }
            this.setFwPort(1630);
        } else {
            this.setBequeath(false);
            this.setViaFirewall(false);
        }
        if (this.isDB2()) {
            if (this.getDbPort() != 446) {
                this.setDbPort(446);
            }
        } else if (this.isDerby()) {
            // empty if block
        }
        if (this.isPostgreSQL() && this.getDbPort() != 5432) {
            this.setDbPort(5432);
        }
        if (this.isFyracle() && this.getDbPort() != 3050) {
            this.setDbPort(3050);
        }
    }

    public boolean supportsBLOB() {
        return this.m_db.supportsBLOB();
    }

    public boolean isOracle() {
        return Database.DB_ORACLE.equals(this.m_type);
    }

    public boolean isDB2() {
        return Database.DB_DB2.equals(this.m_type);
    }

    public boolean isDerby() {
        return Database.DB_DERBY.equals(this.m_type);
    }

    public boolean isMSSQLServer() {
        return Database.DB_MSSQLServer.equals(this.m_type);
    }

    public boolean isPostgreSQL() {
        return Database.DB_POSTGRESQL.equals(this.m_type);
    }

    public boolean isFyracle() {
        return Database.DB_FYRACLE.equals(this.m_type);
    }

    public boolean isDatabaseOK() {
        return this.m_okDB;
    }

    public boolean setDataSource() {
        if (this.m_ds == null && Ini.isClient() && this.getDatabase() != null) {
            this.m_ds = this.getDatabase().getDataSource(this);
        }
        return this.m_ds != null;
    }

    public boolean setDataSource(DataSource ds) {
        if (ds == null && this.m_ds != null) {
            this.getDatabase().close();
        }
        this.m_ds = ds;
        return this.m_ds != null;
    }

    public DataSource getDataSource() {
        return this.m_ds;
    }

    public boolean isDataSource() {
        return this.m_ds != null;
    }

    public Exception testDatabase(boolean retest) {
        if (this.isRMIoverHTTP()) {
            return null;
        }
        if (!retest && this.m_ds != null && this.m_okDB) {
            return null;
        }
        if (this.m_ds != null) {
            this.getDatabase().close();
        }
        this.m_ds = null;
        this.setDataSource();
        Connection conn = this.getConnection(true, 2);
        if (conn != null) {
            try {
                this.readInfo(conn);
                conn.close();
            }
            catch (Exception e) {
                log.severe(e.toString());
                return e;
            }
        }
        return this.m_dbException;
    }

    public void readInfo(Connection conn) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        this.m_info[0] = "Database=" + dbmd.getDatabaseProductName() + " - " + dbmd.getDatabaseProductVersion();
        this.m_info[0] = this.m_info[0].replace('\n', ' ');
        this.m_info[1] = "Driver  =" + dbmd.getDriverName() + " - " + dbmd.getDriverVersion();
        if (this.isDataSource()) {
            this.m_info[1] = this.m_info[1] + " - via DataSource";
        }
        this.m_info[1] = this.m_info[1].replace('\n', ' ');
        log.config(this.m_info[0] + " - " + this.m_info[1]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.m_apps_host);
        sb.append("{").append(this.m_db_host).append("-").append(this.m_db_name).append("-").append(this.m_db_uid).append("}");
        return sb.toString();
    }

    public String toStringDetail() {
        StringBuffer sb = new StringBuffer(this.m_apps_host);
        sb.append("{").append(this.m_db_host).append("-").append(this.m_db_name).append("-").append(this.m_db_uid).append("}");
        Connection conn = this.getConnection(true, 2);
        if (conn != null) {
            try {
                DatabaseMetaData dbmd = conn.getMetaData();
                sb.append("\nDatabase=" + dbmd.getDatabaseProductName() + " - " + dbmd.getDatabaseProductVersion());
                sb.append("\nDriver  =" + dbmd.getDriverName() + " - " + dbmd.getDriverVersion());
                if (this.isDataSource()) {
                    sb.append(" - via DS");
                }
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        conn = null;
        return sb.toString();
    }

    public String getDBInfo() {
        if (this.m_dbInfo != null) {
            return this.m_dbInfo;
        }
        StringBuffer sb = new StringBuffer();
        Connection conn = this.getConnection(true, 2);
        if (conn != null) {
            try {
                DatabaseMetaData dbmd = conn.getMetaData();
                sb.append(dbmd.getDatabaseProductVersion()).append(";").append(dbmd.getDriverVersion());
                if (this.isDataSource()) {
                    sb.append(";DS");
                }
                conn.close();
                this.m_dbInfo = sb.toString();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "", e);
                sb.append(e.getLocalizedMessage());
            }
        }
        conn = null;
        return sb.toString();
    }

    public String toStringLong() {
        StringBuffer sb = new StringBuffer("CConnection[");
        sb.append("name=").append(this.m_name).append(",AppsHost=").append(this.m_apps_host).append(",AppsPort=").append(this.m_apps_port).append(",Profile=").append(this.getConnectionProfile()).append(",type=").append(this.m_type).append(",DBhost=").append(this.m_db_host).append(",DBport=").append(this.m_db_port).append(",DBname=").append(this.m_db_name).append(",BQ=").append(this.m_bequeath).append(",FW=").append(this.m_firewall).append(",FWhost=").append(this.m_fw_host).append(",FWport=").append(this.m_fw_port).append(",UID=").append(this.m_db_uid).append(",PWD=").append(this.m_db_pwd);
        sb.append("]");
        return sb.toString();
    }

    private void setAttributes(String attributes) {
        try {
            this.setName(attributes.substring(attributes.indexOf("name=") + 5, attributes.indexOf(",AppsHost=")));
            this.setAppsHost(attributes.substring(attributes.indexOf("AppsHost=") + 9, attributes.indexOf(",AppsPort=")));
            int index = attributes.indexOf("AppsPort=");
            this.setAppsPort(attributes.substring(index + 9, attributes.indexOf(",", index)));
            index = attributes.indexOf("Profile=");
            if (index > 0) {
                this.setConnectionProfile(attributes.substring(index + 8, attributes.indexOf(",", index)));
            }
            this.setType(attributes.substring(attributes.indexOf("type=") + 5, attributes.indexOf(",DBhost=")));
            this.setDbHost(attributes.substring(attributes.indexOf("DBhost=") + 7, attributes.indexOf(",DBport=")));
            this.setDbPort(attributes.substring(attributes.indexOf("DBport=") + 7, attributes.indexOf(",DBname=")));
            this.setDbName(attributes.substring(attributes.indexOf("DBname=") + 7, attributes.indexOf(",BQ=")));
            this.setBequeath(attributes.substring(attributes.indexOf("BQ=") + 3, attributes.indexOf(",FW=")));
            this.setViaFirewall(attributes.substring(attributes.indexOf("FW=") + 3, attributes.indexOf(",FWhost=")));
            this.setFwHost(attributes.substring(attributes.indexOf("FWhost=") + 7, attributes.indexOf(",FWport=")));
            this.setFwPort(attributes.substring(attributes.indexOf("FWport=") + 7, attributes.indexOf(",UID=")));
            this.setDbUid(attributes.substring(attributes.indexOf("UID=") + 4, attributes.indexOf(",PWD=")));
            this.setDbPwd(attributes.substring(attributes.indexOf("PWD=") + 4, attributes.indexOf("]")));
        }
        catch (Exception e) {
            log.severe(attributes + " - " + e.toString());
        }
    }

    public boolean equals(Object o) {
        CConnection cc;
        return o instanceof CConnection && (cc = (CConnection)o).getAppsHost().equals(this.m_apps_host) && cc.getAppsPort() == this.m_apps_port && cc.getDbHost().equals(this.m_db_host) && cc.getDbPort() == this.m_db_port && cc.getConnectionProfile().equals(this.getConnectionProfile()) && cc.getDbName().equals(this.m_db_name) && cc.getType().equals(this.m_type) && cc.getDbUid().equals(this.m_db_uid) && cc.getDbPwd().equals(this.m_db_pwd);
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer(this.m_info[0]);
        sb.append(" - ").append(this.m_info[1]).append("\n").append(((Object)this.getDatabase()).toString()).append("\nAppsServerOK=").append(this.isAppsServerOK(false)).append(", DatabaseOK=").append(this.isDatabaseOK());
        return sb.toString();
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public AdempiereDatabase getDatabase() {
        if (this.m_db != null && !this.m_db.getName().equals(this.m_type)) {
            this.m_db = null;
        }
        if (this.m_db == null) {
            try {
                for (int i = 0; i < Database.DB_NAMES.length; ++i) {
                    if (!Database.DB_NAMES[i].equals(this.m_type)) continue;
                    this.m_db = (AdempiereDatabase)Database.DB_CLASSES[i].newInstance();
                    break;
                }
            }
            catch (Exception e) {
                log.severe(e.toString());
            }
        }
        return this.m_db;
    }

    public String getConnectionURL() {
        this.getDatabase();
        if (this.m_db != null) {
            return this.m_db.getConnectionURL(this);
        }
        return "";
    }

    public Connection getServerConnection(boolean autoCommit, int trxLevel) {
        Connection conn = null;
        if (this.m_ds != null) {
            try {
                conn = this.m_ds.getConnection();
                conn.setAutoCommit(autoCommit);
                conn.setTransactionIsolation(trxLevel);
                this.m_okDB = true;
            }
            catch (SQLException ex) {
                this.m_dbException = ex;
                log.log(Level.SEVERE, "", ex);
            }
        }
        return conn;
    }

    public Connection getConnection(boolean autoCommit, int transactionIsolation) {
        Connection conn = null;
        this.m_dbException = null;
        this.m_okDB = false;
        this.getDatabase();
        if (this.m_db == null) {
            this.m_dbException = new IllegalStateException("No Database Connector");
            return null;
        }
        try {
            Exception ee = null;
            try {
                conn = this.m_db.getCachedConnection(this, autoCommit, transactionIsolation);
            }
            catch (Exception e) {
                ee = e;
            }
            if (conn == null) {
                Thread.yield();
                log.config("retrying - " + ee);
                conn = this.m_db.getCachedConnection(this, autoCommit, transactionIsolation);
            }
            if (conn != null) {
                if (conn.getTransactionIsolation() != transactionIsolation) {
                    conn.setTransactionIsolation(transactionIsolation);
                }
                if (conn.getAutoCommit() != autoCommit) {
                    conn.setAutoCommit(autoCommit);
                }
                this.m_okDB = true;
            }
        }
        catch (UnsatisfiedLinkError ule) {
            String msg = ule.getLocalizedMessage() + " -> Did you set the LD_LIBRARY_PATH ? - " + this.getConnectionURL();
            this.m_dbException = new Exception(msg);
            log.severe(msg);
        }
        catch (SQLException ex) {
            this.m_dbException = ex;
            if (conn == null) {
                log.log(Level.SEVERE, this.getConnectionURL() + ", (1) AutoCommit=" + autoCommit + ",TrxIso=" + CConnection.getTransactionIsolationInfo(transactionIsolation) + " - " + ex.getMessage());
            } else {
                try {
                    log.severe(this.getConnectionURL() + ", (2) AutoCommit=" + conn.getAutoCommit() + "->" + autoCommit + ", TrxIso=" + CConnection.getTransactionIsolationInfo(conn.getTransactionIsolation()) + "->" + CConnection.getTransactionIsolationInfo(transactionIsolation) + " - " + ex.getMessage());
                }
                catch (Exception ee) {
                    log.severe(this.getConnectionURL() + ", (3) AutoCommit=" + autoCommit + ", TrxIso=" + CConnection.getTransactionIsolationInfo(transactionIsolation) + " - " + ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            this.m_dbException = ex;
            log.log(Level.SEVERE, this.getConnectionURL(), ex);
        }
        return conn;
    }

    public Exception getDatabaseException() {
        return this.m_dbException;
    }

    public InitialContext getInitialContext(boolean useCache) {
        block5: {
            if (useCache && this.m_iContext != null) {
                return this.m_iContext;
            }
            if (this.m_env == null || !useCache) {
                this.m_env = CConnection.getInitialEnvironment(this.getAppsHost(), this.getAppsPort(), this.isRMIoverHTTP());
            }
            String connect = (String)this.m_env.get("java.naming.provider.url");
            Env.setContext(Env.getCtx(), "java.naming.provider.url", connect);
            this.m_iContext = null;
            try {
                this.m_iContext = new InitialContext(this.m_env);
            }
            catch (Exception ex) {
                this.m_okApps = false;
                this.m_appsException = ex;
                if (connect == null) {
                    connect = (String)this.m_env.get("java.naming.provider.url");
                }
                log.severe(connect + "\n - " + ex.toString() + "\n - " + this.m_env);
                if (!CLogMgt.isLevelFinest()) break block5;
                ex.printStackTrace();
            }
        }
        return this.m_iContext;
    }

    public static Hashtable getInitialEnvironment(String AppsHost, int AppsPort, boolean RMIoverHTTP) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        String connect = AppsHost;
        if (RMIoverHTTP) {
            env.put("java.naming.factory.initial", "org.jboss.naming.HttpNamingContextFactory");
            if (AppsHost.indexOf("://") == -1) {
                connect = "http://" + AppsHost + ":" + AppsPort + "/invoker/JNDIFactory";
            }
            env.put("java.naming.provider.url", connect);
        } else {
            env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            if (AppsHost.indexOf("://") == -1) {
                connect = "jnp://" + AppsHost + ":" + AppsPort;
            }
            env.put("java.naming.provider.url", connect);
        }
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming.client");
        env.put("jnp.timeout", "5000");
        env.put("jnp.sotimeout", "5000");
        env.put("jnp.discoveryTimeout", "5000");
        return env;
    }

    public static InitialContext getInitialContext(Hashtable env) {
        InitialContext iContext;
        block2: {
            iContext = null;
            try {
                iContext = new InitialContext(env);
            }
            catch (Exception ex) {
                log.warning("URL=" + env.get("java.naming.provider.url") + "\n - " + ex.toString() + "\n - " + env);
                iContext = null;
                if (!CLogMgt.isLevelFinest()) break block2;
                ex.printStackTrace();
            }
        }
        return iContext;
    }

    private boolean queryAppsServerInfo() {
        log.finer(this.getAppsHost());
        long start = System.currentTimeMillis();
        this.m_okApps = false;
        this.m_queryAppsServer = true;
        this.m_appsException = null;
        this.getInitialContext(false);
        if (this.m_iContext == null) {
            return this.m_okApps;
        }
        if (this.getAppsHost().equalsIgnoreCase("MyAppsServer")) {
            log.warning(this.getAppsHost() + " ignored");
            return this.m_okApps;
        }
        try {
            StatusHome statusHome = (StatusHome)this.m_iContext.lookup("adempiere/Status");
            Status status = statusHome.create();
            this.updateInfoFromServer(status);
            status.remove();
            this.m_okApps = true;
        }
        catch (CommunicationException ce) {
            String connect = (String)this.m_env.get("java.naming.provider.url");
            log.warning(connect + "\n - " + ce.toString() + "\n - " + this.m_env);
        }
        catch (Exception e) {
            this.m_appsException = e;
            String connect = (String)this.m_env.get("java.naming.provider.url");
            log.warning(connect + "\n - " + e.toString() + "\n - " + this.m_env);
        }
        CLogMgtLog4J.enable(true);
        log.fine("Success=" + this.m_okApps + " - " + (System.currentTimeMillis() - start) + "ms");
        return this.m_okApps;
    }

    public Exception getAppsServerException() {
        return this.m_appsException;
    }

    private void updateInfoFromServer(Status svr) throws Exception {
        if (svr == null) {
            throw new IllegalArgumentException("AppsServer was NULL");
        }
        this.setType(svr.getDbType());
        this.setDbHost(svr.getDbHost());
        this.setDbPort(svr.getDbPort());
        this.setDbName(svr.getDbName());
        this.setDbUid(svr.getDbUid());
        this.setDbPwd(svr.getDbPwd());
        this.setBequeath(false);
        this.setFwHost(svr.getFwHost());
        this.setFwPort(svr.getFwPort());
        if (this.getFwHost().length() == 0) {
            this.setViaFirewall(false);
        }
        this.m_version = svr.getDateVersion();
        log.config("Server=" + this.getDbHost() + ", DB=" + this.getDbName());
    }

    public String convertStatement(String origStatement) throws Exception {
        if (this.m_db != null && !this.m_db.getName().equals(this.m_type)) {
            this.getDatabase();
        }
        if (this.m_db != null) {
            return this.m_db.convertStatement(origStatement);
        }
        throw new Exception("CConnection.convertStatement - No Converstion Database");
    }

    public String getStatus() {
        StringBuffer sb = new StringBuffer(this.m_apps_host);
        sb.append("{").append(this.m_db_host).append("-").append(this.m_db_name).append("-").append(this.m_db_uid).append("}");
        if (this.m_db != null) {
            sb.append(this.m_db.getStatus());
        }
        return sb.toString();
    }

    public static String getTransactionIsolationInfo(int transactionIsolation) {
        if (transactionIsolation == 0) {
            return "NONE";
        }
        if (transactionIsolation == 2) {
            return "READ_COMMITTED";
        }
        if (transactionIsolation == 1) {
            return "READ_UNCOMMITTED";
        }
        if (transactionIsolation == 4) {
            return "REPEATABLE_READ";
        }
        if (transactionIsolation == 2) {
            return "SERIALIZABLE";
        }
        return "<?" + transactionIsolation + "?>";
    }

    public static void main(String[] args) {
        boolean server = true;
        if (args.length == 0) {
            System.out.println("CConnection <server|client>");
        } else {
            server = "server".equals(args[0]);
        }
        System.out.println("CConnection - " + (server ? "server" : "client"));
        if (server) {
            Adempiere.startup(false);
        } else {
            Adempiere.startup(true);
        }
        System.out.println("Connection = ");
        System.out.println(Ini.getProperty("Connection"));
        CConnection cc = CConnection.get();
        System.out.println(">> " + cc.toStringLong());
        Connection con = cc.getConnection(false, 2);
        new CConnectionDialog(cc);
    }
}

