/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.cm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.cm.CacheHandler;
import org.compiere.model.MCStage;
import org.compiere.model.MContainer;
import org.compiere.model.MMedia;
import org.compiere.model.MMediaServer;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.MTree_NodeCMC;
import org.compiere.model.MTree_NodeCMS;
import org.compiere.model.MWebProject;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;

public class WebProjectDeploy
extends SvrProcess {
    private int p_CM_WebProject_ID = 0;
    private MWebProject m_project = null;
    private HashMap<Integer, MCStage> m_map = new HashMap();
    private ArrayList<Integer> m_idList = new ArrayList();

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("CM_WebProject_ID")) {
                this.p_CM_WebProject_ID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        CacheHandler thisHandler = new CacheHandler(CacheHandler.convertJNPURLToCacheURL(this.getCtx().getProperty("java.naming.provider.url")), this.log, this.getCtx(), this.get_TrxName());
        this.log.info("CM_WebProject_ID=" + this.p_CM_WebProject_ID);
        this.m_project = new MWebProject(this.getCtx(), this.p_CM_WebProject_ID, this.get_TrxName());
        if (this.m_project.get_ID() != this.p_CM_WebProject_ID) {
            throw new AdempiereUserError("@NotFound@ @CM_WebProject_ID@ " + this.p_CM_WebProject_ID);
        }
        MMedia[] media = MMedia.getMedia(this.m_project);
        MMediaServer[] mserver = MMediaServer.getMediaServer(this.m_project);
        for (int i = 0; i < mserver.length; ++i) {
            mserver[i].deploy(media);
        }
        MCStage[] stages = MCStage.getStages(this.m_project);
        for (int i = 0; i < stages.length; ++i) {
            this.m_map.put(new Integer(stages[i].getCM_CStage_ID()), stages[i]);
        }
        MTree treeS = new MTree(this.getCtx(), this.m_project.getAD_TreeCMS_ID(), false, false, this.get_TrxName());
        MTreeNode root = treeS.getRoot();
        this.copyStage(root, "/");
        MContainer[] containers = MContainer.getContainers(this.m_project);
        for (int i = 0; i < containers.length; ++i) {
            MContainer container = containers[i];
            if (!this.m_idList.contains(new Integer(container.getCM_Container_ID()))) {
                String name = container.getName();
                if (container.delete(true)) {
                    this.log.fine("Deleted: " + name);
                } else {
                    this.log.warning("Failed Delete: " + name);
                    this.addLog(0, null, null, "@Error@ @Delete@: " + name);
                }
            }
            thisHandler.cleanContainer(container.get_ID());
        }
        MTree_NodeCMS[] nodesCMS = MTree_NodeCMS.getTree(this.getCtx(), this.m_project.getAD_TreeCMS_ID(), this.get_TrxName());
        MTree_NodeCMC[] nodesCMC = MTree_NodeCMC.getTree(this.getCtx(), this.m_project.getAD_TreeCMC_ID(), this.get_TrxName());
        block3: for (int s = 0; s < nodesCMS.length; ++s) {
            MTree_NodeCMS nodeCMS = nodesCMS[s];
            int Node_ID = nodeCMS.getNode_ID();
            for (int c = 0; c < nodesCMC.length; ++c) {
                MTree_NodeCMC nodeCMC = nodesCMC[c];
                if (nodeCMC.getNode_ID() != Node_ID) continue;
                nodeCMC.setParent_ID(nodeCMS.getParent_ID());
                nodeCMC.setSeqNo(nodeCMS.getSeqNo());
                nodeCMC.save();
                continue block3;
            }
        }
        thisHandler.cleanContainerTree(this.p_CM_WebProject_ID);
        return "@Copied@ @CM_Container_ID@ #" + this.m_idList.size();
    }

    private void copyStage(MTreeNode node, String path) {
        CacheHandler thisHandler = new CacheHandler(CacheHandler.convertJNPURLToCacheURL(this.getCtx().getProperty("java.naming.provider.url")), this.log, this.getCtx(), this.get_TrxName());
        Integer ID = new Integer(node.getNode_ID());
        MCStage stage = this.m_map.get(ID);
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            MTreeNode child = (MTreeNode)node.getChildAt(i);
            ID = new Integer(child.getNode_ID());
            stage = this.m_map.get(ID);
            if (stage == null) {
                this.log.warning("Not Found ID=" + ID);
                continue;
            }
            if (!stage.isActive()) continue;
            if (stage != null && stage.isModified()) {
                MContainer cc = MContainer.copy(this.m_project, stage, path);
                if (cc != null) {
                    this.addLog(0, null, null, "@Copied@: " + cc.getName());
                    this.m_idList.add(ID);
                }
                thisHandler.cleanContainer(cc.get_ID());
                stage.setIsModified(false);
                stage.save(stage.get_TrxName());
            }
            if (!child.isSummary()) continue;
            this.copyStage(child, path + stage.getRelativeURL() + "/");
        }
    }
}

