/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.wf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.Adempiere;
import org.compiere.apps.AEnv;
import org.compiere.apps.AMenu;
import org.compiere.apps.AMenuStartItem;
import org.compiere.apps.AWindow;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.wf.WFContentPanel;
import org.compiere.apps.wf.WFLine;
import org.compiere.apps.wf.WFNode;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;

public class WFPanel
extends CPanel
implements PropertyChangeListener,
ActionListener,
FormPanel {
    private AMenu m_menu = null;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private MWorkflow m_wf = null;
    private Properties m_ctx = Env.getCtx();
    private WFNode m_activeNode = null;
    private boolean m_readWrite = false;
    private static CLogger log = CLogger.getCLogger(WFPanel.class);
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel southPanel = new CPanel();
    private WFContentPanel centerPanel = new WFContentPanel(this);
    private BorderLayout southLayout = new BorderLayout();
    private JScrollPane infoScrollPane = new JScrollPane();
    private JTextPane infoTextPane = new JTextPane();
    private CPanel buttonPanel = new CPanel();
    private JButton wfStart = new JButton();
    private JButton wfBack = new JButton();
    private JButton wfNext = new JButton();
    private JButton wfEnd = new JButton();
    private CPanel loadPanel = new CPanel(new FlowLayout(3));
    private CComboBox workflow = new CComboBox();
    private CButton bResetLayout = AEnv.getButton("Reset");
    private CButton bSaveLayout = AEnv.getButton("Save");
    private CButton bZoom = AEnv.getButton("Zoom");
    private CButton bIgnore = AEnv.getButton("Ignore");

    public WFPanel() {
        this((AMenu)null);
    }

    public WFPanel(AMenu menu) {
        this.m_menu = menu;
        this.m_readWrite = menu == null;
        log.info("RW=" + this.m_readWrite);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WFPanel", e);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        CompiereColor.setBackground(this);
        this.southPanel.setLayout(this.southLayout);
        this.add((Component)new JScrollPane(this.centerPanel), "Center");
        this.infoScrollPane.getViewport().add((Component)this.infoTextPane, null);
        this.infoScrollPane.setPreferredSize(new Dimension(200, 140));
        this.infoTextPane.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.infoTextPane.setEditable(false);
        this.infoTextPane.setRequestFocusEnabled(false);
        this.infoTextPane.setContentType("text/html");
        this.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.infoScrollPane, "Center");
        this.southPanel.add((Component)this.buttonPanel, "South");
        this.wfStart.setIcon(Env.getImageIcon("wfStart24.gif"));
        this.wfStart.setMargin(new Insets(0, 10, 0, 10));
        this.wfStart.setRequestFocusEnabled(false);
        this.wfStart.addActionListener(this);
        this.wfStart.setToolTipText(Msg.getMsg(this.m_ctx, "WFStart"));
        this.wfBack.setIcon(Env.getImageIcon("wfBack24.gif"));
        this.wfBack.setMargin(new Insets(0, 15, 0, 15));
        this.wfBack.setRequestFocusEnabled(false);
        this.wfBack.addActionListener(this);
        this.wfBack.setToolTipText(Msg.getMsg(this.m_ctx, "WFPrevious"));
        this.wfNext.setIcon(Env.getImageIcon("wfNext24.gif"));
        this.wfNext.setMargin(new Insets(0, 15, 0, 15));
        this.wfNext.setRequestFocusEnabled(false);
        this.wfNext.addActionListener(this);
        this.wfNext.setToolTipText(Msg.getMsg(this.m_ctx, "WFNext"));
        this.wfEnd.setIcon(Env.getImageIcon("wfEnd24.gif"));
        this.wfEnd.setMargin(new Insets(0, 10, 0, 10));
        this.wfEnd.setRequestFocusEnabled(false);
        this.wfEnd.addActionListener(this);
        this.wfEnd.setToolTipText(Msg.getMsg(this.m_ctx, "WFExit"));
        this.buttonPanel.add((Component)this.wfStart, null);
        this.buttonPanel.add((Component)this.wfBack, null);
        this.buttonPanel.add((Component)this.wfNext, null);
        this.buttonPanel.add((Component)this.wfEnd, null);
    }

    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        log.fine("WindowNo=" + WindowNo);
        try {
            this.loadPanel();
            frame.getContentPane().add((Component)this.loadPanel, "North");
            this.setPreferredSize(new Dimension(500, 500));
            frame.getContentPane().add((Component)this, "Center");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "init", e);
        }
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void loadPanel() {
        String sql = MRole.getDefault().addAccessSQL("SELECT AD_Workflow_ID, Name FROM AD_Workflow ORDER BY 2", "AD_Workflow", false, false);
        Object[] pp = DB.getKeyNamePairs(sql, true);
        this.workflow = new CComboBox(pp);
        this.loadPanel.add(this.workflow);
        this.workflow.addActionListener(this);
        this.loadPanel.add(this.bIgnore);
        this.bIgnore.addActionListener(this);
        this.loadPanel.add(this.bResetLayout);
        this.bResetLayout.addActionListener(this);
        this.loadPanel.add(this.bSaveLayout);
        this.bSaveLayout.addActionListener(this);
        this.loadPanel.add(this.bZoom);
        this.bZoom.addActionListener(this);
    }

    private void load(boolean readWrite) {
        KeyNamePair pp = (KeyNamePair)this.workflow.getSelectedItem();
        if (pp == null) {
            return;
        }
        this.load(pp.getKey(), readWrite);
    }

    public void load(int AD_Workflow_ID, boolean readWrite) {
        log.fine("RW=" + readWrite + " - AD_Workflow_ID=" + AD_Workflow_ID);
        if (AD_Workflow_ID == 0) {
            return;
        }
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        this.m_wf = new MWorkflow(Env.getCtx(), AD_Workflow_ID, null);
        this.centerPanel.removeAll();
        this.centerPanel.setReadWrite(readWrite);
        if (readWrite) {
            this.centerPanel.setWorkflow(this.m_wf);
        }
        MWFNode[] nodes = this.m_wf.getNodes(true, AD_Client_ID);
        for (int i = 0; i < nodes.length; ++i) {
            WFNode wfn = new WFNode(nodes[i]);
            wfn.addPropertyChangeListener(WFNode.PROPERTY_SELECTED, this);
            boolean rw = readWrite && AD_Client_ID == nodes[i].getAD_Client_ID();
            this.centerPanel.add((Component)wfn, rw);
            MWFNodeNext[] nexts = nodes[i].getTransitions(AD_Client_ID);
            for (int j = 0; j < nexts.length; ++j) {
                this.centerPanel.add((Component)new WFLine(nexts[j]), false);
            }
        }
        StringBuffer msg = new StringBuffer("<HTML>");
        msg.append("<H2>").append(this.m_wf.getName(true)).append("</H2>");
        String s = this.m_wf.getDescription(true);
        if (s != null && s.length() > 0) {
            msg.append("<B>").append(s).append("</B>");
        }
        if ((s = this.m_wf.getHelp(true)) != null && s.length() > 0) {
            msg.append("<BR>").append(s);
        }
        msg.append("</HTML>");
        this.infoTextPane.setText(msg.toString());
        this.infoTextPane.setCaretPosition(0);
        this.centerPanel.validate();
        this.centerPanel.repaint();
        this.validate();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getNewValue() == Boolean.TRUE) {
            this.start((WFNode)e.getSource());
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.m_wf == null && e.getSource() != this.workflow) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        if (e.getSource() == this.bZoom) {
            this.zoom();
        } else if (e.getSource() == this.bIgnore) {
            this.load(this.m_wf.getAD_Workflow_ID(), true);
        } else if (e.getSource() == this.workflow) {
            this.load(true);
        } else if (e.getSource() == this.bSaveLayout) {
            if (this.m_wf.getAD_Client_ID() == AD_Client_ID) {
                this.m_wf.save();
            }
            MWFNode[] nodes = this.m_wf.getNodes(false, AD_Client_ID);
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i].getAD_Client_ID() != AD_Client_ID) continue;
                nodes[i].save();
            }
        } else if (e.getSource() == this.bResetLayout) {
            this.resetLayout();
        } else if (e.getSource() == this.wfStart || this.m_activeNode == null) {
            this.start(this.m_wf.getAD_WF_Node_ID());
        } else if (e.getSource() == this.wfBack) {
            this.start(this.m_wf.getPrevious(this.m_activeNode.getAD_WF_Node_ID(), AD_Client_ID));
        } else if (e.getSource() == this.wfNext) {
            this.start(this.m_wf.getNext(this.m_activeNode.getAD_WF_Node_ID(), AD_Client_ID));
        } else if (e.getSource() == this.wfEnd) {
            this.start(this.m_wf.getLast(this.m_activeNode.getAD_WF_Node_ID(), AD_Client_ID));
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void start(WFNode node) {
        log.fine("Node=" + node);
        MWFNode model = node.getModel();
        StringBuffer msg = new StringBuffer("<HTML>");
        msg.append("<H2>").append(model.getName(true)).append("</H2>");
        String s = model.getDescription(true);
        if (s != null && s.length() > 0) {
            msg.append("<B>").append(s).append("</B>");
        }
        if ((s = model.getHelp(true)) != null && s.length() > 0) {
            msg.append("<BR>").append(s);
        }
        msg.append("</HTML>");
        this.infoTextPane.setText(msg.toString());
        this.infoTextPane.setCaretPosition(0);
        if (this.m_menu != null) {
            new AMenuStartItem(model.getAD_WF_Node_ID(), false, model.getName(true), this.m_menu).start();
        }
        this.m_activeNode = node;
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        boolean first = this.m_wf.isFirst(this.m_activeNode.getAD_WF_Node_ID(), AD_Client_ID);
        boolean last = this.m_wf.isLast(this.m_activeNode.getAD_WF_Node_ID(), AD_Client_ID);
        this.wfStart.setEnabled(!first);
        this.wfBack.setEnabled(!first);
        this.wfNext.setEnabled(!last);
        this.wfEnd.setEnabled(!last);
    }

    public void start(int AD_WF_Node_ID) {
        if (AD_WF_Node_ID == 0) {
            return;
        }
        for (int i = 0; i < this.centerPanel.getComponentCount(); ++i) {
            WFNode node;
            Component comp = this.centerPanel.getComponent(i);
            if (!(comp instanceof WFNode) || (node = (WFNode)comp).getAD_WF_Node_ID() != AD_WF_Node_ID) continue;
            this.start(node);
            return;
        }
    }

    public void resetLayout() {
        Point p0 = new Point(0, 0);
        for (int i = 0; i < this.centerPanel.getComponentCount(); ++i) {
            Component comp = this.centerPanel.getComponent(i);
            comp.setLocation(p0);
        }
        this.centerPanel.validate();
    }

    private void zoom() {
        AWindow frame;
        int AD_Window_ID = 113;
        MQuery query = null;
        if (this.m_wf != null) {
            query = MQuery.getEqualQuery("AD_Workflow_ID", this.m_wf.getAD_Workflow_ID());
        }
        if (!(frame = new AWindow()).initWindow(AD_Window_ID, query)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        AEnv.showCenterScreen(frame);
        frame = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("WFPanel[");
        if (this.m_wf != null) {
            sb.append(this.m_wf.getAD_Workflow_ID());
        }
        sb.append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(true);
        JFrame jf = new JFrame("WF");
        WFPanel pp = new WFPanel(null);
        pp.load(101, true);
        jf.getContentPane().add(pp);
        jf.pack();
        jf.setVisible(true);
    }
}

